# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._inputs import *

__all__ = [
    'GetRemoteReferenceResult',
    'AwaitableGetRemoteReferenceResult',
    'get_remote_reference',
    'get_remote_reference_output',
]

@pulumi.output_type
class GetRemoteReferenceResult:
    """
    The result of fetching from a Terraform state store.
    """
    def __init__(__self__, outputs=None):
        if outputs and not isinstance(outputs, dict):
            raise TypeError("Expected argument 'outputs' to be a dict")
        pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter
    def outputs(self) -> Mapping[str, Any]:
        """
        The outputs displayed from Terraform state.
        """
        return pulumi.get(self, "outputs")


class AwaitableGetRemoteReferenceResult(GetRemoteReferenceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemoteReferenceResult(
            outputs=self.outputs)


def get_remote_reference(hostname: Optional[builtins.str] = None,
                         organization: Optional[builtins.str] = None,
                         token: Optional[builtins.str] = None,
                         workspaces: Optional[Union['Workspaces', 'WorkspacesDict']] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemoteReferenceResult:
    """
    Access state from a remote backend.


    :param builtins.str hostname: The remote backend hostname to connect to.
    :param builtins.str organization: The name of the organization containing the targeted workspace(s).
    :param builtins.str token: The token used to authenticate with the remote backend.
    """
    __args__ = dict()
    __args__['hostname'] = hostname
    __args__['organization'] = organization
    __args__['token'] = token
    __args__['workspaces'] = workspaces
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('terraform:state:getRemoteReference', __args__, opts=opts, typ=GetRemoteReferenceResult).value

    return AwaitableGetRemoteReferenceResult(
        outputs=pulumi.get(__ret__, 'outputs'))
def get_remote_reference_output(hostname: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                organization: Optional[pulumi.Input[builtins.str]] = None,
                                token: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                workspaces: Optional[pulumi.Input[Union['Workspaces', 'WorkspacesDict']]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRemoteReferenceResult]:
    """
    Access state from a remote backend.


    :param builtins.str hostname: The remote backend hostname to connect to.
    :param builtins.str organization: The name of the organization containing the targeted workspace(s).
    :param builtins.str token: The token used to authenticate with the remote backend.
    """
    __args__ = dict()
    __args__['hostname'] = hostname
    __args__['organization'] = organization
    __args__['token'] = token
    __args__['workspaces'] = workspaces
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('terraform:state:getRemoteReference', __args__, opts=opts, typ=GetRemoteReferenceResult)
    return __ret__.apply(lambda __response__: GetRemoteReferenceResult(
        outputs=pulumi.get(__response__, 'outputs')))
