# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'Workspaces',
    'WorkspacesDict',
]

MYPY = False

if not MYPY:
    class WorkspacesDict(TypedDict):
        name: NotRequired[builtins.str]
        """
        The full name of one remote workspace. When configured, only the default workspace can be used. This option conflicts with prefix.
        """
        prefix: NotRequired[builtins.str]
        """
        A prefix used in the names of one or more remote workspaces, all of which can be used with this configuration. The full workspace names are used in HCP Terraform, and the short names (minus the prefix) are used on the command line for Terraform CLI workspaces. If omitted, only the default workspace can be used. This option conflicts with name.
        """
elif False:
    WorkspacesDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class Workspaces:
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str name: The full name of one remote workspace. When configured, only the default workspace can be used. This option conflicts with prefix.
        :param builtins.str prefix: A prefix used in the names of one or more remote workspaces, all of which can be used with this configuration. The full workspace names are used in HCP Terraform, and the short names (minus the prefix) are used on the command line for Terraform CLI workspaces. If omitted, only the default workspace can be used. This option conflicts with name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The full name of one remote workspace. When configured, only the default workspace can be used. This option conflicts with prefix.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        A prefix used in the names of one or more remote workspaces, all of which can be used with this configuration. The full workspace names are used in HCP Terraform, and the short names (minus the prefix) are used on the command line for Terraform CLI workspaces. If omitted, only the default workspace can be used. This option conflicts with name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[builtins.str]):
        pulumi.set(self, "prefix", value)


