# -*- coding: utf-8 -*-
import os
import unittest

import intelmq.lib.test as test
from intelmq.bots.parsers.malwareurl.parser import MalwareurlParserBot
from intelmq.lib import utils

with open(os.path.join(os.path.dirname(__file__), 'test_malwareurl.data')) as handle:
    REPORT_DATA = handle.read()
    REPORT_DATA_SPLIT = REPORT_DATA.splitlines()


REPORT = {"__type": "Report",
          "feed.name": "Malware url",
          "feed.url": "http://www.malwareurl.com",
          "raw": utils.base64_encode(REPORT_DATA),
          "time.observation": "2018-01-22T14:38:24+00:00"
          }
EVENT1 = {"feed.url": "http://www.malwareurl.com",
          "time.observation": "2018-01-22T14:38:24+00:00",
          "raw": utils.base64_encode(REPORT_DATA_SPLIT[170].strip() + REPORT_DATA_SPLIT[173].strip()),
          "source.fqdn": "eaglewingtravels.com",
          "feed.name": "Malware url",
          "classification.type": "phishing",
          "__type": "Event",
          "source.ip": "173.236.99.82"}
EVENT2 = {"__type": "Event",
          "feed.name": "Malware url",
          "classification.type": "phishing",
          "raw": utils.base64_encode(REPORT_DATA_SPLIT[178].strip() + REPORT_DATA_SPLIT[181].strip()),
          "source.fqdn": "logsdoninc.com",
          "time.observation": "2018-01-22T14:38:24+00:00",
          "feed.url": "http://www.malwareurl.com",
          "source.ip": "23.99.128.52"}
EVENT3 = {"__type": "Event",
          "feed.name": "Malware url",
          "classification.type": "phishing",
          "raw": utils.base64_encode(REPORT_DATA_SPLIT[186].strip() + REPORT_DATA_SPLIT[189].strip()),
          "source.fqdn": "admin-survey.com",
          "time.observation": "2018-01-22T14:38:24+00:00",
          "feed.url": "http://www.malwareurl.com",
          "source.ip": "198.54.117.2"}


class TestMalwareurlParserBot(test.BotTestCase, unittest.TestCase):

    @classmethod
    def set_bot(cls):
        cls.bot_reference = MalwareurlParserBot
        cls.default_input_message = REPORT

    def test_event(self):
        self.run_bot()
        self.assertMessageEqual(0, EVENT1)
        self.assertMessageEqual(1, EVENT2)
        self.assertMessageEqual(2, EVENT3)

if __name__ == '__main__':  # pragma: no cover
    unittest.main()
