// Generated by CoffeeScript 1.10.0
(function() {
  var $, EventsCalendar, ref;

  $ = (ref = this.joyJQ) != null ? ref : this.$;

  EventsCalendar = (function() {
    function EventsCalendar() {
      return;
    }

    EventsCalendar.prototype.enable = function() {
      this._enablePopup();
      $(window).resize((function(_this) {
        return function() {
          return _this._handleResize();
        };
      })(this));
      this._handleResize();
    };

    EventsCalendar.prototype._enablePopup = function() {
      if ($("#joyous-overlay").length === 0) {
        $("<div id=\"joyous-overlay\" class=\"joy-overlay\"></div>\n<div class=\"joy-popup joy-popup__outer\">\n  <div id=\"joyous-more-events\" class=\"calendar joy-popup__content\">\n    <a class=\"joy-popup__close\" href=\"#\">×</a>\n    <div class=\"joy-cal__day-title\"></div>\n    <div class=\"joy-days-events\"></div>\n  </div>\n</div>").appendTo("body");
      }
      $(".joy-overlay, .joy-popup__outer, .joy-popup__close").click(function() {
        $(".joy-overlay, .joy-popup__outer").hide();
        return false;
      });
      return $(".joy-popup__content").click(function(event) {
        return event.stopPropagation();
      });
    };

    EventsCalendar.prototype._handleResize = function() {
      if ($(".joy-cal--monthly").length > 0) {
        this._adjustDays();
      }
      this._linkReadMore();
    };

    EventsCalendar.prototype._adjustDays = function() {
      var eventsHeight, height, width;
      width = $(".joy-cal--monthly .joy-cal__day").first().outerWidth();
      height = $(".joy-cal--monthly .joy-cal__date").first().outerHeight();
      eventsHeight = (width - height) * 0.71;
      $(".joy-cal--monthly .joy-days-events").outerHeight(eventsHeight);
    };

    EventsCalendar.prototype._linkReadMore = function() {
      $(".joy-days-events").each((function(_this) {
        return function(index, element) {
          var day;
          day = $(element).closest(".joy-cal__day");
          day.find(".joy-cal__read-more").remove();
          if (element.offsetHeight < element.scrollHeight || element.offsetWidth < element.scrollWidth) {
            _this._addReadMoreLink(day);
          }
        };
      })(this));
    };

    EventsCalendar.prototype._addReadMoreLink = function(day) {
      var link;
      link = $("<a>").attr('href', 'javascript:void 0').attr('title', "Show all of this day's events").addClass("joy-cal__read-more").text("+");
      link.click(function(ev) {
        var events, title, y;
        title = day.find(".joy-cal__day-title").clone();
        $("#joyous-more-events .joy-cal__day-title").replaceWith(title);
        events = day.find(".joy-days-events").clone().height('auto');
        $("#joyous-more-events .joy-days-events").replaceWith(events);
        y = Math.max(ev.pageY - 100, $(window).scrollTop());
        $(".joy-popup__outer").css('top', y);
        $("#joyous-overlay, .joy-popup__outer").show();
        return false;
      });
      day.append(link);
    };

    return EventsCalendar;

  })();

  $(function() {
    var calendar;
    calendar = new EventsCalendar();
    calendar.enable();
  });

}).call(this);
