# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import date, datetime  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel  # noqa: F401
from pydantic import AnyUrl, Field

from telus_bulk.models.tmf_645.check_service_qualification_item import (
    CheckServiceQualificationItem,
)
from telus_bulk.models.tmf_645.related_party import RelatedParty
from telus_bulk.models.tmf_645.task_state_type import TaskStateType


class CheckServiceQualificationUpdate(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CheckServiceQualificationUpdate - a model defined in OpenAPI

        description: The description of this CheckServiceQualificationUpdate [Optional].
        effective_qualification_date: The effective_qualification_date of this CheckServiceQualificationUpdate [Optional].
        estimated_response_date: The estimated_response_date of this CheckServiceQualificationUpdate [Optional].
        expected_qualification_date: The expected_qualification_date of this CheckServiceQualificationUpdate [Optional].
        expiration_date: The expiration_date of this CheckServiceQualificationUpdate [Optional].
        external_id: The external_id of this CheckServiceQualificationUpdate [Optional].
        instant_sync_qualification: The instant_sync_qualification of this CheckServiceQualificationUpdate [Optional].
        provide_alternative: The provide_alternative of this CheckServiceQualificationUpdate [Optional].
        provide_unavailability_reason: The provide_unavailability_reason of this CheckServiceQualificationUpdate [Optional].
        qualification_result: The qualification_result of this CheckServiceQualificationUpdate [Optional].
        related_party: The related_party of this CheckServiceQualificationUpdate [Optional].
        service_qualification_item: The service_qualification_item of this CheckServiceQualificationUpdate [Optional].
        state: The state of this CheckServiceQualificationUpdate [Optional].
        base_type: The base_type of this CheckServiceQualificationUpdate [Optional].
        schema_location: The schema_location of this CheckServiceQualificationUpdate [Optional].
        type: The type of this CheckServiceQualificationUpdate [Optional].
    """

    description: Optional[str] = None
    effective_qualification_date: Optional[datetime] = None
    estimated_response_date: Optional[datetime] = None
    expected_qualification_date: Optional[datetime] = None
    expiration_date: Optional[datetime] = None
    external_id: Optional[str] = None
    instant_sync_qualification: Optional[bool] = None
    provide_alternative: Optional[bool] = None
    provide_unavailability_reason: Optional[bool] = None
    qualification_result: Optional[str] = None
    related_party: Optional[List[RelatedParty]] = None
    service_qualification_item: Optional[List[CheckServiceQualificationItem]] = None
    state: Optional[TaskStateType] = None
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


CheckServiceQualificationUpdate.update_forward_refs()
