# AUTOGENERATED! DO NOT EDIT! File to edit: control_refine.ipynb (unless otherwise specified).

__all__ = ['CPRefiner', 'CheckerRefiner', 'checker_opencv', 'OpenCVCheckerRefiner', 'EllipseRefiner', 'fit_conic',
           'ellipse_dualconic', 'DualConicEllipseRefiner']

# Cell
import math

import numpy as np
import skimage.draw
import torch
from torch.distributions.multivariate_normal import MultivariateNormal

from .utils import *

# Cell
class CPRefiner:
    def __init__(self, cutoff_it, cutoff_norm):
        self.cutoff_it   = cutoff_it
        self.cutoff_norm = cutoff_norm

    def proc_arr(self, arr):            return (arr,)
    def it_preproc(self, p, b):         pass
    def get_bb(self, p, b):             raise NotImplementedError('Please implement get_bb')
    def get_W(self, p, b, bb):          return None
    def refine_point(self, arrs, p, W): raise NotImplementedError('Please implement refine_point')

    def __call__(self, arr, ps, bs):
        arrs = self.proc_arr(arr)
        bb_arr = array_bb(arr)
        ps_refined = []
        for idx, (p, b) in enumerate(zip(ps, bs)):
            self.it_preproc(p, b)
            b_init = b
            for it in torch.arange(self.cutoff_it):
                p_prev = p
                bb = self.get_bb(p, b)
                if not is_bb_in_bb(bb, bb_arr): p = arr.new_full(2, math.nan); break
                W = self.get_W(p, b, bb)
                p = self.refine_point(tuple(bb_array(arr, bb) for arr in arrs), p-bb[0], W)+bb[0]
                if torch.any(torch.isnan(p)): break
                if not is_p_in_b(p, b_init):    p = arr.new_full(2, math.nan); break
                if torch.norm(p-p_prev) < self.cutoff_norm: break
                b = b-p_prev+p
            ps_refined.append(p)
        return stackify(tuple(ps_refined))

# Cell
class CheckerRefiner(CPRefiner):
    def __init__(self, hw_min, hw_max, cutoff_it, cutoff_norm):
        super().__init__(cutoff_it, cutoff_norm)
        assert_allclose(type(hw_min), int)
        assert_allclose(type(hw_max), int)
        self.hw_min, self.hw_max = hw_min, hw_max

    def it_preproc(self, p, b):
        d_min = min([pld(p, l) for l in b_ls(b)])
        hw = torch.floor(d_min/math.sqrt(2))
        hw = hw.clamp(self.hw_min, self.hw_max)
        self.hw = hw
        self.bb = stackify(((-hw, -hw),
                            ( hw,  hw)))

    def get_bb(self, p, b): return self.bb+p.round()

    def get_W(self, p, b, bb):
        zero = p.new_tensor(0)

        sigma = self.hw/2
        cov = stackify(((sigma**2,     zero),
                        (    zero, sigma**2)))
        d = MultivariateNormal(p, covariance_matrix=cov)
        return torch.exp(d.log_prob(grid2ps(*bb_grid(bb)))).reshape(tuple(bb_sz(bb).long()))

# Cell
@numpyify
def checker_opencv(arr_dx, arr_dy, W=None):
    # Condition array points
    ps_cond, T = condition(array_ps(arr_dx))

    # Form linear system
    A = grid2ps(arr_dx, arr_dy)
    b = (A*ps_cond).sum(dim=1)

    # Get weighted least squares estimate
    p = wlstsq(A, b, W)

    # Convert back to unconditioned points
    return pmm(p, torch.inverse(T), aug=True)

# Cell
class OpenCVCheckerRefiner(CheckerRefiner):
    def __init__(self, hw_min, hw_max, cutoff_it, cutoff_norm):
        super().__init__(hw_min, hw_max, cutoff_it, cutoff_norm)

    def proc_arr(self, arr): return grad_array(arr)

    def refine_point(self, arrs, p, W): return checker_opencv(*arrs, W)

# Cell
class EllipseRefiner(CPRefiner):
    def __init__(self, cutoff_it, cutoff_norm):
        super().__init__(cutoff_it, cutoff_norm)

    def it_preproc(self, p, b):
        bb = ps_bb(b)
        bb = stackify((bb[0].floor(), bb[1].ceil()))
        W = p.new_tensor(skimage.draw.polygon2mask(*torch2np((tuple(bb_sz(bb).long()), b-bb[0]))))
        self.bb, self.W = bb-p.round(), W

    def get_bb(self, p, b):    return self.bb+p.round()

    def get_W(self, p, b, bb): return self.W

# Cell
@numpyify
def fit_conic(arr_dx, arr_dy, W=None):
    one = arr_dx.new_tensor(1)

    # Condition array points
    ps_cond, T = condition(array_ps(arr_dx))

    # Form homogeneous coordinates of lines
    ls = grid2ps(arr_dx, arr_dy)
    ls = torch.cat([ls, -(ls*ps_cond).sum(dim=1, keepdim=True)], dim=1)

    # Form linear system
    A = stackify((ls[:,0]**2, ls[:,0]*ls[:,1], ls[:,1]**2, ls[:,0]*ls[:,2], ls[:,1]*ls[:,2]), dim=1)
    b = -ls[:, 2]**2

    # Get weighted least squares estimate
    aq_inv = wlstsq(A, b, W)

    # Get conic matrix
    Aq_inv = stackify(((  aq_inv[0], aq_inv[1]/2, aq_inv[3]/2),
                       (aq_inv[1]/2,   aq_inv[2], aq_inv[4]/2),
                       (aq_inv[3]/2, aq_inv[4]/2,         one)))
    Aq = torch.inverse(Aq_inv)

    # Rescale conic matrix to take conditioning into account
    return T.T@Aq@T

# Cell
@numpyify
def ellipse_dualconic(arr_dx, arr_dy, W=None):
    Aq = fit_conic(arr_dx, arr_dy, W)
    return conic2ellipse(Aq)

# Cell
class DualConicEllipseRefiner(EllipseRefiner):
    def __init__(self, cutoff_it, cutoff_norm):
        super().__init__(cutoff_it, cutoff_norm)

    def proc_arr(self, arr): return grad_array(arr)

    def refine_point(self, arrs, p, W): return ellipse_dualconic(*arrs, W)[:2]