# AUTOGENERATED! DO NOT EDIT! File to edit: api.ipynb (unless otherwise specified).

__all__ = ['plot_bipartite', 'plot_residuals', 'plot_extrinsics', 'save', 'load']

# Cell
from .calib import multi_calib
from .cb_geom import CbGeom, CpCSRGrid, FmCFPGrid
from .control_refine import OpenCVCheckerRefiner
from .fiducial_detect import DotVisionCheckerDLDetector
from .image import File16bitImg

# Cell
def plot_bipartite(calib, ax=None):
    import camera_calib.calib

    camera_calib.calib.plot_bipartite(*calib['graph'], ax=ax)

# Cell
def plot_residuals(calib, ax=None):
    import matplotlib.pyplot as plt

    if ax == None: _, ax = plt.subplots(1, 1, figsize=(6,6))

    for p1, p2 in zip(calib['pss_c_p'], calib['pss_c_p_m']):
        res = p1-p2
        plt.plot(res[:,0], res[:,1], 's')
    ax.set_aspect(1)
    ax.set_xlim(-0.25, 0.25)
    ax.set_ylim(-0.25, 0.25)
    return ax

# Cell
def plot_extrinsics(calib, ax=None):
    import camera_calib.plot

    Ms_cb  = tuple(rigid_cb.get_param()  for rigid_cb  in calib['rigids_cb'])
    Ms_cam = tuple(rigid_cam.get_param() for rigid_cam in calib['rigids_cam'])
    return camera_calib.plot.plot_extrinsics(Ms_cb, Ms_cam, calib['cb_geom'], ax=ax)

# Cell
def save(calib, file_calib):
    import torch
    torch.save(calib, file_calib)

# Cell
def load(file_calib):
    import torch
    return torch.load(file_calib)