/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import java.util.ArrayList;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementImage;
import net.sourceforge.plantuml.salt.factory.ElementFactory;

public class ElementFactoryImage
implements ElementFactory {
    private final DataSource dataSource;
    private final Dictionary dictionary;

    public ElementFactoryImage(DataSource dataSource, Dictionary dictionary) {
        this.dataSource = dataSource;
        this.dictionary = dictionary;
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        String header = (String)((Terminated)this.dataSource.next()).getElement();
        String name = header.length() > 2 ? header.substring(2) : null;
        ArrayList<String> img = new ArrayList<String>();
        while (!this.dataSource.peek(0).getElement().equals(">>")) {
            img.add((String)((Terminated)this.dataSource.next()).getElement());
        }
        Terminated next = (Terminated)this.dataSource.next();
        ElementImage element = new ElementImage(img);
        if (name != null) {
            this.dictionary.put(name, element);
        }
        return new Terminated<Element>(element, next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.dataSource.peek(0).getElement();
        return text.equals("<<") || text.matches("\\<\\<\\w+");
    }
}

