/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.gitlog.GNode;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class MagicBox {
    private final ISkinParam skinParam;
    private final GNode node;

    public MagicBox(ISkinParam skinParam, GNode node) {
        this.skinParam = skinParam;
        this.node = node;
    }

    private TextBlock getSmallBlock() {
        FontConfiguration mono = new FontConfiguration(UFont.monospaced(15).bold(), HColorUtils.BLACK, HColorUtils.BLACK, false);
        TextBlock big = this.node.getDisplay().create(mono, HorizontalAlignment.CENTER, this.skinParam);
        return big;
    }

    private TextBlock getCommentBlock() {
        if (this.node.getComment() != null && this.node.isTop()) {
            FontConfiguration tag = new FontConfiguration(UFont.sansSerif(13), HColorUtils.BLACK, HColorUtils.BLACK, false);
            return Display.create(this.node.getComment()).create(tag, HorizontalAlignment.CENTER, this.skinParam);
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    public Dimension2D getBigDim(StringBounder stringBounder) {
        Dimension2D dimComment = this.getCommentBlock().calculateDimension(stringBounder);
        Dimension2D dimSmall = this.getSmallBlock().calculateDimension(stringBounder);
        Dimension2D mergeTB = Dimension2DDouble.mergeTB(dimComment, dimSmall);
        return Dimension2DDouble.delta(mergeTB, 8.0, 2.0);
    }

    public void drawBorder(UGraphic ug, Dimension2D sizeInDot) {
        TextBlock comment = this.getCommentBlock();
        TextBlock small = this.getSmallBlock();
        double moveY = comment.calculateDimension(ug.getStringBounder()).getHeight();
        URectangle rect = new URectangle(sizeInDot.getWidth(), sizeInDot.getHeight() - moveY).rounded(8.0);
        ug.apply(new UStroke(1.5)).apply(UTranslate.dy(moveY)).draw(rect);
        comment.drawU(ug);
        double deltaWidth = rect.getWidth() - small.calculateDimension(ug.getStringBounder()).getWidth();
        double deltaHeight = rect.getHeight() - small.calculateDimension(ug.getStringBounder()).getHeight();
        small.drawU(ug.apply(new UTranslate(deltaWidth / 2.0, moveY + deltaHeight / 2.0)));
    }
}

