# -*- coding: utf-8 -*-

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .compute import (
    AcceleratorConfig,
    DeprecationStatus,
    AcceleratorType,
    AcceleratorTypesScopedList,
    Data,
    Warning,
    AcceleratorTypeAggregatedList,
    AcceleratorTypeList,
    AccessConfig,
    Address,
    AddressesScopedList,
    AddressAggregatedList,
    AddressList,
    AliasIpRange,
    AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
    AllocationSpecificSKUAllocationReservedInstanceProperties,
    AllocationSpecificSKUReservation,
    CustomerEncryptionKey,
    GuestOsFeature,
    AttachedDiskInitializeParams,
    InitialStateConfig,
    AttachedDisk,
    AuditLogConfig,
    AuditConfig,
    AuthorizationLoggingOptions,
    AutoscalingPolicy,
    AutoscalerStatusDetails,
    Autoscaler,
    AutoscalersScopedList,
    AutoscalerAggregatedList,
    AutoscalerList,
    AutoscalingPolicyCpuUtilization,
    AutoscalingPolicyCustomMetricUtilization,
    AutoscalingPolicyLoadBalancingUtilization,
    AutoscalingPolicyScaleInControl,
    FixedOrPercent,
    Backend,
    BackendBucketCdnPolicy,
    BackendBucket,
    BackendBucketList,
    BackendServiceCdnPolicy,
    CircuitBreakers,
    ConnectionDraining,
    ConsistentHashLoadBalancerSettings,
    BackendServiceFailoverPolicy,
    BackendServiceIAP,
    BackendServiceLogConfig,
    OutlierDetection,
    SecuritySettings,
    BackendService,
    BackendServicesScopedList,
    BackendServiceAggregatedList,
    CacheKeyPolicy,
    HealthStatus,
    BackendServiceGroupHealth,
    BackendServiceList,
    BackendServiceReference,
    Expr,
    Binding,
    CacheInvalidationRule,
    LicenseResourceCommitment,
    Reservation,
    ResourceCommitment,
    Commitment,
    CommitmentsScopedList,
    CommitmentAggregatedList,
    CommitmentList,
    Condition,
    ConfidentialInstanceConfig,
    ConsistentHashLoadBalancerSettingsHttpCookie,
    Duration,
    CorsPolicy,
    CustomerEncryptionKeyProtectedDisk,
    Disk,
    DisksScopedList,
    DiskAggregatedList,
    DiskInstantiationConfig,
    DiskList,
    DiskMoveRequest,
    DiskType,
    DiskTypesScopedList,
    DiskTypeAggregatedList,
    DiskTypeList,
    DisksAddResourcePoliciesRequest,
    DisksRemoveResourcePoliciesRequest,
    DisksResizeRequest,
    DisplayDevice,
    DistributionPolicyZoneConfiguration,
    DistributionPolicy,
    ExchangedPeeringRoute,
    ExchangedPeeringRoutesList,
    ExternalVpnGatewayInterface,
    ExternalVpnGateway,
    ExternalVpnGatewayList,
    FileContentBuffer,
    Allowed,
    Denied,
    FirewallLogConfig,
    Firewall,
    FirewallList,
    MetadataFilter,
    ForwardingRule,
    ForwardingRulesScopedList,
    ForwardingRuleAggregatedList,
    ForwardingRuleList,
    ForwardingRuleReference,
    GRPCHealthCheck,
    NetworkEndpoint,
    GlobalNetworkEndpointGroupsAttachEndpointsRequest,
    GlobalNetworkEndpointGroupsDetachEndpointsRequest,
    GlobalSetLabelsRequest,
    Policy,
    GlobalSetPolicyRequest,
    GuestAttributesValue,
    GuestAttributes,
    GuestAttributesEntry,
    HTTP2HealthCheck,
    HTTPHealthCheck,
    HTTPSHealthCheck,
    HealthCheckLogConfig,
    SSLHealthCheck,
    TCPHealthCheck,
    HealthCheck,
    HealthCheckList,
    HealthCheckReference,
    HealthCheckService,
    HealthCheckServiceReference,
    HealthCheckServicesList,
    HealthChecksScopedList,
    HealthChecksAggregatedList,
    HealthStatusForNetworkEndpoint,
    HostRule,
    HttpFaultAbort,
    HttpFaultDelay,
    HttpFaultInjection,
    HttpHeaderOption,
    HttpHeaderAction,
    Int64RangeMatch,
    HttpHeaderMatch,
    HttpQueryParameterMatch,
    HttpRedirectAction,
    HttpRetryPolicy,
    RequestMirrorPolicy,
    UrlRewrite,
    WeightedBackendService,
    HttpRouteAction,
    HttpRouteRuleMatch,
    HttpRouteRule,
    RawDisk,
    Image,
    ImageList,
    Metadata,
    NetworkInterface,
    ReservationAffinity,
    Scheduling,
    ServiceAccount,
    ShieldedInstanceConfig,
    ShieldedInstanceIntegrityPolicy,
    Tags,
    Instance,
    InstancesScopedList,
    InstanceAggregatedList,
    NamedPort,
    InstanceGroup,
    InstanceGroupsScopedList,
    InstanceGroupAggregatedList,
    InstanceGroupList,
    InstanceGroupManagerAutoHealingPolicy,
    InstanceGroupManagerActionsSummary,
    StatefulPolicy,
    InstanceGroupManagerStatus,
    InstanceGroupManagerUpdatePolicy,
    InstanceGroupManagerVersion,
    InstanceGroupManager,
    InstanceGroupManagersScopedList,
    InstanceGroupManagerAggregatedList,
    InstanceGroupManagerList,
    InstanceGroupManagerStatusStateful,
    InstanceGroupManagerStatusVersionTarget,
    InstanceGroupManagerStatusStatefulPerInstanceConfigs,
    InstanceGroupManagersAbandonInstancesRequest,
    InstanceGroupManagersApplyUpdatesRequest,
    PerInstanceConfig,
    InstanceGroupManagersCreateInstancesRequest,
    InstanceGroupManagersDeleteInstancesRequest,
    InstanceGroupManagersDeletePerInstanceConfigsReq,
    InstanceManagedByIgmError,
    InstanceGroupManagersListErrorsResponse,
    ManagedInstance,
    InstanceGroupManagersListManagedInstancesResponse,
    InstanceGroupManagersListPerInstanceConfigsResp,
    InstanceGroupManagersPatchPerInstanceConfigsReq,
    InstanceGroupManagersRecreateInstancesRequest,
    InstanceGroupManagersSetInstanceTemplateRequest,
    InstanceGroupManagersSetTargetPoolsRequest,
    InstanceGroupManagersUpdatePerInstanceConfigsReq,
    InstanceReference,
    InstanceGroupsAddInstancesRequest,
    InstanceWithNamedPorts,
    InstanceGroupsListInstances,
    InstanceGroupsListInstancesRequest,
    InstanceGroupsRemoveInstancesRequest,
    InstanceGroupsSetNamedPortsRequest,
    InstanceList,
    Reference,
    InstanceListReferrers,
    InstanceManagedByIgmErrorManagedInstanceError,
    InstanceManagedByIgmErrorInstanceActionDetails,
    ManagedInstanceVersion,
    InstanceMoveRequest,
    InstanceProperties,
    SourceInstanceParams,
    InstanceTemplate,
    InstanceTemplateList,
    InstancesAddResourcePoliciesRequest,
    InstancesRemoveResourcePoliciesRequest,
    InstancesSetLabelsRequest,
    InstancesSetMachineResourcesRequest,
    InstancesSetMachineTypeRequest,
    InstancesSetMinCpuPlatformRequest,
    InstancesSetServiceAccountRequest,
    InstancesStartWithEncryptionKeyRequest,
    InterconnectCircuitInfo,
    InterconnectOutageNotification,
    Interconnect,
    InterconnectAttachmentPartnerMetadata,
    InterconnectAttachmentPrivateInfo,
    InterconnectAttachment,
    InterconnectAttachmentsScopedList,
    InterconnectAttachmentAggregatedList,
    InterconnectAttachmentList,
    InterconnectDiagnosticsARPEntry,
    InterconnectDiagnosticsLinkStatus,
    InterconnectDiagnostics,
    InterconnectDiagnosticsLinkLACPStatus,
    InterconnectDiagnosticsLinkOpticalPower,
    InterconnectList,
    InterconnectLocationRegionInfo,
    InterconnectLocation,
    InterconnectLocationList,
    InterconnectsGetDiagnosticsResponse,
    LicenseResourceRequirements,
    License,
    LicenseCodeLicenseAlias,
    LicenseCode,
    LicensesListResponse,
    LocalDisk,
    LogConfigCloudAuditOptions,
    LogConfigCounterOptions,
    LogConfigDataAccessOptions,
    LogConfig,
    LogConfigCounterOptionsCustomField,
    Accelerators,
    ScratchDisks,
    MachineType,
    MachineTypesScopedList,
    MachineTypeAggregatedList,
    MachineTypeList,
    ManagedInstanceInstanceHealth,
    ManagedInstanceLastAttempt,
    PreservedState,
    Errors,
    Items,
    MetadataFilterLabelMatch,
    NetworkPeering,
    NetworkRoutingConfig,
    Network,
    NetworkEndpointGroupAppEngine,
    NetworkEndpointGroupCloudFunction,
    NetworkEndpointGroupCloudRun,
    NetworkEndpointGroup,
    NetworkEndpointGroupsScopedList,
    NetworkEndpointGroupAggregatedList,
    NetworkEndpointGroupList,
    NetworkEndpointGroupsAttachEndpointsRequest,
    NetworkEndpointGroupsDetachEndpointsRequest,
    NetworkEndpointGroupsListEndpointsRequest,
    NetworkEndpointWithHealthStatus,
    NetworkEndpointGroupsListNetworkEndpoints,
    NetworkList,
    NetworksAddPeeringRequest,
    NetworksRemovePeeringRequest,
    NetworksUpdatePeeringRequest,
    NodeGroupAutoscalingPolicy,
    NodeGroupMaintenanceWindow,
    NodeGroup,
    NodeGroupsScopedList,
    NodeGroupAggregatedList,
    NodeGroupList,
    ServerBinding,
    NodeGroupNode,
    NodeGroupsAddNodesRequest,
    NodeGroupsDeleteNodesRequest,
    NodeGroupsListNodes,
    NodeGroupsSetNodeTemplateRequest,
    NodeTemplateNodeTypeFlexibility,
    NodeTemplate,
    NodeTemplatesScopedList,
    NodeTemplateAggregatedList,
    NodeTemplateList,
    NodeType,
    NodeTypesScopedList,
    NodeTypeAggregatedList,
    NodeTypeList,
    NotificationEndpointGrpcSettings,
    NotificationEndpoint,
    NotificationEndpointList,
    Error,
    Warnings,
    Operation,
    OperationsScopedList,
    OperationAggregatedList,
    OperationList,
    PacketMirroringForwardingRuleInfo,
    PacketMirroringFilter,
    PacketMirroringMirroredResourceInfo,
    PacketMirroringNetworkInfo,
    PacketMirroring,
    PacketMirroringsScopedList,
    PacketMirroringAggregatedList,
    PacketMirroringList,
    PacketMirroringMirroredResourceInfoInstanceInfo,
    PacketMirroringMirroredResourceInfoSubnetInfo,
    PathRule,
    PathMatcher,
    Rule,
    WafExpressionSet,
    PreconfiguredWafSet,
    PreservedStatePreservedDisk,
    Quota,
    UsageExportLocation,
    Project,
    XpnResourceId,
    ProjectsDisableXpnResourceRequest,
    ProjectsEnableXpnResourceRequest,
    ProjectsGetXpnResources,
    ProjectsListXpnHostsRequest,
    ProjectsSetDefaultNetworkTierRequest,
    Region,
    RegionAutoscalerList,
    RegionDiskTypeList,
    RegionDisksAddResourcePoliciesRequest,
    RegionDisksRemoveResourcePoliciesRequest,
    RegionDisksResizeRequest,
    RegionInstanceGroupList,
    RegionInstanceGroupManagerDeleteInstanceConfigReq,
    RegionInstanceGroupManagerList,
    RegionInstanceGroupManagerPatchInstanceConfigReq,
    RegionInstanceGroupManagerUpdateInstanceConfigReq,
    RegionInstanceGroupManagersAbandonInstancesRequest,
    RegionInstanceGroupManagersApplyUpdatesRequest,
    RegionInstanceGroupManagersCreateInstancesRequest,
    RegionInstanceGroupManagersDeleteInstancesRequest,
    RegionInstanceGroupManagersListErrorsResponse,
    RegionInstanceGroupManagersListInstanceConfigsResp,
    RegionInstanceGroupManagersListInstancesResponse,
    RegionInstanceGroupManagersRecreateRequest,
    RegionInstanceGroupManagersSetTargetPoolsRequest,
    RegionInstanceGroupManagersSetTemplateRequest,
    RegionInstanceGroupsListInstances,
    RegionInstanceGroupsListInstancesRequest,
    RegionInstanceGroupsSetNamedPortsRequest,
    RegionList,
    RegionSetLabelsRequest,
    RegionSetPolicyRequest,
    RegionTargetHttpsProxiesSetSslCertificatesRequest,
    UrlMap,
    RegionUrlMapsValidateRequest,
    ReservationsScopedList,
    ReservationAggregatedList,
    ReservationList,
    ReservationsResizeRequest,
    ResourceGroupReference,
    ResourcePolicy,
    ResourcePoliciesScopedList,
    ResourcePolicyGroupPlacementPolicy,
    ResourcePolicySnapshotSchedulePolicy,
    ResourcePolicyAggregatedList,
    ResourcePolicyDailyCycle,
    ResourcePolicyHourlyCycle,
    ResourcePolicyList,
    ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
    ResourcePolicySnapshotSchedulePolicySchedule,
    ResourcePolicySnapshotSchedulePolicySnapshotProperties,
    ResourcePolicyWeeklyCycle,
    ResourcePolicyWeeklyCycleDayOfWeek,
    Route,
    RouteList,
    RouterBgp,
    RouterBgpPeer,
    RouterInterface,
    RouterNat,
    Router,
    RouterAdvertisedIpRange,
    RoutersScopedList,
    RouterAggregatedList,
    RouterList,
    RouterNatLogConfig,
    RouterNatSubnetworkToNat,
    RouterStatusBgpPeerStatus,
    RouterStatusNatStatus,
    RouterStatus,
    RouterStatusResponse,
    RoutersPreviewResponse,
    SchedulingNodeAffinity,
    Screenshot,
    SecurityPoliciesWafConfig,
    SecurityPoliciesListPreconfiguredExpressionSetsResponse,
    SecurityPolicyRule,
    SecurityPolicy,
    SecurityPolicyList,
    SecurityPolicyReference,
    SecurityPolicyRuleMatcher,
    SecurityPolicyRuleMatcherConfig,
    SerialPortOutput,
    ShieldedInstanceIdentityEntry,
    ShieldedInstanceIdentity,
    SignedUrlKey,
    Snapshot,
    SnapshotList,
    SslCertificateManagedSslCertificate,
    SslCertificateSelfManagedSslCertificate,
    SslCertificate,
    SslCertificatesScopedList,
    SslCertificateAggregatedList,
    SslCertificateList,
    SslPolicy,
    SslPoliciesList,
    SslPoliciesListAvailableFeaturesResponse,
    SslPolicyReference,
    StatefulPolicyPreservedState,
    StatefulPolicyPreservedStateDiskDevice,
    SubnetworkLogConfig,
    SubnetworkSecondaryRange,
    Subnetwork,
    SubnetworksScopedList,
    SubnetworkAggregatedList,
    SubnetworkList,
    SubnetworksExpandIpCidrRangeRequest,
    SubnetworksSetPrivateIpGoogleAccessRequest,
    TargetGrpcProxy,
    TargetGrpcProxyList,
    TargetHttpProxy,
    TargetHttpProxiesScopedList,
    TargetHttpProxyAggregatedList,
    TargetHttpProxyList,
    TargetHttpsProxy,
    TargetHttpsProxiesScopedList,
    TargetHttpsProxiesSetQuicOverrideRequest,
    TargetHttpsProxiesSetSslCertificatesRequest,
    TargetHttpsProxyAggregatedList,
    TargetHttpsProxyList,
    TargetInstance,
    TargetInstancesScopedList,
    TargetInstanceAggregatedList,
    TargetInstanceList,
    TargetPool,
    TargetPoolsScopedList,
    TargetPoolAggregatedList,
    TargetPoolInstanceHealth,
    TargetPoolList,
    TargetPoolsAddHealthCheckRequest,
    TargetPoolsAddInstanceRequest,
    TargetPoolsRemoveHealthCheckRequest,
    TargetPoolsRemoveInstanceRequest,
    TargetReference,
    TargetSslProxiesSetBackendServiceRequest,
    TargetSslProxiesSetProxyHeaderRequest,
    TargetSslProxiesSetSslCertificatesRequest,
    TargetSslProxy,
    TargetSslProxyList,
    TargetTcpProxiesSetBackendServiceRequest,
    TargetTcpProxiesSetProxyHeaderRequest,
    TargetTcpProxy,
    TargetTcpProxyList,
    TargetVpnGateway,
    TargetVpnGatewaysScopedList,
    TargetVpnGatewayAggregatedList,
    TargetVpnGatewayList,
    TestFailure,
    TestPermissionsRequest,
    TestPermissionsResponse,
    UrlMapTest,
    UrlMapList,
    UrlMapReference,
    UrlMapValidationResult,
    UrlMapsScopedList,
    UrlMapsAggregatedList,
    UrlMapsValidateRequest,
    UrlMapsValidateResponse,
    UsableSubnetworkSecondaryRange,
    UsableSubnetwork,
    UsableSubnetworksAggregatedList,
    VmEndpointNatMappingsInterfaceNatMappings,
    VmEndpointNatMappings,
    VmEndpointNatMappingsList,
    VpnGatewayVpnGatewayInterface,
    VpnGateway,
    VpnGatewaysScopedList,
    VpnGatewayAggregatedList,
    VpnGatewayList,
    VpnGatewayStatusVpnConnection,
    VpnGatewayStatus,
    VpnGatewayStatusHighAvailabilityRequirementState,
    VpnGatewayStatusTunnel,
    VpnGatewaysGetStatusResponse,
    VpnTunnel,
    VpnTunnelsScopedList,
    VpnTunnelAggregatedList,
    VpnTunnelList,
    WafExpressionSetExpression,
    XpnHostList,
    Zone,
    ZoneList,
    ZoneSetLabelsRequest,
    ZoneSetPolicyRequest,
    AggregatedListAcceleratorTypesRequest,
    GetAcceleratorTypeRequest,
    ListAcceleratorTypesRequest,
    AggregatedListAddressesRequest,
    DeleteAddressRequest,
    GetAddressRequest,
    InsertAddressRequest,
    ListAddressesRequest,
    AggregatedListAutoscalersRequest,
    DeleteAutoscalerRequest,
    GetAutoscalerRequest,
    InsertAutoscalerRequest,
    ListAutoscalersRequest,
    PatchAutoscalerRequest,
    UpdateAutoscalerRequest,
    AddSignedUrlKeyBackendBucketRequest,
    DeleteBackendBucketRequest,
    DeleteSignedUrlKeyBackendBucketRequest,
    GetBackendBucketRequest,
    InsertBackendBucketRequest,
    ListBackendBucketsRequest,
    PatchBackendBucketRequest,
    UpdateBackendBucketRequest,
    AddSignedUrlKeyBackendServiceRequest,
    AggregatedListBackendServicesRequest,
    DeleteBackendServiceRequest,
    DeleteSignedUrlKeyBackendServiceRequest,
    GetBackendServiceRequest,
    GetHealthBackendServiceRequest,
    InsertBackendServiceRequest,
    ListBackendServicesRequest,
    PatchBackendServiceRequest,
    SetSecurityPolicyBackendServiceRequest,
    UpdateBackendServiceRequest,
    AggregatedListDiskTypesRequest,
    GetDiskTypeRequest,
    ListDiskTypesRequest,
    AddResourcePoliciesDiskRequest,
    AggregatedListDisksRequest,
    CreateSnapshotDiskRequest,
    DeleteDiskRequest,
    GetDiskRequest,
    GetIamPolicyDiskRequest,
    InsertDiskRequest,
    ListDisksRequest,
    RemoveResourcePoliciesDiskRequest,
    ResizeDiskRequest,
    SetIamPolicyDiskRequest,
    SetLabelsDiskRequest,
    TestIamPermissionsDiskRequest,
    DeleteExternalVpnGatewayRequest,
    GetExternalVpnGatewayRequest,
    InsertExternalVpnGatewayRequest,
    ListExternalVpnGatewaysRequest,
    SetLabelsExternalVpnGatewayRequest,
    TestIamPermissionsExternalVpnGatewayRequest,
    DeleteFirewallRequest,
    GetFirewallRequest,
    InsertFirewallRequest,
    ListFirewallsRequest,
    PatchFirewallRequest,
    UpdateFirewallRequest,
    AggregatedListForwardingRulesRequest,
    DeleteForwardingRuleRequest,
    GetForwardingRuleRequest,
    InsertForwardingRuleRequest,
    ListForwardingRulesRequest,
    PatchForwardingRuleRequest,
    SetTargetForwardingRuleRequest,
    DeleteGlobalAddressRequest,
    GetGlobalAddressRequest,
    InsertGlobalAddressRequest,
    ListGlobalAddressesRequest,
    DeleteGlobalForwardingRuleRequest,
    GetGlobalForwardingRuleRequest,
    InsertGlobalForwardingRuleRequest,
    ListGlobalForwardingRulesRequest,
    PatchGlobalForwardingRuleRequest,
    SetTargetGlobalForwardingRuleRequest,
    AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    DeleteGlobalNetworkEndpointGroupRequest,
    DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    GetGlobalNetworkEndpointGroupRequest,
    InsertGlobalNetworkEndpointGroupRequest,
    ListGlobalNetworkEndpointGroupsRequest,
    ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest,
    AggregatedListGlobalOperationsRequest,
    DeleteGlobalOperationRequest,
    DeleteGlobalOperationResponse,
    GetGlobalOperationRequest,
    ListGlobalOperationsRequest,
    WaitGlobalOperationRequest,
    DeleteGlobalOrganizationOperationRequest,
    DeleteGlobalOrganizationOperationResponse,
    GetGlobalOrganizationOperationRequest,
    ListGlobalOrganizationOperationsRequest,
    AggregatedListHealthChecksRequest,
    DeleteHealthCheckRequest,
    GetHealthCheckRequest,
    InsertHealthCheckRequest,
    ListHealthChecksRequest,
    PatchHealthCheckRequest,
    UpdateHealthCheckRequest,
    DeleteImageRequest,
    DeprecateImageRequest,
    GetImageRequest,
    GetFromFamilyImageRequest,
    GetIamPolicyImageRequest,
    InsertImageRequest,
    ListImagesRequest,
    PatchImageRequest,
    SetIamPolicyImageRequest,
    SetLabelsImageRequest,
    TestIamPermissionsImageRequest,
    AbandonInstancesInstanceGroupManagerRequest,
    AggregatedListInstanceGroupManagersRequest,
    ApplyUpdatesToInstancesInstanceGroupManagerRequest,
    CreateInstancesInstanceGroupManagerRequest,
    DeleteInstanceGroupManagerRequest,
    DeleteInstancesInstanceGroupManagerRequest,
    DeletePerInstanceConfigsInstanceGroupManagerRequest,
    GetInstanceGroupManagerRequest,
    InsertInstanceGroupManagerRequest,
    ListInstanceGroupManagersRequest,
    ListErrorsInstanceGroupManagersRequest,
    ListManagedInstancesInstanceGroupManagersRequest,
    ListPerInstanceConfigsInstanceGroupManagersRequest,
    PatchInstanceGroupManagerRequest,
    PatchPerInstanceConfigsInstanceGroupManagerRequest,
    RecreateInstancesInstanceGroupManagerRequest,
    ResizeInstanceGroupManagerRequest,
    SetInstanceTemplateInstanceGroupManagerRequest,
    SetTargetPoolsInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsInstanceGroupManagerRequest,
    AddInstancesInstanceGroupRequest,
    AggregatedListInstanceGroupsRequest,
    DeleteInstanceGroupRequest,
    GetInstanceGroupRequest,
    InsertInstanceGroupRequest,
    ListInstanceGroupsRequest,
    ListInstancesInstanceGroupsRequest,
    RemoveInstancesInstanceGroupRequest,
    SetNamedPortsInstanceGroupRequest,
    DeleteInstanceTemplateRequest,
    GetInstanceTemplateRequest,
    GetIamPolicyInstanceTemplateRequest,
    InsertInstanceTemplateRequest,
    ListInstanceTemplatesRequest,
    SetIamPolicyInstanceTemplateRequest,
    TestIamPermissionsInstanceTemplateRequest,
    AddAccessConfigInstanceRequest,
    AddResourcePoliciesInstanceRequest,
    AggregatedListInstancesRequest,
    AttachDiskInstanceRequest,
    DeleteInstanceRequest,
    DeleteAccessConfigInstanceRequest,
    DetachDiskInstanceRequest,
    GetInstanceRequest,
    GetGuestAttributesInstanceRequest,
    GetIamPolicyInstanceRequest,
    GetScreenshotInstanceRequest,
    GetSerialPortOutputInstanceRequest,
    GetShieldedInstanceIdentityInstanceRequest,
    InsertInstanceRequest,
    ListInstancesRequest,
    ListReferrersInstancesRequest,
    RemoveResourcePoliciesInstanceRequest,
    ResetInstanceRequest,
    SetDeletionProtectionInstanceRequest,
    SetDiskAutoDeleteInstanceRequest,
    SetIamPolicyInstanceRequest,
    SetLabelsInstanceRequest,
    SetMachineResourcesInstanceRequest,
    SetMachineTypeInstanceRequest,
    SetMetadataInstanceRequest,
    SetMinCpuPlatformInstanceRequest,
    SetSchedulingInstanceRequest,
    SetServiceAccountInstanceRequest,
    SetShieldedInstanceIntegrityPolicyInstanceRequest,
    SetTagsInstanceRequest,
    SimulateMaintenanceEventInstanceRequest,
    StartInstanceRequest,
    StartWithEncryptionKeyInstanceRequest,
    StopInstanceRequest,
    TestIamPermissionsInstanceRequest,
    UpdateInstanceRequest,
    UpdateAccessConfigInstanceRequest,
    UpdateDisplayDeviceInstanceRequest,
    UpdateNetworkInterfaceInstanceRequest,
    UpdateShieldedInstanceConfigInstanceRequest,
    AggregatedListInterconnectAttachmentsRequest,
    DeleteInterconnectAttachmentRequest,
    GetInterconnectAttachmentRequest,
    InsertInterconnectAttachmentRequest,
    ListInterconnectAttachmentsRequest,
    PatchInterconnectAttachmentRequest,
    GetInterconnectLocationRequest,
    ListInterconnectLocationsRequest,
    DeleteInterconnectRequest,
    GetInterconnectRequest,
    GetDiagnosticsInterconnectRequest,
    InsertInterconnectRequest,
    ListInterconnectsRequest,
    PatchInterconnectRequest,
    GetLicenseCodeRequest,
    TestIamPermissionsLicenseCodeRequest,
    DeleteLicenseRequest,
    GetLicenseRequest,
    GetIamPolicyLicenseRequest,
    InsertLicenseRequest,
    ListLicensesRequest,
    SetIamPolicyLicenseRequest,
    TestIamPermissionsLicenseRequest,
    AggregatedListMachineTypesRequest,
    GetMachineTypeRequest,
    ListMachineTypesRequest,
    AggregatedListNetworkEndpointGroupsRequest,
    AttachNetworkEndpointsNetworkEndpointGroupRequest,
    DeleteNetworkEndpointGroupRequest,
    DetachNetworkEndpointsNetworkEndpointGroupRequest,
    GetNetworkEndpointGroupRequest,
    InsertNetworkEndpointGroupRequest,
    ListNetworkEndpointGroupsRequest,
    ListNetworkEndpointsNetworkEndpointGroupsRequest,
    TestIamPermissionsNetworkEndpointGroupRequest,
    AddPeeringNetworkRequest,
    DeleteNetworkRequest,
    GetNetworkRequest,
    InsertNetworkRequest,
    ListNetworksRequest,
    ListPeeringRoutesNetworksRequest,
    PatchNetworkRequest,
    RemovePeeringNetworkRequest,
    SwitchToCustomModeNetworkRequest,
    UpdatePeeringNetworkRequest,
    AddNodesNodeGroupRequest,
    AggregatedListNodeGroupsRequest,
    DeleteNodeGroupRequest,
    DeleteNodesNodeGroupRequest,
    GetNodeGroupRequest,
    GetIamPolicyNodeGroupRequest,
    InsertNodeGroupRequest,
    ListNodeGroupsRequest,
    ListNodesNodeGroupsRequest,
    PatchNodeGroupRequest,
    SetIamPolicyNodeGroupRequest,
    SetNodeTemplateNodeGroupRequest,
    TestIamPermissionsNodeGroupRequest,
    AggregatedListNodeTemplatesRequest,
    DeleteNodeTemplateRequest,
    GetNodeTemplateRequest,
    GetIamPolicyNodeTemplateRequest,
    InsertNodeTemplateRequest,
    ListNodeTemplatesRequest,
    SetIamPolicyNodeTemplateRequest,
    TestIamPermissionsNodeTemplateRequest,
    AggregatedListNodeTypesRequest,
    GetNodeTypeRequest,
    ListNodeTypesRequest,
    AggregatedListPacketMirroringsRequest,
    DeletePacketMirroringRequest,
    GetPacketMirroringRequest,
    InsertPacketMirroringRequest,
    ListPacketMirroringsRequest,
    PatchPacketMirroringRequest,
    TestIamPermissionsPacketMirroringRequest,
    DisableXpnHostProjectRequest,
    DisableXpnResourceProjectRequest,
    EnableXpnHostProjectRequest,
    EnableXpnResourceProjectRequest,
    GetProjectRequest,
    GetXpnHostProjectRequest,
    GetXpnResourcesProjectsRequest,
    ListXpnHostsProjectsRequest,
    MoveDiskProjectRequest,
    MoveInstanceProjectRequest,
    SetCommonInstanceMetadataProjectRequest,
    SetDefaultNetworkTierProjectRequest,
    SetUsageExportBucketProjectRequest,
    DeleteRegionAutoscalerRequest,
    GetRegionAutoscalerRequest,
    InsertRegionAutoscalerRequest,
    ListRegionAutoscalersRequest,
    PatchRegionAutoscalerRequest,
    UpdateRegionAutoscalerRequest,
    DeleteRegionBackendServiceRequest,
    GetRegionBackendServiceRequest,
    GetHealthRegionBackendServiceRequest,
    InsertRegionBackendServiceRequest,
    ListRegionBackendServicesRequest,
    PatchRegionBackendServiceRequest,
    UpdateRegionBackendServiceRequest,
    AggregatedListRegionCommitmentsRequest,
    GetRegionCommitmentRequest,
    InsertRegionCommitmentRequest,
    ListRegionCommitmentsRequest,
    GetRegionDiskTypeRequest,
    ListRegionDiskTypesRequest,
    AddResourcePoliciesRegionDiskRequest,
    CreateSnapshotRegionDiskRequest,
    DeleteRegionDiskRequest,
    GetRegionDiskRequest,
    GetIamPolicyRegionDiskRequest,
    InsertRegionDiskRequest,
    ListRegionDisksRequest,
    RemoveResourcePoliciesRegionDiskRequest,
    ResizeRegionDiskRequest,
    SetIamPolicyRegionDiskRequest,
    SetLabelsRegionDiskRequest,
    TestIamPermissionsRegionDiskRequest,
    DeleteRegionHealthCheckServiceRequest,
    GetRegionHealthCheckServiceRequest,
    InsertRegionHealthCheckServiceRequest,
    ListRegionHealthCheckServicesRequest,
    PatchRegionHealthCheckServiceRequest,
    DeleteRegionHealthCheckRequest,
    GetRegionHealthCheckRequest,
    InsertRegionHealthCheckRequest,
    ListRegionHealthChecksRequest,
    PatchRegionHealthCheckRequest,
    UpdateRegionHealthCheckRequest,
    AbandonInstancesRegionInstanceGroupManagerRequest,
    ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest,
    CreateInstancesRegionInstanceGroupManagerRequest,
    DeleteRegionInstanceGroupManagerRequest,
    DeleteInstancesRegionInstanceGroupManagerRequest,
    DeletePerInstanceConfigsRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupManagerRequest,
    InsertRegionInstanceGroupManagerRequest,
    ListRegionInstanceGroupManagersRequest,
    ListErrorsRegionInstanceGroupManagersRequest,
    ListManagedInstancesRegionInstanceGroupManagersRequest,
    ListPerInstanceConfigsRegionInstanceGroupManagersRequest,
    PatchRegionInstanceGroupManagerRequest,
    PatchPerInstanceConfigsRegionInstanceGroupManagerRequest,
    RecreateInstancesRegionInstanceGroupManagerRequest,
    ResizeRegionInstanceGroupManagerRequest,
    SetInstanceTemplateRegionInstanceGroupManagerRequest,
    SetTargetPoolsRegionInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupRequest,
    ListRegionInstanceGroupsRequest,
    ListInstancesRegionInstanceGroupsRequest,
    SetNamedPortsRegionInstanceGroupRequest,
    DeleteRegionNetworkEndpointGroupRequest,
    GetRegionNetworkEndpointGroupRequest,
    InsertRegionNetworkEndpointGroupRequest,
    ListRegionNetworkEndpointGroupsRequest,
    DeleteRegionNotificationEndpointRequest,
    GetRegionNotificationEndpointRequest,
    InsertRegionNotificationEndpointRequest,
    ListRegionNotificationEndpointsRequest,
    DeleteRegionOperationRequest,
    DeleteRegionOperationResponse,
    GetRegionOperationRequest,
    ListRegionOperationsRequest,
    WaitRegionOperationRequest,
    DeleteRegionSslCertificateRequest,
    GetRegionSslCertificateRequest,
    InsertRegionSslCertificateRequest,
    ListRegionSslCertificatesRequest,
    DeleteRegionTargetHttpProxyRequest,
    GetRegionTargetHttpProxyRequest,
    InsertRegionTargetHttpProxyRequest,
    ListRegionTargetHttpProxiesRequest,
    SetUrlMapRegionTargetHttpProxyRequest,
    DeleteRegionTargetHttpsProxyRequest,
    GetRegionTargetHttpsProxyRequest,
    InsertRegionTargetHttpsProxyRequest,
    ListRegionTargetHttpsProxiesRequest,
    SetSslCertificatesRegionTargetHttpsProxyRequest,
    SetUrlMapRegionTargetHttpsProxyRequest,
    DeleteRegionUrlMapRequest,
    GetRegionUrlMapRequest,
    InsertRegionUrlMapRequest,
    ListRegionUrlMapsRequest,
    PatchRegionUrlMapRequest,
    UpdateRegionUrlMapRequest,
    ValidateRegionUrlMapRequest,
    GetRegionRequest,
    ListRegionsRequest,
    AggregatedListReservationsRequest,
    DeleteReservationRequest,
    GetReservationRequest,
    GetIamPolicyReservationRequest,
    InsertReservationRequest,
    ListReservationsRequest,
    ResizeReservationRequest,
    SetIamPolicyReservationRequest,
    TestIamPermissionsReservationRequest,
    AggregatedListResourcePoliciesRequest,
    DeleteResourcePolicyRequest,
    GetResourcePolicyRequest,
    GetIamPolicyResourcePolicyRequest,
    InsertResourcePolicyRequest,
    ListResourcePoliciesRequest,
    SetIamPolicyResourcePolicyRequest,
    TestIamPermissionsResourcePolicyRequest,
    AggregatedListRoutersRequest,
    DeleteRouterRequest,
    GetRouterRequest,
    GetNatMappingInfoRoutersRequest,
    GetRouterStatusRouterRequest,
    InsertRouterRequest,
    ListRoutersRequest,
    PatchRouterRequest,
    PreviewRouterRequest,
    UpdateRouterRequest,
    DeleteRouteRequest,
    GetRouteRequest,
    InsertRouteRequest,
    ListRoutesRequest,
    AddRuleSecurityPolicyRequest,
    DeleteSecurityPolicyRequest,
    GetSecurityPolicyRequest,
    GetRuleSecurityPolicyRequest,
    InsertSecurityPolicyRequest,
    ListSecurityPoliciesRequest,
    ListPreconfiguredExpressionSetsSecurityPoliciesRequest,
    PatchSecurityPolicyRequest,
    PatchRuleSecurityPolicyRequest,
    RemoveRuleSecurityPolicyRequest,
    DeleteSnapshotRequest,
    GetSnapshotRequest,
    GetIamPolicySnapshotRequest,
    ListSnapshotsRequest,
    SetIamPolicySnapshotRequest,
    SetLabelsSnapshotRequest,
    TestIamPermissionsSnapshotRequest,
    AggregatedListSslCertificatesRequest,
    DeleteSslCertificateRequest,
    GetSslCertificateRequest,
    InsertSslCertificateRequest,
    ListSslCertificatesRequest,
    DeleteSslPolicyRequest,
    GetSslPolicyRequest,
    InsertSslPolicyRequest,
    ListSslPoliciesRequest,
    ListAvailableFeaturesSslPoliciesRequest,
    PatchSslPolicyRequest,
    AggregatedListSubnetworksRequest,
    DeleteSubnetworkRequest,
    ExpandIpCidrRangeSubnetworkRequest,
    GetSubnetworkRequest,
    GetIamPolicySubnetworkRequest,
    InsertSubnetworkRequest,
    ListSubnetworksRequest,
    ListUsableSubnetworksRequest,
    PatchSubnetworkRequest,
    SetIamPolicySubnetworkRequest,
    SetPrivateIpGoogleAccessSubnetworkRequest,
    TestIamPermissionsSubnetworkRequest,
    DeleteTargetGrpcProxyRequest,
    GetTargetGrpcProxyRequest,
    InsertTargetGrpcProxyRequest,
    ListTargetGrpcProxiesRequest,
    PatchTargetGrpcProxyRequest,
    AggregatedListTargetHttpProxiesRequest,
    DeleteTargetHttpProxyRequest,
    GetTargetHttpProxyRequest,
    InsertTargetHttpProxyRequest,
    ListTargetHttpProxiesRequest,
    PatchTargetHttpProxyRequest,
    SetUrlMapTargetHttpProxyRequest,
    AggregatedListTargetHttpsProxiesRequest,
    DeleteTargetHttpsProxyRequest,
    GetTargetHttpsProxyRequest,
    InsertTargetHttpsProxyRequest,
    ListTargetHttpsProxiesRequest,
    SetQuicOverrideTargetHttpsProxyRequest,
    SetSslCertificatesTargetHttpsProxyRequest,
    SetSslPolicyTargetHttpsProxyRequest,
    SetUrlMapTargetHttpsProxyRequest,
    AggregatedListTargetInstancesRequest,
    DeleteTargetInstanceRequest,
    GetTargetInstanceRequest,
    InsertTargetInstanceRequest,
    ListTargetInstancesRequest,
    AddHealthCheckTargetPoolRequest,
    AddInstanceTargetPoolRequest,
    AggregatedListTargetPoolsRequest,
    DeleteTargetPoolRequest,
    GetTargetPoolRequest,
    GetHealthTargetPoolRequest,
    InsertTargetPoolRequest,
    ListTargetPoolsRequest,
    RemoveHealthCheckTargetPoolRequest,
    RemoveInstanceTargetPoolRequest,
    SetBackupTargetPoolRequest,
    DeleteTargetSslProxyRequest,
    GetTargetSslProxyRequest,
    InsertTargetSslProxyRequest,
    ListTargetSslProxiesRequest,
    SetBackendServiceTargetSslProxyRequest,
    SetProxyHeaderTargetSslProxyRequest,
    SetSslCertificatesTargetSslProxyRequest,
    SetSslPolicyTargetSslProxyRequest,
    DeleteTargetTcpProxyRequest,
    GetTargetTcpProxyRequest,
    InsertTargetTcpProxyRequest,
    ListTargetTcpProxiesRequest,
    SetBackendServiceTargetTcpProxyRequest,
    SetProxyHeaderTargetTcpProxyRequest,
    AggregatedListTargetVpnGatewaysRequest,
    DeleteTargetVpnGatewayRequest,
    GetTargetVpnGatewayRequest,
    InsertTargetVpnGatewayRequest,
    ListTargetVpnGatewaysRequest,
    AggregatedListUrlMapsRequest,
    DeleteUrlMapRequest,
    GetUrlMapRequest,
    InsertUrlMapRequest,
    InvalidateCacheUrlMapRequest,
    ListUrlMapsRequest,
    PatchUrlMapRequest,
    UpdateUrlMapRequest,
    ValidateUrlMapRequest,
    AggregatedListVpnGatewaysRequest,
    DeleteVpnGatewayRequest,
    GetVpnGatewayRequest,
    GetStatusVpnGatewayRequest,
    InsertVpnGatewayRequest,
    ListVpnGatewaysRequest,
    SetLabelsVpnGatewayRequest,
    TestIamPermissionsVpnGatewayRequest,
    AggregatedListVpnTunnelsRequest,
    DeleteVpnTunnelRequest,
    GetVpnTunnelRequest,
    InsertVpnTunnelRequest,
    ListVpnTunnelsRequest,
    DeleteZoneOperationRequest,
    DeleteZoneOperationResponse,
    GetZoneOperationRequest,
    ListZoneOperationsRequest,
    WaitZoneOperationRequest,
    GetZoneRequest,
    ListZonesRequest,
)

__all__ = (
    "AcceleratorConfig",
    "DeprecationStatus",
    "AcceleratorType",
    "AcceleratorTypesScopedList",
    "Data",
    "Warning",
    "AcceleratorTypeAggregatedList",
    "AcceleratorTypeList",
    "AccessConfig",
    "Address",
    "AddressesScopedList",
    "AddressAggregatedList",
    "AddressList",
    "AliasIpRange",
    "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    "AllocationSpecificSKUAllocationReservedInstanceProperties",
    "AllocationSpecificSKUReservation",
    "CustomerEncryptionKey",
    "GuestOsFeature",
    "AttachedDiskInitializeParams",
    "InitialStateConfig",
    "AttachedDisk",
    "AuditLogConfig",
    "AuditConfig",
    "AuthorizationLoggingOptions",
    "AutoscalingPolicy",
    "AutoscalerStatusDetails",
    "Autoscaler",
    "AutoscalersScopedList",
    "AutoscalerAggregatedList",
    "AutoscalerList",
    "AutoscalingPolicyCpuUtilization",
    "AutoscalingPolicyCustomMetricUtilization",
    "AutoscalingPolicyLoadBalancingUtilization",
    "AutoscalingPolicyScaleInControl",
    "FixedOrPercent",
    "Backend",
    "BackendBucketCdnPolicy",
    "BackendBucket",
    "BackendBucketList",
    "BackendServiceCdnPolicy",
    "CircuitBreakers",
    "ConnectionDraining",
    "ConsistentHashLoadBalancerSettings",
    "BackendServiceFailoverPolicy",
    "BackendServiceIAP",
    "BackendServiceLogConfig",
    "OutlierDetection",
    "SecuritySettings",
    "BackendService",
    "BackendServicesScopedList",
    "BackendServiceAggregatedList",
    "CacheKeyPolicy",
    "HealthStatus",
    "BackendServiceGroupHealth",
    "BackendServiceList",
    "BackendServiceReference",
    "Expr",
    "Binding",
    "CacheInvalidationRule",
    "LicenseResourceCommitment",
    "Reservation",
    "ResourceCommitment",
    "Commitment",
    "CommitmentsScopedList",
    "CommitmentAggregatedList",
    "CommitmentList",
    "Condition",
    "ConfidentialInstanceConfig",
    "ConsistentHashLoadBalancerSettingsHttpCookie",
    "Duration",
    "CorsPolicy",
    "CustomerEncryptionKeyProtectedDisk",
    "Disk",
    "DisksScopedList",
    "DiskAggregatedList",
    "DiskInstantiationConfig",
    "DiskList",
    "DiskMoveRequest",
    "DiskType",
    "DiskTypesScopedList",
    "DiskTypeAggregatedList",
    "DiskTypeList",
    "DisksAddResourcePoliciesRequest",
    "DisksRemoveResourcePoliciesRequest",
    "DisksResizeRequest",
    "DisplayDevice",
    "DistributionPolicyZoneConfiguration",
    "DistributionPolicy",
    "ExchangedPeeringRoute",
    "ExchangedPeeringRoutesList",
    "ExternalVpnGatewayInterface",
    "ExternalVpnGateway",
    "ExternalVpnGatewayList",
    "FileContentBuffer",
    "Allowed",
    "Denied",
    "FirewallLogConfig",
    "Firewall",
    "FirewallList",
    "MetadataFilter",
    "ForwardingRule",
    "ForwardingRulesScopedList",
    "ForwardingRuleAggregatedList",
    "ForwardingRuleList",
    "ForwardingRuleReference",
    "GRPCHealthCheck",
    "NetworkEndpoint",
    "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    "GlobalSetLabelsRequest",
    "Policy",
    "GlobalSetPolicyRequest",
    "GuestAttributesValue",
    "GuestAttributes",
    "GuestAttributesEntry",
    "HTTP2HealthCheck",
    "HTTPHealthCheck",
    "HTTPSHealthCheck",
    "HealthCheckLogConfig",
    "SSLHealthCheck",
    "TCPHealthCheck",
    "HealthCheck",
    "HealthCheckList",
    "HealthCheckReference",
    "HealthCheckService",
    "HealthCheckServiceReference",
    "HealthCheckServicesList",
    "HealthChecksScopedList",
    "HealthChecksAggregatedList",
    "HealthStatusForNetworkEndpoint",
    "HostRule",
    "HttpFaultAbort",
    "HttpFaultDelay",
    "HttpFaultInjection",
    "HttpHeaderOption",
    "HttpHeaderAction",
    "Int64RangeMatch",
    "HttpHeaderMatch",
    "HttpQueryParameterMatch",
    "HttpRedirectAction",
    "HttpRetryPolicy",
    "RequestMirrorPolicy",
    "UrlRewrite",
    "WeightedBackendService",
    "HttpRouteAction",
    "HttpRouteRuleMatch",
    "HttpRouteRule",
    "RawDisk",
    "Image",
    "ImageList",
    "Metadata",
    "NetworkInterface",
    "ReservationAffinity",
    "Scheduling",
    "ServiceAccount",
    "ShieldedInstanceConfig",
    "ShieldedInstanceIntegrityPolicy",
    "Tags",
    "Instance",
    "InstancesScopedList",
    "InstanceAggregatedList",
    "NamedPort",
    "InstanceGroup",
    "InstanceGroupsScopedList",
    "InstanceGroupAggregatedList",
    "InstanceGroupList",
    "InstanceGroupManagerAutoHealingPolicy",
    "InstanceGroupManagerActionsSummary",
    "StatefulPolicy",
    "InstanceGroupManagerStatus",
    "InstanceGroupManagerUpdatePolicy",
    "InstanceGroupManagerVersion",
    "InstanceGroupManager",
    "InstanceGroupManagersScopedList",
    "InstanceGroupManagerAggregatedList",
    "InstanceGroupManagerList",
    "InstanceGroupManagerStatusStateful",
    "InstanceGroupManagerStatusVersionTarget",
    "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    "InstanceGroupManagersAbandonInstancesRequest",
    "InstanceGroupManagersApplyUpdatesRequest",
    "PerInstanceConfig",
    "InstanceGroupManagersCreateInstancesRequest",
    "InstanceGroupManagersDeleteInstancesRequest",
    "InstanceGroupManagersDeletePerInstanceConfigsReq",
    "InstanceManagedByIgmError",
    "InstanceGroupManagersListErrorsResponse",
    "ManagedInstance",
    "InstanceGroupManagersListManagedInstancesResponse",
    "InstanceGroupManagersListPerInstanceConfigsResp",
    "InstanceGroupManagersPatchPerInstanceConfigsReq",
    "InstanceGroupManagersRecreateInstancesRequest",
    "InstanceGroupManagersSetInstanceTemplateRequest",
    "InstanceGroupManagersSetTargetPoolsRequest",
    "InstanceGroupManagersUpdatePerInstanceConfigsReq",
    "InstanceReference",
    "InstanceGroupsAddInstancesRequest",
    "InstanceWithNamedPorts",
    "InstanceGroupsListInstances",
    "InstanceGroupsListInstancesRequest",
    "InstanceGroupsRemoveInstancesRequest",
    "InstanceGroupsSetNamedPortsRequest",
    "InstanceList",
    "Reference",
    "InstanceListReferrers",
    "InstanceManagedByIgmErrorManagedInstanceError",
    "InstanceManagedByIgmErrorInstanceActionDetails",
    "ManagedInstanceVersion",
    "InstanceMoveRequest",
    "InstanceProperties",
    "SourceInstanceParams",
    "InstanceTemplate",
    "InstanceTemplateList",
    "InstancesAddResourcePoliciesRequest",
    "InstancesRemoveResourcePoliciesRequest",
    "InstancesSetLabelsRequest",
    "InstancesSetMachineResourcesRequest",
    "InstancesSetMachineTypeRequest",
    "InstancesSetMinCpuPlatformRequest",
    "InstancesSetServiceAccountRequest",
    "InstancesStartWithEncryptionKeyRequest",
    "InterconnectCircuitInfo",
    "InterconnectOutageNotification",
    "Interconnect",
    "InterconnectAttachmentPartnerMetadata",
    "InterconnectAttachmentPrivateInfo",
    "InterconnectAttachment",
    "InterconnectAttachmentsScopedList",
    "InterconnectAttachmentAggregatedList",
    "InterconnectAttachmentList",
    "InterconnectDiagnosticsARPEntry",
    "InterconnectDiagnosticsLinkStatus",
    "InterconnectDiagnostics",
    "InterconnectDiagnosticsLinkLACPStatus",
    "InterconnectDiagnosticsLinkOpticalPower",
    "InterconnectList",
    "InterconnectLocationRegionInfo",
    "InterconnectLocation",
    "InterconnectLocationList",
    "InterconnectsGetDiagnosticsResponse",
    "LicenseResourceRequirements",
    "License",
    "LicenseCodeLicenseAlias",
    "LicenseCode",
    "LicensesListResponse",
    "LocalDisk",
    "LogConfigCloudAuditOptions",
    "LogConfigCounterOptions",
    "LogConfigDataAccessOptions",
    "LogConfig",
    "LogConfigCounterOptionsCustomField",
    "Accelerators",
    "ScratchDisks",
    "MachineType",
    "MachineTypesScopedList",
    "MachineTypeAggregatedList",
    "MachineTypeList",
    "ManagedInstanceInstanceHealth",
    "ManagedInstanceLastAttempt",
    "PreservedState",
    "Errors",
    "Items",
    "MetadataFilterLabelMatch",
    "NetworkPeering",
    "NetworkRoutingConfig",
    "Network",
    "NetworkEndpointGroupAppEngine",
    "NetworkEndpointGroupCloudFunction",
    "NetworkEndpointGroupCloudRun",
    "NetworkEndpointGroup",
    "NetworkEndpointGroupsScopedList",
    "NetworkEndpointGroupAggregatedList",
    "NetworkEndpointGroupList",
    "NetworkEndpointGroupsAttachEndpointsRequest",
    "NetworkEndpointGroupsDetachEndpointsRequest",
    "NetworkEndpointGroupsListEndpointsRequest",
    "NetworkEndpointWithHealthStatus",
    "NetworkEndpointGroupsListNetworkEndpoints",
    "NetworkList",
    "NetworksAddPeeringRequest",
    "NetworksRemovePeeringRequest",
    "NetworksUpdatePeeringRequest",
    "NodeGroupAutoscalingPolicy",
    "NodeGroupMaintenanceWindow",
    "NodeGroup",
    "NodeGroupsScopedList",
    "NodeGroupAggregatedList",
    "NodeGroupList",
    "ServerBinding",
    "NodeGroupNode",
    "NodeGroupsAddNodesRequest",
    "NodeGroupsDeleteNodesRequest",
    "NodeGroupsListNodes",
    "NodeGroupsSetNodeTemplateRequest",
    "NodeTemplateNodeTypeFlexibility",
    "NodeTemplate",
    "NodeTemplatesScopedList",
    "NodeTemplateAggregatedList",
    "NodeTemplateList",
    "NodeType",
    "NodeTypesScopedList",
    "NodeTypeAggregatedList",
    "NodeTypeList",
    "NotificationEndpointGrpcSettings",
    "NotificationEndpoint",
    "NotificationEndpointList",
    "Error",
    "Warnings",
    "Operation",
    "OperationsScopedList",
    "OperationAggregatedList",
    "OperationList",
    "PacketMirroringForwardingRuleInfo",
    "PacketMirroringFilter",
    "PacketMirroringMirroredResourceInfo",
    "PacketMirroringNetworkInfo",
    "PacketMirroring",
    "PacketMirroringsScopedList",
    "PacketMirroringAggregatedList",
    "PacketMirroringList",
    "PacketMirroringMirroredResourceInfoInstanceInfo",
    "PacketMirroringMirroredResourceInfoSubnetInfo",
    "PathRule",
    "PathMatcher",
    "Rule",
    "WafExpressionSet",
    "PreconfiguredWafSet",
    "PreservedStatePreservedDisk",
    "Quota",
    "UsageExportLocation",
    "Project",
    "XpnResourceId",
    "ProjectsDisableXpnResourceRequest",
    "ProjectsEnableXpnResourceRequest",
    "ProjectsGetXpnResources",
    "ProjectsListXpnHostsRequest",
    "ProjectsSetDefaultNetworkTierRequest",
    "Region",
    "RegionAutoscalerList",
    "RegionDiskTypeList",
    "RegionDisksAddResourcePoliciesRequest",
    "RegionDisksRemoveResourcePoliciesRequest",
    "RegionDisksResizeRequest",
    "RegionInstanceGroupList",
    "RegionInstanceGroupManagerDeleteInstanceConfigReq",
    "RegionInstanceGroupManagerList",
    "RegionInstanceGroupManagerPatchInstanceConfigReq",
    "RegionInstanceGroupManagerUpdateInstanceConfigReq",
    "RegionInstanceGroupManagersAbandonInstancesRequest",
    "RegionInstanceGroupManagersApplyUpdatesRequest",
    "RegionInstanceGroupManagersCreateInstancesRequest",
    "RegionInstanceGroupManagersDeleteInstancesRequest",
    "RegionInstanceGroupManagersListErrorsResponse",
    "RegionInstanceGroupManagersListInstanceConfigsResp",
    "RegionInstanceGroupManagersListInstancesResponse",
    "RegionInstanceGroupManagersRecreateRequest",
    "RegionInstanceGroupManagersSetTargetPoolsRequest",
    "RegionInstanceGroupManagersSetTemplateRequest",
    "RegionInstanceGroupsListInstances",
    "RegionInstanceGroupsListInstancesRequest",
    "RegionInstanceGroupsSetNamedPortsRequest",
    "RegionList",
    "RegionSetLabelsRequest",
    "RegionSetPolicyRequest",
    "RegionTargetHttpsProxiesSetSslCertificatesRequest",
    "UrlMap",
    "RegionUrlMapsValidateRequest",
    "ReservationsScopedList",
    "ReservationAggregatedList",
    "ReservationList",
    "ReservationsResizeRequest",
    "ResourceGroupReference",
    "ResourcePolicy",
    "ResourcePoliciesScopedList",
    "ResourcePolicyGroupPlacementPolicy",
    "ResourcePolicySnapshotSchedulePolicy",
    "ResourcePolicyAggregatedList",
    "ResourcePolicyDailyCycle",
    "ResourcePolicyHourlyCycle",
    "ResourcePolicyList",
    "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    "ResourcePolicySnapshotSchedulePolicySchedule",
    "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    "ResourcePolicyWeeklyCycle",
    "ResourcePolicyWeeklyCycleDayOfWeek",
    "Route",
    "RouteList",
    "RouterBgp",
    "RouterBgpPeer",
    "RouterInterface",
    "RouterNat",
    "Router",
    "RouterAdvertisedIpRange",
    "RoutersScopedList",
    "RouterAggregatedList",
    "RouterList",
    "RouterNatLogConfig",
    "RouterNatSubnetworkToNat",
    "RouterStatusBgpPeerStatus",
    "RouterStatusNatStatus",
    "RouterStatus",
    "RouterStatusResponse",
    "RoutersPreviewResponse",
    "SchedulingNodeAffinity",
    "Screenshot",
    "SecurityPoliciesWafConfig",
    "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
    "SecurityPolicyRule",
    "SecurityPolicy",
    "SecurityPolicyList",
    "SecurityPolicyReference",
    "SecurityPolicyRuleMatcher",
    "SecurityPolicyRuleMatcherConfig",
    "SerialPortOutput",
    "ShieldedInstanceIdentityEntry",
    "ShieldedInstanceIdentity",
    "SignedUrlKey",
    "Snapshot",
    "SnapshotList",
    "SslCertificateManagedSslCertificate",
    "SslCertificateSelfManagedSslCertificate",
    "SslCertificate",
    "SslCertificatesScopedList",
    "SslCertificateAggregatedList",
    "SslCertificateList",
    "SslPolicy",
    "SslPoliciesList",
    "SslPoliciesListAvailableFeaturesResponse",
    "SslPolicyReference",
    "StatefulPolicyPreservedState",
    "StatefulPolicyPreservedStateDiskDevice",
    "SubnetworkLogConfig",
    "SubnetworkSecondaryRange",
    "Subnetwork",
    "SubnetworksScopedList",
    "SubnetworkAggregatedList",
    "SubnetworkList",
    "SubnetworksExpandIpCidrRangeRequest",
    "SubnetworksSetPrivateIpGoogleAccessRequest",
    "TargetGrpcProxy",
    "TargetGrpcProxyList",
    "TargetHttpProxy",
    "TargetHttpProxiesScopedList",
    "TargetHttpProxyAggregatedList",
    "TargetHttpProxyList",
    "TargetHttpsProxy",
    "TargetHttpsProxiesScopedList",
    "TargetHttpsProxiesSetQuicOverrideRequest",
    "TargetHttpsProxiesSetSslCertificatesRequest",
    "TargetHttpsProxyAggregatedList",
    "TargetHttpsProxyList",
    "TargetInstance",
    "TargetInstancesScopedList",
    "TargetInstanceAggregatedList",
    "TargetInstanceList",
    "TargetPool",
    "TargetPoolsScopedList",
    "TargetPoolAggregatedList",
    "TargetPoolInstanceHealth",
    "TargetPoolList",
    "TargetPoolsAddHealthCheckRequest",
    "TargetPoolsAddInstanceRequest",
    "TargetPoolsRemoveHealthCheckRequest",
    "TargetPoolsRemoveInstanceRequest",
    "TargetReference",
    "TargetSslProxiesSetBackendServiceRequest",
    "TargetSslProxiesSetProxyHeaderRequest",
    "TargetSslProxiesSetSslCertificatesRequest",
    "TargetSslProxy",
    "TargetSslProxyList",
    "TargetTcpProxiesSetBackendServiceRequest",
    "TargetTcpProxiesSetProxyHeaderRequest",
    "TargetTcpProxy",
    "TargetTcpProxyList",
    "TargetVpnGateway",
    "TargetVpnGatewaysScopedList",
    "TargetVpnGatewayAggregatedList",
    "TargetVpnGatewayList",
    "TestFailure",
    "TestPermissionsRequest",
    "TestPermissionsResponse",
    "UrlMapTest",
    "UrlMapList",
    "UrlMapReference",
    "UrlMapValidationResult",
    "UrlMapsScopedList",
    "UrlMapsAggregatedList",
    "UrlMapsValidateRequest",
    "UrlMapsValidateResponse",
    "UsableSubnetworkSecondaryRange",
    "UsableSubnetwork",
    "UsableSubnetworksAggregatedList",
    "VmEndpointNatMappingsInterfaceNatMappings",
    "VmEndpointNatMappings",
    "VmEndpointNatMappingsList",
    "VpnGatewayVpnGatewayInterface",
    "VpnGateway",
    "VpnGatewaysScopedList",
    "VpnGatewayAggregatedList",
    "VpnGatewayList",
    "VpnGatewayStatusVpnConnection",
    "VpnGatewayStatus",
    "VpnGatewayStatusHighAvailabilityRequirementState",
    "VpnGatewayStatusTunnel",
    "VpnGatewaysGetStatusResponse",
    "VpnTunnel",
    "VpnTunnelsScopedList",
    "VpnTunnelAggregatedList",
    "VpnTunnelList",
    "WafExpressionSetExpression",
    "XpnHostList",
    "Zone",
    "ZoneList",
    "ZoneSetLabelsRequest",
    "ZoneSetPolicyRequest",
    "AggregatedListAcceleratorTypesRequest",
    "GetAcceleratorTypeRequest",
    "ListAcceleratorTypesRequest",
    "AggregatedListAddressesRequest",
    "DeleteAddressRequest",
    "GetAddressRequest",
    "InsertAddressRequest",
    "ListAddressesRequest",
    "AggregatedListAutoscalersRequest",
    "DeleteAutoscalerRequest",
    "GetAutoscalerRequest",
    "InsertAutoscalerRequest",
    "ListAutoscalersRequest",
    "PatchAutoscalerRequest",
    "UpdateAutoscalerRequest",
    "AddSignedUrlKeyBackendBucketRequest",
    "DeleteBackendBucketRequest",
    "DeleteSignedUrlKeyBackendBucketRequest",
    "GetBackendBucketRequest",
    "InsertBackendBucketRequest",
    "ListBackendBucketsRequest",
    "PatchBackendBucketRequest",
    "UpdateBackendBucketRequest",
    "AddSignedUrlKeyBackendServiceRequest",
    "AggregatedListBackendServicesRequest",
    "DeleteBackendServiceRequest",
    "DeleteSignedUrlKeyBackendServiceRequest",
    "GetBackendServiceRequest",
    "GetHealthBackendServiceRequest",
    "InsertBackendServiceRequest",
    "ListBackendServicesRequest",
    "PatchBackendServiceRequest",
    "SetSecurityPolicyBackendServiceRequest",
    "UpdateBackendServiceRequest",
    "AggregatedListDiskTypesRequest",
    "GetDiskTypeRequest",
    "ListDiskTypesRequest",
    "AddResourcePoliciesDiskRequest",
    "AggregatedListDisksRequest",
    "CreateSnapshotDiskRequest",
    "DeleteDiskRequest",
    "GetDiskRequest",
    "GetIamPolicyDiskRequest",
    "InsertDiskRequest",
    "ListDisksRequest",
    "RemoveResourcePoliciesDiskRequest",
    "ResizeDiskRequest",
    "SetIamPolicyDiskRequest",
    "SetLabelsDiskRequest",
    "TestIamPermissionsDiskRequest",
    "DeleteExternalVpnGatewayRequest",
    "GetExternalVpnGatewayRequest",
    "InsertExternalVpnGatewayRequest",
    "ListExternalVpnGatewaysRequest",
    "SetLabelsExternalVpnGatewayRequest",
    "TestIamPermissionsExternalVpnGatewayRequest",
    "DeleteFirewallRequest",
    "GetFirewallRequest",
    "InsertFirewallRequest",
    "ListFirewallsRequest",
    "PatchFirewallRequest",
    "UpdateFirewallRequest",
    "AggregatedListForwardingRulesRequest",
    "DeleteForwardingRuleRequest",
    "GetForwardingRuleRequest",
    "InsertForwardingRuleRequest",
    "ListForwardingRulesRequest",
    "PatchForwardingRuleRequest",
    "SetTargetForwardingRuleRequest",
    "DeleteGlobalAddressRequest",
    "GetGlobalAddressRequest",
    "InsertGlobalAddressRequest",
    "ListGlobalAddressesRequest",
    "DeleteGlobalForwardingRuleRequest",
    "GetGlobalForwardingRuleRequest",
    "InsertGlobalForwardingRuleRequest",
    "ListGlobalForwardingRulesRequest",
    "PatchGlobalForwardingRuleRequest",
    "SetTargetGlobalForwardingRuleRequest",
    "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "DeleteGlobalNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "GetGlobalNetworkEndpointGroupRequest",
    "InsertGlobalNetworkEndpointGroupRequest",
    "ListGlobalNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
    "AggregatedListGlobalOperationsRequest",
    "DeleteGlobalOperationRequest",
    "DeleteGlobalOperationResponse",
    "GetGlobalOperationRequest",
    "ListGlobalOperationsRequest",
    "WaitGlobalOperationRequest",
    "DeleteGlobalOrganizationOperationRequest",
    "DeleteGlobalOrganizationOperationResponse",
    "GetGlobalOrganizationOperationRequest",
    "ListGlobalOrganizationOperationsRequest",
    "AggregatedListHealthChecksRequest",
    "DeleteHealthCheckRequest",
    "GetHealthCheckRequest",
    "InsertHealthCheckRequest",
    "ListHealthChecksRequest",
    "PatchHealthCheckRequest",
    "UpdateHealthCheckRequest",
    "DeleteImageRequest",
    "DeprecateImageRequest",
    "GetImageRequest",
    "GetFromFamilyImageRequest",
    "GetIamPolicyImageRequest",
    "InsertImageRequest",
    "ListImagesRequest",
    "PatchImageRequest",
    "SetIamPolicyImageRequest",
    "SetLabelsImageRequest",
    "TestIamPermissionsImageRequest",
    "AbandonInstancesInstanceGroupManagerRequest",
    "AggregatedListInstanceGroupManagersRequest",
    "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
    "CreateInstancesInstanceGroupManagerRequest",
    "DeleteInstanceGroupManagerRequest",
    "DeleteInstancesInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsInstanceGroupManagerRequest",
    "GetInstanceGroupManagerRequest",
    "InsertInstanceGroupManagerRequest",
    "ListInstanceGroupManagersRequest",
    "ListErrorsInstanceGroupManagersRequest",
    "ListManagedInstancesInstanceGroupManagersRequest",
    "ListPerInstanceConfigsInstanceGroupManagersRequest",
    "PatchInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsInstanceGroupManagerRequest",
    "RecreateInstancesInstanceGroupManagerRequest",
    "ResizeInstanceGroupManagerRequest",
    "SetInstanceTemplateInstanceGroupManagerRequest",
    "SetTargetPoolsInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
    "AddInstancesInstanceGroupRequest",
    "AggregatedListInstanceGroupsRequest",
    "DeleteInstanceGroupRequest",
    "GetInstanceGroupRequest",
    "InsertInstanceGroupRequest",
    "ListInstanceGroupsRequest",
    "ListInstancesInstanceGroupsRequest",
    "RemoveInstancesInstanceGroupRequest",
    "SetNamedPortsInstanceGroupRequest",
    "DeleteInstanceTemplateRequest",
    "GetInstanceTemplateRequest",
    "GetIamPolicyInstanceTemplateRequest",
    "InsertInstanceTemplateRequest",
    "ListInstanceTemplatesRequest",
    "SetIamPolicyInstanceTemplateRequest",
    "TestIamPermissionsInstanceTemplateRequest",
    "AddAccessConfigInstanceRequest",
    "AddResourcePoliciesInstanceRequest",
    "AggregatedListInstancesRequest",
    "AttachDiskInstanceRequest",
    "DeleteInstanceRequest",
    "DeleteAccessConfigInstanceRequest",
    "DetachDiskInstanceRequest",
    "GetInstanceRequest",
    "GetGuestAttributesInstanceRequest",
    "GetIamPolicyInstanceRequest",
    "GetScreenshotInstanceRequest",
    "GetSerialPortOutputInstanceRequest",
    "GetShieldedInstanceIdentityInstanceRequest",
    "InsertInstanceRequest",
    "ListInstancesRequest",
    "ListReferrersInstancesRequest",
    "RemoveResourcePoliciesInstanceRequest",
    "ResetInstanceRequest",
    "SetDeletionProtectionInstanceRequest",
    "SetDiskAutoDeleteInstanceRequest",
    "SetIamPolicyInstanceRequest",
    "SetLabelsInstanceRequest",
    "SetMachineResourcesInstanceRequest",
    "SetMachineTypeInstanceRequest",
    "SetMetadataInstanceRequest",
    "SetMinCpuPlatformInstanceRequest",
    "SetSchedulingInstanceRequest",
    "SetServiceAccountInstanceRequest",
    "SetShieldedInstanceIntegrityPolicyInstanceRequest",
    "SetTagsInstanceRequest",
    "SimulateMaintenanceEventInstanceRequest",
    "StartInstanceRequest",
    "StartWithEncryptionKeyInstanceRequest",
    "StopInstanceRequest",
    "TestIamPermissionsInstanceRequest",
    "UpdateInstanceRequest",
    "UpdateAccessConfigInstanceRequest",
    "UpdateDisplayDeviceInstanceRequest",
    "UpdateNetworkInterfaceInstanceRequest",
    "UpdateShieldedInstanceConfigInstanceRequest",
    "AggregatedListInterconnectAttachmentsRequest",
    "DeleteInterconnectAttachmentRequest",
    "GetInterconnectAttachmentRequest",
    "InsertInterconnectAttachmentRequest",
    "ListInterconnectAttachmentsRequest",
    "PatchInterconnectAttachmentRequest",
    "GetInterconnectLocationRequest",
    "ListInterconnectLocationsRequest",
    "DeleteInterconnectRequest",
    "GetInterconnectRequest",
    "GetDiagnosticsInterconnectRequest",
    "InsertInterconnectRequest",
    "ListInterconnectsRequest",
    "PatchInterconnectRequest",
    "GetLicenseCodeRequest",
    "TestIamPermissionsLicenseCodeRequest",
    "DeleteLicenseRequest",
    "GetLicenseRequest",
    "GetIamPolicyLicenseRequest",
    "InsertLicenseRequest",
    "ListLicensesRequest",
    "SetIamPolicyLicenseRequest",
    "TestIamPermissionsLicenseRequest",
    "AggregatedListMachineTypesRequest",
    "GetMachineTypeRequest",
    "ListMachineTypesRequest",
    "AggregatedListNetworkEndpointGroupsRequest",
    "AttachNetworkEndpointsNetworkEndpointGroupRequest",
    "DeleteNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsNetworkEndpointGroupRequest",
    "GetNetworkEndpointGroupRequest",
    "InsertNetworkEndpointGroupRequest",
    "ListNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsNetworkEndpointGroupsRequest",
    "TestIamPermissionsNetworkEndpointGroupRequest",
    "AddPeeringNetworkRequest",
    "DeleteNetworkRequest",
    "GetNetworkRequest",
    "InsertNetworkRequest",
    "ListNetworksRequest",
    "ListPeeringRoutesNetworksRequest",
    "PatchNetworkRequest",
    "RemovePeeringNetworkRequest",
    "SwitchToCustomModeNetworkRequest",
    "UpdatePeeringNetworkRequest",
    "AddNodesNodeGroupRequest",
    "AggregatedListNodeGroupsRequest",
    "DeleteNodeGroupRequest",
    "DeleteNodesNodeGroupRequest",
    "GetNodeGroupRequest",
    "GetIamPolicyNodeGroupRequest",
    "InsertNodeGroupRequest",
    "ListNodeGroupsRequest",
    "ListNodesNodeGroupsRequest",
    "PatchNodeGroupRequest",
    "SetIamPolicyNodeGroupRequest",
    "SetNodeTemplateNodeGroupRequest",
    "TestIamPermissionsNodeGroupRequest",
    "AggregatedListNodeTemplatesRequest",
    "DeleteNodeTemplateRequest",
    "GetNodeTemplateRequest",
    "GetIamPolicyNodeTemplateRequest",
    "InsertNodeTemplateRequest",
    "ListNodeTemplatesRequest",
    "SetIamPolicyNodeTemplateRequest",
    "TestIamPermissionsNodeTemplateRequest",
    "AggregatedListNodeTypesRequest",
    "GetNodeTypeRequest",
    "ListNodeTypesRequest",
    "AggregatedListPacketMirroringsRequest",
    "DeletePacketMirroringRequest",
    "GetPacketMirroringRequest",
    "InsertPacketMirroringRequest",
    "ListPacketMirroringsRequest",
    "PatchPacketMirroringRequest",
    "TestIamPermissionsPacketMirroringRequest",
    "DisableXpnHostProjectRequest",
    "DisableXpnResourceProjectRequest",
    "EnableXpnHostProjectRequest",
    "EnableXpnResourceProjectRequest",
    "GetProjectRequest",
    "GetXpnHostProjectRequest",
    "GetXpnResourcesProjectsRequest",
    "ListXpnHostsProjectsRequest",
    "MoveDiskProjectRequest",
    "MoveInstanceProjectRequest",
    "SetCommonInstanceMetadataProjectRequest",
    "SetDefaultNetworkTierProjectRequest",
    "SetUsageExportBucketProjectRequest",
    "DeleteRegionAutoscalerRequest",
    "GetRegionAutoscalerRequest",
    "InsertRegionAutoscalerRequest",
    "ListRegionAutoscalersRequest",
    "PatchRegionAutoscalerRequest",
    "UpdateRegionAutoscalerRequest",
    "DeleteRegionBackendServiceRequest",
    "GetRegionBackendServiceRequest",
    "GetHealthRegionBackendServiceRequest",
    "InsertRegionBackendServiceRequest",
    "ListRegionBackendServicesRequest",
    "PatchRegionBackendServiceRequest",
    "UpdateRegionBackendServiceRequest",
    "AggregatedListRegionCommitmentsRequest",
    "GetRegionCommitmentRequest",
    "InsertRegionCommitmentRequest",
    "ListRegionCommitmentsRequest",
    "GetRegionDiskTypeRequest",
    "ListRegionDiskTypesRequest",
    "AddResourcePoliciesRegionDiskRequest",
    "CreateSnapshotRegionDiskRequest",
    "DeleteRegionDiskRequest",
    "GetRegionDiskRequest",
    "GetIamPolicyRegionDiskRequest",
    "InsertRegionDiskRequest",
    "ListRegionDisksRequest",
    "RemoveResourcePoliciesRegionDiskRequest",
    "ResizeRegionDiskRequest",
    "SetIamPolicyRegionDiskRequest",
    "SetLabelsRegionDiskRequest",
    "TestIamPermissionsRegionDiskRequest",
    "DeleteRegionHealthCheckServiceRequest",
    "GetRegionHealthCheckServiceRequest",
    "InsertRegionHealthCheckServiceRequest",
    "ListRegionHealthCheckServicesRequest",
    "PatchRegionHealthCheckServiceRequest",
    "DeleteRegionHealthCheckRequest",
    "GetRegionHealthCheckRequest",
    "InsertRegionHealthCheckRequest",
    "ListRegionHealthChecksRequest",
    "PatchRegionHealthCheckRequest",
    "UpdateRegionHealthCheckRequest",
    "AbandonInstancesRegionInstanceGroupManagerRequest",
    "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
    "CreateInstancesRegionInstanceGroupManagerRequest",
    "DeleteRegionInstanceGroupManagerRequest",
    "DeleteInstancesRegionInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupManagerRequest",
    "InsertRegionInstanceGroupManagerRequest",
    "ListRegionInstanceGroupManagersRequest",
    "ListErrorsRegionInstanceGroupManagersRequest",
    "ListManagedInstancesRegionInstanceGroupManagersRequest",
    "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
    "PatchRegionInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
    "RecreateInstancesRegionInstanceGroupManagerRequest",
    "ResizeRegionInstanceGroupManagerRequest",
    "SetInstanceTemplateRegionInstanceGroupManagerRequest",
    "SetTargetPoolsRegionInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupRequest",
    "ListRegionInstanceGroupsRequest",
    "ListInstancesRegionInstanceGroupsRequest",
    "SetNamedPortsRegionInstanceGroupRequest",
    "DeleteRegionNetworkEndpointGroupRequest",
    "GetRegionNetworkEndpointGroupRequest",
    "InsertRegionNetworkEndpointGroupRequest",
    "ListRegionNetworkEndpointGroupsRequest",
    "DeleteRegionNotificationEndpointRequest",
    "GetRegionNotificationEndpointRequest",
    "InsertRegionNotificationEndpointRequest",
    "ListRegionNotificationEndpointsRequest",
    "DeleteRegionOperationRequest",
    "DeleteRegionOperationResponse",
    "GetRegionOperationRequest",
    "ListRegionOperationsRequest",
    "WaitRegionOperationRequest",
    "DeleteRegionSslCertificateRequest",
    "GetRegionSslCertificateRequest",
    "InsertRegionSslCertificateRequest",
    "ListRegionSslCertificatesRequest",
    "DeleteRegionTargetHttpProxyRequest",
    "GetRegionTargetHttpProxyRequest",
    "InsertRegionTargetHttpProxyRequest",
    "ListRegionTargetHttpProxiesRequest",
    "SetUrlMapRegionTargetHttpProxyRequest",
    "DeleteRegionTargetHttpsProxyRequest",
    "GetRegionTargetHttpsProxyRequest",
    "InsertRegionTargetHttpsProxyRequest",
    "ListRegionTargetHttpsProxiesRequest",
    "SetSslCertificatesRegionTargetHttpsProxyRequest",
    "SetUrlMapRegionTargetHttpsProxyRequest",
    "DeleteRegionUrlMapRequest",
    "GetRegionUrlMapRequest",
    "InsertRegionUrlMapRequest",
    "ListRegionUrlMapsRequest",
    "PatchRegionUrlMapRequest",
    "UpdateRegionUrlMapRequest",
    "ValidateRegionUrlMapRequest",
    "GetRegionRequest",
    "ListRegionsRequest",
    "AggregatedListReservationsRequest",
    "DeleteReservationRequest",
    "GetReservationRequest",
    "GetIamPolicyReservationRequest",
    "InsertReservationRequest",
    "ListReservationsRequest",
    "ResizeReservationRequest",
    "SetIamPolicyReservationRequest",
    "TestIamPermissionsReservationRequest",
    "AggregatedListResourcePoliciesRequest",
    "DeleteResourcePolicyRequest",
    "GetResourcePolicyRequest",
    "GetIamPolicyResourcePolicyRequest",
    "InsertResourcePolicyRequest",
    "ListResourcePoliciesRequest",
    "SetIamPolicyResourcePolicyRequest",
    "TestIamPermissionsResourcePolicyRequest",
    "AggregatedListRoutersRequest",
    "DeleteRouterRequest",
    "GetRouterRequest",
    "GetNatMappingInfoRoutersRequest",
    "GetRouterStatusRouterRequest",
    "InsertRouterRequest",
    "ListRoutersRequest",
    "PatchRouterRequest",
    "PreviewRouterRequest",
    "UpdateRouterRequest",
    "DeleteRouteRequest",
    "GetRouteRequest",
    "InsertRouteRequest",
    "ListRoutesRequest",
    "AddRuleSecurityPolicyRequest",
    "DeleteSecurityPolicyRequest",
    "GetSecurityPolicyRequest",
    "GetRuleSecurityPolicyRequest",
    "InsertSecurityPolicyRequest",
    "ListSecurityPoliciesRequest",
    "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
    "PatchSecurityPolicyRequest",
    "PatchRuleSecurityPolicyRequest",
    "RemoveRuleSecurityPolicyRequest",
    "DeleteSnapshotRequest",
    "GetSnapshotRequest",
    "GetIamPolicySnapshotRequest",
    "ListSnapshotsRequest",
    "SetIamPolicySnapshotRequest",
    "SetLabelsSnapshotRequest",
    "TestIamPermissionsSnapshotRequest",
    "AggregatedListSslCertificatesRequest",
    "DeleteSslCertificateRequest",
    "GetSslCertificateRequest",
    "InsertSslCertificateRequest",
    "ListSslCertificatesRequest",
    "DeleteSslPolicyRequest",
    "GetSslPolicyRequest",
    "InsertSslPolicyRequest",
    "ListSslPoliciesRequest",
    "ListAvailableFeaturesSslPoliciesRequest",
    "PatchSslPolicyRequest",
    "AggregatedListSubnetworksRequest",
    "DeleteSubnetworkRequest",
    "ExpandIpCidrRangeSubnetworkRequest",
    "GetSubnetworkRequest",
    "GetIamPolicySubnetworkRequest",
    "InsertSubnetworkRequest",
    "ListSubnetworksRequest",
    "ListUsableSubnetworksRequest",
    "PatchSubnetworkRequest",
    "SetIamPolicySubnetworkRequest",
    "SetPrivateIpGoogleAccessSubnetworkRequest",
    "TestIamPermissionsSubnetworkRequest",
    "DeleteTargetGrpcProxyRequest",
    "GetTargetGrpcProxyRequest",
    "InsertTargetGrpcProxyRequest",
    "ListTargetGrpcProxiesRequest",
    "PatchTargetGrpcProxyRequest",
    "AggregatedListTargetHttpProxiesRequest",
    "DeleteTargetHttpProxyRequest",
    "GetTargetHttpProxyRequest",
    "InsertTargetHttpProxyRequest",
    "ListTargetHttpProxiesRequest",
    "PatchTargetHttpProxyRequest",
    "SetUrlMapTargetHttpProxyRequest",
    "AggregatedListTargetHttpsProxiesRequest",
    "DeleteTargetHttpsProxyRequest",
    "GetTargetHttpsProxyRequest",
    "InsertTargetHttpsProxyRequest",
    "ListTargetHttpsProxiesRequest",
    "SetQuicOverrideTargetHttpsProxyRequest",
    "SetSslCertificatesTargetHttpsProxyRequest",
    "SetSslPolicyTargetHttpsProxyRequest",
    "SetUrlMapTargetHttpsProxyRequest",
    "AggregatedListTargetInstancesRequest",
    "DeleteTargetInstanceRequest",
    "GetTargetInstanceRequest",
    "InsertTargetInstanceRequest",
    "ListTargetInstancesRequest",
    "AddHealthCheckTargetPoolRequest",
    "AddInstanceTargetPoolRequest",
    "AggregatedListTargetPoolsRequest",
    "DeleteTargetPoolRequest",
    "GetTargetPoolRequest",
    "GetHealthTargetPoolRequest",
    "InsertTargetPoolRequest",
    "ListTargetPoolsRequest",
    "RemoveHealthCheckTargetPoolRequest",
    "RemoveInstanceTargetPoolRequest",
    "SetBackupTargetPoolRequest",
    "DeleteTargetSslProxyRequest",
    "GetTargetSslProxyRequest",
    "InsertTargetSslProxyRequest",
    "ListTargetSslProxiesRequest",
    "SetBackendServiceTargetSslProxyRequest",
    "SetProxyHeaderTargetSslProxyRequest",
    "SetSslCertificatesTargetSslProxyRequest",
    "SetSslPolicyTargetSslProxyRequest",
    "DeleteTargetTcpProxyRequest",
    "GetTargetTcpProxyRequest",
    "InsertTargetTcpProxyRequest",
    "ListTargetTcpProxiesRequest",
    "SetBackendServiceTargetTcpProxyRequest",
    "SetProxyHeaderTargetTcpProxyRequest",
    "AggregatedListTargetVpnGatewaysRequest",
    "DeleteTargetVpnGatewayRequest",
    "GetTargetVpnGatewayRequest",
    "InsertTargetVpnGatewayRequest",
    "ListTargetVpnGatewaysRequest",
    "AggregatedListUrlMapsRequest",
    "DeleteUrlMapRequest",
    "GetUrlMapRequest",
    "InsertUrlMapRequest",
    "InvalidateCacheUrlMapRequest",
    "ListUrlMapsRequest",
    "PatchUrlMapRequest",
    "UpdateUrlMapRequest",
    "ValidateUrlMapRequest",
    "AggregatedListVpnGatewaysRequest",
    "DeleteVpnGatewayRequest",
    "GetVpnGatewayRequest",
    "GetStatusVpnGatewayRequest",
    "InsertVpnGatewayRequest",
    "ListVpnGatewaysRequest",
    "SetLabelsVpnGatewayRequest",
    "TestIamPermissionsVpnGatewayRequest",
    "AggregatedListVpnTunnelsRequest",
    "DeleteVpnTunnelRequest",
    "GetVpnTunnelRequest",
    "InsertVpnTunnelRequest",
    "ListVpnTunnelsRequest",
    "DeleteZoneOperationRequest",
    "DeleteZoneOperationResponse",
    "GetZoneOperationRequest",
    "ListZoneOperationsRequest",
    "WaitZoneOperationRequest",
    "GetZoneRequest",
    "ListZonesRequest",
)
