#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.sqlalchemy_utils',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20220311',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Assorted utility functions to support working with SQLAlchemy.',
  long_description =
    ('Assorted utility functions to support working with SQLAlchemy.\n'    
 '\n'    
 '*Latest release 20220311*:\n'    
 'Many updates and small fixes.\n'    
 '\n'    
 '## Function `auto_session(function)`\n'    
 '\n'    
 'Decorator to run a function in a session if one is not presupplied.\n'    
 'The function `function` runs within a transaction,\n'    
 'nested if the session already exists.\n'    
 '\n'    
 'See `with_session` for details.\n'    
 '\n'    
 '## Class `BasicTableMixin`\n'    
 '\n'    
 'Useful methods for most tables.\n'    
 '\n'    
 '*Method `BasicTableMixin.__getitem__(index, *, session)`*:\n'    
 'Index the table by its `id` column.\n'    
 '\n'    
 '*Method `BasicTableMixin.by_id(index, *, session)`*:\n'    
 'Index the table by its `id` column.\n'    
 '\n'    
 '*Method `BasicTableMixin.lookup(*, session, **criteria)`*:\n'    
 'Return an iterable `Query` of row entities matching `criteria`.\n'    
 '\n'    
 '*Method `BasicTableMixin.lookup1(*, session, **criteria)`*:\n'    
 'Return the row entity matching `criteria`, or `None` if no match.\n'    
 '\n'    
 '## Function `find_json_field(column_value, field_name, *, infill=False)`\n'    
 '\n'    
 'Descend a JSONable Python object `column_value`\n'    
 'to `field_name`.\n'    
 'Return `column_value` (possibly infilled), `final_field`, '    
 '`final_field_name`.\n'    
 '\n'    
 'This supports database row columns which are JSON columns.\n'    
 '\n'    
 'Parameters:\n'    
 '* `column_value`: the original value of the column\n'    
 '* `field_name`: the field within the column to locate\n'    
 '* `infill`: optional keyword parameter, default `False`.\n'    
 '  If true,\n'    
 '  `column_value` and its innards will be filled in as `dict`s\n'    
 '  to allow deferencing the `field_name`.\n'    
 '\n'    
 'The `field_name` is a `str`\n'    
 "consisting of a period (`'.'`) separated sequence of field parts.\n"    
 'Each field part becomes a key to index the column mapping.\n'    
 'These keys are split into the leading field parts\n'    
 'and the final field part,\n'    
 'which is returned as `final_field_name` above.\n'    
 '\n'    
 'The `final_field` return value above\n'    
 'is the mapping within which `final_field_value` may lie\n'    
 'and where `final_field_value` may be set.\n'    
 'Note: it may not be present.\n'    
 '\n'    
 'If a leading key is missing and `infill` is true\n'    
 'the corresponding part of the `column_value` is set to an empty dictionary\n'    
 'in order to allow deferencing the leading key.\n'    
 'This includes the case when `column_value` itself is `None`,\n'    
 'which is why the `column_value` is part of the return.\n'    
 '\n'    
 'If a leading key is missing and `infill` is false\n'    
 'this function will raise a `KeyError`\n'    
 'for the portion of the `field_name` which failed.\n'    
 '\n'    
 'Examples:\n'    
 '\n'    
 "    >>> find_json_field({'a':{'b':{}}}, 'a.b')\n"    
 "    ({'a': {'b': {}}}, {'b': {}}, 'b')\n"    
 "    >>> find_json_field({'a':{}}, 'a.b')\n"    
 "    ({'a': {}}, {}, 'b')\n"    
 "    >>> find_json_field({'a':{'b':{}}}, 'a.b.c.d')\n"    
 '    Traceback (most recent call last):\n'    
 '        ...\n'    
 "    KeyError: 'a.b.c'\n"    
 "    >>> find_json_field({'a':{'b':{}}}, 'a.b.c.d', infill=True)\n"    
 "    ({'a': {'b': {'c': {}}}}, {}, 'd')\n"    
 "    >>> find_json_field(None, 'a.b.c.d')\n"    
 '    Traceback (most recent call last):\n'    
 '        ...\n'    
 "    KeyError: 'a'\n"    
 "    >>> find_json_field(None, 'a.b.c.d', infill=True)\n"    
 "    ({'a': {'b': {'c': {}}}}, {}, 'd')\n"    
 '\n'    
 '## Function `get_json_field(column_value, field_name, *, default=None)`\n'    
 '\n'    
 'Return the value of `field_name` from `column_value`\n'    
 'or a defaault if the field is not present.\n'    
 '\n'    
 'Parameters:\n'    
 '* `column_value`: the original value of the column\n'    
 '* `field_name`: the field within the column to locate\n'    
 '* `default`: default value to return if the field is not present,\n'    
 '  default: `None`\n'    
 '\n'    
 'Examples:\n'    
 '\n'    
 "    >>> get_json_field({'a': 1}, 'a')\n"    
 '    1\n'    
 "    >>> get_json_field({'b': 1}, 'a')\n"    
 "    >>> get_json_field({'a': {}}, 'a.b')\n"    
 "    >>> get_json_field({'a': {'b': 2}}, 'a.b')\n"    
 '    2\n'    
 '\n'    
 '## Class `HasIdMixin`\n'    
 '\n'    
 'Include an "id" `Column` as the primary key.\n'    
 '\n'    
 '## Function `json_column(*da, **dkw)`\n'    
 '\n'    
 'Class decorator to declare a virtual column name on a table\n'    
 'where the value resides inside a JSON column of the table.\n'    
 '\n'    
 'Parameters:\n'    
 '* `cls`: the class to annotate\n'    
 '* `attr`: the virtual column name to present as a row attribute\n'    
 '* `json_field_name`: the field within the JSON column\n'    
 '  used to store this value,\n'    
 '  default the same as `attr`\n'    
 '* `json_column_name`: the name of the associated JSON column,\n'    
 "  default `'info'`\n"    
 '* `default`: the default value returned by the getter\n'    
 '  if the field is not present,\n'    
 '  default `None`\n'    
 '\n'    
 'Example use:\n'    
 '\n'    
 '    Base = declarative_base()\n'    
 '    ...\n'    
 "    @json_column('virtual_name', 'json.field.name')\n"    
 '    class TableClass(Base):\n'    
 '      ...\n'    
 '\n'    
 'This annotates the class with a `.virtual_name` property\n'    
 'which can be accessed or set,\n'    
 'accessing or modifying the associated JSON column\n'    
 '(in this instance, the column `info`,\n'    
 "accessing `info['json']['field']['name']`).\n"    
 '\n'    
 '## Function `log_level(*da, **dkw)`\n'    
 '\n'    
 'Decorator for functions which wraps calls to the function\n'    
 'in a context manager, optionally supplying the context\n'    
 'as the first argument to the called function.\n'    
 '\n'    
 '## Class `ORM(cs.resources.MultiOpenMixin, cs.context.ContextManagerMixin)`\n'    
 '\n'    
 'A convenience base class for an ORM class.\n'    
 '\n'    
 'This defines a `.Base` attribute which is a new `DeclarativeBase`\n'    
 'and provides various Session related convenience methods.\n'    
 'It is also a `MultiOpenMixin` subclass\n'    
 'supporting nested open/close sequences and use as a context manager.\n'    
 '\n'    
 '*Method `ORM.__init__(self, *a, **kw)`*:\n'    
 'Initialise the ORM.\n'    
 '\n'    
 'If `serial_sessions` is true (default `False`)\n'    
 'then allocate a lock to serialise session allocation.\n'    
 'This might be chosen with SQL backends which do not support\n'    
 'concurrent sessions such as SQLite.\n'    
 '\n'    
 "In the case of SQLite there's a small inbuilt timeout in\n"    
 'an attempt to serialise transactions but it is possible to\n'    
 'exceed it easily and recovery is usually infeasible.\n'    
 'Instead we use the `serial_sessions` option to obtain a\n'    
 'mutex before allocating a session.\n'    
 '\n'    
 '*Method `ORM.arranged_session(self, *a, **kw)`*:\n'    
 'Arrange a new session for this `Thread`.\n'    
 '\n'    
 '*Method `ORM.declare_schema(self)`*:\n'    
 'Declare the database schema / ORM mapping.\n'    
 'This just defines the relation types etc.\n'    
 'It *does not* act on the database itself.\n'    
 'It is called automatically at the end of `__init__`.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    def declare_schema(self):\n'    
 '      """ Define the database schema / ORM mapping.\n'    
 '      """\n'    
 '      orm = self\n'    
 '      Base = self.Base\n'    
 '      class Entities(\n'    
 '      ........\n'    
 '      self.entities = Entities\n'    
 '\n'    
 'After this, methods can access the example `Entities` relation\n'    
 'as `self.entites`.\n'    
 '\n'    
 '*Property `ORM.default_session`*:\n'    
 'The current per-`Thread` session.\n'    
 '\n'    
 '*Property `ORM.engine`*:\n'    
 'SQLAlchemy engine, made on demand.\n'    
 '\n'    
 '*Method `ORM.startup_shutdown(self)`*:\n'    
 'Default startup/shutdown context manager.\n'    
 '\n'    
 'This base method operates a lockfile to manage concurrent access\n'    
 'by other programmes (which would also need to honour this file).\n'    
 'If you actually expect this to be common\n'    
 'you should try to keep the `ORM` "open" as briefly as possible.\n'    
 'The lock file is only operated if `self.db_fspath`,\n'    
 'current set only for filesystem SQLite database URLs.\n'    
 '\n'    
 '## Function `orm_auto_session(method)`\n'    
 '\n'    
 'Decorator to run a method in a session derived from `self.orm`\n'    
 'if a session is not presupplied.\n'    
 'Intended to assist classes with a `.orm` attribute.\n'    
 '\n'    
 'See `with_session` for details.\n'    
 '\n'    
 '## Function `set_json_field(column_value, field_name, value, *, '    
 'infill=False)`\n'    
 '\n'    
 'Set a new `value` for `field_name` of `column_value`.\n'    
 'Return the new `column_value`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `column_value`: the original value of the column\n'    
 '* `field_name`: the field within the column to locate\n'    
 '* `value`: the value to store as `field_name`\n'    
 '* `infill`: optional keyword parameter, default `False`.\n'    
 '  If true,\n'    
 '  `column_value` and its innards will be filled in as `dict`s\n'    
 '  to allow deferencing the `field_name`.\n'    
 '\n'    
 'As with `find_json_field`,\n'    
 'a true `infill` may modify `column_value` to provide `field_name`\n'    
 'which is why this function returns the new `column_value`.\n'    
 '\n'    
 'Examples:\n'    
 '\n'    
 "    >>> set_json_field({'a': 2}, 'a', 3)\n"    
 "    {'a': 3}\n"    
 "    >>> set_json_field({'a': 2, 'b': {'c': 5}}, 'b.c', 4)\n"    
 "    {'a': 2, 'b': {'c': 4}}\n"    
 "    >>> set_json_field({'a': 2}, 'b.c', 4)\n"    
 '    Traceback (most recent call last):\n'    
 '        ...\n'    
 "    KeyError: 'b'\n"    
 "    >>> set_json_field({'a': 2}, 'b.c', 4, infill=True)\n"    
 "    {'a': 2, 'b': {'c': 4}}\n"    
 "    >>> set_json_field(None, 'b.c', 4, infill=True)\n"    
 "    {'b': {'c': 4}}\n"    
 '\n'    
 '## Class `SQLAState(cs.threads.State, _thread._local)`\n'    
 '\n'    
 'Thread local state for SQLAlchemy ORM and session.\n'    
 '\n'    
 '*Method `SQLAState.auto_session(self, *, orm=None)`*:\n'    
 'Context manager to use the current session\n'    
 'if not `None`, otherwise to make one using `orm` or `self.orm`.\n'    
 '\n'    
 '*Method `SQLAState.new_session(self, *, orm=None)`*:\n'    
 'Context manager to create a new session from `orm` or `self.orm`.\n'    
 '\n'    
 '## Function `using_session(orm=None, session=None)`\n'    
 '\n'    
 'A context manager to prepare an SQLAlchemy session\n'    
 'for use by a suite.\n'    
 '\n'    
 'Parameters:\n'    
 '* `orm`: optional reference ORM,\n'    
 '  an object with a `.session()` method for creating a new session.\n'    
 '  Default: if needed, obtained from the global `state.orm`.\n'    
 '* `session`: optional existing session.\n'    
 '  Default: the global `state.session` if not `None`,\n'    
 '  otherwise created by `orm.session()`.\n'    
 '\n'    
 'If a new session is created, the new session and reference ORM\n'    
 'are pushed onto the globals `state.session` and `state.orm`\n'    
 'respectively.\n'    
 '\n'    
 'If an existing session is reused,\n'    
 'the suite runs within a savepoint from `session.begin_nested()`.\n'    
 '\n'    
 '## Function `with_orm(function, *a, orm=None, **kw)`\n'    
 '\n'    
 'Call `function` with the supplied `orm` in the shared state.\n'    
 '\n'    
 '## Function `with_session(function, *a, orm=None, session=None, **kw)`\n'    
 '\n'    
 'Call `function(*a,session=session,**kw)`, creating a session if required.\n'    
 'The function `function` runs within a transaction,\n'    
 'nested if the session already exists.\n'    
 'If a new session is created\n'    
 'it is set as the default session in the shared state.\n'    
 '\n'    
 'This is the inner mechanism of `@auto_session` and\n'    
 '`ORM.auto_session`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `function`: the function to call\n'    
 '* `a`: the positional parameters\n'    
 '* `orm`: optional ORM class with a `.session()` context manager method\n'    
 '  such as the `ORM` base class supplied by this module.\n'    
 '* `session`: optional existing ORM session\n'    
 '* `kw`: other keyword arguments, passed to `function`\n'    
 '\n'    
 'One of `orm` or `session` must be not `None`; if `session`\n'    
 'is `None` then one is made from `orm.session()` and used as\n'    
 'a context manager.\n'    
 '\n'    
 'The `session` is also passed to `function` as\n'    
 'the keyword parameter `session` to support nested calls.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20220311*:\n'    
 'Many updates and small fixes.\n'    
 '\n'    
 '*Release 20210420*:\n'    
 '* ORM: drop .Session from docstring, no longer used.\n'    
 '* Rename ORM.sessionmaker to ORM._sessionmaker, not for public use.\n'    
 '* ORM: replace session with arranged_session, which allocates a session in '    
 'conformance with ORM.serial_sessions (serial sessions are used with '    
 'SQLite).\n'    
 '* Drop @ORM.auto_session and @ORM.orm_method decorators, no longer used.\n'    
 '* SQLAState.new_session: use orm.arranged_session(), use begin_nested(); '    
 'SQLAState.auto_session: use begin_nested().\n'    
 '\n'    
 '*Release 20210322*:\n'    
 'Delete escaped debug code which issued a RuntimeError.\n'    
 '\n'    
 '*Release 20210321*:\n'    
 "* Default session support, particularly though an ORM's .sqla_state "    
 'per-Thread state object - this allows removal of a lot of plumbing and '    
 '@auto_session decoration.\n'    
 '* Support for serialised sessions, for db backend where only one session may '    
 'be active at a time; this brings easy support for multithreaded SQLite '    
 'access.\n'    
 '\n'    
 '*Release 20210306*:\n'    
 '* Rename _state to state, making it public.\n'    
 '* Some other internal changes.\n'    
 '\n'    
 '*Release 20201025*:\n'    
 '* New BasicTableMixin and HasIdMixin classes with useful methods and a '    
 'typical `id` Column respectively.\n'    
 '* Assorted fixes and improvements.\n'    
 '\n'    
 '*Release 20190830.1*:\n'    
 'Have the decorators set .__module__.\n'    
 '\n'    
 '*Release 20190830*:\n'    
 '@json_column: small docstring improvement.\n'    
 '\n'    
 '*Release 20190829*:\n'    
 '* Bugfix @json_column setter: mark the column as modified for the ORM.\n'    
 '* New push_log_level context manager and @log_level decorator to temporarily '    
 'change the SQLAlchemy logging handler level.\n'    
 '\n'    
 '*Release 20190812*:\n'    
 '* Make ORM a MultiOpenMixin.\n'    
 '* get_json_field: use forgotten `default` parameter.\n'    
 '* Other minor changes.\n'    
 '\n'    
 '*Release 20190526*:\n'    
 '* Support for virtual columns mapped to a JSON column interior value:\n'    
 '* New functions find_json_field, get_json_field, set_json_field.\n'    
 '* New decorator @json_column for declaritive_base tables.\n'    
 '\n'    
 '*Release 20190517*:\n'    
 '* Make ORM._Session private session factory the public ORM.Session factory '    
 'for external use.\n'    
 '* with_session: preexisting sessions still trigger a session.begin_nested, '    
 'removes flush/commit tension elsewhere.\n'    
 '\n'    
 '*Release 20190403*:\n'    
 '* Rename @ORM.orm_auto_session to @ORM.auto_session.\n'    
 '* New @orm_auto_session decorator for methods of objects with a .orm '    
 'attribute.\n'    
 '\n'    
 '*Release 20190319.1*:\n'    
 'Initial release. ORM base class, @auto_session decorator.'),
  install_requires = ['icontract', 'sqlalchemy', 'cs.deco', 'cs.fileutils', 'cs.lex', 'cs.logutils', 'cs.pfx', 'cs.py.func', 'cs.resources', 'cs.threads'],
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 3', 'Topic :: Database', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.sqlalchemy_utils'],
)
