# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .msg_hist_key import tMsgHistKey

class tMsgHist(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: int = 0,
                 status: str = '',
                 msgdate: datetime.datetime = datetime.datetime.min,
                 msg: dict = None):
        """
        Constructor.

        :param id: int
        :param status: str
        :param msgdate: datetime.datetime
        :param msg: dict
        """
        self.id = id
        self.status = status
        self.msgdate = msgdate
        self.msg = msg

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.status = ''
        self.msgdate = datetime.datetime.min
        self.msg = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tMsgHist'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("id", self.id)
        _w.write_char("status", self.status)
        _w.write_datetime("msgdate", self.msgdate)
        _w.write_json("msg", self.msg)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int64("id")
        self.status = _r.read_char("status")
        self.msgdate = _r.read_datetime("msgdate")
        self.msg = _r.read_json("msg")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tMsgHist"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.status = rec.status
        self.msgdate = rec.msgdate
        self.msg = rec.msg

    def _write_pk(self, _key: "tMsgHist"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tMsgHist"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tMsgHistKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tMsgHistKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        if key_only:
            return dvc

        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("msgdate", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("msg", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tMsgHist._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tMsgHistKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tMsgHistKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<MsgHist [id:%r, status:%.32s, msgdate:%s, msg:%.32s]>' % (
            self.id, self.status, self.msgdate, self.msg)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tMsgHist.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tMsgHist()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tMsgHist.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tMsgHist._cache_davs(dvc, for_ins, key_only)

