# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_type_key import tNoTypeKey
from bs_loco.db.tables.no_type import tNoType

class dNoTypeSelectOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoTypeKey()
        self.orec     = tNoType()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: str) -> "dNoTypeSelectOne":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :return: Self for convenience.
        """
        self.irec.id = id

        return await self.exec()

    async def exec(self, irec: tNoTypeKey = None) -> "dNoTypeSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoTypeSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  status,
  descr,
  grp,
  priority,
  pref_corr,
  corr_cnt,
  max_life,
  modified_by,
  tm_stamp
from
  loco.NoType
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)

        self._dbstmnt.bind_out("id", str, 128)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("descr", str, 256)
        self._dbstmnt.bind_out("grp", str, 64)
        self._dbstmnt.bind_out("priority", int, 4)
        self._dbstmnt.bind_out("pref_corr", dict)
        self._dbstmnt.bind_out("corr_cnt", int, 4)
        self._dbstmnt.bind_out("max_life", int, 4)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.status = self._dbstmnt.result[1]
        self.orec.descr = self._dbstmnt.result[2]
        self.orec.grp = self._dbstmnt.result[3]
        self.orec.priority = self._dbstmnt.result[4]
        self.orec.pref_corr = self._dbstmnt.result[5]
        self.orec.corr_cnt = self._dbstmnt.result[6]
        self.orec.max_life = self._dbstmnt.result[7]
        self.orec.modified_by = self._dbstmnt.result[8]
        self.orec.tm_stamp = self._dbstmnt.result[9]

        return True

    async def fetch_all(self, outList: tNoType.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

