# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.imsg_req_res_by_msg_req import iMsgReqResByMsgReq
from bs_loco.db.tables.msg_req_res import tMsgReqRes

class dMsgReqResByMsgReq:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iMsgReqResByMsgReq()
        self.orec     = tMsgReqRes()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        msgreq_id: int,
                        criteria: str) -> "dMsgReqResByMsgReq":
        """
        Execute the query by setting all the inputs.

        :param msgreq_id: int
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.msgreq_id = msgreq_id
        self.irec.criteria = criteria

        return await self.exec()

    async def exec(self, irec: iMsgReqResByMsgReq = None) -> "dMsgReqResByMsgReq":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("MsgReqResByMsgReq", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  mr.*
from
  loco.msgreqres mr
where
  mr.msgreq_id = :msgreq_id
  [criteria]
order by
  mr.id""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("msgreq_id", self.irec.msgreq_id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("msgreq_id", int, 8)
        self._dbstmnt.bind_out("corr_id_list", dict)
        self._dbstmnt.bind_out("filename", str)
        self._dbstmnt.bind_out("mimetype", str)
        self._dbstmnt.bind_out("content", bytearray)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.msgreq_id = self._dbstmnt.result[1]
        self.orec.corr_id_list = self._dbstmnt.result[2]
        self.orec.filename = self._dbstmnt.result[3]
        self.orec.mimetype = self._dbstmnt.result[4]
        self.orec.content = self._dbstmnt.result[5]
        self.orec.modified_by = self._dbstmnt.result[6]
        self.orec.tm_stamp = self._dbstmnt.result[7]

        return True

    async def fetch_all(self, outList: tMsgReqRes.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

