# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_prov import tCorrProv

class dCorrProvUpdate:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCorrProv()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: str,
                        corrtype_id: str,
                        descr: str,
                        status: str,
                        cfg_schema: dict,
                        cfg: dict,
                        lastcfg_id: int,
                        modified_by: str) -> "dCorrProvUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param corrtype_id: str
        :param descr: str
        :param status: str
        :param cfg_schema: dict
        :param cfg: dict
        :param lastcfg_id: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.corrtype_id = corrtype_id
        self.irec.descr = descr
        self.irec.status = status
        self.irec.cfg_schema = cfg_schema
        self.irec.cfg = cfg
        self.irec.lastcfg_id = lastcfg_id
        self.irec.modified_by = modified_by

        return await self.exec()

    async def exec(self, irec: tCorrProv = None) -> "dCorrProvUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("CorrProvUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.CorrProv
set
  descr = :descr,
  status = :status,
  cfg_schema = :cfg_schema,
  cfg = :cfg,
  lastcfg_id = :lastcfg_id,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  id = :id and
  corrtype_id = :corrtype_id""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str, 16)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("descr", self.irec.descr, str)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("cfg_schema", self.irec.cfg_schema, dict)
        self._dbstmnt.bind_in("cfg", self.irec.cfg, dict)
        self._dbstmnt.bind_in("lastcfg_id", self.irec.lastcfg_id, int, 8)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

