# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_msg_req import tSnapMsgReq

class dSnapMsgReqInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapMsgReq()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  valuedate: datetime.date,
                  notype_id: str,
                  tot_req: int,
                  tot_proc: int,
                  tot_cancelled: int,
                  tot_part_canc: int,
                  tot_msgs: int,
                  tot_msgs_sent: int,
                  tot_msgs_failed: int,
                  tot_msgs_retrys: int) -> "dSnapMsgReqInsert":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param notype_id: str
        :param tot_req: int
        :param tot_proc: int
        :param tot_cancelled: int
        :param tot_part_canc: int
        :param tot_msgs: int
        :param tot_msgs_sent: int
        :param tot_msgs_failed: int
        :param tot_msgs_retrys: int
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.notype_id = notype_id
        self.irec.tot_req = tot_req
        self.irec.tot_proc = tot_proc
        self.irec.tot_cancelled = tot_cancelled
        self.irec.tot_part_canc = tot_part_canc
        self.irec.tot_msgs = tot_msgs
        self.irec.tot_msgs_sent = tot_msgs_sent
        self.irec.tot_msgs_failed = tot_msgs_failed
        self.irec.tot_msgs_retrys = tot_msgs_retrys

        return self.exec()

    def exec(self, irec: tSnapMsgReq = None) -> "dSnapMsgReqInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("SnapMsgReqInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.SnapMsgReq (
  valuedate,
  notype_id,
  tot_req,
  tot_proc,
  tot_cancelled,
  tot_part_canc,
  tot_msgs,
  tot_msgs_sent,
  tot_msgs_failed,
  tot_msgs_retrys
) values (
  :valuedate,
  :notype_id,
  :tot_req,
  :tot_proc,
  :tot_cancelled,
  :tot_part_canc,
  :tot_msgs,
  :tot_msgs_sent,
  :tot_msgs_failed,
  :tot_msgs_retrys
)""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 64)
        self._dbstmnt.bind_in("tot_req", self.irec.tot_req, int, 4)
        self._dbstmnt.bind_in("tot_proc", self.irec.tot_proc, int, 4)
        self._dbstmnt.bind_in("tot_cancelled", self.irec.tot_cancelled, int, 4)
        self._dbstmnt.bind_in("tot_part_canc", self.irec.tot_part_canc, int, 4)
        self._dbstmnt.bind_in("tot_msgs", self.irec.tot_msgs, int, 4)
        self._dbstmnt.bind_in("tot_msgs_sent", self.irec.tot_msgs_sent, int, 4)
        self._dbstmnt.bind_in("tot_msgs_failed", self.irec.tot_msgs_failed, int, 4)
        self._dbstmnt.bind_in("tot_msgs_retrys", self.irec.tot_msgs_retrys, int, 4)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

