# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ import tNoTempl

class dNoTemplUpdate:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoTempl()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  notype_id: str,
                  corrtype_id: str,
                  status: str,
                  lastcfg_id: int,
                  templ: dict,
                  res_list: dict,
                  modified_by: str) -> "dNoTemplUpdate":
        """
        Execute the query by setting all the inputs.

        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param lastcfg_id: int
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.notype_id = notype_id
        self.irec.corrtype_id = corrtype_id
        self.irec.status = status
        self.irec.lastcfg_id = lastcfg_id
        self.irec.templ = templ
        self.irec.res_list = res_list
        self.irec.modified_by = modified_by

        return self.exec()

    def exec(self, irec: tNoTempl = None) -> "dNoTemplUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("NoTemplUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.NoTempl
set
  status = :status,
  lastcfg_id = :lastcfg_id,
  templ = :templ,
  res_list = :res_list,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  notype_id = :notype_id and
  corrtype_id = :corrtype_id""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("lastcfg_id", self.irec.lastcfg_id, int, 8)
        self._dbstmnt.bind_in("templ", self.irec.templ, dict)
        self._dbstmnt.bind_in("res_list", self.irec.res_list, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

