# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ_cfg import tNoTemplCfg

class dNoTemplCfgInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoTemplCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  notype_id: str,
                  corrtype_id: str,
                  status: str,
                  activate: datetime.datetime,
                  deactivate: datetime.datetime,
                  templ: dict,
                  res_list: dict,
                  modified_by: str,
                  tm_stamp: datetime.datetime) -> "dNoTemplCfgInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.notype_id = notype_id
        self.irec.corrtype_id = corrtype_id
        self.irec.status = status
        self.irec.activate = activate
        self.irec.deactivate = deactivate
        self.irec.templ = templ
        self.irec.res_list = res_list
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return self.exec()

    def exec(self, irec: tNoTemplCfg = None) -> "dNoTemplCfgInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("NoTemplCfgInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.NoTemplCfg (
  notype_id,
  corrtype_id,
  status,
  activate,
  deactivate,
  templ,
  res_list,
  modified_by,
  tm_stamp
) values (
  :notype_id,
  :corrtype_id,
  :status,
  :activate,
  :deactivate,
  :templ,
  :res_list,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("activate", self.irec.activate, datetime.datetime)
        self._dbstmnt.bind_in("deactivate", self.irec.deactivate, datetime.datetime)
        self._dbstmnt.bind_in("templ", self.irec.templ, dict)
        self._dbstmnt.bind_in("res_list", self.irec.res_list, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        self.irec.id = self._dbcon.post_get_sequence(self._dbstmnt, "loco.NoTemplCfg", "id", 8)

        if irec:
            irec._copy_from(self.irec)

        return self

