# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.imsg_status_cnt_by_req import iMsgStatusCntByReq
from bs_loco.db.tables.omsg_status_cnt_by_req import oMsgStatusCntByReq

class dMsgStatusCntByReq:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iMsgStatusCntByReq()
        self.orec     = oMsgStatusCntByReq()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  msgreq_id: int) -> "dMsgStatusCntByReq":
        """
        Execute the query by setting all the inputs.

        :param msgreq_id: int
        :return: Self for convenience.
        """
        self.irec.msgreq_id = msgreq_id

        return self.exec()

    def exec(self, irec: iMsgStatusCntByReq = None) -> "dMsgStatusCntByReq":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgStatusCntByReq", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  m.status,
  count(*) as cnt
from
  loco.msg m
where
  m.msgreq_id = :msgreq_id
group by
  m.status""")

        self._dbstmnt.bind_in("msgreq_id", self.irec.msgreq_id, int, 8)

        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("cnt", int, 4)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.status = self._dbstmnt.result[0]
        self.orec.cnt = self._dbstmnt.result[1]

        return True

    def fetch_all(self, outList: oMsgStatusCntByReq.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

