# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_req_res import tMsgReqRes

class dMsgReqResInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgReqRes()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  msgreq_id: int,
                  corr_id_list: dict,
                  filename: str,
                  mimetype: str,
                  content: bytearray,
                  modified_by: str,
                  tm_stamp: datetime.datetime) -> "dMsgReqResInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param msgreq_id: int
        :param corr_id_list: dict
        :param filename: str
        :param mimetype: str
        :param content: bytearray
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.msgreq_id = msgreq_id
        self.irec.corr_id_list = corr_id_list
        self.irec.filename = filename
        self.irec.mimetype = mimetype
        self.irec.content = content
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return self.exec()

    def exec(self, irec: tMsgReqRes = None) -> "dMsgReqResInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgReqResInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.MsgReqRes (
  msgreq_id,
  corr_id_list,
  filename,
  mimetype,
  content,
  modified_by,
  tm_stamp
) values (
  :msgreq_id,
  :corr_id_list,
  :filename,
  :mimetype,
  :content,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("msgreq_id", self.irec.msgreq_id, int, 8)
        self._dbstmnt.bind_in("corr_id_list", self.irec.corr_id_list, dict)
        self._dbstmnt.bind_in("filename", self.irec.filename, str)
        self._dbstmnt.bind_in("mimetype", self.irec.mimetype, str)
        self._dbstmnt.bind_in("content", self.irec.content, bytearray)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        self.irec.id = self._dbcon.post_get_sequence(self._dbstmnt, "loco.MsgReqRes", "id", 8)

        if irec:
            irec._copy_from(self.irec)

        return self

