# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_req import tMsgReq
from bs_loco.db.tables.msg_req_key import tMsgReqKey

from .msg_req_lock_one import dMsgReqLockOne
from .msg_req_select_one import dMsgReqSelectOne
from .msg_req_update import dMsgReqUpdate
from .msg_req_insert import dMsgReqInsert
from .msg_req_delete_one import dMsgReqDeleteOne

class dMsgReq:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tMsgReq()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tMsgReqKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tMsgReq, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tMsgReqKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      id: int,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param id: int
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tMsgReqKey()

        _key.id = id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tMsgReqKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dMsgReqLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dMsgReq)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock MsgReq record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), errCode = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tMsgReqKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tMsgReq) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tMsgReqKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            id: int) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param id: int
        :return: True if the row as selectd.
        """
        _key = tMsgReqKey()

        _key.id = id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tMsgReqKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dMsgReqSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dMsgReq":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dMsgReq)")

        return self

    def select_one_with(self, _rec: tMsgReq) -> "dMsgReq":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dMsgReq)")

        return self

    def select_one_deft(self,
                        id: int) -> "dMsgReq":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param id: int
        """
        _key = tMsgReqKey()

        _key.id = id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dMsgReq)")

        return self

    def select_one_by_key(self, _key: tMsgReqKey) -> "dMsgReq":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dMsgReq)")

        return self

    def update_deft(self,
                    id: int,
                    notype_id: str,
                    priority: int,
                    status: str,
                    time_req: datetime.datetime,
                    time_to_send: datetime.datetime,
                    time_proc: datetime.datetime,
                    msg_addr: dict,
                    msg_dict: dict,
                    cust_res: bool,
                    meta_data: dict,
                    modified_by: str):
        """
        Update the record by setting all column values.

        :param id: int
        :param notype_id: str
        :param priority: int
        :param status: str
        :param time_req: datetime.datetime
        :param time_to_send: datetime.datetime
        :param time_proc: datetime.datetime
        :param msg_addr: dict
        :param msg_dict: dict
        :param cust_res: bool
        :param meta_data: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.id = id
        self.rec.notype_id = notype_id
        self.rec.priority = priority
        self.rec.status = status
        self.rec.time_req = time_req
        self.rec.time_to_send = time_to_send
        self.rec.time_proc = time_proc
        self.rec.msg_addr = msg_addr
        self.rec.msg_dict = msg_dict
        self.rec.cust_res = cust_res
        self.rec.meta_data = meta_data
        self.rec.modified_by = modified_by

        self.update()

    def update(self, irec: tMsgReq = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dMsgReqUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    notype_id: str,
                    priority: int,
                    status: str,
                    time_req: datetime.datetime,
                    time_to_send: datetime.datetime,
                    time_proc: datetime.datetime,
                    msg_addr: dict,
                    msg_dict: dict,
                    cust_res: bool,
                    meta_data: dict,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param id: int
        :param notype_id: str
        :param priority: int
        :param status: str
        :param time_req: datetime.datetime
        :param time_to_send: datetime.datetime
        :param time_proc: datetime.datetime
        :param msg_addr: dict
        :param msg_dict: dict
        :param cust_res: bool
        :param meta_data: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.notype_id = notype_id
        self.rec.priority = priority
        self.rec.status = status
        self.rec.time_req = time_req
        self.rec.time_to_send = time_to_send
        self.rec.time_proc = time_proc
        self.rec.msg_addr = msg_addr
        self.rec.msg_dict = msg_dict
        self.rec.cust_res = cust_res
        self.rec.meta_data = meta_data
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tMsgReq = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dMsgReqInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def delete_one_deft(self,
                        id: int):
        """
        Delete one record by it's primary key columns.

        :param id: int
        """
        _key = tMsgReqKey()

        _key.id = id

        self.delete_one(_key)

    def delete_one(self, irec: tMsgReqKey = None):
        """
        Delete the record by its primary key or irec if it is not None.

        :param irec: If not None use this record to delete record.
        """
        _key = tMsgReqKey()

        if irec:
            _key._copy_from(irec)
        else:
            self.rec._write_key(_key)

        with dMsgReqDeleteOne(self._dbcon) as _qry:
            _qry.exec(_key)

