# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_hist import tMsgHist

class dMsgHistUpdate:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgHist()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  status: str,
                  msgdate: datetime.datetime,
                  msg: dict) -> "dMsgHistUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param status: str
        :param msgdate: datetime.datetime
        :param msg: dict
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.status = status
        self.irec.msgdate = msgdate
        self.irec.msg = msg

        return self.exec()

    def exec(self, irec: tMsgHist = None) -> "dMsgHistUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgHistUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.MsgHist
set
  status = :status,
  msgdate = :msgdate,
  msg = :msg
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("msgdate", self.irec.msgdate, datetime.datetime)
        self._dbstmnt.bind_in("msg", self.irec.msg, dict)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

