# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_type import tCorrType

class dCorrTypeUpdate:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCorrType()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: str,
                  descr: str,
                  status: str,
                  templ_schema: dict,
                  modified_by: str) -> "dCorrTypeUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param descr: str
        :param status: str
        :param templ_schema: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.descr = descr
        self.irec.status = status
        self.irec.templ_schema = templ_schema
        self.irec.modified_by = modified_by

        return self.exec()

    def exec(self, irec: tCorrType = None) -> "dCorrTypeUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("CorrTypeUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.CorrType
set
  descr = :descr,
  status = :status,
  templ_schema = :templ_schema,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  id = :id""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str, 16)
        self._dbstmnt.bind_in("descr", self.irec.descr, str)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("templ_schema", self.irec.templ_schema, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

