# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:02 2021
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_type_allow import tCorrTypeAllow
from bs_loco.db.tables.corr_type_allow_key import tCorrTypeAllowKey

from .corr_type_allow_lock_one import dCorrTypeAllowLockOne
from .corr_type_allow_select_one import dCorrTypeAllowSelectOne
from .corr_type_allow_update import dCorrTypeAllowUpdate
from .corr_type_allow_insert import dCorrTypeAllowInsert
from .corr_type_allow_delete_one import dCorrTypeAllowDeleteOne

class dCorrTypeAllow:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tCorrTypeAllow()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tCorrTypeAllowKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tCorrTypeAllow, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tCorrTypeAllowKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      corrtype_id: str,
                      allow_id: str,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param corrtype_id: str
        :param allow_id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tCorrTypeAllowKey()

        _key.corrtype_id = corrtype_id
        _key.allow_id = allow_id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tCorrTypeAllowKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dCorrTypeAllowLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dCorrTypeAllow)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock CorrTypeAllow record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), errCode = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tCorrTypeAllowKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tCorrTypeAllow) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tCorrTypeAllowKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            corrtype_id: str,
                            allow_id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param corrtype_id: str
        :param allow_id: str
        :return: True if the row as selectd.
        """
        _key = tCorrTypeAllowKey()

        _key.corrtype_id = corrtype_id
        _key.allow_id = allow_id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tCorrTypeAllowKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dCorrTypeAllowSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dCorrTypeAllow":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrTypeAllow)")

        return self

    def select_one_with(self, _rec: tCorrTypeAllow) -> "dCorrTypeAllow":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrTypeAllow)")

        return self

    def select_one_deft(self,
                        corrtype_id: str,
                        allow_id: str) -> "dCorrTypeAllow":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param corrtype_id: str
        :param allow_id: str
        """
        _key = tCorrTypeAllowKey()

        _key.corrtype_id = corrtype_id
        _key.allow_id = allow_id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrTypeAllow)")

        return self

    def select_one_by_key(self, _key: tCorrTypeAllowKey) -> "dCorrTypeAllow":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrTypeAllow)")

        return self

    def update_deft(self,
                    corrtype_id: str,
                    allow_id: str,
                    status: str,
                    regex: str,
                    modified_by: str):
        """
        Update the record by setting all column values.

        :param corrtype_id: str
        :param allow_id: str
        :param status: str
        :param regex: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.corrtype_id = corrtype_id
        self.rec.allow_id = allow_id
        self.rec.status = status
        self.rec.regex = regex
        self.rec.modified_by = modified_by

        self.update()

    def update(self, irec: tCorrTypeAllow = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dCorrTypeAllowUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    corrtype_id: str,
                    allow_id: str,
                    status: str,
                    regex: str,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param corrtype_id: str
        :param allow_id: str
        :param status: str
        :param regex: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.corrtype_id = corrtype_id
        self.rec.allow_id = allow_id
        self.rec.status = status
        self.rec.regex = regex
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tCorrTypeAllow = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dCorrTypeAllowInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def delete_one_deft(self,
                        corrtype_id: str,
                        allow_id: str):
        """
        Delete one record by it's primary key columns.

        :param corrtype_id: str
        :param allow_id: str
        """
        _key = tCorrTypeAllowKey()

        _key.corrtype_id = corrtype_id
        _key.allow_id = allow_id

        self.delete_one(_key)

    def delete_one(self, irec: tCorrTypeAllowKey = None):
        """
        Delete the record by its primary key or irec if it is not None.

        :param irec: If not None use this record to delete record.
        """
        _key = tCorrTypeAllowKey()

        if irec:
            _key._copy_from(irec)
        else:
            self.rec._write_key(_key)

        with dCorrTypeAllowDeleteOne(self._dbcon) as _qry:
            _qry.exec(_key)

