{
  description = "mbf-gtf devshell";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-unstable";
    rust-overlay.url = "github:oxalica/rust-overlay";
    flake-utils.url = "github:numtide/flake-utils";
  };

  outputs = { self, nixpkgs, rust-overlay, flake-utils, ... }:
    flake-utils.lib.eachDefaultSystem (system:
      let
        overlays = [ (import rust-overlay) ];
        pkgs = import nixpkgs { inherit system overlays; };
      in with pkgs; {
        devShell = mkShell {
          buildInputs = [
            rust-bin.stable."1.59.0".default
            #(pkgs.python39.withPackages (pp: [ pp.maturin ]))
            (pkgs.python39.withPackages (pp: [ pp.cffi ]))
            pkgs.maturin
            bacon
            #pkgs.python36
          ];

          shellHook = "";
        };
      });
}
