import smtplib


def send_mail_to(mail, receiver_mail: str , password, message)->bool:
    '''
    sends mail to specific address/addresses.
    '''
    try:
        server = smtplib.SMTP('smtp.gmail.com', 587)
        server.starttls()
        server.login(mail, password)
        server.sendmail(mail, receiver_mail, message)
        server.quit()
        return True
    except smtplib.SMTPException as e:
        print('[-] Exception : ', e)
        return False


if __name__=='__main__':
    msg = '''Subject: This is a test mail
    Dear User,
    This is a test message.
    '''
    gmail = 'your@gmail.com'
    password = 'password'
    receivers = 'list of emails'

    # mail to self
    send_mail_to(gmail, gmail, password, msg)

    # mail to others
    send_mail_to(gmail, receivers, password, msg)
