# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['blackbricks']

package_data = \
{'': ['*']}

install_requires = \
['black>=22.8.0,<23.0.0',
 'databricks-cli>=0.17.3,<0.18.0',
 'sqlparse>=0.4.2,<0.5.0',
 'typer[all]>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['blackbricks = blackbricks.cli:app']}

setup_kwargs = {
    'name': 'blackbricks',
    'version': '2.0.0',
    'description': 'Black for Databricks notebooks',
    'long_description': "[![PyPI version](https://img.shields.io/pypi/v/blackbricks.svg?logo=pypi&logoColor=FFE873)](https://pypi.org/project/blackbricks/)\n[![Downloads](https://pepy.tech/badge/blackbricks)](https://pepy.tech/project/blackbricks)\n[![Downloads per month](https://pepy.tech/badge/blackbricks/month)](https://pepy.tech/project/blackbricks/month)\n[![License](https://img.shields.io/pypi/l/blackbricks)](LICENSE)\n[![Code style: Black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n# Blackbricks\n\nA formatting tool for your Databricks notebooks.\n\n- Python cells are formatted with [black](https://github.com/psf/black)\n- SQL cells are formatted with [sqlparse](https://github.com/andialbrecht/sqlparse)\n\n## Table of Contents\n\n* [Installation](#installation)\n* [Usage](#usage)\n* [Version control integration](#version-control-integration)\n* [Contributing](#contributing)\n* [FAQ](#faq)\n* [Breaking changes](#breaking-changes)\n\n## Installation\n\nWhile you can use `pip` directly, you should prefer using [pipx](https://pypa.github.io/pipx/).\n\n```bash\n$ pipx install blackbricks\n```\n\nYou probably also want to have installed the `databricks-cli`, in order to use `blackbricks` directly on your notebooks.\n\n``` bash\n$ pipx install databricks-cli\n$ databricks configure  # Required in order to use `blackbricks` on remote notebooks.\n```\n\n## Usage\nYou can use `blackbricks` on Python notebook files stored locally, or directly on the notebooks stored in Databricks. \n\nFor the most part, `blackbricks` operates very similarly to `black`.\n\n``` bash\n$ blackbricks notebook1.py notebook2.py  # Formats both notebooks.\n$ blackbricks notebook_directory/  # Formats every notebook under the directory (recursively).\n```\nAn important difference is that `blackbricks` will ignore any file that does not contain the `# Databricks notebook\nsource` header on the first line. Databricks adds this line to all Python notebooks. This means you can happily run\n`blackbricks` on a directory with both notebooks and regular Python files, and `blackbricks` won't touch the latter.\n\nIf you specify the `-r` or `--remote` flag, `blackbricks` will work directly on your notebooks stored in Databricks.\n\n``` bash\n$ blackbricks --remote /Users/username/notebook.py\n$ blackbricks --remote /Repos/username/repo-name/notebook.py\n```\n\n### Full usage\n\n```text\n$ poetry run blackbricks --help\n\n Usage: blackbricks [OPTIONS] [FILENAMES]...\n\n Formatting tool for Databricks python notebooks.\n Python cells are formatted using `black`, and SQL cells are formatted by `sqlparse`.\n Local files (without the `--remote` option):\n - Only files that look like Databricks (Python) notebooks will be processed. That is,\n they must start with the header `# Databricks notebook source`\n - If you specify a directory as one of the file names, all files in that directory will\n be added, including any subdirectory.\n Remote files (with the `--remote` option):\n - Make sure you have installed the Databricks CLI (``pip install databricks_cli``)\n - Make sure you have configured at least one profile (`databricks configure`). Check the\n file `~/.databrickscfg` if you are not sure.\n - File paths should start with `/`. Otherwise they are interpreted as relative to\n `/Users/username`, where `username` is the username specified in the Databricks profile\n used.\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────╮\n│   filenames      [FILENAMES]...  Path to the notebook(s) to format. [default: None]    │\n╰────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────╮\n│ --remote                     -r                             If this option is used,    │\n│                                                             all filenames are treated  │\n│                                                             as paths to notebooks on   │\n│                                                             your Databricks host (i.e. │\n│                                                             not local files).          │\n│ --profile                    -p                    NAME     If using --remote, which   │\n│                                                             Databricks profile to use. │\n│                                                             [default: DEFAULT]         │\n│ --line-length                                      INTEGER  How many characters per    │\n│                                                             line to allow.             │\n│                                                             [default: 88]              │\n│ --sql-upper                      --no-sql-upper             SQL keywords should be     │\n│                                                             UPPERCASE or lowercase.    │\n│                                                             [default: sql-upper]       │\n│ --check                                                     Don't write the files      │\n│                                                             back, just return the      │\n│                                                             status. Return code 0      │\n│                                                             means nothing would        │\n│                                                             change.                    │\n│ --diff                                                      Don't write the files      │\n│                                                             back, just output a diff   │\n│                                                             for each file on stdout.   │\n│ --version                                                   Display version            │\n│                                                             information and exit.      │\n│ --help                                                      Show this message and      │\n│                                                             exit.                      │\n╰────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n\n\n## Version control integration\n\nUse [pre-commit](https://pre-commit.com). Add a `.pre-commit-config.yaml` file\nto your repo with the following content (changing/removing the `args` as you\nwish): \n\n```yaml\nrepos:\n-   repo: https://github.com/inspera/blackbricks\n    rev: 1.0.0\n    hooks:\n    - id: blackbricks\n      args: [--line-length=120]\n```\n\nSet the `rev` attribute to the most recent version of `blackbricks`.\nThe `args` are optional and can be used to set any of `blackbricks` options.\n\n## Contributing\n\nIf you find blackbricks useful, feel free to say so with a star. If you think it is utterly broken, you are more than\nwelcome to contribute improvements. Please open an issue first to discuss what you want added/fixed. Unless you are just\nadding tests. In that case your pull request is extremely likely to be merged right away.\n\n## FAQ\n\n### Can I disable SQL formatting?\n\nSure! Certain SQL statements might not be parsed and indented properly by `sqlparse`, and the result can be jumbled\nformatting. You can disable SQL formatting for a cell by adding `-- nofmt` to the very first line of a cell:\n\n```sql\n%sql  -- nofmt\nselect this,\n             sql_will,   -- be kept just\n         like_this\n  from if_that_is.what_you_need\n```\n\n### How do I use `blackbricks` on my Databricks notebooks?\n\nFirst, make sure you have set up `databricks-cli` on your system (see [installation](#installation)), and that you have\nat least one profile setup in `~/.databrickscfg`. As an example:\n\n```cfg\n# File: ~/.databrickscfg\n\n[DEFAULT]\nhost = https://dbc-b23456-a1243.cloud.databricks.com/\nusername = username@example.com\npassword = dapi12345678901234567890\n\n[OTHERPROFILE]\nhost = https://dbc-c54321-d234.cloud.databricks.com\nusername = name.user@example.com\npassword = dapi09876543211234567890\n```\n\nYou should use [access tokens](https://docs.databricks.com/dev-tools/api/latest/authentication.html) instead of your actual password.\n\nYou can then do:\n\n``` bash\n$ blackbricks --remote /Users/username@example.com/notebook.py  # Uses DEFAULT profile.\n$ blackbricks --remote notebook.py  # Equivalent to the above.\n$ blackbricks --remote --profile OTHERPROFILE /Users/name.user@example.com/notebook.py\n$ blackbricks --remote --profile OTHERPROFILE notebook.py  # Equivalent to the above.\n$ blackbricks --remote /Repos/username@example.com/repo-name/notebook.py  # Targeting notebook in a Repo\n```\n\n### Can you run blackbricks while using Databricks in the browser?\n\nNo. See https://github.com/inspera/blackbricks/issues/27 for why.\n\nHowever, Databricks now allows you to [format your notebooks with black directly](https://docs.databricks.com/notebooks/notebooks-use.html#format-code-cells).\n\n### I get an error: `TypeError: init() got an unexpected keyword argument 'no_args_is_help'`\n\nThis means you had an old version of `click` installed from before, and your installation didn't upgrade it\nautomatically. Updating your installation should do the trick, e.g. `pip install -U blackbricks` or similar depending on\nyour installation method of choice.\n\n\n### Shell commands like `!ls` throws an error\n\nSee https://github.com/inspera/blackbricks/issues/21.\n\n## Breaking changes\n\n### Breaking changes with version 2.0\n\nNotebooks will be terminated with a `\\n` starting with version `2.0.0`. This harmonizes EOF handling and should be much\nless annoying in practice than prior versions. This causes a diff on _any_ notebook that was previously formatted with\n`blackbricks<2.0.0`.\n\nAlso, the deprecated and non-functional flag for two space indentation is removed, and providing said flag is now an error.\n\n### Breaking changes with version 1.0\n\nEarlier versions of blackbricks applied a patched version of black in order to allow two-space indentation. This was\ndone because Databricks used two-space indentation, and did not allow you to change that. \n\nSince then, Databricks has added the option to choose. Because you can now choose, blackbricks re-joins black in being\nuncompromising, and since version 1.0 you can no longer choose anything but 4 space indentation.\n\nIf you _must_ keep using two-space indentation, then stick to versions `<1.0`.\n",
    'author': 'Bendik Samseth',
    'author_email': 'bendik.samseth@inspera.no',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/inspera/blackbricks',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
