#!/usr/bin/env python3
#
# GlobalChem - IUPAC Blue Book Rings
#
# -----------------------------------

class IUPACBlueBookRings(object):

    def __init__(self):

        self.name = 'iupac_blue_book_rings'
        
    @staticmethod
    def get_smiles():

        smiles = {
            'cyclopropane': 'C1CC1',
            'spiropentane': 'C1CC12CC2',
            'cyclobutane': 'C1CCC1',
            'cyclopentane': 'C1CCCC1',
            'furan': 'O1C=CC=C1',
            'thiophene': 'C1=CC=CS1',
            'pyrrole': 'N1C=CC=C1',
            '2H-pyrrole': 'N1=CC=CC1',
            '3H-pyrrole': 'N1=CCC=C1',
            'pyrazole': 'N1N=CC=C1',
            '2H-imidazole': 'C1N=CC=N1',
            '1,2,3-triazole': 'N1N=NC=C1',
            '1,2,4-triazole': 'N1N=CN=C1',
            '1,2-dithiole': 'S1SC=CC1',
            '1,3-dithiole': 'S1CSC=C1',
            '3H-1,2-oxathiole': 'O1SCC=C1',
            'isoxazole': 'O1N=CC=C1',
            'oxazole': 'O1C=NC=C1',
            'thiazole': 'S1C=NC=C1',
            'isothiazole': 'S1N=CC=C1',
            '1,2,3-oxadiazole': 'O1N=NC=C1',
            '1,2,4-oxadiazole': 'O1N=CN=C1',
            '1,2,5-oxadiazole': 'O1N=CC=N1',
            '1,3,4-oxadiazole': 'O1C=NN=C1',
            '1,2,3,4-oxatriazole': 'O1N=NN=C1',
            '1,2,3,5-oxatriazole': 'O1N=NC=N1',
            '3H-1,2,3-dioxazole': 'O1ONC=C1',
            '1,2,4-dioxazole': 'O1OC=NC1',
            '1,3,2-dioxazole': 'O1NOC=C1',
            '1,3,4-dioxazole': 'O1CON=C1',
            '5H-1,2,5-oxathiazole': 'O1SC=CN1',
            '1,3-oxathiole': 'O1CSC=C1',
            'benzene': 'C1=CC=CC=C1',
            'cyclohexane': 'C1CCCCC1',
            '2H-pyran': 'C1C=CC=CO1',
            '4H-pyran': 'C1=CCC=CO1',
            '2H-pyran-2-one': 'O=C1C=CC=CO1',
            '4H-pyran-4-one': 'O=C1C=COC=C1',
            '1,2-dioxin': 'O1OC=CC=C1',
            '1,3-dioxin': 'O1COC=CC1',
            'pyridine': 'C1=NC=CC=C1',
            'pyridazine': 'C1=NN=CC=C1',
            'pyrimidine': 'C1=NC=CC=N1',
            'pyrazine': 'C1=NC=CN=C1',
            'piperazine': 'N1CCNCC1',
            '1,3,5-triazine': 'N1=CN=CN=C1',
            '1,2,4-triazine': 'N1=NC=NC=C1',
            '1,2,3-triazine': 'N1=NN=CC=C1',
            '4H-1,2-Oxazine': 'O1N=CCC=C1',
            '2H-1,3-Oxazine': 'O1CN=CC=C1',
            '6H-1,3-Oxazine': 'O1C=NC=CC1',
            '6H-1,2-Oxazine': 'O1N=CC=CC1',
            '1,4-Oxazine': 'O1C=CN=CC1',
            '2H-1,2-Oxazine': 'O1NC=CC=C1',
            '4H-1,4-Oxazine': 'O1C=CNC=C1',
            '1,2,5-Oxathiazine': 'O1SC=CN=C1',
            '1,2,6-Oxathiazine': 'O1SC=CC=N1',
            '1,2,4-Oxadiazine': 'O1NC=NC=C1',
            '1,3,5-Oxadiazine': 'O1C=NC=NC1',
            'morpholine': 'N1CCOCC1',
            'azepine': 'N1C=CC=CC=C1',
            'oxepin': 'O1C=CC=CC=C1',
            'thiepin': 'S1C=CC=CC=C1',
            '4H-1,2-diazepine': 'N1=CC=CCC=N1',
            'indene': 'C12=C(CC=C2)C=CC=C1',
            '2H-indene': 'C12=CCC=C1C=CC=C2',
            'benzofuran': 'C12=CC=CC=C1C=CO2',
            'isobenzofuran': 'C12=COC=C1C=CC=C2',
            'benzo[b]thiophene': 'C12=CC=CC=C1C=CS2',
            'benzo[c]thiophene': 'C12=CSC=C1C=CC=C2',
            'indole': 'C12=C(NC=C2)C=CC=C1',
            '3H-indole': 'C12=C(N=CC2)C=CC=C1',
            '1H-indole': 'C12=C(NC=C2)C=CC=C1',
            'cyclopenta[b]pyridine': 'C12=CC=CC1=CC=CN2',
            'pyrano[3,4-b]-pyrrole': 'C12=COC=CC1=CC=N2',
            'indazole': 'C12=C(NN=C2)C=CC=C1',
            'benzisoxazole': 'C12=NOC=C1C=CC=C2',
            'benzoxazole': 'C12=CC=CC=C1OC=N2',
            '2,1-benzisoxazole': 'C12=CON=C1C=CC=C2',
            'naphthalene': 'C12=CC=CC=C1C=CC=C2',
            '1,2,3,4-tetrahydronaphthalene': 'C12=C(CCCC2)C=CC=C1',
            'octahydronaphthalene': 'C12CCCCC1=CCCC2',
            '2H-1-benzopyran': 'C12=CC=CC=C1OCC=C2',
            '2H-1-benzopyran-2-one': 'O=C1C=CC2=CC=CC=C2O1',
            '4H-1-benzopyran-4-one': 'O=C1C=COC2=CC=CC=C12',
            '1H-2-benzopyran-1-one': 'O=C1C2=CC=CC=C2C=CO1',
            '3H-2-benzopyran-1-one': 'O=C1C2=CC=CC=C2CCO1',
            'quinoline': 'C12=CC=CC=C1N=CC=C2',
            'isoquinoline': 'C12=C(C=NC=C2)C=CC=C1',
            'cinnoline': 'C12=CC=NN=C1C=CC=C2',
            'quinazoline': 'C12=CN=CN=C1C=CC=C2',
            '1,8-napthyhridine': 'C1=CC2=C(N=C1)N=CC=C2',
            '1,7-napththyridine': 'C1=CC2=C(C=NC=C2)N=C1',
            '1,5-napththridine': 'C1=CC2=C(C=CC=N2)N=C1',
            '1,6-napthyridine': 'C1=CC2=C(C=CN=C2)N=C1',
            '2H-1,3-benzoxazine': 'C12=CC=CC=C1OCN=C2',
            '2H-1,4-benzoxazine': 'C12=CC=CC=C1OCC=N2',
            '1H-2,3-benzoxazine': 'C12=CC=CC=C1CON=C2',
            '4H-3,1-benzoxazine': 'C12=CC=CC=C1N=COC2',
            '2H-1,2-benzoxazine': 'C12=CC=CC=C1ONC=C2',
            '4H-1,3-benzoxazine': 'C12=CC=CC=C1OC=NC2',
            'anthracene': 'C12=CC=CC=C1C=C3C=CC=CC3=C2',
            'phenanthrene': 'C12=CC=CC=C1C=CC3=CC=CC=C23',
            'phenalene': 'C12=C3C(CC=C2)=CC=CC3=CC=C1',
            'fluorene': 'C1(CC2=C3C=CC=C2)=C3C=CC=C1',
            'carbazole': 'C1(NC2=C3C=CC=C2)=C3C=CC=C1',
            'xanthene': 'C1(CC2=C(C=CC=C2)O3)=C3C=CC=C1',
            'acridine': 'C12=NC3=CC=CC=C3C=C1C=CC=C2',
            'norpinane': 'C1(C2)CCCC2C1',
            '7H-purine': 'C12=NC=NC=C1NC=N2',
            'steroid_ring_system': 'C12CCCCC1C3C(C(CCC4)C4CC3)CC2',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'cyclopropane':'[#6]1-[#6]-[#6]-1',
            'spiropentane':'[#6]1-[#6]-[#6]-12-[#6]-[#6]-2',
            'cyclobutane':'[#6]1-[#6]-[#6]-[#6]-1',
            'cyclopentane':'[#6]1-[#6]-[#6]-[#6]-[#6]-1',
            'furan':'[#8]1:[#6]:[#6]:[#6]:[#6]:1',
            'thiophene':'[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'pyrrole':'[#7H]1:[#6]:[#6]:[#6]:[#6]:1',
            '2H-pyrrole':'[#7]1=[#6]-[#6]=[#6]-[#6]-1',
            '3H-pyrrole':'[#7]1=[#6]-[#6]-[#6]=[#6]-1',
            'pyrazole':'[#7H]1:[#7]:[#6]:[#6]:[#6]:1',
            '2H-imidazole':'[#6]1-[#7]=[#6]-[#6]=[#7]-1',
            '1,2,3-triazole':'[#7H]1:[#7]:[#7]:[#6]:[#6]:1',
            '1,2,4-triazole':'[#7H]1:[#7]:[#6]:[#7]:[#6]:1',
            '1,2-dithiole':'[#16]1-[#16]-[#6]=[#6]-[#6]-1',
            '1,3-dithiole':'[#16]1-[#6]-[#16]-[#6]=[#6]-1',
            '3H-1,2-oxathiole':'[#8]1-[#16]-[#6]-[#6]=[#6]-1',
            'isoxazole':'[#8]1:[#7]:[#6]:[#6]:[#6]:1',
            'oxazole':'[#8]1:[#6]:[#7]:[#6]:[#6]:1',
            'thiazole':'[#16]1:[#6]:[#7]:[#6]:[#6]:1',
            'isothiazole':'[#16]1:[#7]:[#6]:[#6]:[#6]:1',
            '1,2,3-oxadiazole':'[#8]1:[#7]:[#7]:[#6]:[#6]:1',
            '1,2,4-oxadiazole':'[#8]1:[#7]:[#6]:[#7]:[#6]:1',
            '1,2,5-oxadiazole':'[#8]1:[#7]:[#6]:[#6]:[#7]:1',
            '1,3,4-oxadiazole':'[#8]1:[#6]:[#7]:[#7]:[#6]:1',
            '1,2,3,4-oxatriazole':'[#8]1:[#7]:[#7]:[#7]:[#6]:1',
            '1,2,3,5-oxatriazole':'[#8]1:[#7]:[#7]:[#6]:[#7]:1',
            '3H-1,2,3-dioxazole':'[#8]1-[#8]-[#7]-[#6]=[#6]-1',
            '1,2,4-dioxazole':'[#8]1-[#8]-[#6]=[#7]-[#6]-1',
            '1,3,2-dioxazole':'[#8]1-[#7]-[#8]-[#6]=[#6]-1',
            '1,3,4-dioxazole':'[#8]1-[#6]-[#8]-[#7]=[#6]-1',
            '5H-1,2,5-oxathiazole':'[#8]1-[#16]-[#6]=[#6]-[#7]-1',
            '1,3-oxathiole':'[#8]1-[#6]-[#16]-[#6]=[#6]-1',
            'benzene':'[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'cyclohexane':'[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            '2H-pyran':'[#6]1-[#6]=[#6]-[#6]=[#6]-[#8]-1',
            '4H-pyran':'[#6]1=[#6]-[#6]-[#6]=[#6]-[#8]-1',
            '2H-pyran-2-one':'[#8]=[#6]1:[#6]:[#6]:[#6]:[#6]:[#8]:1',
            '4H-pyran-4-one':'[#8]=[#6]1:[#6]:[#6]:[#8]:[#6]:[#6]:1',
            '1,2-dioxin':'[#8]1-[#8]-[#6]=[#6]-[#6]=[#6]-1',
            '1,3-dioxin':'[#8]1-[#6]-[#8]-[#6]=[#6]-[#6]-1',
            'pyridine':'[#6]1:[#7]:[#6]:[#6]:[#6]:[#6]:1',
            'pyridazine':'[#6]1:[#7]:[#7]:[#6]:[#6]:[#6]:1',
            'pyrimidine':'[#6]1:[#7]:[#6]:[#6]:[#6]:[#7]:1',
            'pyrazine':'[#6]1:[#7]:[#6]:[#6]:[#7]:[#6]:1',
            'piperazine':'[#7]1-[#6]-[#6]-[#7]-[#6]-[#6]-1',
            '1,3,5-triazine':'[#7]1:[#6]:[#7]:[#6]:[#7]:[#6]:1',
            '1,2,4-triazine':'[#7]1:[#7]:[#6]:[#7]:[#6]:[#6]:1',
            '1,2,3-triazine':'[#7]1:[#7]:[#7]:[#6]:[#6]:[#6]:1',
            '4H-1,2-Oxazine':'[#8]1-[#7]=[#6]-[#6]-[#6]=[#6]-1',
            '2H-1,3-Oxazine':'[#8]1-[#6]-[#7]=[#6]-[#6]=[#6]-1',
            '6H-1,3-Oxazine':'[#8]1-[#6]=[#7]-[#6]=[#6]-[#6]-1',
            '6H-1,2-Oxazine':'[#8]1-[#7]=[#6]-[#6]=[#6]-[#6]-1',
            '1,4-Oxazine':'[#8]1-[#6]=[#6]-[#7]=[#6]-[#6]-1',
            '2H-1,2-Oxazine':'[#8]1-[#7]-[#6]=[#6]-[#6]=[#6]-1',
            '4H-1,4-Oxazine':'[#8]1-[#6]=[#6]-[#7]-[#6]=[#6]-1',
            '1,2,5-Oxathiazine':'[#8]1-[#16]-[#6]=[#6]-[#7]=[#6]-1',
            '1,2,6-Oxathiazine':'[#8]1-[#16]-[#6]=[#6]-[#6]=[#7]-1',
            '1,2,4-Oxadiazine':'[#8]1-[#7]-[#6]=[#7]-[#6]=[#6]-1',
            '1,3,5-Oxadiazine':'[#8]1-[#6]=[#7]-[#6]=[#7]-[#6]-1',
            'morpholine':'[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'azepine':'[#7]1-[#6]=[#6]-[#6]=[#6]-[#6]=[#6]-1',
            'oxepin':'[#8]1-[#6]=[#6]-[#6]=[#6]-[#6]=[#6]-1',
            'thiepin':'[#16]1-[#6]=[#6]-[#6]=[#6]-[#6]=[#6]-1',
            '4H-1,2-diazepine':'[#7]1=[#6]-[#6]=[#6]-[#6]-[#6]=[#7]-1',
            'indene':'[#6]12:[#6](-[#6]-[#6]=[#6]-1):[#6]:[#6]:[#6]:[#6]:2',
            '2H-indene':'[#6]12=[#6]-[#6]-[#6]=[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'benzofuran':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:[#6]:[#8]:2',
            'isobenzofuran':'[#6]12:[#6]:[#8]:[#6]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'benzo[b]thiophene':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:[#6]:[#16]:2',
            'benzo[c]thiophene':'[#6]12:[#6]:[#16]:[#6]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'indole':'[#6]12:[#6](:[#7H]:[#6]:[#6]:1):[#6]:[#6]:[#6]:[#6]:2',
            '3H-indole':'[#6]12:[#6](-[#7]=[#6]-[#6]-1):[#6]:[#6]:[#6]:[#6]:2',
            '1H-indole':'[#6]12:[#6](:[#7H]:[#6]:[#6]:1):[#6]:[#6]:[#6]:[#6]:2',
            'cyclopenta[b]pyridine':'[#6]12:[#6]:[#6]:[#6]:[#6]-1:[#6]:[#6]:[#6]:[#7H]:2',
            'pyrano[3,4-b]-pyrrole':'[#6]12:[#6]:[#8]:[#6]:[#6]:[#6]-1:[#6]:[#6]:[#7]:2',
            'indazole':'[#6]12:[#6](:[#7H]:[#7]:[#6]:1):[#6]:[#6]:[#6]:[#6]:2',
            'benzisoxazole':'[#6]12:[#7]:[#8]:[#6]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'benzoxazole':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#8]:[#6]:[#7]:2',
            '2,1-benzisoxazole':'[#6]12:[#6]:[#8]:[#7]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'naphthalene':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            '1,2,3,4-tetrahydronaphthalene':'[#6]12:[#6](-[#6]-[#6]-[#6]-[#6]-1):[#6]:[#6]:[#6]:[#6]:2',
            'octahydronaphthalene':'[#6]12-[#6]-[#6]-[#6]-[#6]-[#6]-1=[#6]-[#6]-[#6]-[#6]-2',
            '2H-1-benzopyran':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6]-[#6]=[#6]-2',
            '2H-1-benzopyran-2-one':'[#8]=[#6]1:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#8]:1',
            '4H-1-benzopyran-4-one':'[#8]=[#6]1:[#6]:[#6]:[#8]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2',
            '1H-2-benzopyran-1-one':'[#8]=[#6]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:[#6]:[#8]:1',
            '3H-2-benzopyran-1-one':'[#8]=[#6]1-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]-[#6]-[#8]-1',
            'quinoline':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#7]:[#6]:[#6]:[#6]:2',
            'isoquinoline':'[#6]12:[#6](:[#6]:[#7]:[#6]:[#6]:1):[#6]:[#6]:[#6]:[#6]:2',
            'cinnoline':'[#6]12:[#6]:[#6]:[#7]:[#7]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'quinazoline':'[#6]12:[#6]:[#7]:[#6]:[#7]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            '1,8-napthyhridine':'[#6]1:[#6]:[#6]2:[#6](:[#7]:[#6]:1):[#7]:[#6]:[#6]:[#6]:2',
            '1,7-napththyridine':'[#6]1:[#6]:[#6]2:[#6](:[#6]:[#7]:[#6]:[#6]:2):[#7]:[#6]:1',
            '1,5-napththridine':'[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:[#6]:[#7]:2):[#7]:[#6]:1',
            '1,6-napthyridine':'[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:[#7]:[#6]:2):[#7]:[#6]:1',
            '2H-1,3-benzoxazine':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6]-[#7]=[#6]-2',
            '2H-1,4-benzoxazine':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6]-[#6]=[#7]-2',
            '1H-2,3-benzoxazine':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-[#8]-[#7]=[#6]-2',
            '4H-3,1-benzoxazine':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#7]=[#6]-[#8]-[#6]-2',
            '2H-1,2-benzoxazine':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]-[#7]-[#6]=[#6]-2',
            '4H-1,3-benzoxazine':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#8]-[#6]=[#7]-[#6]-2',
            'anthracene':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:2',
            'phenanthrene':'[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:[#6]:[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:2:1',
            'phenalene':'[#6]12:[#6]3:[#6](-[#6]-[#6]=[#6]-1):[#6]:[#6]:[#6]:[#6]:3:[#6]:[#6]:[#6]:2',
            'fluorene':'[#6]12-[#6]-[#6]3:[#6](:[#6]:[#6]:[#6]:[#6]:3)-[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'carbazole':'[#6]12:[#7H]:[#6]3:[#6](:[#6]:[#6]:[#6]:[#6]:3):[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'xanthene':'[#6]12-[#6]-[#6]3:[#6](:[#6]:[#6]:[#6]:[#6]:3)-[#8]-[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'acridine':'[#6]12:[#7]:[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3:[#6]:[#6]:1:[#6]:[#6]:[#6]:[#6]:2',
            'norpinane':'[#6]12-[#6]-[#6](-[#6]-[#6]-[#6]-1)-[#6]-2',
            '7H-purine':'[#6]12:[#7]:[#6]:[#7]:[#6]:[#6]:1:[#7H]:[#6]:[#7]:2',
            'steroid_ring_system':'[#6]12-[#6]-[#6]-[#6]-[#6]-[#6]-1-[#6]1-[#6](-[#6]3-[#6]-[#6]-[#6]-[#6]-3-[#6]-[#6]-1)-[#6]-[#6]-2',
        }

        return smarts
