"""Add indexes

Revision ID: 71ec303c90e4
Revises: 30ffbaee18cd
Create Date: 2021-07-18 13:21:51.711159

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = "71ec303c90e4"
down_revision = "30ffbaee18cd"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        "ix_call_node_call_hash_vpo",
        "call_node",
        ["call_hash"],
        unique=True,
        postgresql_ops={"call_hash": "varchar_pattern_ops"},
    )
    op.create_index(
        "ix_execution_id_vpo",
        "execution",
        ["id"],
        unique=True,
        postgresql_ops={"id": "varchar_pattern_ops"},
    )
    op.create_index(op.f("ix_file_path"), "file", ["path"], unique=False)
    op.create_index(
        "ix_job_id_vpo", "job", ["id"], unique=True, postgresql_ops={"id": "varchar_pattern_ops"}
    )
    op.create_index(
        "ix_task_hash_vpo",
        "task",
        ["hash"],
        unique=True,
        postgresql_ops={"hash": "varchar_pattern_ops"},
    )
    op.create_index(
        "ix_task_name_vpo",
        "task",
        ["name"],
        unique=False,
        postgresql_ops={"name": "varchar_pattern_ops"},
    )
    op.create_index(
        "ix_task_namespace_vpo",
        "task",
        ["namespace"],
        unique=False,
        postgresql_ops={"namespace": "varchar_pattern_ops"},
    )
    op.create_index(
        "ix_value_value_hash_vpo",
        "value",
        ["value_hash"],
        unique=True,
        postgresql_ops={"value_hash": "varchar_pattern_ops"},
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "ix_value_value_hash_vpo",
        table_name="value",
        postgresql_ops={"value_hash": "varchar_pattern_ops"},
    )
    op.drop_index(
        "ix_task_namespace_vpo",
        table_name="task",
        postgresql_ops={"namespace": "varchar_pattern_ops"},
    )
    op.drop_index(
        "ix_task_name_vpo", table_name="task", postgresql_ops={"name": "varchar_pattern_ops"}
    )
    op.drop_index(
        "ix_task_hash_vpo", table_name="task", postgresql_ops={"hash": "varchar_pattern_ops"}
    )
    op.drop_index("ix_job_id_vpo", table_name="job", postgresql_ops={"id": "varchar_pattern_ops"})
    op.drop_index(op.f("ix_file_path"), table_name="file")
    op.drop_index(
        "ix_execution_id_vpo", table_name="execution", postgresql_ops={"id": "varchar_pattern_ops"}
    )
    op.drop_index(
        "ix_call_node_call_hash_vpo",
        table_name="call_node",
        postgresql_ops={"call_hash": "varchar_pattern_ops"},
    )
    # ### end Alembic commands ###
