# Generated by Django 3.1.10 on 2021-06-22 16:27

from django.db import migrations, models
from nautobot_circuit_maintenance.models import RawNotification
import hashlib


def gen_raw_md5(apps, schema_editor):
    """Custom update of _raw_md5 hash."""
    for raw_notification in RawNotification.objects.all():
        raw_notification._raw_md5 = hashlib.md5(raw_notification.raw.encode("utf-8")).hexdigest()  # nosec
        raw_notification.save(update_fields=["_raw_md5"])


class Migration(migrations.Migration):

    dependencies = [
        ("nautobot_circuit_maintenance", "0003_improve_rawnotification"),
    ]

    operations = [
        migrations.AddField(
            model_name="rawnotification",
            name="_raw_md5",
            field=models.TextField(null=True),
        ),
        migrations.RunPython(gen_raw_md5),
        migrations.AlterField(
            model_name="rawnotification",
            name="_raw_md5",
            field=models.TextField(unique=True),
        ),
        migrations.AlterField(
            model_name="rawnotification",
            name="raw",
            field=models.TextField(),
        ),
    ]
