# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 admin_portal: pulumi.Input['WorkspaceAdminPortalArgs'],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 auth_policy: pulumi.Input['WorkspaceAuthPolicyArgs'],
                 backend_stack: pulumi.Input[str],
                 country: pulumi.Input[str],
                 frontegg_domain: pulumi.Input[str],
                 frontend_stack: pulumi.Input[str],
                 mfa_policy: pulumi.Input['WorkspaceMfaPolicyArgs'],
                 open_saas_installed: pulumi.Input[bool],
                 password_policy: pulumi.Input['WorkspacePasswordPolicyArgs'],
                 captcha_policy: Optional[pulumi.Input['WorkspaceCaptchaPolicyArgs']] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 facebook_social_login: Optional[pulumi.Input['WorkspaceFacebookSocialLoginArgs']] = None,
                 github_social_login: Optional[pulumi.Input['WorkspaceGithubSocialLoginArgs']] = None,
                 google_social_login: Optional[pulumi.Input['WorkspaceGoogleSocialLoginArgs']] = None,
                 hosted_login: Optional[pulumi.Input['WorkspaceHostedLoginArgs']] = None,
                 lockout_policy: Optional[pulumi.Input['WorkspaceLockoutPolicyArgs']] = None,
                 mfa_authentication_app: Optional[pulumi.Input['WorkspaceMfaAuthenticationAppArgs']] = None,
                 microsoft_social_login: Optional[pulumi.Input['WorkspaceMicrosoftSocialLoginArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pwned_password_email: Optional[pulumi.Input['WorkspacePwnedPasswordEmailArgs']] = None,
                 reset_password_email: Optional[pulumi.Input['WorkspaceResetPasswordEmailArgs']] = None,
                 saml: Optional[pulumi.Input['WorkspaceSamlArgs']] = None,
                 user_activation_email: Optional[pulumi.Input['WorkspaceUserActivationEmailArgs']] = None,
                 user_invitation_email: Optional[pulumi.Input['WorkspaceUserInvitationEmailArgs']] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input['WorkspaceAdminPortalArgs'] admin_portal: Configures the admin portal.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
               responses.
        :param pulumi.Input['WorkspaceAuthPolicyArgs'] auth_policy: Configures the general authentication policy.
        :param pulumi.Input[str] backend_stack: The backend stack of the application associated with the workspace.
        :param pulumi.Input[str] country: The country associated with the workspace.
        :param pulumi.Input[str] frontegg_domain: The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        :param pulumi.Input[str] frontend_stack: The frontend stack of the application associated with the worksapce.
        :param pulumi.Input['WorkspaceMfaPolicyArgs'] mfa_policy: Configures the multi-factor authentication (MFA) policy.
        :param pulumi.Input[bool] open_saas_installed: Whether the application associated with the workspace has OpenSaaS installed.
        :param pulumi.Input['WorkspacePasswordPolicyArgs'] password_policy: Configures the password policy.
        :param pulumi.Input['WorkspaceCaptchaPolicyArgs'] captcha_policy: Configures the CAPTCHA policy in the signup form.
        :param pulumi.Input[str] custom_domain: A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
               points to "ssl.frontegg.com" before setting this field.
        :param pulumi.Input['WorkspaceFacebookSocialLoginArgs'] facebook_social_login: Configures social login with Facebook.
        :param pulumi.Input['WorkspaceGithubSocialLoginArgs'] github_social_login: Configures social login with GitHub.
        :param pulumi.Input['WorkspaceGoogleSocialLoginArgs'] google_social_login: Configures social login with Google.
        :param pulumi.Input['WorkspaceHostedLoginArgs'] hosted_login: Configures Frontegg-hosted OAuth login.
        :param pulumi.Input['WorkspaceLockoutPolicyArgs'] lockout_policy: Configures the user lockout policy.
        :param pulumi.Input['WorkspaceMfaAuthenticationAppArgs'] mfa_authentication_app: Configures the multi-factor authentication (MFA) via an authentication app.
        :param pulumi.Input['WorkspaceMicrosoftSocialLoginArgs'] microsoft_social_login: Configures social login with Google.
        :param pulumi.Input[str] name: The name of the workspace.
        :param pulumi.Input['WorkspacePwnedPasswordEmailArgs'] pwned_password_email: Configures the pwned password email.
        :param pulumi.Input['WorkspaceResetPasswordEmailArgs'] reset_password_email: Configures the password reset email.
        :param pulumi.Input['WorkspaceSamlArgs'] saml: Configures SSO via SAML.
        :param pulumi.Input['WorkspaceUserActivationEmailArgs'] user_activation_email: Configures the user activation email.
        :param pulumi.Input['WorkspaceUserInvitationEmailArgs'] user_invitation_email: Configures the user invitation email.
        """
        pulumi.set(__self__, "admin_portal", admin_portal)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "auth_policy", auth_policy)
        pulumi.set(__self__, "backend_stack", backend_stack)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "frontegg_domain", frontegg_domain)
        pulumi.set(__self__, "frontend_stack", frontend_stack)
        pulumi.set(__self__, "mfa_policy", mfa_policy)
        pulumi.set(__self__, "open_saas_installed", open_saas_installed)
        pulumi.set(__self__, "password_policy", password_policy)
        if captcha_policy is not None:
            pulumi.set(__self__, "captcha_policy", captcha_policy)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if facebook_social_login is not None:
            pulumi.set(__self__, "facebook_social_login", facebook_social_login)
        if github_social_login is not None:
            pulumi.set(__self__, "github_social_login", github_social_login)
        if google_social_login is not None:
            pulumi.set(__self__, "google_social_login", google_social_login)
        if hosted_login is not None:
            pulumi.set(__self__, "hosted_login", hosted_login)
        if lockout_policy is not None:
            pulumi.set(__self__, "lockout_policy", lockout_policy)
        if mfa_authentication_app is not None:
            pulumi.set(__self__, "mfa_authentication_app", mfa_authentication_app)
        if microsoft_social_login is not None:
            pulumi.set(__self__, "microsoft_social_login", microsoft_social_login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pwned_password_email is not None:
            pulumi.set(__self__, "pwned_password_email", pwned_password_email)
        if reset_password_email is not None:
            pulumi.set(__self__, "reset_password_email", reset_password_email)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if user_activation_email is not None:
            pulumi.set(__self__, "user_activation_email", user_activation_email)
        if user_invitation_email is not None:
            pulumi.set(__self__, "user_invitation_email", user_invitation_email)

    @property
    @pulumi.getter(name="adminPortal")
    def admin_portal(self) -> pulumi.Input['WorkspaceAdminPortalArgs']:
        """
        Configures the admin portal.
        """
        return pulumi.get(self, "admin_portal")

    @admin_portal.setter
    def admin_portal(self, value: pulumi.Input['WorkspaceAdminPortalArgs']):
        pulumi.set(self, "admin_portal", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
        responses.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="authPolicy")
    def auth_policy(self) -> pulumi.Input['WorkspaceAuthPolicyArgs']:
        """
        Configures the general authentication policy.
        """
        return pulumi.get(self, "auth_policy")

    @auth_policy.setter
    def auth_policy(self, value: pulumi.Input['WorkspaceAuthPolicyArgs']):
        pulumi.set(self, "auth_policy", value)

    @property
    @pulumi.getter(name="backendStack")
    def backend_stack(self) -> pulumi.Input[str]:
        """
        The backend stack of the application associated with the workspace.
        """
        return pulumi.get(self, "backend_stack")

    @backend_stack.setter
    def backend_stack(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend_stack", value)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Input[str]:
        """
        The country associated with the workspace.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[str]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="fronteggDomain")
    def frontegg_domain(self) -> pulumi.Input[str]:
        """
        The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        """
        return pulumi.get(self, "frontegg_domain")

    @frontegg_domain.setter
    def frontegg_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "frontegg_domain", value)

    @property
    @pulumi.getter(name="frontendStack")
    def frontend_stack(self) -> pulumi.Input[str]:
        """
        The frontend stack of the application associated with the worksapce.
        """
        return pulumi.get(self, "frontend_stack")

    @frontend_stack.setter
    def frontend_stack(self, value: pulumi.Input[str]):
        pulumi.set(self, "frontend_stack", value)

    @property
    @pulumi.getter(name="mfaPolicy")
    def mfa_policy(self) -> pulumi.Input['WorkspaceMfaPolicyArgs']:
        """
        Configures the multi-factor authentication (MFA) policy.
        """
        return pulumi.get(self, "mfa_policy")

    @mfa_policy.setter
    def mfa_policy(self, value: pulumi.Input['WorkspaceMfaPolicyArgs']):
        pulumi.set(self, "mfa_policy", value)

    @property
    @pulumi.getter(name="openSaasInstalled")
    def open_saas_installed(self) -> pulumi.Input[bool]:
        """
        Whether the application associated with the workspace has OpenSaaS installed.
        """
        return pulumi.get(self, "open_saas_installed")

    @open_saas_installed.setter
    def open_saas_installed(self, value: pulumi.Input[bool]):
        pulumi.set(self, "open_saas_installed", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> pulumi.Input['WorkspacePasswordPolicyArgs']:
        """
        Configures the password policy.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: pulumi.Input['WorkspacePasswordPolicyArgs']):
        pulumi.set(self, "password_policy", value)

    @property
    @pulumi.getter(name="captchaPolicy")
    def captcha_policy(self) -> Optional[pulumi.Input['WorkspaceCaptchaPolicyArgs']]:
        """
        Configures the CAPTCHA policy in the signup form.
        """
        return pulumi.get(self, "captcha_policy")

    @captcha_policy.setter
    def captcha_policy(self, value: Optional[pulumi.Input['WorkspaceCaptchaPolicyArgs']]):
        pulumi.set(self, "captcha_policy", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
        points to "ssl.frontegg.com" before setting this field.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="facebookSocialLogin")
    def facebook_social_login(self) -> Optional[pulumi.Input['WorkspaceFacebookSocialLoginArgs']]:
        """
        Configures social login with Facebook.
        """
        return pulumi.get(self, "facebook_social_login")

    @facebook_social_login.setter
    def facebook_social_login(self, value: Optional[pulumi.Input['WorkspaceFacebookSocialLoginArgs']]):
        pulumi.set(self, "facebook_social_login", value)

    @property
    @pulumi.getter(name="githubSocialLogin")
    def github_social_login(self) -> Optional[pulumi.Input['WorkspaceGithubSocialLoginArgs']]:
        """
        Configures social login with GitHub.
        """
        return pulumi.get(self, "github_social_login")

    @github_social_login.setter
    def github_social_login(self, value: Optional[pulumi.Input['WorkspaceGithubSocialLoginArgs']]):
        pulumi.set(self, "github_social_login", value)

    @property
    @pulumi.getter(name="googleSocialLogin")
    def google_social_login(self) -> Optional[pulumi.Input['WorkspaceGoogleSocialLoginArgs']]:
        """
        Configures social login with Google.
        """
        return pulumi.get(self, "google_social_login")

    @google_social_login.setter
    def google_social_login(self, value: Optional[pulumi.Input['WorkspaceGoogleSocialLoginArgs']]):
        pulumi.set(self, "google_social_login", value)

    @property
    @pulumi.getter(name="hostedLogin")
    def hosted_login(self) -> Optional[pulumi.Input['WorkspaceHostedLoginArgs']]:
        """
        Configures Frontegg-hosted OAuth login.
        """
        return pulumi.get(self, "hosted_login")

    @hosted_login.setter
    def hosted_login(self, value: Optional[pulumi.Input['WorkspaceHostedLoginArgs']]):
        pulumi.set(self, "hosted_login", value)

    @property
    @pulumi.getter(name="lockoutPolicy")
    def lockout_policy(self) -> Optional[pulumi.Input['WorkspaceLockoutPolicyArgs']]:
        """
        Configures the user lockout policy.
        """
        return pulumi.get(self, "lockout_policy")

    @lockout_policy.setter
    def lockout_policy(self, value: Optional[pulumi.Input['WorkspaceLockoutPolicyArgs']]):
        pulumi.set(self, "lockout_policy", value)

    @property
    @pulumi.getter(name="mfaAuthenticationApp")
    def mfa_authentication_app(self) -> Optional[pulumi.Input['WorkspaceMfaAuthenticationAppArgs']]:
        """
        Configures the multi-factor authentication (MFA) via an authentication app.
        """
        return pulumi.get(self, "mfa_authentication_app")

    @mfa_authentication_app.setter
    def mfa_authentication_app(self, value: Optional[pulumi.Input['WorkspaceMfaAuthenticationAppArgs']]):
        pulumi.set(self, "mfa_authentication_app", value)

    @property
    @pulumi.getter(name="microsoftSocialLogin")
    def microsoft_social_login(self) -> Optional[pulumi.Input['WorkspaceMicrosoftSocialLoginArgs']]:
        """
        Configures social login with Google.
        """
        return pulumi.get(self, "microsoft_social_login")

    @microsoft_social_login.setter
    def microsoft_social_login(self, value: Optional[pulumi.Input['WorkspaceMicrosoftSocialLoginArgs']]):
        pulumi.set(self, "microsoft_social_login", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pwnedPasswordEmail")
    def pwned_password_email(self) -> Optional[pulumi.Input['WorkspacePwnedPasswordEmailArgs']]:
        """
        Configures the pwned password email.
        """
        return pulumi.get(self, "pwned_password_email")

    @pwned_password_email.setter
    def pwned_password_email(self, value: Optional[pulumi.Input['WorkspacePwnedPasswordEmailArgs']]):
        pulumi.set(self, "pwned_password_email", value)

    @property
    @pulumi.getter(name="resetPasswordEmail")
    def reset_password_email(self) -> Optional[pulumi.Input['WorkspaceResetPasswordEmailArgs']]:
        """
        Configures the password reset email.
        """
        return pulumi.get(self, "reset_password_email")

    @reset_password_email.setter
    def reset_password_email(self, value: Optional[pulumi.Input['WorkspaceResetPasswordEmailArgs']]):
        pulumi.set(self, "reset_password_email", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['WorkspaceSamlArgs']]:
        """
        Configures SSO via SAML.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['WorkspaceSamlArgs']]):
        pulumi.set(self, "saml", value)

    @property
    @pulumi.getter(name="userActivationEmail")
    def user_activation_email(self) -> Optional[pulumi.Input['WorkspaceUserActivationEmailArgs']]:
        """
        Configures the user activation email.
        """
        return pulumi.get(self, "user_activation_email")

    @user_activation_email.setter
    def user_activation_email(self, value: Optional[pulumi.Input['WorkspaceUserActivationEmailArgs']]):
        pulumi.set(self, "user_activation_email", value)

    @property
    @pulumi.getter(name="userInvitationEmail")
    def user_invitation_email(self) -> Optional[pulumi.Input['WorkspaceUserInvitationEmailArgs']]:
        """
        Configures the user invitation email.
        """
        return pulumi.get(self, "user_invitation_email")

    @user_invitation_email.setter
    def user_invitation_email(self, value: Optional[pulumi.Input['WorkspaceUserInvitationEmailArgs']]):
        pulumi.set(self, "user_invitation_email", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 admin_portal: Optional[pulumi.Input['WorkspaceAdminPortalArgs']] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auth_policy: Optional[pulumi.Input['WorkspaceAuthPolicyArgs']] = None,
                 backend_stack: Optional[pulumi.Input[str]] = None,
                 captcha_policy: Optional[pulumi.Input['WorkspaceCaptchaPolicyArgs']] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 facebook_social_login: Optional[pulumi.Input['WorkspaceFacebookSocialLoginArgs']] = None,
                 frontegg_domain: Optional[pulumi.Input[str]] = None,
                 frontend_stack: Optional[pulumi.Input[str]] = None,
                 github_social_login: Optional[pulumi.Input['WorkspaceGithubSocialLoginArgs']] = None,
                 google_social_login: Optional[pulumi.Input['WorkspaceGoogleSocialLoginArgs']] = None,
                 hosted_login: Optional[pulumi.Input['WorkspaceHostedLoginArgs']] = None,
                 lockout_policy: Optional[pulumi.Input['WorkspaceLockoutPolicyArgs']] = None,
                 mfa_authentication_app: Optional[pulumi.Input['WorkspaceMfaAuthenticationAppArgs']] = None,
                 mfa_policy: Optional[pulumi.Input['WorkspaceMfaPolicyArgs']] = None,
                 microsoft_social_login: Optional[pulumi.Input['WorkspaceMicrosoftSocialLoginArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_saas_installed: Optional[pulumi.Input[bool]] = None,
                 password_policy: Optional[pulumi.Input['WorkspacePasswordPolicyArgs']] = None,
                 pwned_password_email: Optional[pulumi.Input['WorkspacePwnedPasswordEmailArgs']] = None,
                 reset_password_email: Optional[pulumi.Input['WorkspaceResetPasswordEmailArgs']] = None,
                 saml: Optional[pulumi.Input['WorkspaceSamlArgs']] = None,
                 user_activation_email: Optional[pulumi.Input['WorkspaceUserActivationEmailArgs']] = None,
                 user_invitation_email: Optional[pulumi.Input['WorkspaceUserInvitationEmailArgs']] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input['WorkspaceAdminPortalArgs'] admin_portal: Configures the admin portal.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
               responses.
        :param pulumi.Input['WorkspaceAuthPolicyArgs'] auth_policy: Configures the general authentication policy.
        :param pulumi.Input[str] backend_stack: The backend stack of the application associated with the workspace.
        :param pulumi.Input['WorkspaceCaptchaPolicyArgs'] captcha_policy: Configures the CAPTCHA policy in the signup form.
        :param pulumi.Input[str] country: The country associated with the workspace.
        :param pulumi.Input[str] custom_domain: A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
               points to "ssl.frontegg.com" before setting this field.
        :param pulumi.Input['WorkspaceFacebookSocialLoginArgs'] facebook_social_login: Configures social login with Facebook.
        :param pulumi.Input[str] frontegg_domain: The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        :param pulumi.Input[str] frontend_stack: The frontend stack of the application associated with the worksapce.
        :param pulumi.Input['WorkspaceGithubSocialLoginArgs'] github_social_login: Configures social login with GitHub.
        :param pulumi.Input['WorkspaceGoogleSocialLoginArgs'] google_social_login: Configures social login with Google.
        :param pulumi.Input['WorkspaceHostedLoginArgs'] hosted_login: Configures Frontegg-hosted OAuth login.
        :param pulumi.Input['WorkspaceLockoutPolicyArgs'] lockout_policy: Configures the user lockout policy.
        :param pulumi.Input['WorkspaceMfaAuthenticationAppArgs'] mfa_authentication_app: Configures the multi-factor authentication (MFA) via an authentication app.
        :param pulumi.Input['WorkspaceMfaPolicyArgs'] mfa_policy: Configures the multi-factor authentication (MFA) policy.
        :param pulumi.Input['WorkspaceMicrosoftSocialLoginArgs'] microsoft_social_login: Configures social login with Google.
        :param pulumi.Input[str] name: The name of the workspace.
        :param pulumi.Input[bool] open_saas_installed: Whether the application associated with the workspace has OpenSaaS installed.
        :param pulumi.Input['WorkspacePasswordPolicyArgs'] password_policy: Configures the password policy.
        :param pulumi.Input['WorkspacePwnedPasswordEmailArgs'] pwned_password_email: Configures the pwned password email.
        :param pulumi.Input['WorkspaceResetPasswordEmailArgs'] reset_password_email: Configures the password reset email.
        :param pulumi.Input['WorkspaceSamlArgs'] saml: Configures SSO via SAML.
        :param pulumi.Input['WorkspaceUserActivationEmailArgs'] user_activation_email: Configures the user activation email.
        :param pulumi.Input['WorkspaceUserInvitationEmailArgs'] user_invitation_email: Configures the user invitation email.
        """
        if admin_portal is not None:
            pulumi.set(__self__, "admin_portal", admin_portal)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if auth_policy is not None:
            pulumi.set(__self__, "auth_policy", auth_policy)
        if backend_stack is not None:
            pulumi.set(__self__, "backend_stack", backend_stack)
        if captcha_policy is not None:
            pulumi.set(__self__, "captcha_policy", captcha_policy)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if facebook_social_login is not None:
            pulumi.set(__self__, "facebook_social_login", facebook_social_login)
        if frontegg_domain is not None:
            pulumi.set(__self__, "frontegg_domain", frontegg_domain)
        if frontend_stack is not None:
            pulumi.set(__self__, "frontend_stack", frontend_stack)
        if github_social_login is not None:
            pulumi.set(__self__, "github_social_login", github_social_login)
        if google_social_login is not None:
            pulumi.set(__self__, "google_social_login", google_social_login)
        if hosted_login is not None:
            pulumi.set(__self__, "hosted_login", hosted_login)
        if lockout_policy is not None:
            pulumi.set(__self__, "lockout_policy", lockout_policy)
        if mfa_authentication_app is not None:
            pulumi.set(__self__, "mfa_authentication_app", mfa_authentication_app)
        if mfa_policy is not None:
            pulumi.set(__self__, "mfa_policy", mfa_policy)
        if microsoft_social_login is not None:
            pulumi.set(__self__, "microsoft_social_login", microsoft_social_login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_saas_installed is not None:
            pulumi.set(__self__, "open_saas_installed", open_saas_installed)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if pwned_password_email is not None:
            pulumi.set(__self__, "pwned_password_email", pwned_password_email)
        if reset_password_email is not None:
            pulumi.set(__self__, "reset_password_email", reset_password_email)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if user_activation_email is not None:
            pulumi.set(__self__, "user_activation_email", user_activation_email)
        if user_invitation_email is not None:
            pulumi.set(__self__, "user_invitation_email", user_invitation_email)

    @property
    @pulumi.getter(name="adminPortal")
    def admin_portal(self) -> Optional[pulumi.Input['WorkspaceAdminPortalArgs']]:
        """
        Configures the admin portal.
        """
        return pulumi.get(self, "admin_portal")

    @admin_portal.setter
    def admin_portal(self, value: Optional[pulumi.Input['WorkspaceAdminPortalArgs']]):
        pulumi.set(self, "admin_portal", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
        responses.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="authPolicy")
    def auth_policy(self) -> Optional[pulumi.Input['WorkspaceAuthPolicyArgs']]:
        """
        Configures the general authentication policy.
        """
        return pulumi.get(self, "auth_policy")

    @auth_policy.setter
    def auth_policy(self, value: Optional[pulumi.Input['WorkspaceAuthPolicyArgs']]):
        pulumi.set(self, "auth_policy", value)

    @property
    @pulumi.getter(name="backendStack")
    def backend_stack(self) -> Optional[pulumi.Input[str]]:
        """
        The backend stack of the application associated with the workspace.
        """
        return pulumi.get(self, "backend_stack")

    @backend_stack.setter
    def backend_stack(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_stack", value)

    @property
    @pulumi.getter(name="captchaPolicy")
    def captcha_policy(self) -> Optional[pulumi.Input['WorkspaceCaptchaPolicyArgs']]:
        """
        Configures the CAPTCHA policy in the signup form.
        """
        return pulumi.get(self, "captcha_policy")

    @captcha_policy.setter
    def captcha_policy(self, value: Optional[pulumi.Input['WorkspaceCaptchaPolicyArgs']]):
        pulumi.set(self, "captcha_policy", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country associated with the workspace.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
        points to "ssl.frontegg.com" before setting this field.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="facebookSocialLogin")
    def facebook_social_login(self) -> Optional[pulumi.Input['WorkspaceFacebookSocialLoginArgs']]:
        """
        Configures social login with Facebook.
        """
        return pulumi.get(self, "facebook_social_login")

    @facebook_social_login.setter
    def facebook_social_login(self, value: Optional[pulumi.Input['WorkspaceFacebookSocialLoginArgs']]):
        pulumi.set(self, "facebook_social_login", value)

    @property
    @pulumi.getter(name="fronteggDomain")
    def frontegg_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        """
        return pulumi.get(self, "frontegg_domain")

    @frontegg_domain.setter
    def frontegg_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frontegg_domain", value)

    @property
    @pulumi.getter(name="frontendStack")
    def frontend_stack(self) -> Optional[pulumi.Input[str]]:
        """
        The frontend stack of the application associated with the worksapce.
        """
        return pulumi.get(self, "frontend_stack")

    @frontend_stack.setter
    def frontend_stack(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frontend_stack", value)

    @property
    @pulumi.getter(name="githubSocialLogin")
    def github_social_login(self) -> Optional[pulumi.Input['WorkspaceGithubSocialLoginArgs']]:
        """
        Configures social login with GitHub.
        """
        return pulumi.get(self, "github_social_login")

    @github_social_login.setter
    def github_social_login(self, value: Optional[pulumi.Input['WorkspaceGithubSocialLoginArgs']]):
        pulumi.set(self, "github_social_login", value)

    @property
    @pulumi.getter(name="googleSocialLogin")
    def google_social_login(self) -> Optional[pulumi.Input['WorkspaceGoogleSocialLoginArgs']]:
        """
        Configures social login with Google.
        """
        return pulumi.get(self, "google_social_login")

    @google_social_login.setter
    def google_social_login(self, value: Optional[pulumi.Input['WorkspaceGoogleSocialLoginArgs']]):
        pulumi.set(self, "google_social_login", value)

    @property
    @pulumi.getter(name="hostedLogin")
    def hosted_login(self) -> Optional[pulumi.Input['WorkspaceHostedLoginArgs']]:
        """
        Configures Frontegg-hosted OAuth login.
        """
        return pulumi.get(self, "hosted_login")

    @hosted_login.setter
    def hosted_login(self, value: Optional[pulumi.Input['WorkspaceHostedLoginArgs']]):
        pulumi.set(self, "hosted_login", value)

    @property
    @pulumi.getter(name="lockoutPolicy")
    def lockout_policy(self) -> Optional[pulumi.Input['WorkspaceLockoutPolicyArgs']]:
        """
        Configures the user lockout policy.
        """
        return pulumi.get(self, "lockout_policy")

    @lockout_policy.setter
    def lockout_policy(self, value: Optional[pulumi.Input['WorkspaceLockoutPolicyArgs']]):
        pulumi.set(self, "lockout_policy", value)

    @property
    @pulumi.getter(name="mfaAuthenticationApp")
    def mfa_authentication_app(self) -> Optional[pulumi.Input['WorkspaceMfaAuthenticationAppArgs']]:
        """
        Configures the multi-factor authentication (MFA) via an authentication app.
        """
        return pulumi.get(self, "mfa_authentication_app")

    @mfa_authentication_app.setter
    def mfa_authentication_app(self, value: Optional[pulumi.Input['WorkspaceMfaAuthenticationAppArgs']]):
        pulumi.set(self, "mfa_authentication_app", value)

    @property
    @pulumi.getter(name="mfaPolicy")
    def mfa_policy(self) -> Optional[pulumi.Input['WorkspaceMfaPolicyArgs']]:
        """
        Configures the multi-factor authentication (MFA) policy.
        """
        return pulumi.get(self, "mfa_policy")

    @mfa_policy.setter
    def mfa_policy(self, value: Optional[pulumi.Input['WorkspaceMfaPolicyArgs']]):
        pulumi.set(self, "mfa_policy", value)

    @property
    @pulumi.getter(name="microsoftSocialLogin")
    def microsoft_social_login(self) -> Optional[pulumi.Input['WorkspaceMicrosoftSocialLoginArgs']]:
        """
        Configures social login with Google.
        """
        return pulumi.get(self, "microsoft_social_login")

    @microsoft_social_login.setter
    def microsoft_social_login(self, value: Optional[pulumi.Input['WorkspaceMicrosoftSocialLoginArgs']]):
        pulumi.set(self, "microsoft_social_login", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openSaasInstalled")
    def open_saas_installed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the application associated with the workspace has OpenSaaS installed.
        """
        return pulumi.get(self, "open_saas_installed")

    @open_saas_installed.setter
    def open_saas_installed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_saas_installed", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input['WorkspacePasswordPolicyArgs']]:
        """
        Configures the password policy.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input['WorkspacePasswordPolicyArgs']]):
        pulumi.set(self, "password_policy", value)

    @property
    @pulumi.getter(name="pwnedPasswordEmail")
    def pwned_password_email(self) -> Optional[pulumi.Input['WorkspacePwnedPasswordEmailArgs']]:
        """
        Configures the pwned password email.
        """
        return pulumi.get(self, "pwned_password_email")

    @pwned_password_email.setter
    def pwned_password_email(self, value: Optional[pulumi.Input['WorkspacePwnedPasswordEmailArgs']]):
        pulumi.set(self, "pwned_password_email", value)

    @property
    @pulumi.getter(name="resetPasswordEmail")
    def reset_password_email(self) -> Optional[pulumi.Input['WorkspaceResetPasswordEmailArgs']]:
        """
        Configures the password reset email.
        """
        return pulumi.get(self, "reset_password_email")

    @reset_password_email.setter
    def reset_password_email(self, value: Optional[pulumi.Input['WorkspaceResetPasswordEmailArgs']]):
        pulumi.set(self, "reset_password_email", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['WorkspaceSamlArgs']]:
        """
        Configures SSO via SAML.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['WorkspaceSamlArgs']]):
        pulumi.set(self, "saml", value)

    @property
    @pulumi.getter(name="userActivationEmail")
    def user_activation_email(self) -> Optional[pulumi.Input['WorkspaceUserActivationEmailArgs']]:
        """
        Configures the user activation email.
        """
        return pulumi.get(self, "user_activation_email")

    @user_activation_email.setter
    def user_activation_email(self, value: Optional[pulumi.Input['WorkspaceUserActivationEmailArgs']]):
        pulumi.set(self, "user_activation_email", value)

    @property
    @pulumi.getter(name="userInvitationEmail")
    def user_invitation_email(self) -> Optional[pulumi.Input['WorkspaceUserInvitationEmailArgs']]:
        """
        Configures the user invitation email.
        """
        return pulumi.get(self, "user_invitation_email")

    @user_invitation_email.setter
    def user_invitation_email(self, value: Optional[pulumi.Input['WorkspaceUserInvitationEmailArgs']]):
        pulumi.set(self, "user_invitation_email", value)


class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_portal: Optional[pulumi.Input[pulumi.InputType['WorkspaceAdminPortalArgs']]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auth_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceAuthPolicyArgs']]] = None,
                 backend_stack: Optional[pulumi.Input[str]] = None,
                 captcha_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceCaptchaPolicyArgs']]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 facebook_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceFacebookSocialLoginArgs']]] = None,
                 frontegg_domain: Optional[pulumi.Input[str]] = None,
                 frontend_stack: Optional[pulumi.Input[str]] = None,
                 github_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceGithubSocialLoginArgs']]] = None,
                 google_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceGoogleSocialLoginArgs']]] = None,
                 hosted_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceHostedLoginArgs']]] = None,
                 lockout_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceLockoutPolicyArgs']]] = None,
                 mfa_authentication_app: Optional[pulumi.Input[pulumi.InputType['WorkspaceMfaAuthenticationAppArgs']]] = None,
                 mfa_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceMfaPolicyArgs']]] = None,
                 microsoft_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceMicrosoftSocialLoginArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_saas_installed: Optional[pulumi.Input[bool]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['WorkspacePasswordPolicyArgs']]] = None,
                 pwned_password_email: Optional[pulumi.Input[pulumi.InputType['WorkspacePwnedPasswordEmailArgs']]] = None,
                 reset_password_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceResetPasswordEmailArgs']]] = None,
                 saml: Optional[pulumi.Input[pulumi.InputType['WorkspaceSamlArgs']]] = None,
                 user_activation_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceUserActivationEmailArgs']]] = None,
                 user_invitation_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceUserInvitationEmailArgs']]] = None,
                 __props__=None):
        """
        Create a Workspace resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['WorkspaceAdminPortalArgs']] admin_portal: Configures the admin portal.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
               responses.
        :param pulumi.Input[pulumi.InputType['WorkspaceAuthPolicyArgs']] auth_policy: Configures the general authentication policy.
        :param pulumi.Input[str] backend_stack: The backend stack of the application associated with the workspace.
        :param pulumi.Input[pulumi.InputType['WorkspaceCaptchaPolicyArgs']] captcha_policy: Configures the CAPTCHA policy in the signup form.
        :param pulumi.Input[str] country: The country associated with the workspace.
        :param pulumi.Input[str] custom_domain: A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
               points to "ssl.frontegg.com" before setting this field.
        :param pulumi.Input[pulumi.InputType['WorkspaceFacebookSocialLoginArgs']] facebook_social_login: Configures social login with Facebook.
        :param pulumi.Input[str] frontegg_domain: The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        :param pulumi.Input[str] frontend_stack: The frontend stack of the application associated with the worksapce.
        :param pulumi.Input[pulumi.InputType['WorkspaceGithubSocialLoginArgs']] github_social_login: Configures social login with GitHub.
        :param pulumi.Input[pulumi.InputType['WorkspaceGoogleSocialLoginArgs']] google_social_login: Configures social login with Google.
        :param pulumi.Input[pulumi.InputType['WorkspaceHostedLoginArgs']] hosted_login: Configures Frontegg-hosted OAuth login.
        :param pulumi.Input[pulumi.InputType['WorkspaceLockoutPolicyArgs']] lockout_policy: Configures the user lockout policy.
        :param pulumi.Input[pulumi.InputType['WorkspaceMfaAuthenticationAppArgs']] mfa_authentication_app: Configures the multi-factor authentication (MFA) via an authentication app.
        :param pulumi.Input[pulumi.InputType['WorkspaceMfaPolicyArgs']] mfa_policy: Configures the multi-factor authentication (MFA) policy.
        :param pulumi.Input[pulumi.InputType['WorkspaceMicrosoftSocialLoginArgs']] microsoft_social_login: Configures social login with Google.
        :param pulumi.Input[str] name: The name of the workspace.
        :param pulumi.Input[bool] open_saas_installed: Whether the application associated with the workspace has OpenSaaS installed.
        :param pulumi.Input[pulumi.InputType['WorkspacePasswordPolicyArgs']] password_policy: Configures the password policy.
        :param pulumi.Input[pulumi.InputType['WorkspacePwnedPasswordEmailArgs']] pwned_password_email: Configures the pwned password email.
        :param pulumi.Input[pulumi.InputType['WorkspaceResetPasswordEmailArgs']] reset_password_email: Configures the password reset email.
        :param pulumi.Input[pulumi.InputType['WorkspaceSamlArgs']] saml: Configures SSO via SAML.
        :param pulumi.Input[pulumi.InputType['WorkspaceUserActivationEmailArgs']] user_activation_email: Configures the user activation email.
        :param pulumi.Input[pulumi.InputType['WorkspaceUserInvitationEmailArgs']] user_invitation_email: Configures the user invitation email.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Workspace resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_portal: Optional[pulumi.Input[pulumi.InputType['WorkspaceAdminPortalArgs']]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auth_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceAuthPolicyArgs']]] = None,
                 backend_stack: Optional[pulumi.Input[str]] = None,
                 captcha_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceCaptchaPolicyArgs']]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 facebook_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceFacebookSocialLoginArgs']]] = None,
                 frontegg_domain: Optional[pulumi.Input[str]] = None,
                 frontend_stack: Optional[pulumi.Input[str]] = None,
                 github_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceGithubSocialLoginArgs']]] = None,
                 google_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceGoogleSocialLoginArgs']]] = None,
                 hosted_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceHostedLoginArgs']]] = None,
                 lockout_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceLockoutPolicyArgs']]] = None,
                 mfa_authentication_app: Optional[pulumi.Input[pulumi.InputType['WorkspaceMfaAuthenticationAppArgs']]] = None,
                 mfa_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceMfaPolicyArgs']]] = None,
                 microsoft_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceMicrosoftSocialLoginArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open_saas_installed: Optional[pulumi.Input[bool]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['WorkspacePasswordPolicyArgs']]] = None,
                 pwned_password_email: Optional[pulumi.Input[pulumi.InputType['WorkspacePwnedPasswordEmailArgs']]] = None,
                 reset_password_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceResetPasswordEmailArgs']]] = None,
                 saml: Optional[pulumi.Input[pulumi.InputType['WorkspaceSamlArgs']]] = None,
                 user_activation_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceUserActivationEmailArgs']]] = None,
                 user_invitation_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceUserInvitationEmailArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            if admin_portal is None and not opts.urn:
                raise TypeError("Missing required property 'admin_portal'")
            __props__.__dict__["admin_portal"] = admin_portal
            if allowed_origins is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_origins'")
            __props__.__dict__["allowed_origins"] = allowed_origins
            if auth_policy is None and not opts.urn:
                raise TypeError("Missing required property 'auth_policy'")
            __props__.__dict__["auth_policy"] = auth_policy
            if backend_stack is None and not opts.urn:
                raise TypeError("Missing required property 'backend_stack'")
            __props__.__dict__["backend_stack"] = backend_stack
            __props__.__dict__["captcha_policy"] = captcha_policy
            if country is None and not opts.urn:
                raise TypeError("Missing required property 'country'")
            __props__.__dict__["country"] = country
            __props__.__dict__["custom_domain"] = custom_domain
            __props__.__dict__["facebook_social_login"] = facebook_social_login
            if frontegg_domain is None and not opts.urn:
                raise TypeError("Missing required property 'frontegg_domain'")
            __props__.__dict__["frontegg_domain"] = frontegg_domain
            if frontend_stack is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_stack'")
            __props__.__dict__["frontend_stack"] = frontend_stack
            __props__.__dict__["github_social_login"] = github_social_login
            __props__.__dict__["google_social_login"] = google_social_login
            __props__.__dict__["hosted_login"] = hosted_login
            __props__.__dict__["lockout_policy"] = lockout_policy
            __props__.__dict__["mfa_authentication_app"] = mfa_authentication_app
            if mfa_policy is None and not opts.urn:
                raise TypeError("Missing required property 'mfa_policy'")
            __props__.__dict__["mfa_policy"] = mfa_policy
            __props__.__dict__["microsoft_social_login"] = microsoft_social_login
            __props__.__dict__["name"] = name
            if open_saas_installed is None and not opts.urn:
                raise TypeError("Missing required property 'open_saas_installed'")
            __props__.__dict__["open_saas_installed"] = open_saas_installed
            if password_policy is None and not opts.urn:
                raise TypeError("Missing required property 'password_policy'")
            __props__.__dict__["password_policy"] = password_policy
            __props__.__dict__["pwned_password_email"] = pwned_password_email
            __props__.__dict__["reset_password_email"] = reset_password_email
            __props__.__dict__["saml"] = saml
            __props__.__dict__["user_activation_email"] = user_activation_email
            __props__.__dict__["user_invitation_email"] = user_invitation_email
        super(Workspace, __self__).__init__(
            'frontegg:index/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_portal: Optional[pulumi.Input[pulumi.InputType['WorkspaceAdminPortalArgs']]] = None,
            allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            auth_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceAuthPolicyArgs']]] = None,
            backend_stack: Optional[pulumi.Input[str]] = None,
            captcha_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceCaptchaPolicyArgs']]] = None,
            country: Optional[pulumi.Input[str]] = None,
            custom_domain: Optional[pulumi.Input[str]] = None,
            facebook_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceFacebookSocialLoginArgs']]] = None,
            frontegg_domain: Optional[pulumi.Input[str]] = None,
            frontend_stack: Optional[pulumi.Input[str]] = None,
            github_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceGithubSocialLoginArgs']]] = None,
            google_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceGoogleSocialLoginArgs']]] = None,
            hosted_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceHostedLoginArgs']]] = None,
            lockout_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceLockoutPolicyArgs']]] = None,
            mfa_authentication_app: Optional[pulumi.Input[pulumi.InputType['WorkspaceMfaAuthenticationAppArgs']]] = None,
            mfa_policy: Optional[pulumi.Input[pulumi.InputType['WorkspaceMfaPolicyArgs']]] = None,
            microsoft_social_login: Optional[pulumi.Input[pulumi.InputType['WorkspaceMicrosoftSocialLoginArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            open_saas_installed: Optional[pulumi.Input[bool]] = None,
            password_policy: Optional[pulumi.Input[pulumi.InputType['WorkspacePasswordPolicyArgs']]] = None,
            pwned_password_email: Optional[pulumi.Input[pulumi.InputType['WorkspacePwnedPasswordEmailArgs']]] = None,
            reset_password_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceResetPasswordEmailArgs']]] = None,
            saml: Optional[pulumi.Input[pulumi.InputType['WorkspaceSamlArgs']]] = None,
            user_activation_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceUserActivationEmailArgs']]] = None,
            user_invitation_email: Optional[pulumi.Input[pulumi.InputType['WorkspaceUserInvitationEmailArgs']]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['WorkspaceAdminPortalArgs']] admin_portal: Configures the admin portal.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
               responses.
        :param pulumi.Input[pulumi.InputType['WorkspaceAuthPolicyArgs']] auth_policy: Configures the general authentication policy.
        :param pulumi.Input[str] backend_stack: The backend stack of the application associated with the workspace.
        :param pulumi.Input[pulumi.InputType['WorkspaceCaptchaPolicyArgs']] captcha_policy: Configures the CAPTCHA policy in the signup form.
        :param pulumi.Input[str] country: The country associated with the workspace.
        :param pulumi.Input[str] custom_domain: A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
               points to "ssl.frontegg.com" before setting this field.
        :param pulumi.Input[pulumi.InputType['WorkspaceFacebookSocialLoginArgs']] facebook_social_login: Configures social login with Facebook.
        :param pulumi.Input[str] frontegg_domain: The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        :param pulumi.Input[str] frontend_stack: The frontend stack of the application associated with the worksapce.
        :param pulumi.Input[pulumi.InputType['WorkspaceGithubSocialLoginArgs']] github_social_login: Configures social login with GitHub.
        :param pulumi.Input[pulumi.InputType['WorkspaceGoogleSocialLoginArgs']] google_social_login: Configures social login with Google.
        :param pulumi.Input[pulumi.InputType['WorkspaceHostedLoginArgs']] hosted_login: Configures Frontegg-hosted OAuth login.
        :param pulumi.Input[pulumi.InputType['WorkspaceLockoutPolicyArgs']] lockout_policy: Configures the user lockout policy.
        :param pulumi.Input[pulumi.InputType['WorkspaceMfaAuthenticationAppArgs']] mfa_authentication_app: Configures the multi-factor authentication (MFA) via an authentication app.
        :param pulumi.Input[pulumi.InputType['WorkspaceMfaPolicyArgs']] mfa_policy: Configures the multi-factor authentication (MFA) policy.
        :param pulumi.Input[pulumi.InputType['WorkspaceMicrosoftSocialLoginArgs']] microsoft_social_login: Configures social login with Google.
        :param pulumi.Input[str] name: The name of the workspace.
        :param pulumi.Input[bool] open_saas_installed: Whether the application associated with the workspace has OpenSaaS installed.
        :param pulumi.Input[pulumi.InputType['WorkspacePasswordPolicyArgs']] password_policy: Configures the password policy.
        :param pulumi.Input[pulumi.InputType['WorkspacePwnedPasswordEmailArgs']] pwned_password_email: Configures the pwned password email.
        :param pulumi.Input[pulumi.InputType['WorkspaceResetPasswordEmailArgs']] reset_password_email: Configures the password reset email.
        :param pulumi.Input[pulumi.InputType['WorkspaceSamlArgs']] saml: Configures SSO via SAML.
        :param pulumi.Input[pulumi.InputType['WorkspaceUserActivationEmailArgs']] user_activation_email: Configures the user activation email.
        :param pulumi.Input[pulumi.InputType['WorkspaceUserInvitationEmailArgs']] user_invitation_email: Configures the user invitation email.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["admin_portal"] = admin_portal
        __props__.__dict__["allowed_origins"] = allowed_origins
        __props__.__dict__["auth_policy"] = auth_policy
        __props__.__dict__["backend_stack"] = backend_stack
        __props__.__dict__["captcha_policy"] = captcha_policy
        __props__.__dict__["country"] = country
        __props__.__dict__["custom_domain"] = custom_domain
        __props__.__dict__["facebook_social_login"] = facebook_social_login
        __props__.__dict__["frontegg_domain"] = frontegg_domain
        __props__.__dict__["frontend_stack"] = frontend_stack
        __props__.__dict__["github_social_login"] = github_social_login
        __props__.__dict__["google_social_login"] = google_social_login
        __props__.__dict__["hosted_login"] = hosted_login
        __props__.__dict__["lockout_policy"] = lockout_policy
        __props__.__dict__["mfa_authentication_app"] = mfa_authentication_app
        __props__.__dict__["mfa_policy"] = mfa_policy
        __props__.__dict__["microsoft_social_login"] = microsoft_social_login
        __props__.__dict__["name"] = name
        __props__.__dict__["open_saas_installed"] = open_saas_installed
        __props__.__dict__["password_policy"] = password_policy
        __props__.__dict__["pwned_password_email"] = pwned_password_email
        __props__.__dict__["reset_password_email"] = reset_password_email
        __props__.__dict__["saml"] = saml
        __props__.__dict__["user_activation_email"] = user_activation_email
        __props__.__dict__["user_invitation_email"] = user_invitation_email
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPortal")
    def admin_portal(self) -> pulumi.Output['outputs.WorkspaceAdminPortal']:
        """
        Configures the admin portal.
        """
        return pulumi.get(self, "admin_portal")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Sequence[str]]:
        """
        The origins that are allowed to access the workspace. This parameter controls the value of the "Origin" header for API
        responses.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="authPolicy")
    def auth_policy(self) -> pulumi.Output['outputs.WorkspaceAuthPolicy']:
        """
        Configures the general authentication policy.
        """
        return pulumi.get(self, "auth_policy")

    @property
    @pulumi.getter(name="backendStack")
    def backend_stack(self) -> pulumi.Output[str]:
        """
        The backend stack of the application associated with the workspace.
        """
        return pulumi.get(self, "backend_stack")

    @property
    @pulumi.getter(name="captchaPolicy")
    def captcha_policy(self) -> pulumi.Output[Optional['outputs.WorkspaceCaptchaPolicy']]:
        """
        Configures the CAPTCHA policy in the signup form.
        """
        return pulumi.get(self, "captcha_policy")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[str]:
        """
        The country associated with the workspace.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[Optional[str]]:
        """
        A custom domain at which Frontegg services will be reachable. You must configure a CNAME record for this domain that
        points to "ssl.frontegg.com" before setting this field.
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="facebookSocialLogin")
    def facebook_social_login(self) -> pulumi.Output[Optional['outputs.WorkspaceFacebookSocialLogin']]:
        """
        Configures social login with Facebook.
        """
        return pulumi.get(self, "facebook_social_login")

    @property
    @pulumi.getter(name="fronteggDomain")
    def frontegg_domain(self) -> pulumi.Output[str]:
        """
        The domain at which the Frontegg API is served for this workspace. The domain must end with ".frontegg.com".
        """
        return pulumi.get(self, "frontegg_domain")

    @property
    @pulumi.getter(name="frontendStack")
    def frontend_stack(self) -> pulumi.Output[str]:
        """
        The frontend stack of the application associated with the worksapce.
        """
        return pulumi.get(self, "frontend_stack")

    @property
    @pulumi.getter(name="githubSocialLogin")
    def github_social_login(self) -> pulumi.Output[Optional['outputs.WorkspaceGithubSocialLogin']]:
        """
        Configures social login with GitHub.
        """
        return pulumi.get(self, "github_social_login")

    @property
    @pulumi.getter(name="googleSocialLogin")
    def google_social_login(self) -> pulumi.Output[Optional['outputs.WorkspaceGoogleSocialLogin']]:
        """
        Configures social login with Google.
        """
        return pulumi.get(self, "google_social_login")

    @property
    @pulumi.getter(name="hostedLogin")
    def hosted_login(self) -> pulumi.Output[Optional['outputs.WorkspaceHostedLogin']]:
        """
        Configures Frontegg-hosted OAuth login.
        """
        return pulumi.get(self, "hosted_login")

    @property
    @pulumi.getter(name="lockoutPolicy")
    def lockout_policy(self) -> pulumi.Output[Optional['outputs.WorkspaceLockoutPolicy']]:
        """
        Configures the user lockout policy.
        """
        return pulumi.get(self, "lockout_policy")

    @property
    @pulumi.getter(name="mfaAuthenticationApp")
    def mfa_authentication_app(self) -> pulumi.Output[Optional['outputs.WorkspaceMfaAuthenticationApp']]:
        """
        Configures the multi-factor authentication (MFA) via an authentication app.
        """
        return pulumi.get(self, "mfa_authentication_app")

    @property
    @pulumi.getter(name="mfaPolicy")
    def mfa_policy(self) -> pulumi.Output['outputs.WorkspaceMfaPolicy']:
        """
        Configures the multi-factor authentication (MFA) policy.
        """
        return pulumi.get(self, "mfa_policy")

    @property
    @pulumi.getter(name="microsoftSocialLogin")
    def microsoft_social_login(self) -> pulumi.Output[Optional['outputs.WorkspaceMicrosoftSocialLogin']]:
        """
        Configures social login with Google.
        """
        return pulumi.get(self, "microsoft_social_login")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the workspace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openSaasInstalled")
    def open_saas_installed(self) -> pulumi.Output[bool]:
        """
        Whether the application associated with the workspace has OpenSaaS installed.
        """
        return pulumi.get(self, "open_saas_installed")

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> pulumi.Output['outputs.WorkspacePasswordPolicy']:
        """
        Configures the password policy.
        """
        return pulumi.get(self, "password_policy")

    @property
    @pulumi.getter(name="pwnedPasswordEmail")
    def pwned_password_email(self) -> pulumi.Output[Optional['outputs.WorkspacePwnedPasswordEmail']]:
        """
        Configures the pwned password email.
        """
        return pulumi.get(self, "pwned_password_email")

    @property
    @pulumi.getter(name="resetPasswordEmail")
    def reset_password_email(self) -> pulumi.Output[Optional['outputs.WorkspaceResetPasswordEmail']]:
        """
        Configures the password reset email.
        """
        return pulumi.get(self, "reset_password_email")

    @property
    @pulumi.getter
    def saml(self) -> pulumi.Output[Optional['outputs.WorkspaceSaml']]:
        """
        Configures SSO via SAML.
        """
        return pulumi.get(self, "saml")

    @property
    @pulumi.getter(name="userActivationEmail")
    def user_activation_email(self) -> pulumi.Output[Optional['outputs.WorkspaceUserActivationEmail']]:
        """
        Configures the user activation email.
        """
        return pulumi.get(self, "user_activation_email")

    @property
    @pulumi.getter(name="userInvitationEmail")
    def user_invitation_email(self) -> pulumi.Output[Optional['outputs.WorkspaceUserInvitationEmail']]:
        """
        Configures the user invitation email.
        """
        return pulumi.get(self, "user_invitation_email")

