"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class Warhorse(Monster):
    """

    Trampling Charge.
      If the horse moves at least 20 ft. straight toward a creature and then
      hits it with a hooves attack on the same turn, that target must
      succeed on a DC 14 Strength saving throw or be knocked prone. If the
      target is prone, the horse can make another attack with its hooves
      against it as a bonus action.

    # Actions

    Hooves.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) bludgeoning damage.
    """
    name = 'Warhorse'
    description = 'Large beast, unaligned'
    challenge_rating = 0.5
    armor_class = 11
    skills = ''
    senses = 'Passive Perception 11'
    languages = ''
    strength = Ability(18)
    dexterity = Ability(12)
    constitution = Ability(13)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 60
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 19
    hit_dice = '3d10 + 3'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WarhorseSkeleton(Monster):
    """

    # Actions

    Hooves.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) bludgeoning damage.
    """
    name = 'Warhorse Skeleton'
    description = 'Large undead, lawful evil'
    challenge_rating = 0.5
    armor_class = 13
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 9'
    languages = ''
    strength = Ability(18)
    dexterity = Ability(12)
    constitution = Ability(15)
    intelligence = Ability(2)
    wisdom = Ability(8)
    charisma = Ability(5)
    speed = 60
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 22
    hit_dice = '3d10 + 6'
    condition_immunities = 'exhaustion, poisoned'
    damage_immunities = 'poison'
    damage_resistances = ''
    damage_vulnerabilities = 'bludgeoning'
    spells = []


class WaterElemental(Monster):
    """

    Water Form.
      The elemental can enter a hostile creature's space and stop there. It
      can move through a space as narrow as 1 inch wide without squeezing.
    Freeze.
      If the elemental takes cold damage, it partially freezes; its speed is
      reduced by 20 ft. until the end of its next turn.

    # Actions

    Multiattack.
      The elemental makes two slam attacks.
    Slam.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) bludgeoning damage.
    Whelm.
      Each creature in the elemental's space must make a DC 15 Strength
      saving throw. On a failure, a target takes 13 (2d8 + 4) bludgeoning
      damage. If it is Large or smaller, it is also grappled (escape DC 14).
      Until this grapple ends, the target is restrained and unable to
      breathe unless it can breathe water. If the saving throw is
      successful, the target is pushed out of the elemental's space.
      
      The elemental can grapple one Large creature or up to two Medium or
      smaller creatures at one time. At the start of each of the elemental's
      turns, each target grappled by it takes 13 (2d8 + 4) bludgeoning
      damage. A creature within 5 feet of the elemental can pull a creature
      or object out of it by taking an action to make a DC 14 Strength and
      succeeding.
    """
    name = 'Water Elemental'
    description = 'Large elemental, neutral'
    challenge_rating = 5
    armor_class = 14
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = 'Aquan'
    strength = Ability(18)
    dexterity = Ability(14)
    constitution = Ability(18)
    intelligence = Ability(5)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 90
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 114
    hit_dice = '12d10 + 48'
    condition_immunities = 'exhaustion, grappled, paralyzed, petrified, poisoned, prone, restrained, unconscious'
    damage_immunities = 'poison'
    damage_resistances = 'acid'
    damage_vulnerabilities = ''
    spells = []


class Weasel(Monster):
    """

    Keen Hearing and Smell.
      The weasel has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one creature. Hit: 1
      piercing damage.
    """
    name = 'Weasel'
    description = 'Tiny beast, unaligned'
    challenge_rating = 0
    armor_class = 13
    skills = 'Perception +3, Stealth +5'
    senses = 'Passive Perception 13'
    languages = ''
    strength = Ability(3)
    dexterity = Ability(16)
    constitution = Ability(8)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(3)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 1
    hit_dice = '1d4 + -1'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerebearBearForm(Monster):
    """

    Shapechanger.
      The werebear can use its action to polymorph into a Large bear-
      humanoid hybrid or into a Large bear, or back into its true form,
      which is humanoid. Its statistics, other than its size and AC, are the
      same in each form. Any equipment it is wearing or carrying isn't
      transformed. It reverts to its true form if it dies.
    Keen Smell.
      The werebear has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Multiattack.
      In bear form, the werebear makes two claw attacks. In humanoid form,
      it makes two greataxe attacks. In hybrid form, it can attack like a
      bear or a humanoid.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 15 (2d10
      + 4) piercing damage. If the target is a humanoid, it must succeed on
      a DC 14 Constitution saving throw or be cursed with werebear
      lycanthropy.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    """
    name = 'Werebear, Bear Form'
    description = 'Medium humanoid, neutral good'
    challenge_rating = 5
    armor_class = 10
    skills = 'Perception +7'
    senses = 'Passive Perception 17'
    languages = ''
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(11)
    wisdom = Ability(12)
    charisma = Ability(12)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    burrow_speed = 0
    hp_max = 135
    hit_dice = '18d8 + 54'
    condition_immunities = ''
    damage_immunities = 'bludgeoning, piercing, and slashing from nonmagical attacks not made with silvered weapons'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerebearBearform(Monster):
    """
    Shapechanger.
      The werebear can use its action to polymorph into a Large bear-
      humanoid hybrid or into a Large bear, or back into its true form,
      which is humanoid. Its statistics, other than its size and AC, are the
      same in each form. Any equipment it is wearing or carrying isn't
      transformed. It reverts to its true form if it dies.
    Keen Smell.
      The werebear has advantage on Wisdom (Perception) checks that rely on
      smell.
    Multiattack.
      In bear form, the werebear makes two claw attacks. In humanoid form,
      it makes two greataxe attacks. In hybrid form, it can attack like a
      bear or a humanoid.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 15 (2d10
      + 4) piercing damage. If the target is a humanoid, it must succeed on
      a DC 14 Constitution saving throw or be cursed with werebear
      lycanthropy.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    """
    name = 'Werebear, Bear form'
    description = 'Medium humanoid, neutral good'
    challenge_rating = 5
    armor_class = 10
    skills = 'Perception +7'
    senses = 'Passive Perception 17'
    languages = ''
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(11)
    wisdom = Ability(12)
    charisma = Ability(12)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    hp_max = 135
    hit_dice = '18d8'
    spells = []


class WerebearHumanForm(Monster):
    """

    Shapechanger.
      The werebear can use its action to polymorph into a Large bear-
      humanoid hybrid or into a Large bear, or back into its true form,
      which is humanoid. Its statistics, other than its size and AC, are the
      same in each form. Any equipment it is wearing or carrying isn't
      transformed. It reverts to its true form if it dies.
    Keen Smell.
      The werebear has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Multiattack.
      In bear form, the werebear makes two claw attacks. In humanoid form,
      it makes two greataxe attacks. In hybrid form, it can attack like a
      bear or a humanoid.
    Greataxe.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 10 (1d12
      + 4) slashing damage.
    """
    name = 'Werebear, Human Form'
    description = 'Medium humanoid, neutral good'
    challenge_rating = 5
    armor_class = 10
    skills = 'Perception +7'
    senses = 'Passive Perception 17'
    languages = 'Common'
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(11)
    wisdom = Ability(12)
    charisma = Ability(12)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 135
    hit_dice = '18d8 + 54'
    condition_immunities = ''
    damage_immunities = 'bludgeoning, piercing, and slashing from nonmagical attacks not made with silvered weapons'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerebearHumanform(Monster):
    """
    Shapechanger.
      The werebear can use its action to polymorph into a Large bear-
      humanoid hybrid or into a Large bear, or back into its true form,
      which is humanoid. Its statistics, other than its size and AC, are the
      same in each form. Any equipment it is wearing or carrying isn't
      transformed. It reverts to its true form if it dies.
    Keen Smell.
      The werebear has advantage on Wisdom (Perception) checks that rely on
      smell.
    Multiattack.
      In bear form, the werebear makes two claw attacks. In humanoid form,
      it makes two greataxe attacks. In hybrid form, it can attack like a
      bear or a humanoid.
    Greataxe.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 10 (1d12
      + 4) slashing damage.
    """
    name = 'Werebear, Human form'
    description = 'Medium humanoid, neutral good'
    challenge_rating = 5
    armor_class = 10
    skills = 'Perception +7'
    senses = 'Passive Perception 17'
    languages = 'Common'
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(11)
    wisdom = Ability(12)
    charisma = Ability(12)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 135
    hit_dice = '18d8'
    spells = []


class WerebearHybridForm(Monster):
    """

    Shapechanger.
      The werebear can use its action to polymorph into a Large bear-
      humanoid hybrid or into a Large bear, or back into its true form,
      which is humanoid. Its statistics, other than its size and AC, are the
      same in each form. Any equipment it is wearing or carrying isn't
      transformed. It reverts to its true form if it dies.
    Keen Smell.
      The werebear has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Multiattack.
      In bear form, the werebear makes two claw attacks. In humanoid form,
      it makes two greataxe attacks. In hybrid form, it can attack like a
      bear or a humanoid.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 15 (2d10
      + 4) piercing damage. If the target is a humanoid, it must succeed on
      a DC 14 Constitution saving throw or be cursed with werebear
      lycanthropy.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    Greataxe.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 10 (1d12
      + 4) slashing damage.
    """
    name = 'Werebear, Hybrid Form'
    description = 'Medium humanoid, neutral good'
    challenge_rating = 5
    armor_class = 10
    skills = 'Perception +7'
    senses = 'Passive Perception 17'
    languages = 'Common'
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(11)
    wisdom = Ability(12)
    charisma = Ability(12)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    burrow_speed = 0
    hp_max = 135
    hit_dice = '18d8 + 54'
    condition_immunities = ''
    damage_immunities = 'bludgeoning, piercing, and slashing from nonmagical attacks not made with silvered weapons'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerebearHybridform(Monster):
    """
    Shapechanger.
      The werebear can use its action to polymorph into a Large bear-
      humanoid hybrid or into a Large bear, or back into its true form,
      which is humanoid. Its statistics, other than its size and AC, are the
      same in each form. Any equipment it is wearing or carrying isn't
      transformed. It reverts to its true form if it dies.
    Keen Smell.
      The werebear has advantage on Wisdom (Perception) checks that rely on
      smell.
    Multiattack.
      In bear form, the werebear makes two claw attacks. In humanoid form,
      it makes two greataxe attacks. In hybrid form, it can attack like a
      bear or a humanoid.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 15 (2d10
      + 4) piercing damage. If the target is a humanoid, it must succeed on
      a DC 14 Constitution saving throw or be cursed with werebear
      lycanthropy.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    Greataxe.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 10 (1d12
      + 4) slashing damage.
    """
    name = 'Werebear, Hybrid form'
    description = 'Medium humanoid, neutral good'
    challenge_rating = 5
    armor_class = 10
    skills = 'Perception +7'
    senses = 'Passive Perception 17'
    languages = 'Common'
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(11)
    wisdom = Ability(12)
    charisma = Ability(12)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    hp_max = 135
    hit_dice = '18d8'
    spells = []


class WereboarBoarForm(Monster):
    """

    Shapechanger.
      The wereboar can use its action to polymorph into a boar-humanoid
      hybrid or into a boar, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Charge (Boar or Hybrid Form Only).
      If the wereboar moves at least 15 feet straight toward a target and
      then hits it with its tusks on the same turn, the target takes an
      extra 7 (2d6) slashing damage. If the target is a creature, it must
      succeed on a DC 13 Strength saving throw or be knocked prone.
    Relentless.
      If the wereboar takes 14 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.

    # Actions

    Tusks.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage. If the target is a humanoid, it must succeed on
      a DC 12 Constitution saving throw or be cursed with wereboar
      lycanthropy.
    """
    name = 'Wereboar, Boar Form'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 4
    armor_class = 10
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 78
    hit_dice = '12d8 + 24'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WereboarBoarform(Monster):
    """
    Shapechanger.
      The wereboar can use its action to polymorph into a boar-humanoid
      hybrid or into a boar, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Charge (Boar or Hybrid Form Only).
      If the wereboar moves at least 15 feet straight toward a target and
      then hits it with its tusks on the same turn, the target takes an
      extra 7 (2d6) slashing damage. If the target is a creature, it must
      succeed on a DC 13 Strength saving throw or be knocked prone.
    Relentless.
      If the wereboar takes 14 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.
    Tusks.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage. If the target is a humanoid, it must succeed on
      a DC 12 Constitution saving throw or be cursed with wereboar
      lycanthropy.
    """
    name = 'Wereboar, Boar form'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 4
    armor_class = 10
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 78
    hit_dice = '12d8'
    spells = []


class WereboarHumanForm(Monster):
    """

    Shapechanger.
      The wereboar can use its action to polymorph into a boar-humanoid
      hybrid or into a boar, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Relentless.
      If the wereboar takes 14 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.

    # Actions

    Multiattack.
      The wereboar makes two attacks, only one of which can be with its
      tusks.
    Maul.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) bludgeoning damage.
    """
    name = 'Wereboar, Human Form'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 4
    armor_class = 10
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = "Common (can't speak in boar form)"
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 78
    hit_dice = '12d8 + 24'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WereboarHumanform(Monster):
    """
    Shapechanger.
      The wereboar can use its action to polymorph into a boar-humanoid
      hybrid or into a boar, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Relentless.
      If the wereboar takes 14 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.
    Multiattack.
      The wereboar makes two attacks, only one of which can be with its
      tusks.
    Maul.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) bludgeoning damage.
    """
    name = 'Wereboar, Human form'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 4
    armor_class = 10
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = "Common (can't speak in boar form)"
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 78
    hit_dice = '12d8'
    spells = []


class WereboarHybridForm(Monster):
    """

    Shapechanger.
      The wereboar can use its action to polymorph into a boar-humanoid
      hybrid or into a boar, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Charge (Boar or Hybrid Form Only).
      If the wereboar moves at least 15 feet straight toward a target and
      then hits it with its tusks on the same turn, the target takes an
      extra 7 (2d6) slashing damage. If the target is a creature, it must
      succeed on a DC 13 Strength saving throw or be knocked prone.
    Relentless.
      If the wereboar takes 14 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.

    # Actions

    Multiattack.
      The wereboar makes two attacks, only one of which can be with its
      tusks.
    Maul.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) bludgeoning damage.
    Tusks.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage. If the target is a humanoid, it must succeed on
      a DC 12 Constitution saving throw or be cursed with wereboar
      lycanthropy.
    """
    name = 'Wereboar, Hybrid Form'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 4
    armor_class = 10
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = 'Common'
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 78
    hit_dice = '12d8 + 24'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WereboarHybridform(Monster):
    """
    Shapechanger.
      The wereboar can use its action to polymorph into a boar-humanoid
      hybrid or into a boar, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Charge (Boar or Hybrid Form Only).
      If the wereboar moves at least 15 feet straight toward a target and
      then hits it with its tusks on the same turn, the target takes an
      extra 7 (2d6) slashing damage. If the target is a creature, it must
      succeed on a DC 13 Strength saving throw or be knocked prone.
    Relentless.
      If the wereboar takes 14 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.
    Multiattack.
      The wereboar makes two attacks, only one of which can be with its
      tusks.
    Maul.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) bludgeoning damage.
    Tusks.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage. If the target is a humanoid, it must succeed on
      a DC 12 Constitution saving throw or be cursed with wereboar
      lycanthropy.
    """
    name = 'Wereboar, Hybrid form'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 4
    armor_class = 10
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = 'Common'
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 78
    hit_dice = '12d8'
    spells = []


class WereratHumanForm(Monster):
    """

    Shapechanger.
      The wererat can use its action to polymorph into a rat-humanoid hybrid
      or into a giant rat, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Smell.
      The wererat has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Multiattack (Humanoid or Hybrid Form Only).
      The wererat makes two attacks, only one of which can be a bite.
    Shortsword.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) piercing damage.
    Hand Crossbow.
      Ranged Weapon Attack: +4 to hit, range 30/120 ft., one target. Hit: 5
      (1d6 + 2) piercing damage.
    """
    name = 'Wererat, Human Form'
    description = 'Medium humanoid, lawful evil'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2, Stealth +4'
    senses = 'Passive Perception 12'
    languages = 'Common'
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 33
    hit_dice = '6d8 + 6'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WereratHumanform(Monster):
    """
    Shapechanger.
      The wererat can use its action to polymorph into a rat-humanoid hybrid
      or into a giant rat, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Smell.
      The wererat has advantage on Wisdom (Perception) checks that rely on
      smell.
    Multiattack (Humanoid or Hybrid Form Only).
      The wererat makes two attacks, only one of which can be a bite.
    Shortsword.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) piercing damage.
    Hand Crossbow.
      Ranged Weapon Attack: +4 to hit, range 30/120 ft., one target. Hit: 5
      (1d6 + 2) piercing damage.
    """
    name = 'Wererat, Human form'
    description = 'Medium humanoid, lawful evil'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2, Stealth +4'
    senses = 'Passive Perception 12'
    languages = 'Common'
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 33
    hit_dice = '6d8'
    spells = []


class WereratHybridForm(Monster):
    """

    Shapechanger.
      The wererat can use its action to polymorph into a rat-humanoid hybrid
      or into a giant rat, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Smell.
      The wererat has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Multiattack.
      The wererat makes two attacks, only one of which can be a bite.
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 4 (1d4 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 11 Constitution saving throw or be cursed with wererat lycanthropy.
    Shortsword.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) piercing damage.
    Hand Crossbow.
      Ranged Weapon Attack: +4 to hit, range 30/120 ft., one target. Hit: 5
      (1d6 + 2) piercing damage.
    """
    name = 'Wererat, Hybrid Form'
    description = 'Medium humanoid, lawful evil'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2, Stealth +4'
    senses = 'Passive Perception 12'
    languages = 'Common'
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 33
    hit_dice = '6d8 + 6'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WereratHybridform(Monster):
    """
    Shapechanger.
      The wererat can use its action to polymorph into a rat-humanoid hybrid
      or into a giant rat, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Smell.
      The wererat has advantage on Wisdom (Perception) checks that rely on
      smell.
    Multiattack.
      The wererat makes two attacks, only one of which can be a bite.
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 4 (1d4 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 11 Constitution saving throw or be cursed with wererat lycanthropy.
    Shortsword.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) piercing damage.
    Hand Crossbow.
      Ranged Weapon Attack: +4 to hit, range 30/120 ft., one target. Hit: 5
      (1d6 + 2) piercing damage.
    """
    name = 'Wererat, Hybrid form'
    description = 'Medium humanoid, lawful evil'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2, Stealth +4'
    senses = 'Passive Perception 12'
    languages = 'Common'
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 33
    hit_dice = '6d8'
    spells = []


class WereratRatForm(Monster):
    """

    Shapechanger.
      The wererat can use its action to polymorph into a rat-humanoid hybrid
      or into a giant rat, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Smell.
      The wererat has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 4 (1d4 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 11 Constitution saving throw or be cursed with wererat lycanthropy.
    """
    name = 'Wererat, Rat Form'
    description = 'Medium humanoid, lawful evil'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 12'
    languages = ''
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 33
    hit_dice = '6d8 + 6'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WereratRatform(Monster):
    """
    Shapechanger.
      The wererat can use its action to polymorph into a rat-humanoid hybrid
      or into a giant rat, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Smell.
      The wererat has advantage on Wisdom (Perception) checks that rely on
      smell.
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 4 (1d4 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 11 Constitution saving throw or be cursed with wererat lycanthropy.
    """
    name = 'Wererat, Rat form'
    description = 'Medium humanoid, lawful evil'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 12'
    languages = ''
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 33
    hit_dice = '6d8'
    spells = []


class WeretigerHumanForm(Monster):
    """

    Shapechanger.
      The weretiger can use its action to polymorph into a tiger-humanoid
      hybrid or into a tiger, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The weretiger has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Multiattack.
      In humanoid form, the weretiger makes two scimitar attacks or two
      longbow attacks. In hybrid form, it can attack like a humanoid or make
      two claw attacks.
    Scimitar.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1d6 +
      3) slashing damage.
    Longbow.
      Ranged Weapon Attack: +4 to hit, range 150/600 ft., one target. Hit: 6
      (1d8 + 2) piercing damage.
    """
    name = 'Weretiger, Human Form'
    description = 'Medium humanoid, neutral'
    challenge_rating = 4
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = 'Common'
    strength = Ability(17)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 120
    hit_dice = '16d8 + 48'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WeretigerHumanform(Monster):
    """
    Shapechanger.
      The weretiger can use its action to polymorph into a tiger-humanoid
      hybrid or into a tiger, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The weretiger has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Multiattack.
      In humanoid form, the weretiger makes two scimitar attacks or two
      longbow attacks. In hybrid form, it can attack like a humanoid or make
      two claw attacks.
    Scimitar.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1d6 +
      3) slashing damage.
    Longbow.
      Ranged Weapon Attack: +4 to hit, range 150/600 ft., one target. Hit: 6
      (1d8 + 2) piercing damage.
    """
    name = 'Weretiger, Human form'
    description = 'Medium humanoid, neutral'
    challenge_rating = 4
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = 'Common'
    strength = Ability(17)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 120
    hit_dice = '16d8'
    spells = []


class WeretigerHybridForm(Monster):
    """

    Shapechanger.
      The weretiger can use its action to polymorph into a tiger-humanoid
      hybrid or into a tiger, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The weretiger has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Pounce.
      If the weretiger moves at least 15 feet straight toward a creature and
      then hits it with a claw attack on the same turn, that target must
      succeed on a DC 14 Strength saving throw or be knocked prone. If the
      target is prone, the weretiger can make one bite attack against it as
      a bonus action.

    # Actions

    Multiattack.
      In humanoid form, the weretiger makes two scimitar attacks or two
      longbow attacks. In hybrid form, it can attack like a humanoid or make
      two claw attacks.
    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 8 (1d10
      + 3) piercing damage. If the target is a humanoid, it must succeed on
      a DC 13 Constitution saving throw or be cursed with weretiger
      lycanthropy.
    Claw.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 7 (1d8 +
      3) slashing damage.
    Scimitar.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1d6 +
      3) slashing damage.
    Longbow.
      Ranged Weapon Attack: +4 to hit, range 150/600 ft., one target. Hit: 6
      (1d8 + 2) piercing damage.
    """
    name = 'Weretiger, Hybrid Form'
    description = 'Medium humanoid, neutral'
    challenge_rating = 4
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = 'Common'
    strength = Ability(17)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 120
    hit_dice = '16d8 + 48'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WeretigerHybridform(Monster):
    """
    Shapechanger.
      The weretiger can use its action to polymorph into a tiger-humanoid
      hybrid or into a tiger, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The weretiger has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Pounce.
      If the weretiger moves at least 15 feet straight toward a creature and
      then hits it with a claw attack on the same turn, that target must
      succeed on a DC 14 Strength saving throw or be knocked prone. If the
      target is prone, the weretiger can make one bite attack against it as
      a bonus action.
    Multiattack.
      In humanoid form, the weretiger makes two scimitar attacks or two
      longbow attacks. In hybrid form, it can attack like a humanoid or make
      two claw attacks.
    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 8 (1d10
      + 3) piercing damage. If the target is a humanoid, it must succeed on
      a DC 13 Constitution saving throw or be cursed with weretiger
      lycanthropy.
    Claw.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 7 (1d8 +
      3) slashing damage.
    Scimitar.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1d6 +
      3) slashing damage.
    Longbow.
      Ranged Weapon Attack: +4 to hit, range 150/600 ft., one target. Hit: 6
      (1d8 + 2) piercing damage.
    """
    name = 'Weretiger, Hybrid form'
    description = 'Medium humanoid, neutral'
    challenge_rating = 4
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = 'Common'
    strength = Ability(17)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 120
    hit_dice = '16d8'
    spells = []


class WeretigerTigerForm(Monster):
    """

    Shapechanger.
      The weretiger can use its action to polymorph into a tiger-humanoid
      hybrid or into a tiger, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The weretiger has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Pounce.
      If the weretiger moves at least 15 feet straight toward a creature and
      then hits it with a claw attack on the same turn, that target must
      succeed on a DC 14 Strength saving throw or be knocked prone. If the
      target is prone, the weretiger can make one bite attack against it as
      a bonus action.

    # Actions

    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 8 (1d10
      + 3) piercing damage. If the target is a humanoid, it must succeed on
      a DC 13 Constitution saving throw or be cursed with weretiger
      lycanthropy.
    Claw.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 7 (1d8 +
      3) slashing damage.
    """
    name = 'Weretiger, Tiger Form'
    description = 'Medium humanoid, neutral'
    challenge_rating = 4
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 120
    hit_dice = '16d8 + 48'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WeretigerTigerform(Monster):
    """
    Shapechanger.
      The weretiger can use its action to polymorph into a tiger-humanoid
      hybrid or into a tiger, or back into its true form, which is humanoid.
      Its statistics, other than its size, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The weretiger has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Pounce.
      If the weretiger moves at least 15 feet straight toward a creature and
      then hits it with a claw attack on the same turn, that target must
      succeed on a DC 14 Strength saving throw or be knocked prone. If the
      target is prone, the weretiger can make one bite attack against it as
      a bonus action.
    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 8 (1d10
      + 3) piercing damage. If the target is a humanoid, it must succeed on
      a DC 13 Constitution saving throw or be cursed with weretiger
      lycanthropy.
    Claw.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 7 (1d8 +
      3) slashing damage.
    """
    name = 'Weretiger, Tiger form'
    description = 'Medium humanoid, neutral'
    challenge_rating = 4
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 120
    hit_dice = '16d8'
    spells = []


class WerewolfHumanForm(Monster):
    """

    Shapechanger.
      The werewolf can use its action to polymorph into a wolf-humanoid
      hybrid or into a wolf, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The werewolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Multiattack.
      The werewolf makes two attacks: two with its spear (humanoid form) or
      one with its bite and one with its claws (hybrid form).
    Spear.
      Melee or Ranged Weapon Attack: +4 to hit, reach 5 ft. or range 20/60
      ft., one creature. Hit: 5 (1d6 + 2) piercing damage, or 6 (1d8 + 2)
      piercing damage if used with two hands to make a melee attack.
    """
    name = 'Werewolf, Human Form'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 3
    armor_class = 11
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = 'Common'
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 58
    hit_dice = '9d8 + 18'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerewolfHumanform(Monster):
    """
    Shapechanger.
      The werewolf can use its action to polymorph into a wolf-humanoid
      hybrid or into a wolf, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The werewolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Multiattack.
      The werewolf makes two attacks: two with its spear (humanoid form) or
      one with its bite and one with its claws (hybrid form).
    Spear.
      Melee or Ranged Weapon Attack: +4 to hit, reach 5 ft. or range 20/60
      ft., one creature. Hit: 5 (1d6 + 2) piercing damage, or 6 (1d8 + 2)
      piercing damage if used with two hands to make a melee attack.
    """
    name = 'Werewolf, Human form'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 3
    armor_class = 11
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = 'Common'
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 58
    hit_dice = '9d8'
    spells = []


class WerewolfHybridForm(Monster):
    """

    Shapechanger.
      The werewolf can use its action to polymorph into a wolf-humanoid
      hybrid or into a wolf, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The werewolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Multiattack.
      The werewolf makes two attacks: two with its spear (humanoid form) or
      one with its bite and one with its claws (hybrid form).
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 12 Constitution saving throw or be cursed with werewolf
      lycanthropy.
    Claws.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 7 (2d4
      + 2) slashing damage.
    """
    name = 'Werewolf, Hybrid Form'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 3
    armor_class = 11
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = 'Common'
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 58
    hit_dice = '9d8 + 18'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerewolfHybridform(Monster):
    """
    Shapechanger.
      The werewolf can use its action to polymorph into a wolf-humanoid
      hybrid or into a wolf, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The werewolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Multiattack.
      The werewolf makes two attacks: two with its spear (humanoid form) or
      one with its bite and one with its claws (hybrid form).
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 12 Constitution saving throw or be cursed with werewolf
      lycanthropy.
    Claws.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 7 (2d4
      + 2) slashing damage.
    """
    name = 'Werewolf, Hybrid form'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 3
    armor_class = 11
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = 'Common'
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 58
    hit_dice = '9d8'
    spells = []


class WerewolfWolfForm(Monster):
    """

    Shapechanger.
      The werewolf can use its action to polymorph into a wolf-humanoid
      hybrid or into a wolf, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The werewolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 12 Constitution saving throw or be cursed with werewolf
      lycanthropy.
    """
    name = 'Werewolf, Wolf Form'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 3
    armor_class = 11
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = ''
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 58
    hit_dice = '9d8 + 18'
    condition_immunities = ''
    damage_immunities = "bludgeoning, piercing, and slashing damage from nonmagical weapons that aren't silvered"
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WerewolfWolfform(Monster):
    """
    Shapechanger.
      The werewolf can use its action to polymorph into a wolf-humanoid
      hybrid or into a wolf, or back into its true form, which is humanoid.
      Its statistics, other than its AC, are the same in each form. Any
      equipment it is wearing or carrying isn't transformed. It reverts to
      its true form if it dies.
    Keen Hearing and Smell.
      The werewolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) piercing damage. If the target is a humanoid, it must succeed on a
      DC 12 Constitution saving throw or be cursed with werewolf
      lycanthropy.
    """
    name = 'Werewolf, Wolf form'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 3
    armor_class = 11
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = ''
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 58
    hit_dice = '9d8'
    spells = []


class WhiteDragonWyrmling(Monster):
    """

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 7 (1d10
      + 2) piercing damage plus 2 (1d4) cold damage.
    Cold Breath.
      The dragon exhales an icy blast of hail in a 15-foot cone. Each
      creature in that area must make a DC 12 Constitution saving throw,
      taking 22 (5d8) cold damage on a failed save, or half as much damage
      on a successful one.
    """
    name = 'White Dragon Wyrmling'
    description = 'Medium dragon, chaotic evil'
    challenge_rating = 2
    armor_class = 16
    skills = 'Perception +4, Stealth +2'
    senses = 'Blindsight 10 ft., Darkvision 60 ft., Passive Perception 14'
    languages = 'Draconic'
    strength = Ability(14)
    dexterity = Ability(10)
    constitution = Ability(14)
    intelligence = Ability(5)
    wisdom = Ability(10)
    charisma = Ability(11)
    speed = 30
    swim_speed = 30
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 15
    hp_max = 32
    hit_dice = '5d8 + 10'
    condition_immunities = ''
    damage_immunities = 'cold'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Wight(Monster):
    """

    Sunlight Sensitivity.
      While in sunlight, the wight has disadvantage on attack rolls, as well
      as on Wisdom (Perception) checks that rely on sight.

    # Actions

    Multiattack.
      The wight makes two longsword attacks or two longbow attacks. It can
      use its Life Drain in place of one longsword attack.
    Life Drain.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 5 (1d6
      + 2) necrotic damage. The target must succeed on a DC 13 Constitution
      saving throw or its hit point maximum is reduced by an amount equal to
      the damage taken. This reduction lasts until the target finishes a
      long rest. The target dies if this effect reduces its hit point
      maximum to 0.
      
      A humanoid slain by this attack rises 24 hours later as a zombie under
      the wight's control, unless the humanoid is restored to life or its
      body is destroyed. The wight can have no more than twelve zombies
      under its control at one time.
    Longsword.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) slashing damage, or 7 (1d10 + 2) slashing damage if used with two
      hands.
    Longbow.
      Ranged Weapon Attack: +4 to hit, range 150/600 ft., one target. Hit: 6
      (1d8 + 2) piercing damage.
    """
    name = 'Wight'
    description = 'Medium undead, neutral evil'
    challenge_rating = 3
    armor_class = 14
    skills = 'Perception +3, Stealth +4'
    senses = 'Darkvision 60 ft., Passive Perception 13'
    languages = 'the languages it knew in life'
    strength = Ability(15)
    dexterity = Ability(14)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(15)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 45
    hit_dice = '6d8 + 18'
    condition_immunities = 'exhaustion, poisoned'
    damage_immunities = 'poison'
    damage_resistances = 'necrotic'
    damage_vulnerabilities = ''
    spells = []


class WilloWisp(Monster):
    """

    Consume Life.
      As a bonus action, the will-o'-wisp can target one creature it can see
      within 5 ft. of it that has 0 hit points and is still alive. The
      target must succeed on a DC 10 Constitution saving throw against this
      magic or die. If the target dies, the will-o'-wisp regains 10 (3d6)
      hit points.
    Ephemeral.
      The will-o'-wisp can't wear or carry anything.
    Incorporeal Movement.
      The will-o'-wisp can move through other creatures and objects as if
      they were difficult terrain. It takes 5 (1d10) force damage if it ends
      its turn inside an object.
    Variable Illumination.
      The will-o'-wisp sheds bright light in a 5- to 20-foot radius and dim
      light for an additional number of ft. equal to the chosen radius. The
      will-o'-wisp can alter the radius as a bonus action.

    # Actions

    Shock.
      Melee Spell Attack: +4 to hit, reach 5 ft., one creature. Hit: 9 (2d8)
      lightning damage.
    Invisibility.
      The will-o'-wisp and its light magically become invisible until it
      attacks or uses its Consume Life, or until its concentration ends (as
      if concentrating on a spell).
    """
    name = "Will-o'-Wisp"
    description = 'Tiny undead, chaotic evil'
    challenge_rating = 2
    armor_class = 19
    skills = ''
    senses = 'Darkvision 120 ft., Passive Perception 12'
    languages = 'the languages it knew in life'
    strength = Ability(1)
    dexterity = Ability(28)
    constitution = Ability(10)
    intelligence = Ability(13)
    wisdom = Ability(14)
    charisma = Ability(11)
    speed = 0
    swim_speed = 0
    fly_speed = 50
    climb_speed = 0
    burrow_speed = 0
    hp_max = 22
    hit_dice = '9d4 + 0'
    condition_immunities = 'exhaustion, grappled, paralyzed, poisoned, prone, restrained, unconscious'
    damage_immunities = 'lightning, poison'
    damage_resistances = 'acid'
    damage_vulnerabilities = ''
    spells = []


class WingedKobold(Monster):
    """Sunlight Sensitivity.
      While in sunlight, the kobold has disadvantage on attack rolls,
      as well as on Wisdom (Perception) checks that rely on sight.
    Pack Tactics.
      The kobold has advantage on an attack roll against a creature if
      at least one of the kobold's allies is within 5 feet of the
      creature and the ally isn't incapacitated.

    # Actions

    Dagger.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 5
      (1d4 + 3) piercing damage.
    Dropped Rock.
      Ranged Weapon Attack: +5 to hit, one target directly below the
      kobold. Hit: 6 (1d6 + 3) bludgeoning damage.

    """
    name = 'Winged Kobold'
    description = 'Small humanoid (kobold), lawful evil'
    challenge_rating = 1 / 4
    armor_class = 13
    skills = ''
    senses = 'Darkvision 60 ft., passive Perception 8'
    languages = 'Common, Draconic'
    strength = Ability(7)
    dexterity = Ability(16)
    constitution = Ability(9)
    intelligence = Ability(8)
    wisdom = Ability(7)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 30
    climb_speed = 0
    burrow_speed = 0
    hp_max = 7
    hit_dice = '3d6 - 3'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class WinterWolf(Monster):
    """

    Keen Hearing and Smell.
      The wolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Pack Tactics.
      The wolf has advantage on an attack roll against a creature if at
      least one of the wolf's allies is within 5 ft. of the creature and the
      ally isn't incapacitated.
    Snow Camouflage.
      The wolf has advantage on Dexterity (Stealth) checks made to hide in
      snowy terrain.

    # Actions

    Bite.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) piercing damage. If the target is a creature, it must succeed on
      a DC 14 Strength saving throw or be knocked prone.
    Cold Breath.
      The wolf exhales a blast of freezing wind in a 15-foot cone. Each
      creature in that area must make a DC 12 Dexterity saving throw, taking
      18 (4d8) cold damage on a failed save, or half as much damage on a
      successful one.
    """
    name = 'Winter Wolf'
    description = 'Large monstrosity, neutral evil'
    challenge_rating = 3
    armor_class = 13
    skills = 'Perception +5, Stealth +3'
    senses = 'Passive Perception 15'
    languages = 'Common, Giant, Winter Wolf'
    strength = Ability(18)
    dexterity = Ability(13)
    constitution = Ability(14)
    intelligence = Ability(7)
    wisdom = Ability(12)
    charisma = Ability(8)
    speed = 50
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 75
    hit_dice = '10d10 + 20'
    condition_immunities = ''
    damage_immunities = 'cold'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Wolf(Monster):
    """

    Keen Hearing and Smell.
      The wolf has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Pack Tactics.
      The wolf has advantage on an attack roll against a creature if at
      least one of the wolf's allies is within 5 ft. of the creature and the
      ally isn't incapacitated.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 7 (2d4 +
      2) piercing damage. If the target is a creature, it must succeed on a
      DC 11 Strength saving throw or be knocked prone.
    """
    name = 'Wolf'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.25
    armor_class = 13
    skills = 'Perception +3, Stealth +4'
    senses = 'Passive Perception 13'
    languages = ''
    strength = Ability(12)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(3)
    wisdom = Ability(12)
    charisma = Ability(6)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 11
    hit_dice = '2d8 + 2'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Worg(Monster):
    """

    Keen Hearing and Smell.
      The worg has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) piercing damage. If the target is a creature, it must succeed on
      a DC 13 Strength saving throw or be knocked prone.
    """
    name = 'Worg'
    description = 'Large monstrosity, neutral evil'
    challenge_rating = 0.5
    armor_class = 13
    skills = 'Perception +4'
    senses = 'Darkvision 60 ft., Passive Perception 14'
    languages = 'Goblin, Worg'
    strength = Ability(16)
    dexterity = Ability(13)
    constitution = Ability(13)
    intelligence = Ability(7)
    wisdom = Ability(11)
    charisma = Ability(8)
    speed = 50
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 26
    hit_dice = '4d10 + 4'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Wraith(Monster):
    """

    Incorporeal Movement.
      The wraith can move through other creatures and objects as if they
      were difficult terrain. It takes 5 (1d10) force damage if it ends its
      turn inside an object.
    Sunlight Sensitivity.
      While in sunlight, the wraith has disadvantage on attack rolls, as
      well as on Wisdom (Perception) checks that rely on sight.

    # Actions

    Life Drain.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one creature. Hit: 21
      (4d8 + 3) necrotic damage. The target must succeed on a DC 14
      Constitution saving throw or its hit point maximum is reduced by an
      amount equal to the damage taken. This reduction lasts until the
      target finishes a long rest. The target dies if this effect reduces
      its hit point maximum to 0.
    Create Specter.
      The wraith targets a humanoid within 10 feet of it that has been dead
      for no longer than 1 minute and died violently. The target's spirit
      rises as a specter in the space of its corpse or in the nearest
      unoccupied space. The specter is under the wraith's control. The
      wraith can have no more than seven specters under its control at one
      time.
    """
    name = 'Wraith'
    description = 'Medium undead, neutral evil'
    challenge_rating = 5
    armor_class = 13
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 12'
    languages = 'the languages it knew in life'
    strength = Ability(6)
    dexterity = Ability(16)
    constitution = Ability(16)
    intelligence = Ability(12)
    wisdom = Ability(14)
    charisma = Ability(15)
    speed = 0
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 67
    hit_dice = '9d8 + 27'
    condition_immunities = 'charmed, exhaustion, grappled, paralyzed, petrified, poisoned, prone, restrained'
    damage_immunities = 'necrotic, poison'
    damage_resistances = 'acid'
    damage_vulnerabilities = ''
    spells = []


class Wyvern(Monster):
    """

    # Actions

    Multiattack.
      The wyvern makes two attacks: one with its bite and one with its
      stinger. While flying, it can use its claws in place of one other
      attack.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one creature. Hit: 11
      (2d6 + 4) piercing damage.
    Claws.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    Stinger.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one creature. Hit: 11
      (2d6 + 4) piercing damage. The target must make a DC 15 Constitution
      saving throw, taking 24 (7d6) poison damage on a failed save, or half
      as much damage on a successful one.
    """
    name = 'Wyvern'
    description = 'Large dragon, unaligned'
    challenge_rating = 6
    armor_class = 13
    skills = 'Perception +4'
    senses = 'Darkvision 60 ft., Passive Perception 14'
    languages = ''
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(16)
    intelligence = Ability(5)
    wisdom = Ability(12)
    charisma = Ability(6)
    speed = 20
    swim_speed = 0
    fly_speed = 80
    climb_speed = 0
    burrow_speed = 0
    hp_max = 110
    hit_dice = '13d10 + 39'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []
