"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class Nalfeshnee(Monster):
    """

    Magic Resistance.
      The nalfeshnee has advantage on saving throws against spells and other
      magical effects.

    # Actions

    Multiattack.
      The nalfeshnee uses Horror Nimbus if it can. It then makes three
      attacks: one with its bite and two with its claws.
    Bite.
      Melee Weapon Attack: +10 to hit, reach 5 ft., one target. Hit: 32
      (5d10 + 5) piercing damage.
    Claw.
      Melee Weapon Attack: +10 to hit, reach 10 ft., one target. Hit: 15
      (3d6 + 5) slashing damage.
    Horror Nimbus.
      The nalfeshnee magically emits scintillating, multicolored light. Each
      creature within 15 feet of the nalfeshnee that can see the light must
      succeed on a DC 15 Wisdom saving throw or be frightened for 1 minute.
      A creature can repeat the saving throw at the end of each of its
      turns, ending the effect on itself on a success. If a creature's
      saving throw is successful or the effect ends for it, the creature is
      immune to the nalfeshnee's Horror Nimbus for the next 24 hours.
    Teleport.
      The nalfeshnee magically teleports, along with any equipment it is
      wearing or carrying, up to 120 feet to an unoccupied space it can see.
    Variant: Summon Demon.
      The demon chooses what to summon and attempts a magical summoning.
      
      A nalfeshnee has a 50 percent chance of summoning 1d4 vrocks, 1d3
      hezrous, 1d2 glabrezus, or one nalfeshnee.
      
      A summoned demon appears in an unoccupied space within 60 feet of its
      summoner, acts as an ally of its summoner, and can't summon other
      demons. It remains for 1 minute, until it or its summoner dies, or
      until its summoner dismisses it as an action.
    """
    name = 'Nalfeshnee'
    description = 'Large fiend, chaotic evil'
    challenge_rating = 13
    armor_class = 18
    skills = ''
    senses = 'Truesight 120 ft., Passive Perception 11'
    languages = 'Abyssal, telepathy 120 ft.'
    strength = Ability(21)
    dexterity = Ability(10)
    constitution = Ability(22)
    intelligence = Ability(19)
    wisdom = Ability(12)
    charisma = Ability(15)
    speed = 20
    swim_speed = 0
    fly_speed = 30
    climb_speed = 0
    burrow_speed = 0
    hp_max = 184
    hit_dice = '16d10 + 96'
    condition_immunities = 'poisoned'
    damage_immunities = 'poison'
    damage_resistances = 'cold'
    damage_vulnerabilities = ''
    spells = []


class NightHag(Monster):
    """

    Innate Spellcasting.
      The hag's innate spellcasting ability is Charisma (spell save DC 14,
      +6 to hit with spell attacks). She can innately cast the following
      spells, requiring no material components:
      
  
      
      At will: detect magic, magic missile
      
      2/day each: plane shift (self only), ray of enfeeblement, sleep
    Magic Resistance.
      The hag has advantage on saving throws against spells and other
      magical effects.
    Night Hag Items.
      A night hag carries two very rare magic items that she must craft for
      herself If either object is lost, the night hag will go to great
      lengths to retrieve it, as creating a new tool takes time and effort.
      
      Heartstone: This lustrous black gem allows a night hag to become
      ethereal while it is in her possession. The touch of a heartstone also
      cures any disease. Crafting a heartstone takes 30 days.
      
      Soul Bag: When an evil humanoid dies as a result of a night hag's
      Nightmare Haunting, the hag catches the soul in this black sack made
      of stitched flesh. A soul bag can hold only one evil soul at a time,
      and only the night hag who crafted the bag can catch a soul with it.
      Crafting a soul bag takes 7 days and a humanoid sacrifice (whose flesh
      is used to make the bag).

    # Actions

    Claws (Hag Form Only).
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    Change Shape.
      The hag magically polymorphs into a Small or Medium female humanoid,
      or back into her true form. Her statistics are the same in each form.
      Any equipment she is wearing or carrying isn't transformed. She
      reverts to her true form if she dies.
    Etherealness.
      The hag magically enters the Ethereal Plane from the Material Plane,
      or vice versa. To do so, the hag must have a heartstone in her
      possession.
    Nightmare Haunting.
      While on the Ethereal Plane, the hag magically touches a sleeping
      humanoid on the Material Plane. A protection from evil and good spell
      cast on the target prevents this contact, as does a magic circle. As
      long as the contact persists, the target has dreadful visions. If
      these visions last for at least 1 hour, the target gains no benefit
      from its rest, and its hit point maximum is reduced by 5 (1d10). If
      this effect reduces the target's hit point maximum to 0, the target
      dies, and if the target was evil, its soul is trapped in the hag's
      soul bag. The reduction to the target's hit point maximum lasts until
      removed by the greater restoration spell or similar magic.
    """
    name = 'Night Hag'
    description = 'Medium fiend, neutral evil'
    challenge_rating = 5
    armor_class = 17
    skills = 'Deception +7, Insight +6, Perception +6, Stealth +6'
    senses = 'Darkvision 120 ft., Passive Perception 16'
    languages = 'Abyssal, Common, Infernal, Primordial'
    strength = Ability(18)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(16)
    wisdom = Ability(14)
    charisma = Ability(16)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 112
    hit_dice = '15d8 + 45'
    condition_immunities = 'charmed'
    damage_immunities = ''
    damage_resistances = 'cold'
    damage_vulnerabilities = ''
    spells = []


class Nightmare(Monster):
    """

    Confer Fire Resistance.
      The nightmare can grant resistance to fire damage to anyone riding it.
    Illumination.
      The nightmare sheds bright light in a 10-foot radius and dim light for
      an additional 10 feet.

    # Actions

    Hooves.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) bludgeoning damage plus 7 (2d6) fire damage.
    Ethereal Stride.
      The nightmare and up to three willing creatures within 5 feet of it
      magically enter the Ethereal Plane from the Material Plane, or vice
      versa.
    """
    name = 'Nightmare'
    description = 'Large fiend, neutral evil'
    challenge_rating = 3
    armor_class = 13
    skills = ''
    senses = 'Passive Perception 11'
    languages = "understands Abyssal, Common, and Infernal but can't speak"
    strength = Ability(18)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(13)
    charisma = Ability(15)
    speed = 60
    swim_speed = 0
    fly_speed = 90
    climb_speed = 0
    burrow_speed = 0
    hp_max = 68
    hit_dice = '8d10 + 24'
    condition_immunities = ''
    damage_immunities = 'fire'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Noble(Monster):
    """

    # Actions

    Rapier.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 5 (1d8 +
      1) piercing damage.

    # Reactions

    Parry.
      The noble adds 2 to its AC against one melee attack that would hit it.
      To do so, the noble must see the attacker and be wielding a melee
      weapon.
    """
    name = 'Noble'
    description = 'Medium humanoid, any alignment'
    challenge_rating = 0.125
    armor_class = 15
    skills = 'Deception +5, Insight +4, Persuasion +5'
    senses = 'Passive Perception 12'
    languages = 'any two languages'
    strength = Ability(11)
    dexterity = Ability(12)
    constitution = Ability(11)
    intelligence = Ability(12)
    wisdom = Ability(14)
    charisma = Ability(16)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 9
    hit_dice = '2d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Nothic(Monster):
    """Keen Sight
      The nothic has advantage on Wisdom (Perception) checks that rely
      on sight.
    Multiattack
      The nothic makes two claw attacks.
    Claw
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6
      (1d6 + 3) slashing damage.
    Rotting Gaze
      The nothic targets one creature it can see within 30 feet of
      it. The target must succeed on a DC 12 Constitution saving throw
      against this magic or take 10 (3d6) necrotic damage.
    Weird Insight
      The nothic targets one creature it can see within 30 feet of
      it. The target must contest its Charisma (Deception) check
      against the nothic’s Wisdom (Insight) check. If the nothic wins,
      it magically learns one fact or secret about the target. The
      target automatically wins if it is immune to being charmed.
    """
    name = 'Nothic'
    description = 'Medium aberration, neutral evil'
    challenge_rating = 2.0
    armor_class = 15
    skills = 'Arcana +3, Insight +4, Perception +2, Stealth +5'
    senses = 'Truesight 120ft., Passive Perception 12'
    languages = 'Undercommon'
    strength = Ability(14)
    dexterity = Ability(16)
    constitution = Ability(16)
    intelligence = Ability(13)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 45
    hit_dice = '6d8+18'
    spells = []
