"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class Gargoyle(Monster):
    """

    False Appearance.
      While the gargoyle remains motion less, it is indistinguishable from
      an inanimate statue.

    # Actions

    Multiattack.
      The gargoyle makes two attacks: one with its bite and one with its
      claws.
    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) piercing damage.
    Claws.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) slashing damage.
    """
    name = 'Gargoyle'
    description = 'Medium elemental, chaotic evil'
    challenge_rating = 2
    armor_class = 15
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = 'Terran'
    strength = Ability(15)
    dexterity = Ability(11)
    constitution = Ability(16)
    intelligence = Ability(6)
    wisdom = Ability(11)
    charisma = Ability(7)
    speed = 30
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 52
    hit_dice = '7d8 + 21'
    condition_immunities = 'exhaustion, petrified, poisoned'
    damage_immunities = 'poison'
    damage_resistances = "bludgeoning, piercing, and slashing from nonmagical weapons that aren't adamantine"
    damage_vulnerabilities = ''
    spells = []


class GelatinousCube(Monster):
    """

    Ooze Cube.
      The cube takes up its entire space. Other creatures can enter the
      space, but a creature that does so is subjected to the cube's Engulf
      and has disadvantage on the saving throw.
      
      Creatures inside the cube can be seen but have total cover.
      
      A creature within 5 feet of the cube can take an action to pull a
      creature or object out of the cube. Doing so requires a successful DC
      12 Strength check, and the creature making the attempt takes 10 (3d6)
      acid damage.
      
      The cube can hold only one Large creature or up to four Medium or
      smaller creatures inside it at a time.
    Transparent.
      Even when the cube is in plain sight, it takes a successful DC 15
      Wisdom (Perception) check to spot a cube that has neither moved nor
      attacked. A creature that tries to enter the cube's space while
      unaware of the cube is surprised by the cube.

    # Actions

    Pseudopod.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 10
      (3d6) acid damage.
    Engulf.
      The cube moves up to its speed. While doing so, it can enter Large or
      smaller creatures' spaces. Whenever the cube enters a creature's
      space, the creature must make a DC 12 Dexterity saving throw.
      
      On a successful save, the creature can choose to be pushed 5 feet back
      or to the side of the cube. A creature that chooses not to be pushed
      suffers the consequences of a failed saving throw.
      
      On a failed save, the cube enters the creature's space, and the
      creature takes 10 (3d6) acid damage and is engulfed. The engulfed
      creature can't breathe, is restrained, and takes 21 (6d6) acid damage
      at the start of each of the cube's turns. When the cube moves, the
      engulfed creature moves with it.
      
      An engulfed creature can try to escape by taking an action to make a
      DC 12 Strength check. On a success, the creature escapes and enters a
      space of its choice within 5 feet of the cube.
    """
    name = 'Gelatinous Cube'
    description = 'Large ooze, unaligned'
    challenge_rating = 2
    armor_class = 6
    skills = ''
    senses = 'Blindsight 60 ft. (blind beyond this radius), Passive Perception 8'
    languages = ''
    strength = Ability(14)
    dexterity = Ability(3)
    constitution = Ability(20)
    intelligence = Ability(1)
    wisdom = Ability(6)
    charisma = Ability(1)
    speed = 15
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 84
    hit_dice = '8d10 + 40'
    condition_immunities = 'blinded, charmed, blinded, exhaustion, frightened, prone'
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Ghast(Monster):
    """

    Stench.
      Any creature that starts its turn within 5 ft. of the ghast must
      succeed on a DC 10 Constitution saving throw or be poisoned until the
      start of its next turn. On a successful saving throw, the creature is
      immune to the ghast's Stench for 24 hours.
    Turn Defiance.
      The ghast and any ghouls within 30 ft. of it have advantage on saving
      throws against effects that turn undead.

    # Actions

    Bite.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one creature. Hit: 12
      (2d8 + 3) piercing damage.
    Claws.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage. If the target is a creature other than an
      undead, it must succeed on a DC 10 Constitution saving throw or be
      paralyzed for 1 minute. The target can repeat the saving throw at the
      end of each of its turns, ending the effect on itself on a success.
    """
    name = 'Ghast'
    description = 'Medium undead, chaotic evil'
    challenge_rating = 2
    armor_class = 13
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = 'Common'
    strength = Ability(16)
    dexterity = Ability(17)
    constitution = Ability(10)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 36
    hit_dice = '8d8 + 0'
    condition_immunities = 'poisoned'
    damage_immunities = 'necrotic'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Ghost(Monster):
    """

    Ethereal Sight.
      The ghost can see 60 ft. into the Ethereal Plane when it is on the
      Material Plane, and vice versa.
    Incorporeal Movement.
      The ghost can move through other creatures and objects as if they were
      difficult terrain. It takes 5 (1d10) force damage if it ends its turn
      inside an object.

    # Actions

    Withering Touch.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 17 (4d6
      + 3) necrotic damage.
    Etherealness.
      The ghost enters the Ethereal Plane from the Material Plane, or vice
      versa. It is visible on the Material Plane while it is in the Border
      Ethereal, and vice versa, yet it can't affect or be affected by
      anything on the other plane.
    Horrifying Visage.
      Each non-undead creature within 60 ft. of the ghost that can see it
      must succeed on a DC 13 Wisdom saving throw or be frightened for 1
      minute. If the save fails by 5 or more, the target also ages 1d4 + 10
      years. A frightened target can repeat the saving throw at the end of
      each of its turns, ending the frightened condition on itself on a
      success. If a target's saving throw is successful or the effect ends
      for it, the target is immune to this ghost's Horrifying Visage for the
      next 24 hours. The aging effect can be reversed with a greater
      restoration spell, but only within 24 hours of it occurring.
    Possession (Recharge 6).
      One humanoid that the ghost can see within 5 ft. of it must succeed on
      a DC 13 Charisma saving throw or be possessed by the ghost; the ghost
      then disappears, and the target is incapacitated and loses control of
      its body. The ghost now controls the body but doesn't deprive the
      target of awareness. The ghost can't be targeted by any attack, spell,
      or other effect, except ones that turn undead, and it retains its
      alignment, Intelligence, Wisdom, Charisma, and immunity to being
      charmed and frightened. It otherwise uses the possessed target's
      statistics, but doesn't gain access to the target's knowledge, class
      features, or proficiencies.
      
      The possession lasts until the body drops to 0 hit points, the ghost
      ends it as a bonus action, or the ghost is turned or forced out by an
      effect like the dispel evil and good spell. When the possession ends,
      the ghost reappears in an unoccupied space within 5 ft. of the body.
      The target is immune to this ghost's Possession for 24 hours after
      succeeding on the saving throw or after the possession ends.
    """
    name = 'Ghost'
    description = 'Medium undead, any alignment'
    challenge_rating = 4
    armor_class = 11
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 11'
    languages = 'any languages it knew in life'
    strength = Ability(7)
    dexterity = Ability(13)
    constitution = Ability(10)
    intelligence = Ability(10)
    wisdom = Ability(12)
    charisma = Ability(17)
    speed = 0
    swim_speed = 0
    fly_speed = 40
    climb_speed = 0
    burrow_speed = 0
    hp_max = 45
    hit_dice = '10d8 + 0'
    condition_immunities = 'charmed, exhaustion, frightened, grappled, paralyzed, petrified, poisoned, prone, restrained'
    damage_immunities = 'cold, necrotic, poison'
    damage_resistances = 'acid'
    damage_vulnerabilities = ''
    spells = []


class Ghoul(Monster):
    """

    # Actions

    Bite.
      Melee Weapon Attack: +2 to hit, reach 5 ft., one creature. Hit: 9 (2d6
      + 2) piercing damage.
    Claws.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 7 (2d4 +
      2) slashing damage. If the target is a creature other than an elf or
      undead, it must succeed on a DC 10 Constitution saving throw or be
      paralyzed for 1 minute. The target can repeat the saving throw at the
      end of each of its turns, ending the effect on itself on a success.
    """
    name = 'Ghoul'
    description = 'Medium undead, chaotic evil'
    challenge_rating = 1
    armor_class = 12
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = 'Common'
    strength = Ability(13)
    dexterity = Ability(15)
    constitution = Ability(10)
    intelligence = Ability(7)
    wisdom = Ability(10)
    charisma = Ability(6)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 22
    hit_dice = '5d8 + 0'
    condition_immunities = 'poisoned'
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantApe(Monster):
    """

    # Actions

    Multiattack.
      The ape makes two fist attacks.
    Fist.
      Melee Weapon Attack: +9 to hit, reach 10 ft., one target. Hit: 22
      (3d10 + 6) bludgeoning damage.
    Rock.
      Ranged Weapon Attack: +9 to hit, range 50/100 ft., one target. Hit: 30
      (7d6 + 6) bludgeoning damage.
    """
    name = 'Giant Ape'
    description = 'Huge beast, unaligned'
    challenge_rating = 7
    armor_class = 12
    skills = 'Athletics +9, Perception +4'
    senses = 'Passive Perception 14'
    languages = ''
    strength = Ability(23)
    dexterity = Ability(14)
    constitution = Ability(18)
    intelligence = Ability(7)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 40
    burrow_speed = 0
    hp_max = 157
    hit_dice = '15d12 + 60'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantBadger(Monster):
    """

    Keen Smell.
      The badger has advantage on Wisdom (Perception) checks that rely on
      smell.

    # Actions

    Multiattack.
      The badger makes two attacks: one with its bite and one with its
      claws.
    Bite.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 4 (1d6 +
      1) piercing damage.
    Claws.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 6 (2d4 +
      1) slashing damage.
    """
    name = 'Giant Badger'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.25
    armor_class = 10
    skills = ''
    senses = 'Darkvision 30 ft., Passive Perception 11'
    languages = ''
    strength = Ability(13)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(5)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 10
    hp_max = 13
    hit_dice = '2d8 + 4'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantBat(Monster):
    """

    Echolocation.
      The bat can't use its blindsight while deafened.
    Keen Hearing.
      The bat has advantage on Wisdom (Perception) checks that rely on
      hearing.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 5 (1d6
      + 2) piercing damage.
    """
    name = 'Giant Bat'
    description = 'Large beast, unaligned'
    challenge_rating = 0.25
    armor_class = 13
    skills = ''
    senses = 'Blindsight 60 ft., Passive Perception 11'
    languages = ''
    strength = Ability(15)
    dexterity = Ability(16)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(6)
    speed = 10
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 22
    hit_dice = '4d10 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantBoar(Monster):
    """

    Charge.
      If the boar moves at least 20 ft. straight toward a target and then
      hits it with a tusk attack on the same turn, the target takes an extra
      7 (2d6) slashing damage. If the target is a creature, it must succeed
      on a DC 13 Strength saving throw or be knocked prone.
    Relentless.
      If the boar takes 10 damage or less that would reduce it to 0 hit
      points, it is reduced to 1 hit point instead.

    # Actions

    Tusk.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage.
    """
    name = 'Giant Boar'
    description = 'Large beast, unaligned'
    challenge_rating = 2
    armor_class = 12
    skills = ''
    senses = 'Passive Perception 8'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(10)
    constitution = Ability(16)
    intelligence = Ability(2)
    wisdom = Ability(7)
    charisma = Ability(5)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 42
    hit_dice = '5d10 + 15'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantCentipede(Monster):
    """

    # Actions

    Bite.
      Bite. Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit:
      4 (1d4 + 2) piercing damage, and the target must succeed on a DC 11
      Constitution saving throw or take 10 (3d6) poison damage. If the
      poison damage reduces the target to 0 hit points, the target is stable
      but poisoned for 1 hour, even after regaining hit points, and is
      paralyzed while poisoned in this way.
    """
    name = 'Giant Centipede'
    description = 'Small beast, unaligned'
    challenge_rating = 0.25
    armor_class = 13
    skills = ''
    senses = 'Blindsight 30 ft., Passive Perception 8'
    languages = ''
    strength = Ability(5)
    dexterity = Ability(14)
    constitution = Ability(12)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(3)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    burrow_speed = 0
    hp_max = 4
    hit_dice = '1d6 + 1'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantConstrictorSnake(Monster):
    """

    # Actions

    Bite.
      Melee Weapon Attack: +6 to hit, reach 10 ft., one creature. Hit: 11
      (2d6 + 4) piercing damage.
    Constrict.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one creature. Hit: 13
      (2d8 + 4) bludgeoning damage, and the target is grappled (escape DC
      16). Until this grapple ends, the creature is restrained, and the
      snake can't constrict another target.
    """
    name = 'Giant Constrictor Snake'
    description = 'Huge beast, unaligned'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +2'
    senses = 'Blindsight 10 ft., Passive Perception 12'
    languages = ''
    strength = Ability(19)
    dexterity = Ability(14)
    constitution = Ability(12)
    intelligence = Ability(1)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 30
    swim_speed = 30
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 60
    hit_dice = '8d12 + 8'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantCrab(Monster):
    """

    Amphibious.
      The crab can breathe air and water.

    # Actions

    Claw.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 4 (1d6 +
      1) bludgeoning damage, and the target is grappled (escape DC 11). The
      crab has two claws, each of which can grapple only one target.
    """
    name = 'Giant Crab'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.125
    armor_class = 15
    skills = 'Stealth +4'
    senses = 'Blindsight 30 ft., Passive Perception 9'
    languages = ''
    strength = Ability(13)
    dexterity = Ability(15)
    constitution = Ability(11)
    intelligence = Ability(1)
    wisdom = Ability(9)
    charisma = Ability(3)
    speed = 30
    swim_speed = 30
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 13
    hit_dice = '3d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantCrocodile(Monster):
    """

    Hold Breath.
      The crocodile can hold its breath for 30 minutes.

    # Actions

    Multiattack.
      The crocodile makes two attacks: one with its bite and one with its
      tail.
    Bite.
      Melee Weapon Attack: +8 to hit, reach 5 ft., one target. Hit: 21 (3d10
      + 5) piercing damage, and the target is grappled (escape DC 16). Until
      this grapple ends, the target is restrained, and the crocodile can't
      bite another target.
    Tail.
      Melee Weapon Attack: +8 to hit, reach 10 ft., one target not grappled
      by the crocodile. Hit: 14 (2d8 + 5) bludgeoning damage. If the target
      is a creature, it must succeed on a DC 16 Strength saving throw or be
      knocked prone.
    """
    name = 'Giant Crocodile'
    description = 'Huge beast, unaligned'
    challenge_rating = 5
    armor_class = 14
    skills = 'Stealth +5'
    senses = 'Passive Perception 10'
    languages = ''
    strength = Ability(21)
    dexterity = Ability(9)
    constitution = Ability(17)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(7)
    speed = 30
    swim_speed = 50
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 85
    hit_dice = '9d12 + 27'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantEagle(Monster):
    """

    Keen Sight.
      The eagle has advantage on Wisdom (Perception) checks that rely on
      sight.

    # Actions

    Multiattack.
      The eagle makes two attacks: one with its beak and one with its
      talons.
    Beak.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1d6 +
      3) piercing damage.
    Talons.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) slashing damage.
    """
    name = 'Giant Eagle'
    description = 'Large beast, neutral good'
    challenge_rating = 1
    armor_class = 13
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = "Giant Eagle, understands Common and Auran but can't speak"
    strength = Ability(16)
    dexterity = Ability(17)
    constitution = Ability(13)
    intelligence = Ability(8)
    wisdom = Ability(14)
    charisma = Ability(10)
    speed = 10
    swim_speed = 0
    fly_speed = 80
    climb_speed = 0
    burrow_speed = 0
    hp_max = 26
    hit_dice = '4d10 + 4'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantElk(Monster):
    """

    Charge.
      If the elk moves at least 20 ft. straight toward a target and then
      hits it with a ram attack on the same turn, the target takes an extra
      7 (2d6) damage. If the target is a creature, it must succeed on a DC
      14 Strength saving throw or be knocked prone.

    # Actions

    Ram.
      Melee Weapon Attack: +6 to hit, reach 10 ft., one target. Hit: 11 (2d6
      + 4) bludgeoning damage.
    Hooves.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one prone creature. Hit:
      22 (4d8 + 4) bludgeoning damage.
    """
    name = 'Giant Elk'
    description = 'Huge beast, unaligned'
    challenge_rating = 2
    armor_class = 15
    skills = 'Perception +4'
    senses = 'Passive Perception 14'
    languages = "Giant Elk, understands Common, Elvish, and Sylvan but can't speak"
    strength = Ability(19)
    dexterity = Ability(16)
    constitution = Ability(14)
    intelligence = Ability(7)
    wisdom = Ability(14)
    charisma = Ability(10)
    speed = 60
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 42
    hit_dice = '5d12 + 10'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantFireBeetle(Monster):
    """

    Illumination.
      The beetle sheds bright light in a 10-foot radius and dim light for an
      additional 10 ft..

    # Actions

    Bite.
      Melee Weapon Attack: +1 to hit, reach 5 ft., one target. Hit: 2 (1d6 -
      1) slashing damage.
    """
    name = 'Giant Fire Beetle'
    description = 'Small beast, unaligned'
    challenge_rating = 0
    armor_class = 13
    skills = ''
    senses = 'Blindsight 30 ft., Passive Perception 8'
    languages = ''
    strength = Ability(8)
    dexterity = Ability(10)
    constitution = Ability(12)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(3)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 4
    hit_dice = '1d6 + 1'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantFrog(Monster):
    """

    Amphibious.
      The frog can breathe air and water
    Standing Leap.
      The frog's long jump is up to 20 ft. and its high jump is up to 10
      ft., with or without a running start.

    # Actions

    Bite.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 4 (1d6 +
      1) piercing damage, and the target is grappled (escape DC 11). Until
      this grapple ends, the target is restrained, and the frog can't bite
      another target.
    Swallow.
      The frog makes one bite attack against a Small or smaller target it is
      grappling. If the attack hits, the target is swallowed, and the
      grapple ends. The swallowed target is blinded and restrained, it has
      total cover against attacks and other effects outside the frog, and it
      takes 5 (2d4) acid damage at the start of each of the frog's turns.
      The frog can have only one target swallowed at a time. If the frog
      dies, a swallowed creature is no longer restrained by it and can
      escape from the corpse using 5 ft. of movement, exiting prone.
    """
    name = 'Giant Frog'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.25
    armor_class = 11
    skills = 'Perception +2, Stealth +3'
    senses = 'Darkvision 30 ft., Passive Perception 12'
    languages = ''
    strength = Ability(12)
    dexterity = Ability(13)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 30
    swim_speed = 30
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 18
    hit_dice = '4d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantGoat(Monster):
    """

    Charge.
      If the goat moves at least 20 ft. straight toward a target and then
      hits it with a ram attack on the same turn, the target takes an extra
      5 (2d4) bludgeoning damage. If the target is a creature, it must
      succeed on a DC 13 Strength saving throw or be knocked prone.
    Sure-Footed.
      The goat has advantage on Strength and Dexterity saving throws made
      against effects that would knock it prone.

    # Actions

    Ram.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 8 (2d4 +
      3) bludgeoning damage.
    """
    name = 'Giant Goat'
    description = 'Large beast, unaligned'
    challenge_rating = 0.5
    armor_class = 11
    skills = ''
    senses = 'Passive Perception 11'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(11)
    constitution = Ability(12)
    intelligence = Ability(3)
    wisdom = Ability(12)
    charisma = Ability(6)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 19
    hit_dice = '3d10 + 3'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantHyena(Monster):
    """

    Rampage.
      When the hyena reduces a creature to 0 hit points with a melee attack
      on its turn, the hyena can take a bonus action to move up to half its
      speed and make a bite attack.

    # Actions

    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) piercing damage.
    """
    name = 'Giant Hyena'
    description = 'Large beast, unaligned'
    challenge_rating = 1
    armor_class = 12
    skills = 'Perception +3'
    senses = 'Passive Perception 13'
    languages = ''
    strength = Ability(16)
    dexterity = Ability(14)
    constitution = Ability(14)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 50
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 45
    hit_dice = '6d10 + 12'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantLizard(Monster):
    """

    Variant: Hold Breath.
      The lizard can hold its breath for 15 minutes. (A lizard that has this
      trait also has a swimming speed of 30 feet.)
    Variant: Spider Climb.
      The lizard can climb difficult surfaces, including upside down on
      ceilings, without needing to make an ability check.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) piercing damage.
    """
    name = 'Giant Lizard'
    description = 'Large beast, unaligned'
    challenge_rating = 0.25
    armor_class = 12
    skills = ''
    senses = 'Darkvision 30 ft., Passive Perception 10'
    languages = ''
    strength = Ability(15)
    dexterity = Ability(12)
    constitution = Ability(13)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(5)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    burrow_speed = 0
    hp_max = 19
    hit_dice = '3d10 + 3'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantOctopus(Monster):
    """

    Hold Breath.
      While out of water, the octopus can hold its breath for 1 hour.
    Underwater Camouflage.
      The octopus has advantage on Dexterity (Stealth) checks made while
      underwater.
    Water Breathing.
      The octopus can breathe only underwater.

    # Actions

    Tentacles.
      Melee Weapon Attack: +5 to hit, reach 15 ft., one target. Hit: 10 (2d6
      + 3) bludgeoning damage. If the target is a creature, it is grappled
      (escape DC 16). Until this grapple ends, the target is restrained, and
      the octopus can't use its tentacles on another target.
    Ink Cloud.
      A 20-foot-radius cloud of ink extends all around the octopus if it is
      underwater. The area is heavily obscured for 1 minute, although a
      significant current can disperse the ink. After releasing the ink, the
      octopus can use the Dash action as a bonus action.
    """
    name = 'Giant Octopus'
    description = 'Large beast, unaligned'
    challenge_rating = 1
    armor_class = 11
    skills = 'Perception +4, Stealth +5'
    senses = 'Darkvision 60 ft., Passive Perception 14'
    languages = ''
    strength = Ability(17)
    dexterity = Ability(13)
    constitution = Ability(13)
    intelligence = Ability(4)
    wisdom = Ability(10)
    charisma = Ability(4)
    speed = 10
    swim_speed = 60
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 52
    hit_dice = '8d10 + 8'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantOwl(Monster):
    """

    Flyby.
      The owl doesn't provoke opportunity attacks when it flies out of an
      enemy's reach.
    Keen Hearing and Sight.
      The owl has advantage on Wisdom (Perception) checks that rely on
      hearing or sight.

    # Actions

    Talons.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 8 (2d6 +
      1) slashing damage.
    """
    name = 'Giant Owl'
    description = 'Large beast, neutral'
    challenge_rating = 0.25
    armor_class = 12
    skills = 'Perception +5, Stealth +4'
    senses = 'Darkvision 120 ft., Passive Perception 15'
    languages = "Giant Owl, understands Common, Elvish, and Sylvan but can't speak"
    strength = Ability(13)
    dexterity = Ability(15)
    constitution = Ability(12)
    intelligence = Ability(8)
    wisdom = Ability(13)
    charisma = Ability(10)
    speed = 5
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 19
    hit_dice = '3d10 + 3'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantPoisonousSnake(Monster):
    """

    # Actions

    Bite.
      Melee Weapon Attack: +6 to hit, reach 10 ft., one target. Hit: 6 (1d4
      + 4) piercing damage, and the target must make a DC 11 Constitution
      saving throw, taking 10 (3d6) poison damage on a failed save, or half
      as much damage on a successful one.
    """
    name = 'Giant Poisonous Snake'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.25
    armor_class = 14
    skills = 'Perception +2'
    senses = 'Blindsight 10 ft., Passive Perception 12'
    languages = ''
    strength = Ability(10)
    dexterity = Ability(18)
    constitution = Ability(13)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 30
    swim_speed = 30
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 11
    hit_dice = '2d8 + 2'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantRat(Monster):
    """

    Keen Smell.
      The rat has advantage on Wisdom (Perception) checks that rely on
      smell.
    Pack Tactics.
      The rat has advantage on an attack roll against a creature if at least
      one of the rat's allies is within 5 ft. of the creature and the ally
      isn't incapacitated.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 4 (1d4 +
      2) piercing damage.
    """
    name = 'Giant Rat'
    description = 'Small beast, unaligned'
    challenge_rating = 0.125
    armor_class = 12
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = ''
    strength = Ability(7)
    dexterity = Ability(15)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(4)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 7
    hit_dice = '2d6 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantRatDiseased(Monster):
    """

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 3 (1d4 +
      2) piercing damage. If the target is a creature, it must succeed on a
      DC 10 Constitution saving throw or contract a disease. Until the
      disease is cured, the target can't regain hit points except by magical
      means, and the target's hit point maximum decreases by 3 (1d6) every
      24 hours. If the target's hit point maximum drops to 0 as a result of
      this disease, the target dies.
    """
    name = 'Giant Rat (Diseased)'
    description = 'Small beast, unaligned'
    challenge_rating = 0.125
    armor_class = 12
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = ''
    strength = Ability(7)
    dexterity = Ability(15)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(4)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 7
    hit_dice = '2d6 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantScorpion(Monster):
    """

    # Actions

    Claw.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 6 (1d8 +
      2) bludgeoning damage, and the target is grappled (escape DC 12). The
      scorpion has two claws, each of which can grapple only one target.
    Multiattack.
      The scorpion makes three attacks: two with its claws and one with its
      sting.
    Sting.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 7
      (1d10 + 2) piercing damage, and the target must make a DC 12
      Constitution saving throw, taking 22 (4d10) poison damage on a failed
      save, or half as much damage on a successful one.
    """
    name = 'Giant Scorpion'
    description = 'Large beast, unaligned'
    challenge_rating = 3
    armor_class = 15
    skills = ''
    senses = 'Blindsight 60 ft., Passive Perception 9'
    languages = ''
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(15)
    intelligence = Ability(1)
    wisdom = Ability(9)
    charisma = Ability(3)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 52
    hit_dice = '7d10 + 14'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantSeaHorse(Monster):
    """

    Charge.
      If the sea horse moves at least 20 ft. straight toward a target and
      then hits it with a ram attack on the same turn, the target takes an
      extra 7 (2d6) bludgeoning damage. If the target is a creature, it must
      succeed on a DC 11 Strength saving throw or be knocked prone.
    Water Breathing.
      The sea horse can breathe only underwater.

    # Actions

    Ram.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 4 (1d6 +
      1) bludgeoning damage.
    """
    name = 'Giant Sea Horse'
    description = 'Large beast, unaligned'
    challenge_rating = 0.5
    armor_class = 13
    skills = ''
    senses = 'Passive Perception 11'
    languages = ''
    strength = Ability(12)
    dexterity = Ability(15)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(5)
    speed = 0
    swim_speed = 40
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 16
    hit_dice = '3d10 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantShark(Monster):
    """

    Blood Frenzy.
      The shark has advantage on melee attack rolls against any creature
      that doesn't have all its hit points.
    Water Breathing.
      The shark can breathe only underwater.

    # Actions

    Bite.
      Weapon Attack: +9 to hit, reach 5 ft., one target. Hit: 22 (3d10 + 6)
      piercing damage.
    """
    name = 'Giant Shark'
    description = 'Huge beast, unaligned'
    challenge_rating = 5
    armor_class = 13
    skills = 'Perception +3'
    senses = 'Blindsight 60 ft., Passive Perception 13'
    languages = ''
    strength = Ability(23)
    dexterity = Ability(11)
    constitution = Ability(21)
    intelligence = Ability(1)
    wisdom = Ability(10)
    charisma = Ability(5)
    speed = 0
    swim_speed = 50
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 126
    hit_dice = '11d12 + 55'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantSpider(Monster):
    """

    Spider Climb.
      The spider can climb difficult surfaces, including upside down on
      ceilings, without needing to make an ability check.
    Web Sense.
      While in contact with a web, the spider knows the exact location of
      any other creature in contact with the same web.
    Web Walker.
      The spider ignores movement restrictions caused by webbing.

    # Actions

    Bite.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one creature. Hit: 7 (1d8
      + 3) piercing damage, and the target must make a DC 11 Constitution
      saving throw, taking 9 (2d8) poison damage on a failed save, or half
      as much damage on a successful one. If the poison damage reduces the
      target to 0 hit points, the target is stable but poisoned for 1 hour,
      even after regaining hit points, and is paralyzed while poisoned in
      this way.
    Web.
      Ranged Weapon Attack: +5 to hit, range 30/60 ft., one creature. Hit:
      The target is restrained by webbing. As an action, the restrained
      target can make a DC 12 Strength check, bursting the webbing on a
      success. The webbing can also be attacked and destroyed (AC 10; hp 5;
      vulnerability to fire damage; immunity to bludgeoning, poison, and
      psychic damage).
    """
    name = 'Giant Spider'
    description = 'Large beast, unaligned'
    challenge_rating = 1
    armor_class = 14
    skills = 'Stealth +7'
    senses = 'Blindsight 10 ft., Darkvision 60 ft., Passive Perception 10'
    languages = ''
    strength = Ability(14)
    dexterity = Ability(16)
    constitution = Ability(12)
    intelligence = Ability(2)
    wisdom = Ability(11)
    charisma = Ability(4)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    burrow_speed = 0
    hp_max = 26
    hit_dice = '4d10 + 4'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantToad(Monster):
    """

    Amphibious.
      The toad can breathe air and water
    Standing Leap.
      The toad's long jump is up to 20 ft. and its high jump is up to 10
      ft., with or without a running start.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 7 (1d10
      + 2) piercing damage plus 5 (1d10) poison damage, and the target is
      grappled (escape DC 13). Until this grapple ends, the target is
      restrained, and the toad can't bite another target.
    Swallow.
      The toad makes one bite attack against a Medium or smaller target it
      is grappling. If the attack hits, the target is swallowed, and the
      grapple ends. The swallowed target is blinded and restrained, it has
      total cover against attacks and other effects outside the toad, and it
      takes 10 (3d6) acid damage at the start of each of the toad's turns.
      The toad can have only one target swallowed at a time.
      
      If the toad dies, a swallowed creature is no longer restrained by it
      and can escape from the corpse using 5 feet of movement, exiting
      prone.
    """
    name = 'Giant Toad'
    description = 'Large beast, unaligned'
    challenge_rating = 1
    armor_class = 11
    skills = ''
    senses = 'Darkvision 30 ft., Passive Perception 10'
    languages = ''
    strength = Ability(15)
    dexterity = Ability(13)
    constitution = Ability(13)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 20
    swim_speed = 40
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 39
    hit_dice = '6d10 + 6'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantVulture(Monster):
    """

    Keen Sight and Smell.
      The vulture has advantage on Wisdom (Perception) checks that rely on
      sight or smell.
    Pack Tactics.
      The vulture has advantage on an attack roll against a creature if at
      least one of the vulture's allies is within 5 ft. of the creature and
      the ally isn't incapacitated.

    # Actions

    Multiattack.
      The vulture makes two attacks: one with its beak and one with its
      talons.
    Beak.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 7 (2d4 +
      2) piercing damage.
    Talons.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 9 (2d6 +
      2) slashing damage.
    """
    name = 'Giant Vulture'
    description = 'Large beast, neutral evil'
    challenge_rating = 1
    armor_class = 10
    skills = 'Perception +3'
    senses = 'Passive Perception 13'
    languages = "understands Common but can't speak"
    strength = Ability(15)
    dexterity = Ability(10)
    constitution = Ability(15)
    intelligence = Ability(6)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 10
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 22
    hit_dice = '3d10 + 6'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantWasp(Monster):
    """

    # Actions

    Sting.
      Sting. Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit:
      5 (1d6 + 2) piercing damage, and the target must make a DC 11
      Constitution saving throw, taking 10 (3d6) poison damage on a failed
      save, or half as much damage on a successful one. If the poison damage
      reduces the target to 0 hit points, the target is stable but poisoned
      for 1 hour, even after regaining hit points, and is paralyzed while
      poisoned in this way.
    """
    name = 'Giant Wasp'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.5
    armor_class = 12
    skills = ''
    senses = 'Passive Perception 10'
    languages = ''
    strength = Ability(10)
    dexterity = Ability(14)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 10
    swim_speed = 50
    fly_speed = 50
    climb_speed = 0
    burrow_speed = 0
    hp_max = 13
    hit_dice = '3d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantWeasel(Monster):
    """

    Keen Hearing and Smell.
      The weasel has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.

    # Actions

    Bite.
      Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 5 (1d4 + 3)
      piercing damage.
    """
    name = 'Giant Weasel'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.125
    armor_class = 13
    skills = 'Perception +3, Stealth +5'
    senses = 'Darkvision 60 ft., Passive Perception 13'
    languages = ''
    strength = Ability(11)
    dexterity = Ability(16)
    constitution = Ability(10)
    intelligence = Ability(4)
    wisdom = Ability(12)
    charisma = Ability(5)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 9
    hit_dice = '2d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GiantWolfSpider(Monster):
    """

    Spider Climb.
      The spider can climb difficult surfaces, including upside down on
      ceilings, without needing to make an ability check.
    Web Sense.
      While in contact with a web, the spider knows the exact location of
      any other creature in contact with the same web.
    Web Walker.
      The spider ignores movement restrictions caused by webbing.

    # Actions

    Bite.
      Weapon Attack: +3 to hit, reach 5 ft., one creature. Hit: 4 (1d6 + 1)
      piercing damage, and the target must make a DC 11 Constitution saving
      throw, taking 7 (2d6) poison damage on a failed save, or half as much
      damage on a successful one. If the poison damage reduces the target to
      0 hit points, the target is stable but poisoned for 1 hour, even after
      regaining hit points, and is paralyzed while poisoned in this way.
    """
    name = 'Giant Wolf Spider'
    description = 'Medium beast, unaligned'
    challenge_rating = 0.25
    armor_class = 13
    skills = 'Perception +3, Stealth +7'
    senses = 'Blindsight 10 ft., Darkvision 60 ft., Passive Perception 13'
    languages = ''
    strength = Ability(12)
    dexterity = Ability(16)
    constitution = Ability(13)
    intelligence = Ability(3)
    wisdom = Ability(12)
    charisma = Ability(4)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 40
    burrow_speed = 0
    hp_max = 11
    hit_dice = '2d8 + 2'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GibberingMouther(Monster):
    """

    Aberrant Ground.
      The ground in a 10-foot radius around the mouther is doughlike
      difficult terrain. Each creature that starts its turn in that area
      must succeed on a DC 10 Strength saving throw or have its speed
      reduced to 0 until the start of its next turn.
    Gibbering.
      The mouther babbles incoherently while it can see any creature and
      isn't incapacitated. Each creature that starts its turn within 20 feet
      of the mouther and can hear the gibbering must succeed on a DC 10
      Wisdom saving throw. On a failure, the creature can't take reactions
      until the start of its next turn and rolls a d8 to determine what it
      does during its turn. On a 1 to 4, the creature does nothing. On a 5
      or 6, the creature takes no action or bonus action and uses all its
      movement to move in a randomly determined direction. On a 7 or 8, the
      creature makes a melee attack against a randomly determined creature
      within its reach or does nothing if it can't make such an attack.

    # Actions

    Multiattack.
      The gibbering mouther makes one bite attack and, if it can, uses its
      Blinding Spittle.
    Bites.
      Melee Weapon Attack: +2 to hit, reach 5 ft., one creature. Hit: 17
      (5d6) piercing damage. If the target is Medium or smaller, it must
      succeed on a DC 10 Strength saving throw or be knocked prone. If the
      target is killed by this damage, it is absorbed into the mouther.
    Blinding Spittle.
      The mouther spits a chemical glob at a point it can see within 15 feet
      of it. The glob explodes in a blinding flash of light on impact. Each
      creature within 5 feet of the flash must succeed on a DC 13 Dexterity
      saving throw or be blinded until the end of the mouther's next turn.
    """
    name = 'Gibbering Mouther'
    description = 'Medium aberration, neutral'
    challenge_rating = 2
    armor_class = 9
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = ''
    strength = Ability(10)
    dexterity = Ability(8)
    constitution = Ability(16)
    intelligence = Ability(3)
    wisdom = Ability(10)
    charisma = Ability(6)
    speed = 10
    swim_speed = 10
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 67
    hit_dice = '9d8 + 27'
    condition_immunities = 'prone'
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Glabrezu(Monster):
    """

    Innate Spellcasting.
      The glabrezu's spellcasting ability is Intelligence (spell save DC
      16). The glabrezu can innately cast the following spells, requiring no
      material components:
      
      At will: darkness, detect magic, dispel magic
      
      1/day each: confusion, fly, power word stun
    Magic Resistance.
      The glabrezu has advantage on saving throws against spells and other
      magical effects.

    # Actions

    Multiattack.
      The glabrezu makes four attacks: two with its pincers and two with its
      fists. Alternatively, it makes two attacks with its pincers and casts
      one spell.
    Pincer.
      Melee Weapon Attack: +9 to hit, reach 10 ft., one target. Hit: 16
      (2d10 + 5) bludgeoning damage. If the target is a Medium or smaller
      creature, it is grappled (escape DC 15). The glabrezu has two pincers,
      each of which can grapple only one target.
    Fist.
      Melee Weapon Attack: +9 to hit, reach 5 ft., one target. Hit: 7 (2d4 +
      2) bludgeoning damage.
    Variant: Summon Demon.
      The demon chooses what to summon and attempts a magical summoning.
      
      A glabrezu has a 30 percent chance of summoning 1d3 vrocks, 1d2
      hezrous, or one glabrezu.
      
      A summoned demon appears in an unoccupied space within 60 feet of its
      summoner, acts as an ally of its summoner, and can't summon other
      demons. It remains for 1 minute, until it or its summoner dies, or
      until its summoner dismisses it as an action.
    """
    name = 'Glabrezu'
    description = 'Large fiend, chaotic evil'
    challenge_rating = 9
    armor_class = 17
    skills = ''
    senses = 'Truesight 120 ft., Passive Perception 13'
    languages = 'Abyssal, telepathy 120 ft.'
    strength = Ability(20)
    dexterity = Ability(15)
    constitution = Ability(21)
    intelligence = Ability(19)
    wisdom = Ability(17)
    charisma = Ability(16)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 157
    hit_dice = '15d10 + 75'
    condition_immunities = 'poisoned'
    damage_immunities = 'poison'
    damage_resistances = 'cold'
    damage_vulnerabilities = ''
    spells = []


class Gladiator(Monster):
    """

    Brave.
      The gladiator has advantage on saving throws against being frightened.
    Brute.
      A melee weapon deals one extra die of its damage when the gladiator
      hits with it (included in the attack).

    # Actions

    Multiattack.
      The gladiator makes three melee attacks or two ranged attacks.
    Spear.
      Melee or Ranged Weapon Attack: +7 to hit, reach 5 ft. and range 20/60
      ft., one target. Hit: 11 (2d6 + 4) piercing damage, or 13 (2d8 + 4)
      piercing damage if used with two hands to make a melee attack.
    Shield Bash.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one creature. Hit: 9 (2d4
      + 4) bludgeoning damage. If the target is a Medium or smaller
      creature, it must succeed on a DC 15 Strength saving throw or be
      knocked prone.

    # Reactions

    Parry.
      The gladiator adds 3 to its AC against one melee attack that would hit
      it. To do so, the gladiator must see the attacker and be wielding a
      melee weapon.
    """
    name = 'Gladiator'
    description = 'Medium humanoid, any alignment'
    challenge_rating = 5
    armor_class = 16
    skills = 'Athletics +10, Intimidation +5'
    senses = 'Passive Perception 11'
    languages = 'any one language (usually Common)'
    strength = Ability(18)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(10)
    wisdom = Ability(12)
    charisma = Ability(15)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 112
    hit_dice = '15d8 + 45'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Gnoll(Monster):
    """

    Rampage.
      When the gnoll reduces a creature to 0 hit points with a melee attack
      on its turn, the gnoll can take a bonus action to move up to half its
      speed and make a bite attack.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 4 (1d4
      + 2) piercing damage.
    Spear.
      Melee or Ranged Weapon Attack: +4 to hit, reach 5 ft. or range 20/60
      ft., one target. Hit: 5 (1d6 + 2) piercing damage, or 6 (1d8 + 2)
      piercing damage if used with two hands to make a melee attack.
    Longbow.
      Ranged Weapon Attack: +3 to hit, range 150/600 ft., one target. Hit: 5
      (1d8 + 1) piercing damage.
    """
    name = 'Gnoll'
    description = 'Medium humanoid, chaotic evil'
    challenge_rating = 0.5
    armor_class = 15
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 10'
    languages = 'Gnoll'
    strength = Ability(14)
    dexterity = Ability(12)
    constitution = Ability(11)
    intelligence = Ability(6)
    wisdom = Ability(10)
    charisma = Ability(7)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 22
    hit_dice = '5d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Goat(Monster):
    """

    Charge.
      If the goat moves at least 20 ft. straight toward a target and then
      hits it with a ram attack on the same turn, the target takes an extra
      2 (1d4) bludgeoning damage. If the target is a creature, it must
      succeed on a DC 10 Strength saving throw or be knocked prone.
    Sure-Footed.
      The goat has advantage on Strength and Dexterity saving throws made
      against effects that would knock it prone.

    # Actions

    Ram.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 3 (1d4 +
      1) bludgeoning damage.
    """
    name = 'Goat'
    description = 'Medium beast, unaligned'
    challenge_rating = 0
    armor_class = 10
    skills = ''
    senses = 'Passive Perception 10'
    languages = ''
    strength = Ability(12)
    dexterity = Ability(10)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(5)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 4
    hit_dice = '1d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Goblin(Monster):
    """

    Nimble Escape.
      The goblin can take the Disengage or Hide action as a bonus action on
      each of its turns.

    # Actions

    Scimitar.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) slashing damage.
    Shortbow.
      Ranged Weapon Attack: +4 to hit, range 80/320 ft., one target. Hit: 5
      (1d6 + 2) piercing damage.
    """
    name = 'Goblin'
    description = 'Small humanoid, neutral evil'
    challenge_rating = 0.25
    armor_class = 15
    skills = 'Stealth +6'
    senses = 'Darkvision 60 ft., Passive Perception 9'
    languages = 'Common, Goblin'
    strength = Ability(8)
    dexterity = Ability(14)
    constitution = Ability(10)
    intelligence = Ability(10)
    wisdom = Ability(8)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 7
    hit_dice = '2d6 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GoldDragonWyrmling(Monster):
    """

    Amphibious.
      The dragon can breathe air and water.

    # Actions

    Bite.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 9 (1d10
      + 4) piercing damage.
    Breath Weapons.
      The dragon uses one of the following breath weapons.
      
      Fire Breath. The dragon exhales fire in a 15-foot cone. Each creature
      in that area must make a DC 13 Dexterity saving throw, taking 22
      (4d10) fire damage on a failed save, or half as much damage on a
      successful one.
      
      Weakening Breath. The dragon exhales gas in a 15-foot cone. Each
      creature in that area must succeed on a DC 13 Strength saving throw or
      have disadvantage on Strength-based attack rolls, Strength checks, and
      Strength saving throws for 1 minute. A creature can repeat the saving
      throw at the end of each of its turns, ending the effect on itself on
      a success.
    """
    name = 'Gold Dragon Wyrmling'
    description = 'Medium dragon, lawful good'
    challenge_rating = 3
    armor_class = 17
    skills = 'Perception +4, Stealth +4'
    senses = 'Blindsight 10 ft., Darkvision 60 ft., Passive Perception 14'
    languages = 'Draconic'
    strength = Ability(19)
    dexterity = Ability(14)
    constitution = Ability(17)
    intelligence = Ability(14)
    wisdom = Ability(11)
    charisma = Ability(16)
    speed = 30
    swim_speed = 30
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 60
    hit_dice = '8d8 + 24'
    condition_immunities = ''
    damage_immunities = 'fire'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Gorgon(Monster):
    """

    Trampling Charge.
      If the gorgon moves at least 20 feet straight toward a creature and
      then hits it with a gore attack on the same turn, that target must
      succeed on a DC 16 Strength saving throw or be knocked prone. If the
      target is prone, the gorgon can make one attack with its hooves
      against it as a bonus action.

    # Actions

    Gore.
      Melee Weapon Attack: +8 to hit, reach 5 ft., one target. Hit: 18 (2d12
      + 5) piercing damage.
    Hooves.
      Melee Weapon Attack: +8 to hit, reach 5 ft., one target. Hit: 16 (2d10
      + 5) bludgeoning damage.
    Petrifying Breath.
      The gorgon exhales petrifying gas in a 30-foot cone. Each creature in
      that area must succeed on a DC 13 Constitution saving throw. On a
      failed save, a target begins to turn to stone and is restrained. The
      restrained target must repeat the saving throw at the end of its next
      turn. On a success, the effect ends on the target. On a failure, the
      target is petrified until freed by the greater restoration spell or
      other magic.
    """
    name = 'Gorgon'
    description = 'Large monstrosity, unaligned'
    challenge_rating = 5
    armor_class = 19
    skills = 'Perception +4'
    senses = 'Darkvision 60 ft., Passive Perception 14'
    languages = ''
    strength = Ability(20)
    dexterity = Ability(11)
    constitution = Ability(18)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 114
    hit_dice = '12d10 + 48'
    condition_immunities = 'petrified'
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GrayOoze(Monster):
    """

    Amorphous.
      The ooze can move through a space as narrow as 1 inch wide without
      squeezing.
    Corrode Metal.
      Any nonmagical weapon made of metal that hits the ooze corrodes. After
      dealing damage, the weapon takes a permanent and cumulative -1 penalty
      to damage rolls. If its penalty drops to -5, the weapon is destroyed.
      Nonmagical ammunition made of metal that hits the ooze is destroyed
      after dealing damage.
      
      The ooze can eat through 2-inch-thick, nonmagical metal in 1 round.
    False Appearance.
      While the ooze remains motionless, it is indistinguishable from an
      oily pool or wet rock.

    # Actions

    Pseudopod.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 4 (1d6 +
      1) bludgeoning damage plus 7 (2d6) acid damage, and if the target is
      wearing nonmagical metal armor, its armor is partly corroded and takes
      a permanent and cumulative -1 penalty to the AC it offers. The armor
      is destroyed if the penalty reduces its AC to 10.
    """
    name = 'Gray Ooze'
    description = 'Medium ooze, unaligned'
    challenge_rating = 0.5
    armor_class = 8
    skills = 'Stealth +2'
    senses = 'Blindsight 60 ft. (blind beyond this radius), Passive Perception 8'
    languages = ''
    strength = Ability(12)
    dexterity = Ability(6)
    constitution = Ability(16)
    intelligence = Ability(1)
    wisdom = Ability(6)
    charisma = Ability(2)
    speed = 10
    swim_speed = 0
    fly_speed = 0
    climb_speed = 10
    burrow_speed = 0
    hp_max = 22
    hit_dice = '3d8 + 9'
    condition_immunities = 'blinded, charmed, deafened, exhaustion, frightened, prone'
    damage_immunities = ''
    damage_resistances = 'acid'
    damage_vulnerabilities = ''
    spells = []


class GreenDragonWyrmling(Monster):
    """

    Amphibious.
      The dragon can breathe air and water.

    # Actions

    Bite.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 7 (1d10
      + 2) piercing damage plus 3 (1d6) poison damage.
    Poison Breath.
      The dragon exhales poisonous gas in a 15-foot cone. Each creature in
      that area must make a DC 11 Constitution saving throw, taking 21 (6d6)
      poison damage on a failed save, or half as much damage on a successful
      one.
    """
    name = 'Green Dragon Wyrmling'
    description = 'Medium dragon, lawful evil'
    challenge_rating = 2
    armor_class = 17
    skills = 'Perception +4, Stealth +3'
    senses = 'Blindsight 10 ft., Darkvision 60 ft., Passive Perception 14'
    languages = 'Draconic'
    strength = Ability(15)
    dexterity = Ability(12)
    constitution = Ability(13)
    intelligence = Ability(14)
    wisdom = Ability(11)
    charisma = Ability(13)
    speed = 30
    swim_speed = 30
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 38
    hit_dice = '7d8 + 7'
    condition_immunities = 'poisoned'
    damage_immunities = 'poison'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GreenHag(Monster):
    """

    Amphibious.
      The hag can breathe air and water.
    Innate Spellcasting.
      The hag's innate spellcasting ability is Charisma (spell save DC 12).
      She can innately cast the following spells, requiring no material
      components:
      
  
      
      At will: dancing lights, minor illusion, vicious mockery
    Mimicry.
      The hag can mimic animal sounds and humanoid voices. A creature that
      hears the sounds can tell they are imitations with a successful DC 14
      Wisdom (Insight) check.

    # Actions

    Claws.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.
    Illusory Appearance.
      The hag covers herself and anything she is wearing or carrying with a
      magical illusion that makes her look like another creature of her
      general size and humanoid shape. The illusion ends if the hag takes a
      bonus action to end it or if she dies.
      
      The changes wrought by this effect fail to hold up to physical
      inspection. For example, the hag could appear to have smooth skin, but
      someone touching her would feel her rough flesh. Otherwise, a creature
      must take an action to visually inspect the illusion and succeed on a
      DC 20 Intelligence (Investigation) check to discern that the hag is
      disguised.
    Invisible Passage.
      The hag magically turns invisible until she attacks or casts a spell,
      or until her concentration ends (as if concentrating on a spell).
      While invisible, she leaves no physical evidence of her passage, so
      she can be tracked only by magic. Any equipment she wears or carries
      is invisible with her.
    """
    name = 'Green Hag'
    description = 'Medium fey, neutral evil'
    challenge_rating = 3
    armor_class = 17
    skills = 'Arcana +3, Deception +4, Perception +4, Stealth +3'
    senses = 'Darkvision 60 ft., Passive Perception 14'
    languages = 'Common, Draconic, Sylvan'
    strength = Ability(18)
    dexterity = Ability(12)
    constitution = Ability(16)
    intelligence = Ability(13)
    wisdom = Ability(14)
    charisma = Ability(14)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 82
    hit_dice = '11d8 + 33'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Grick(Monster):
    """

    Stone Camouflage.
      The grick has advantage on Dexterity (Stealth) checks made to hide in
      rocky terrain.

    # Actions

    Multiattack.
      The grick makes one attack with its tentacles. If that attack hits,
      the grick can make one beak attack against the same target.
    Tentacles.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 9 (2d6 +
      2) slashing damage.
    Beak.
      Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 +
      2) piercing damage.
    """
    name = 'Grick'
    description = 'Medium monstrosity, neutral'
    challenge_rating = 2
    armor_class = 14
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 12'
    languages = ''
    strength = Ability(14)
    dexterity = Ability(14)
    constitution = Ability(11)
    intelligence = Ability(3)
    wisdom = Ability(14)
    charisma = Ability(5)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 30
    burrow_speed = 0
    hp_max = 27
    hit_dice = '6d8 + 0'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = 'bludgeoning, piercing, and slashing damage from nonmagical weapons'
    damage_vulnerabilities = ''
    spells = []


class Griffon(Monster):
    """

    Keen Sight.
      The griffon has advantage on Wisdom (Perception) checks that rely on
      sight.

    # Actions

    Multiattack.
      The griffon makes two attacks: one with its beak and one with its
      claws.
    Beak.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 8 (1d8 +
      4) piercing damage.
    Claws.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) slashing damage.
    """
    name = 'Griffon'
    description = 'Large monstrosity, unaligned'
    challenge_rating = 2
    armor_class = 12
    skills = 'Perception +5'
    senses = 'Darkvision 60 ft., Passive Perception 15'
    languages = ''
    strength = Ability(18)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(2)
    wisdom = Ability(13)
    charisma = Ability(8)
    speed = 30
    swim_speed = 0
    fly_speed = 80
    climb_speed = 0
    burrow_speed = 0
    hp_max = 59
    hit_dice = '7d10 + 21'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Grimlock(Monster):
    """

    Blind Senses.
      The grimlock can't use its blindsight while deafened and unable to
      smell.
    Keen Hearing and Smell.
      The grimlock has advantage on Wisdom (Perception) checks that rely on
      hearing or smell.
    Stone Camouflage.
      The grimlock has advantage on Dexterity (Stealth) checks made to hide
      in rocky terrain.

    # Actions

    Spiked Bone Club.
      Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 5 (1d4 +
      3) bludgeoning damage plus 2 (1d4) piercing damage.
    """
    name = 'Grimlock'
    description = 'Medium humanoid, neutral evil'
    challenge_rating = 0.25
    armor_class = 11
    skills = 'Athletics +5, Perception +3, Stealth +3'
    senses = 'Blindsight 30 ft. or 10 ft. while deafened (blind beyond this radius), Passive Perception 13'
    languages = 'Undercommon'
    strength = Ability(16)
    dexterity = Ability(12)
    constitution = Ability(12)
    intelligence = Ability(9)
    wisdom = Ability(8)
    charisma = Ability(6)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 11
    hit_dice = '2d8 + 2'
    condition_immunities = 'blinded'
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class Guard(Monster):
    """

    # Actions

    Spear.
      Melee or Ranged Weapon Attack: +3 to hit, reach 5 ft. or range 20/60
      ft., one target. Hit: 4 (1d6 + 1) piercing damage or 5 (1d8 + 1)
      piercing damage if used with two hands to make a melee attack.
    """
    name = 'Guard'
    description = 'Medium humanoid, any alignment'
    challenge_rating = 0.125
    armor_class = 16
    skills = 'Perception +2'
    senses = 'Passive Perception 12'
    languages = 'any one language (usually Common)'
    strength = Ability(13)
    dexterity = Ability(12)
    constitution = Ability(12)
    intelligence = Ability(10)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 11
    hit_dice = '2d8 + 2'
    condition_immunities = ''
    damage_immunities = ''
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = []


class GuardianNaga(Monster):
    """

    Rejuvenation.
      If it dies, the naga returns to life in 1d6 days and regains all its
      hit points. Only a wish spell can prevent this trait from functioning.
    Spellcasting.
      The naga is an 11th-level spellcaster. Its spellcasting ability is Wisdom (spell save DC 16, +8 to hit with spell attacks), and it needs only verbal components to cast its spells. It has the following cleric spells prepared:

    - Cantrips (at will): mending, sacred flame, thaumaturgy
    - 1st level (4 slots): command, cure wounds, shield of faith
    - 2nd level (3 slots): calm emotions, hold person
    - 3rd level (3 slots): bestow curse, clairvoyance
    - 4th level (3 slots): banishment, freedom of movement
    - 5th level (2 slots): flame strike, geas
    - 6th level (1 slot): true seeing

    # Actions

    Bite.
      Melee Weapon Attack: +8 to hit, reach 10 ft., one creature. Hit: 8
      (1d8 + 4) piercing damage, and the target must make a DC 15
      Constitution saving throw, taking 45 (10d8) poison damage on a failed
      save, or half as much damage on a successful one.
    Spit Poison.
      Ranged Weapon Attack: +8 to hit, range 15/30 ft., one creature. Hit:
      The target must make a DC 15 Constitution saving throw, taking 45
      (10d8) poison damage on a failed save, or half as much damage on a
      successful one.
    """
    name = 'Guardian Naga'
    description = 'Large monstrosity, lawful good'
    challenge_rating = 10
    armor_class = 18
    skills = ''
    senses = 'Darkvision 60 ft., Passive Perception 14'
    languages = 'Celestial, Common'
    strength = Ability(19)
    dexterity = Ability(18)
    constitution = Ability(16)
    intelligence = Ability(16)
    wisdom = Ability(19)
    charisma = Ability(18)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    burrow_speed = 0
    hp_max = 127
    hit_dice = '15d10 + 45'
    condition_immunities = 'charmed, poisoned'
    damage_immunities = 'poison'
    damage_resistances = ''
    damage_vulnerabilities = ''
    spells = ['mending', 'sacred flame', 'thaumaturgy', 'command', 'cure wounds', 'shield of faith', 'calm emotions', 'hold person', 'bestow curse', 'clairvoyance', 'banishment', 'freedom of movement', 'flame strike', 'geas', 'true seeing']


class Gynosphinx(Monster):
    """

    Inscrutable.
      The sphinx is immune to any effect that would sense its emotions or
      read its thoughts, as well as any divination spell that it refuses.
      Wisdom (Insight) checks made to ascertain the sphinx's intentions or
      sincerity have disadvantage.
    Magic Weapons.
      The sphinx's weapon attacks are magical.
    Spellcasting.
      The sphinx is a 9th-level spellcaster. Its spellcasting ability is Intelligence (spell save DC 16, +8 to hit with spell attacks). It requires no material components to cast its spells. The sphinx has the following wizard spells prepared:

    - Cantrips (at will): mage hand, minor illusion, prestidigitation
    - 1st level (4 slots): detect magic, identify, shield
    - 2nd level (3 slots): darkness, locate object, suggestion
    - 3rd level (3 slots): dispel magic, remove curse, tongues
    - 4th level (3 slots): banishment, greater invisibility
    - 5th level (1 slot): legend lore

    # Actions

    Multiattack.
      The sphinx makes two claw attacks.
    Claw.
      Melee Weapon Attack: +9 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) slashing damage.

    # Legendary Actions

    Claw Attack.
      The sphinx makes one claw attack.
    Teleport (Costs 2 Actions).
      The sphinx magically teleports, along with any equipment it is wearing
      or carrying, up to 120 feet to an unoccupied space it can see.
    Cast a Spell (Costs 3 Actions).
      The sphinx casts a spell from its list of prepared spells, using a
      spell slot as normal.
    """
    name = 'Gynosphinx'
    description = 'Large monstrosity, lawful neutral'
    challenge_rating = 11
    armor_class = 17
    skills = 'Arcana +12, History +12, Perception +8, Religion +8'
    senses = 'Truesight 120 ft., Passive Perception 18'
    languages = 'Common, Sphinx'
    strength = Ability(18)
    dexterity = Ability(15)
    constitution = Ability(16)
    intelligence = Ability(18)
    wisdom = Ability(18)
    charisma = Ability(18)
    speed = 40
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    burrow_speed = 0
    hp_max = 136
    hit_dice = '16d10 + 48'
    condition_immunities = 'charmed, frightened'
    damage_immunities = 'psychic'
    damage_resistances = 'bludgeoning, piercing, and slashing from nonmagical weapons'
    damage_vulnerabilities = ''
    spells = ['mage hand', 'minor illusion', 'prestidigitation', 'detect magic', 'identify', 'shield', 'darkness', 'locate object', 'suggestion', 'dispel magic', 'remove curse', 'tongues', 'banishment', 'greater invisibility', 'legend lore']
