"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const cognito = require("@aws-cdk/aws-cognito");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
const actions = require("../lib");
test('Cognito Action', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const vpc = new ec2.Vpc(stack, 'Stack');
    const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', { vpc });
    const userPool = new cognito.UserPool(stack, 'UserPool');
    const userPoolClient = new cognito.UserPoolClient(stack, 'Client', { userPool });
    const userPoolDomain = new cognito.UserPoolDomain(stack, 'Domain', {
        userPool,
        cognitoDomain: {
            domainPrefix: 'prefix',
        },
    });
    // WHEN
    lb.addListener('Listener', {
        port: 80,
        defaultAction: new actions.AuthenticateCognitoAction({
            userPool,
            userPoolClient,
            userPoolDomain,
            next: elbv2.ListenerAction.fixedResponse(200, {
                contentType: 'text/plain',
                messageBody: 'Authenticated',
            }),
        }),
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::Listener', {
        DefaultActions: [
            {
                AuthenticateCognitoConfig: {
                    UserPoolArn: { 'Fn::GetAtt': ['UserPool6BA7E5F2', 'Arn'] },
                    UserPoolClientId: { Ref: 'Client4A7F64DF' },
                    UserPoolDomain: { Ref: 'Domain66AC69E0' },
                },
                Order: 1,
                Type: 'authenticate-cognito',
            },
            {
                FixedResponseConfig: {
                    ContentType: 'text/plain',
                    MessageBody: 'Authenticated',
                    StatusCode: '200',
                },
                Order: 2,
                Type: 'fixed-response',
            },
        ],
    }));
});
//# sourceMappingURL=data:application/json;base64,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