"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const index_1 = require("./index");
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack');
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = new aws_ec2_1.Vpc(stack, 'nat', {
    natGateways: 1,
    maxAzs: 2,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: (_a = stack.node.tryGetContext('GITLAB_TOKEN')) !== null && _a !== void 0 ? _a : 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    vpcSubnet: {
        subnetType: aws_ec2_1.SubnetType.PRIVATE,
    },
});
runner.expireAfter(core_1.Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFrom(aws_ec2_1.Peer.ipv4('0.0.0.0/0'), aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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