# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ProvidersLdapIdParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alternate_security_identities_attribute': 'str',
        'authentication': 'bool',
        'balance_servers': 'bool',
        'base_dn': 'str',
        'bind_dn': 'str',
        'bind_mechanism': 'str',
        'bind_password': 'str',
        'bind_timeout': 'int',
        'certificate_authority_file': 'str',
        'check_online_interval': 'int',
        'cn_attribute': 'str',
        'create_home_directory': 'bool',
        'crypt_password_attribute': 'str',
        'email_attribute': 'str',
        'enabled': 'bool',
        'enumerate_groups': 'bool',
        'enumerate_users': 'bool',
        'findable_groups': 'list[str]',
        'findable_users': 'list[str]',
        'gecos_attribute': 'str',
        'gid_attribute': 'str',
        'group_base_dn': 'str',
        'group_domain': 'str',
        'group_filter': 'str',
        'group_members_attribute': 'str',
        'group_search_scope': 'str',
        'home_directory_template': 'str',
        'homedir_attribute': 'str',
        'ignore_tls_errors': 'bool',
        'listable_groups': 'list[str]',
        'listable_users': 'list[str]',
        'login_shell': 'str',
        'member_lookup_method': 'str',
        'member_of_attribute': 'str',
        'name': 'str',
        'name_attribute': 'str',
        'netgroup_base_dn': 'str',
        'netgroup_filter': 'str',
        'netgroup_members_attribute': 'str',
        'netgroup_search_scope': 'str',
        'netgroup_triple_attribute': 'str',
        'normalize_groups': 'bool',
        'normalize_users': 'bool',
        'nt_password_attribute': 'str',
        'ntlm_support': 'str',
        'provider_domain': 'str',
        'require_secure_connection': 'bool',
        'restrict_findable': 'bool',
        'restrict_listable': 'bool',
        'search_scope': 'str',
        'search_timeout': 'int',
        'server_uris': 'list[str]',
        'shadow_expire_attribute': 'str',
        'shadow_flag_attribute': 'str',
        'shadow_inactive_attribute': 'str',
        'shadow_last_change_attribute': 'str',
        'shadow_max_attribute': 'str',
        'shadow_min_attribute': 'str',
        'shadow_user_filter': 'str',
        'shadow_warning_attribute': 'str',
        'shell_attribute': 'str',
        'ssh_public_key_attribute': 'str',
        'template': 'str',
        'tls_protocol_min': 'str',
        'uid_attribute': 'str',
        'unfindable_groups': 'list[str]',
        'unfindable_users': 'list[str]',
        'unique_group_members_attribute': 'str',
        'unlistable_groups': 'list[str]',
        'unlistable_users': 'list[str]',
        'user_base_dn': 'str',
        'user_domain': 'str',
        'user_filter': 'str',
        'user_search_scope': 'str'
    }

    attribute_map = {
        'alternate_security_identities_attribute': 'alternate_security_identities_attribute',
        'authentication': 'authentication',
        'balance_servers': 'balance_servers',
        'base_dn': 'base_dn',
        'bind_dn': 'bind_dn',
        'bind_mechanism': 'bind_mechanism',
        'bind_password': 'bind_password',
        'bind_timeout': 'bind_timeout',
        'certificate_authority_file': 'certificate_authority_file',
        'check_online_interval': 'check_online_interval',
        'cn_attribute': 'cn_attribute',
        'create_home_directory': 'create_home_directory',
        'crypt_password_attribute': 'crypt_password_attribute',
        'email_attribute': 'email_attribute',
        'enabled': 'enabled',
        'enumerate_groups': 'enumerate_groups',
        'enumerate_users': 'enumerate_users',
        'findable_groups': 'findable_groups',
        'findable_users': 'findable_users',
        'gecos_attribute': 'gecos_attribute',
        'gid_attribute': 'gid_attribute',
        'group_base_dn': 'group_base_dn',
        'group_domain': 'group_domain',
        'group_filter': 'group_filter',
        'group_members_attribute': 'group_members_attribute',
        'group_search_scope': 'group_search_scope',
        'home_directory_template': 'home_directory_template',
        'homedir_attribute': 'homedir_attribute',
        'ignore_tls_errors': 'ignore_tls_errors',
        'listable_groups': 'listable_groups',
        'listable_users': 'listable_users',
        'login_shell': 'login_shell',
        'member_lookup_method': 'member_lookup_method',
        'member_of_attribute': 'member_of_attribute',
        'name': 'name',
        'name_attribute': 'name_attribute',
        'netgroup_base_dn': 'netgroup_base_dn',
        'netgroup_filter': 'netgroup_filter',
        'netgroup_members_attribute': 'netgroup_members_attribute',
        'netgroup_search_scope': 'netgroup_search_scope',
        'netgroup_triple_attribute': 'netgroup_triple_attribute',
        'normalize_groups': 'normalize_groups',
        'normalize_users': 'normalize_users',
        'nt_password_attribute': 'nt_password_attribute',
        'ntlm_support': 'ntlm_support',
        'provider_domain': 'provider_domain',
        'require_secure_connection': 'require_secure_connection',
        'restrict_findable': 'restrict_findable',
        'restrict_listable': 'restrict_listable',
        'search_scope': 'search_scope',
        'search_timeout': 'search_timeout',
        'server_uris': 'server_uris',
        'shadow_expire_attribute': 'shadow_expire_attribute',
        'shadow_flag_attribute': 'shadow_flag_attribute',
        'shadow_inactive_attribute': 'shadow_inactive_attribute',
        'shadow_last_change_attribute': 'shadow_last_change_attribute',
        'shadow_max_attribute': 'shadow_max_attribute',
        'shadow_min_attribute': 'shadow_min_attribute',
        'shadow_user_filter': 'shadow_user_filter',
        'shadow_warning_attribute': 'shadow_warning_attribute',
        'shell_attribute': 'shell_attribute',
        'ssh_public_key_attribute': 'ssh_public_key_attribute',
        'template': 'template',
        'tls_protocol_min': 'tls_protocol_min',
        'uid_attribute': 'uid_attribute',
        'unfindable_groups': 'unfindable_groups',
        'unfindable_users': 'unfindable_users',
        'unique_group_members_attribute': 'unique_group_members_attribute',
        'unlistable_groups': 'unlistable_groups',
        'unlistable_users': 'unlistable_users',
        'user_base_dn': 'user_base_dn',
        'user_domain': 'user_domain',
        'user_filter': 'user_filter',
        'user_search_scope': 'user_search_scope'
    }

    def __init__(self, alternate_security_identities_attribute=None, authentication=None, balance_servers=None, base_dn=None, bind_dn=None, bind_mechanism=None, bind_password=None, bind_timeout=None, certificate_authority_file=None, check_online_interval=None, cn_attribute=None, create_home_directory=None, crypt_password_attribute=None, email_attribute=None, enabled=None, enumerate_groups=None, enumerate_users=None, findable_groups=None, findable_users=None, gecos_attribute=None, gid_attribute=None, group_base_dn=None, group_domain=None, group_filter=None, group_members_attribute=None, group_search_scope=None, home_directory_template=None, homedir_attribute=None, ignore_tls_errors=None, listable_groups=None, listable_users=None, login_shell=None, member_lookup_method=None, member_of_attribute=None, name=None, name_attribute=None, netgroup_base_dn=None, netgroup_filter=None, netgroup_members_attribute=None, netgroup_search_scope=None, netgroup_triple_attribute=None, normalize_groups=None, normalize_users=None, nt_password_attribute=None, ntlm_support=None, provider_domain=None, require_secure_connection=None, restrict_findable=None, restrict_listable=None, search_scope=None, search_timeout=None, server_uris=None, shadow_expire_attribute=None, shadow_flag_attribute=None, shadow_inactive_attribute=None, shadow_last_change_attribute=None, shadow_max_attribute=None, shadow_min_attribute=None, shadow_user_filter=None, shadow_warning_attribute=None, shell_attribute=None, ssh_public_key_attribute=None, template=None, tls_protocol_min=None, uid_attribute=None, unfindable_groups=None, unfindable_users=None, unique_group_members_attribute=None, unlistable_groups=None, unlistable_users=None, user_base_dn=None, user_domain=None, user_filter=None, user_search_scope=None):  # noqa: E501
        """ProvidersLdapIdParams - a model defined in Swagger"""  # noqa: E501

        self._alternate_security_identities_attribute = None
        self._authentication = None
        self._balance_servers = None
        self._base_dn = None
        self._bind_dn = None
        self._bind_mechanism = None
        self._bind_password = None
        self._bind_timeout = None
        self._certificate_authority_file = None
        self._check_online_interval = None
        self._cn_attribute = None
        self._create_home_directory = None
        self._crypt_password_attribute = None
        self._email_attribute = None
        self._enabled = None
        self._enumerate_groups = None
        self._enumerate_users = None
        self._findable_groups = None
        self._findable_users = None
        self._gecos_attribute = None
        self._gid_attribute = None
        self._group_base_dn = None
        self._group_domain = None
        self._group_filter = None
        self._group_members_attribute = None
        self._group_search_scope = None
        self._home_directory_template = None
        self._homedir_attribute = None
        self._ignore_tls_errors = None
        self._listable_groups = None
        self._listable_users = None
        self._login_shell = None
        self._member_lookup_method = None
        self._member_of_attribute = None
        self._name = None
        self._name_attribute = None
        self._netgroup_base_dn = None
        self._netgroup_filter = None
        self._netgroup_members_attribute = None
        self._netgroup_search_scope = None
        self._netgroup_triple_attribute = None
        self._normalize_groups = None
        self._normalize_users = None
        self._nt_password_attribute = None
        self._ntlm_support = None
        self._provider_domain = None
        self._require_secure_connection = None
        self._restrict_findable = None
        self._restrict_listable = None
        self._search_scope = None
        self._search_timeout = None
        self._server_uris = None
        self._shadow_expire_attribute = None
        self._shadow_flag_attribute = None
        self._shadow_inactive_attribute = None
        self._shadow_last_change_attribute = None
        self._shadow_max_attribute = None
        self._shadow_min_attribute = None
        self._shadow_user_filter = None
        self._shadow_warning_attribute = None
        self._shell_attribute = None
        self._ssh_public_key_attribute = None
        self._template = None
        self._tls_protocol_min = None
        self._uid_attribute = None
        self._unfindable_groups = None
        self._unfindable_users = None
        self._unique_group_members_attribute = None
        self._unlistable_groups = None
        self._unlistable_users = None
        self._user_base_dn = None
        self._user_domain = None
        self._user_filter = None
        self._user_search_scope = None
        self.discriminator = None

        if alternate_security_identities_attribute is not None:
            self.alternate_security_identities_attribute = alternate_security_identities_attribute
        if authentication is not None:
            self.authentication = authentication
        if balance_servers is not None:
            self.balance_servers = balance_servers
        if base_dn is not None:
            self.base_dn = base_dn
        if bind_dn is not None:
            self.bind_dn = bind_dn
        if bind_mechanism is not None:
            self.bind_mechanism = bind_mechanism
        if bind_password is not None:
            self.bind_password = bind_password
        if bind_timeout is not None:
            self.bind_timeout = bind_timeout
        if certificate_authority_file is not None:
            self.certificate_authority_file = certificate_authority_file
        if check_online_interval is not None:
            self.check_online_interval = check_online_interval
        if cn_attribute is not None:
            self.cn_attribute = cn_attribute
        if create_home_directory is not None:
            self.create_home_directory = create_home_directory
        if crypt_password_attribute is not None:
            self.crypt_password_attribute = crypt_password_attribute
        if email_attribute is not None:
            self.email_attribute = email_attribute
        if enabled is not None:
            self.enabled = enabled
        if enumerate_groups is not None:
            self.enumerate_groups = enumerate_groups
        if enumerate_users is not None:
            self.enumerate_users = enumerate_users
        if findable_groups is not None:
            self.findable_groups = findable_groups
        if findable_users is not None:
            self.findable_users = findable_users
        if gecos_attribute is not None:
            self.gecos_attribute = gecos_attribute
        if gid_attribute is not None:
            self.gid_attribute = gid_attribute
        if group_base_dn is not None:
            self.group_base_dn = group_base_dn
        if group_domain is not None:
            self.group_domain = group_domain
        if group_filter is not None:
            self.group_filter = group_filter
        if group_members_attribute is not None:
            self.group_members_attribute = group_members_attribute
        if group_search_scope is not None:
            self.group_search_scope = group_search_scope
        if home_directory_template is not None:
            self.home_directory_template = home_directory_template
        if homedir_attribute is not None:
            self.homedir_attribute = homedir_attribute
        if ignore_tls_errors is not None:
            self.ignore_tls_errors = ignore_tls_errors
        if listable_groups is not None:
            self.listable_groups = listable_groups
        if listable_users is not None:
            self.listable_users = listable_users
        if login_shell is not None:
            self.login_shell = login_shell
        if member_lookup_method is not None:
            self.member_lookup_method = member_lookup_method
        if member_of_attribute is not None:
            self.member_of_attribute = member_of_attribute
        if name is not None:
            self.name = name
        if name_attribute is not None:
            self.name_attribute = name_attribute
        if netgroup_base_dn is not None:
            self.netgroup_base_dn = netgroup_base_dn
        if netgroup_filter is not None:
            self.netgroup_filter = netgroup_filter
        if netgroup_members_attribute is not None:
            self.netgroup_members_attribute = netgroup_members_attribute
        if netgroup_search_scope is not None:
            self.netgroup_search_scope = netgroup_search_scope
        if netgroup_triple_attribute is not None:
            self.netgroup_triple_attribute = netgroup_triple_attribute
        if normalize_groups is not None:
            self.normalize_groups = normalize_groups
        if normalize_users is not None:
            self.normalize_users = normalize_users
        if nt_password_attribute is not None:
            self.nt_password_attribute = nt_password_attribute
        if ntlm_support is not None:
            self.ntlm_support = ntlm_support
        if provider_domain is not None:
            self.provider_domain = provider_domain
        if require_secure_connection is not None:
            self.require_secure_connection = require_secure_connection
        if restrict_findable is not None:
            self.restrict_findable = restrict_findable
        if restrict_listable is not None:
            self.restrict_listable = restrict_listable
        if search_scope is not None:
            self.search_scope = search_scope
        if search_timeout is not None:
            self.search_timeout = search_timeout
        if server_uris is not None:
            self.server_uris = server_uris
        if shadow_expire_attribute is not None:
            self.shadow_expire_attribute = shadow_expire_attribute
        if shadow_flag_attribute is not None:
            self.shadow_flag_attribute = shadow_flag_attribute
        if shadow_inactive_attribute is not None:
            self.shadow_inactive_attribute = shadow_inactive_attribute
        if shadow_last_change_attribute is not None:
            self.shadow_last_change_attribute = shadow_last_change_attribute
        if shadow_max_attribute is not None:
            self.shadow_max_attribute = shadow_max_attribute
        if shadow_min_attribute is not None:
            self.shadow_min_attribute = shadow_min_attribute
        if shadow_user_filter is not None:
            self.shadow_user_filter = shadow_user_filter
        if shadow_warning_attribute is not None:
            self.shadow_warning_attribute = shadow_warning_attribute
        if shell_attribute is not None:
            self.shell_attribute = shell_attribute
        if ssh_public_key_attribute is not None:
            self.ssh_public_key_attribute = ssh_public_key_attribute
        if template is not None:
            self.template = template
        if tls_protocol_min is not None:
            self.tls_protocol_min = tls_protocol_min
        if uid_attribute is not None:
            self.uid_attribute = uid_attribute
        if unfindable_groups is not None:
            self.unfindable_groups = unfindable_groups
        if unfindable_users is not None:
            self.unfindable_users = unfindable_users
        if unique_group_members_attribute is not None:
            self.unique_group_members_attribute = unique_group_members_attribute
        if unlistable_groups is not None:
            self.unlistable_groups = unlistable_groups
        if unlistable_users is not None:
            self.unlistable_users = unlistable_users
        if user_base_dn is not None:
            self.user_base_dn = user_base_dn
        if user_domain is not None:
            self.user_domain = user_domain
        if user_filter is not None:
            self.user_filter = user_filter
        if user_search_scope is not None:
            self.user_search_scope = user_search_scope

    @property
    def alternate_security_identities_attribute(self):
        """Gets the alternate_security_identities_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the attribute name used when searching for alternate security identities.  # noqa: E501

        :return: The alternate_security_identities_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._alternate_security_identities_attribute

    @alternate_security_identities_attribute.setter
    def alternate_security_identities_attribute(self, alternate_security_identities_attribute):
        """Sets the alternate_security_identities_attribute of this ProvidersLdapIdParams.

        Specifies the attribute name used when searching for alternate security identities.  # noqa: E501

        :param alternate_security_identities_attribute: The alternate_security_identities_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if alternate_security_identities_attribute is not None and len(alternate_security_identities_attribute) > 255:
            raise ValueError("Invalid value for `alternate_security_identities_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if alternate_security_identities_attribute is not None and len(alternate_security_identities_attribute) < 0:
            raise ValueError("Invalid value for `alternate_security_identities_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._alternate_security_identities_attribute = alternate_security_identities_attribute

    @property
    def authentication(self):
        """Gets the authentication of this ProvidersLdapIdParams.  # noqa: E501

        If true, enables authentication and identity management through the authentication provider.  # noqa: E501

        :return: The authentication of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._authentication

    @authentication.setter
    def authentication(self, authentication):
        """Sets the authentication of this ProvidersLdapIdParams.

        If true, enables authentication and identity management through the authentication provider.  # noqa: E501

        :param authentication: The authentication of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._authentication = authentication

    @property
    def balance_servers(self):
        """Gets the balance_servers of this ProvidersLdapIdParams.  # noqa: E501

        If true, connects the provider to a random server.  # noqa: E501

        :return: The balance_servers of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._balance_servers

    @balance_servers.setter
    def balance_servers(self, balance_servers):
        """Sets the balance_servers of this ProvidersLdapIdParams.

        If true, connects the provider to a random server.  # noqa: E501

        :param balance_servers: The balance_servers of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._balance_servers = balance_servers

    @property
    def base_dn(self):
        """Gets the base_dn of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the root of the tree in which to search identities.  # noqa: E501

        :return: The base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._base_dn

    @base_dn.setter
    def base_dn(self, base_dn):
        """Sets the base_dn of this ProvidersLdapIdParams.

        Specifies the root of the tree in which to search identities.  # noqa: E501

        :param base_dn: The base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if base_dn is not None and len(base_dn) > 255:
            raise ValueError("Invalid value for `base_dn`, length must be less than or equal to `255`")  # noqa: E501
        if base_dn is not None and len(base_dn) < 0:
            raise ValueError("Invalid value for `base_dn`, length must be greater than or equal to `0`")  # noqa: E501

        self._base_dn = base_dn

    @property
    def bind_dn(self):
        """Gets the bind_dn of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the distinguished name for binding to the LDAP server.  # noqa: E501

        :return: The bind_dn of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._bind_dn

    @bind_dn.setter
    def bind_dn(self, bind_dn):
        """Sets the bind_dn of this ProvidersLdapIdParams.

        Specifies the distinguished name for binding to the LDAP server.  # noqa: E501

        :param bind_dn: The bind_dn of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if bind_dn is not None and len(bind_dn) > 255:
            raise ValueError("Invalid value for `bind_dn`, length must be less than or equal to `255`")  # noqa: E501
        if bind_dn is not None and len(bind_dn) < 0:
            raise ValueError("Invalid value for `bind_dn`, length must be greater than or equal to `0`")  # noqa: E501

        self._bind_dn = bind_dn

    @property
    def bind_mechanism(self):
        """Gets the bind_mechanism of this ProvidersLdapIdParams.  # noqa: E501

        Specifies which bind mechanism to use when connecting to an LDAP server. The only supported option is the 'simple' value.  # noqa: E501

        :return: The bind_mechanism of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._bind_mechanism

    @bind_mechanism.setter
    def bind_mechanism(self, bind_mechanism):
        """Sets the bind_mechanism of this ProvidersLdapIdParams.

        Specifies which bind mechanism to use when connecting to an LDAP server. The only supported option is the 'simple' value.  # noqa: E501

        :param bind_mechanism: The bind_mechanism of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._bind_mechanism = bind_mechanism

    @property
    def bind_password(self):
        """Gets the bind_password of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the password for the distinguished name for binding to the LDAP server.  # noqa: E501

        :return: The bind_password of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._bind_password

    @bind_password.setter
    def bind_password(self, bind_password):
        """Sets the bind_password of this ProvidersLdapIdParams.

        Specifies the password for the distinguished name for binding to the LDAP server.  # noqa: E501

        :param bind_password: The bind_password of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if bind_password is not None and len(bind_password) > 255:
            raise ValueError("Invalid value for `bind_password`, length must be less than or equal to `255`")  # noqa: E501
        if bind_password is not None and len(bind_password) < 0:
            raise ValueError("Invalid value for `bind_password`, length must be greater than or equal to `0`")  # noqa: E501

        self._bind_password = bind_password

    @property
    def bind_timeout(self):
        """Gets the bind_timeout of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the timeout in seconds when binding to an LDAP server.  # noqa: E501

        :return: The bind_timeout of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: int
        """
        return self._bind_timeout

    @bind_timeout.setter
    def bind_timeout(self, bind_timeout):
        """Sets the bind_timeout of this ProvidersLdapIdParams.

        Specifies the timeout in seconds when binding to an LDAP server.  # noqa: E501

        :param bind_timeout: The bind_timeout of this ProvidersLdapIdParams.  # noqa: E501
        :type: int
        """
        if bind_timeout is not None and bind_timeout > 3600:  # noqa: E501
            raise ValueError("Invalid value for `bind_timeout`, must be a value less than or equal to `3600`")  # noqa: E501
        if bind_timeout is not None and bind_timeout < 1:  # noqa: E501
            raise ValueError("Invalid value for `bind_timeout`, must be a value greater than or equal to `1`")  # noqa: E501

        self._bind_timeout = bind_timeout

    @property
    def certificate_authority_file(self):
        """Gets the certificate_authority_file of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the path to the root certificates file.  # noqa: E501

        :return: The certificate_authority_file of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._certificate_authority_file

    @certificate_authority_file.setter
    def certificate_authority_file(self, certificate_authority_file):
        """Sets the certificate_authority_file of this ProvidersLdapIdParams.

        Specifies the path to the root certificates file.  # noqa: E501

        :param certificate_authority_file: The certificate_authority_file of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if certificate_authority_file is not None and len(certificate_authority_file) > 4096:
            raise ValueError("Invalid value for `certificate_authority_file`, length must be less than or equal to `4096`")  # noqa: E501
        if certificate_authority_file is not None and len(certificate_authority_file) < 0:
            raise ValueError("Invalid value for `certificate_authority_file`, length must be greater than or equal to `0`")  # noqa: E501

        self._certificate_authority_file = certificate_authority_file

    @property
    def check_online_interval(self):
        """Gets the check_online_interval of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the time in seconds between provider online checks.  # noqa: E501

        :return: The check_online_interval of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: int
        """
        return self._check_online_interval

    @check_online_interval.setter
    def check_online_interval(self, check_online_interval):
        """Sets the check_online_interval of this ProvidersLdapIdParams.

        Specifies the time in seconds between provider online checks.  # noqa: E501

        :param check_online_interval: The check_online_interval of this ProvidersLdapIdParams.  # noqa: E501
        :type: int
        """
        if check_online_interval is not None and check_online_interval > 3600:  # noqa: E501
            raise ValueError("Invalid value for `check_online_interval`, must be a value less than or equal to `3600`")  # noqa: E501
        if check_online_interval is not None and check_online_interval < 0:  # noqa: E501
            raise ValueError("Invalid value for `check_online_interval`, must be a value greater than or equal to `0`")  # noqa: E501

        self._check_online_interval = check_online_interval

    @property
    def cn_attribute(self):
        """Gets the cn_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the canonical name.  # noqa: E501

        :return: The cn_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._cn_attribute

    @cn_attribute.setter
    def cn_attribute(self, cn_attribute):
        """Sets the cn_attribute of this ProvidersLdapIdParams.

        Specifies the canonical name.  # noqa: E501

        :param cn_attribute: The cn_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if cn_attribute is not None and len(cn_attribute) > 255:
            raise ValueError("Invalid value for `cn_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if cn_attribute is not None and len(cn_attribute) < 0:
            raise ValueError("Invalid value for `cn_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._cn_attribute = cn_attribute

    @property
    def create_home_directory(self):
        """Gets the create_home_directory of this ProvidersLdapIdParams.  # noqa: E501

        Automatically create the home directory on the first login.  # noqa: E501

        :return: The create_home_directory of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._create_home_directory

    @create_home_directory.setter
    def create_home_directory(self, create_home_directory):
        """Sets the create_home_directory of this ProvidersLdapIdParams.

        Automatically create the home directory on the first login.  # noqa: E501

        :param create_home_directory: The create_home_directory of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._create_home_directory = create_home_directory

    @property
    def crypt_password_attribute(self):
        """Gets the crypt_password_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the hashed password value.  # noqa: E501

        :return: The crypt_password_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._crypt_password_attribute

    @crypt_password_attribute.setter
    def crypt_password_attribute(self, crypt_password_attribute):
        """Sets the crypt_password_attribute of this ProvidersLdapIdParams.

        Specifies the hashed password value.  # noqa: E501

        :param crypt_password_attribute: The crypt_password_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if crypt_password_attribute is not None and len(crypt_password_attribute) > 255:
            raise ValueError("Invalid value for `crypt_password_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if crypt_password_attribute is not None and len(crypt_password_attribute) < 0:
            raise ValueError("Invalid value for `crypt_password_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._crypt_password_attribute = crypt_password_attribute

    @property
    def email_attribute(self):
        """Gets the email_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Email attribute.  # noqa: E501

        :return: The email_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._email_attribute

    @email_attribute.setter
    def email_attribute(self, email_attribute):
        """Sets the email_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Email attribute.  # noqa: E501

        :param email_attribute: The email_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if email_attribute is not None and len(email_attribute) > 64:
            raise ValueError("Invalid value for `email_attribute`, length must be less than or equal to `64`")  # noqa: E501
        if email_attribute is not None and len(email_attribute) < 4:
            raise ValueError("Invalid value for `email_attribute`, length must be greater than or equal to `4`")  # noqa: E501

        self._email_attribute = email_attribute

    @property
    def enabled(self):
        """Gets the enabled of this ProvidersLdapIdParams.  # noqa: E501

        If true, enables the LDAP provider.  # noqa: E501

        :return: The enabled of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ProvidersLdapIdParams.

        If true, enables the LDAP provider.  # noqa: E501

        :param enabled: The enabled of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def enumerate_groups(self):
        """Gets the enumerate_groups of this ProvidersLdapIdParams.  # noqa: E501

        If true, allows the provider to enumerate groups.  # noqa: E501

        :return: The enumerate_groups of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._enumerate_groups

    @enumerate_groups.setter
    def enumerate_groups(self, enumerate_groups):
        """Sets the enumerate_groups of this ProvidersLdapIdParams.

        If true, allows the provider to enumerate groups.  # noqa: E501

        :param enumerate_groups: The enumerate_groups of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._enumerate_groups = enumerate_groups

    @property
    def enumerate_users(self):
        """Gets the enumerate_users of this ProvidersLdapIdParams.  # noqa: E501

        If true, allows the provider to enumerate users.  # noqa: E501

        :return: The enumerate_users of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._enumerate_users

    @enumerate_users.setter
    def enumerate_users(self, enumerate_users):
        """Sets the enumerate_users of this ProvidersLdapIdParams.

        If true, allows the provider to enumerate users.  # noqa: E501

        :param enumerate_users: The enumerate_users of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._enumerate_users = enumerate_users

    @property
    def findable_groups(self):
        """Gets the findable_groups of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the list of groups that can be resolved.  # noqa: E501

        :return: The findable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._findable_groups

    @findable_groups.setter
    def findable_groups(self, findable_groups):
        """Sets the findable_groups of this ProvidersLdapIdParams.

        Specifies the list of groups that can be resolved.  # noqa: E501

        :param findable_groups: The findable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._findable_groups = findable_groups

    @property
    def findable_users(self):
        """Gets the findable_users of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the list of users that can be resolved.  # noqa: E501

        :return: The findable_users of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._findable_users

    @findable_users.setter
    def findable_users(self, findable_users):
        """Sets the findable_users of this ProvidersLdapIdParams.

        Specifies the list of users that can be resolved.  # noqa: E501

        :param findable_users: The findable_users of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._findable_users = findable_users

    @property
    def gecos_attribute(self):
        """Gets the gecos_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP GECOS attribute.  # noqa: E501

        :return: The gecos_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._gecos_attribute

    @gecos_attribute.setter
    def gecos_attribute(self, gecos_attribute):
        """Sets the gecos_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP GECOS attribute.  # noqa: E501

        :param gecos_attribute: The gecos_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if gecos_attribute is not None and len(gecos_attribute) > 255:
            raise ValueError("Invalid value for `gecos_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if gecos_attribute is not None and len(gecos_attribute) < 0:
            raise ValueError("Invalid value for `gecos_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._gecos_attribute = gecos_attribute

    @property
    def gid_attribute(self):
        """Gets the gid_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP GID attribute.  # noqa: E501

        :return: The gid_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._gid_attribute

    @gid_attribute.setter
    def gid_attribute(self, gid_attribute):
        """Sets the gid_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP GID attribute.  # noqa: E501

        :param gid_attribute: The gid_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if gid_attribute is not None and len(gid_attribute) > 255:
            raise ValueError("Invalid value for `gid_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if gid_attribute is not None and len(gid_attribute) < 0:
            raise ValueError("Invalid value for `gid_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._gid_attribute = gid_attribute

    @property
    def group_base_dn(self):
        """Gets the group_base_dn of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the distinguished name of the entry where LDAP searches for groups are started.  # noqa: E501

        :return: The group_base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._group_base_dn

    @group_base_dn.setter
    def group_base_dn(self, group_base_dn):
        """Sets the group_base_dn of this ProvidersLdapIdParams.

        Specifies the distinguished name of the entry where LDAP searches for groups are started.  # noqa: E501

        :param group_base_dn: The group_base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if group_base_dn is not None and len(group_base_dn) > 255:
            raise ValueError("Invalid value for `group_base_dn`, length must be less than or equal to `255`")  # noqa: E501
        if group_base_dn is not None and len(group_base_dn) < 0:
            raise ValueError("Invalid value for `group_base_dn`, length must be greater than or equal to `0`")  # noqa: E501

        self._group_base_dn = group_base_dn

    @property
    def group_domain(self):
        """Gets the group_domain of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the domain for this provider through which groups are qualified.  # noqa: E501

        :return: The group_domain of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._group_domain

    @group_domain.setter
    def group_domain(self, group_domain):
        """Sets the group_domain of this ProvidersLdapIdParams.

        Specifies the domain for this provider through which groups are qualified.  # noqa: E501

        :param group_domain: The group_domain of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if group_domain is not None and len(group_domain) > 255:
            raise ValueError("Invalid value for `group_domain`, length must be less than or equal to `255`")  # noqa: E501
        if group_domain is not None and len(group_domain) < 0:
            raise ValueError("Invalid value for `group_domain`, length must be greater than or equal to `0`")  # noqa: E501

        self._group_domain = group_domain

    @property
    def group_filter(self):
        """Gets the group_filter of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP filter for group objects.  # noqa: E501

        :return: The group_filter of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._group_filter

    @group_filter.setter
    def group_filter(self, group_filter):
        """Sets the group_filter of this ProvidersLdapIdParams.

        Specifies the LDAP filter for group objects.  # noqa: E501

        :param group_filter: The group_filter of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if group_filter is not None and len(group_filter) > 255:
            raise ValueError("Invalid value for `group_filter`, length must be less than or equal to `255`")  # noqa: E501
        if group_filter is not None and len(group_filter) < 0:
            raise ValueError("Invalid value for `group_filter`, length must be greater than or equal to `0`")  # noqa: E501

        self._group_filter = group_filter

    @property
    def group_members_attribute(self):
        """Gets the group_members_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Group Members attribute.  # noqa: E501

        :return: The group_members_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._group_members_attribute

    @group_members_attribute.setter
    def group_members_attribute(self, group_members_attribute):
        """Sets the group_members_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Group Members attribute.  # noqa: E501

        :param group_members_attribute: The group_members_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if group_members_attribute is not None and len(group_members_attribute) > 255:
            raise ValueError("Invalid value for `group_members_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if group_members_attribute is not None and len(group_members_attribute) < 0:
            raise ValueError("Invalid value for `group_members_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._group_members_attribute = group_members_attribute

    @property
    def group_search_scope(self):
        """Gets the group_search_scope of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the depth from the base DN to perform LDAP searches.  # noqa: E501

        :return: The group_search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._group_search_scope

    @group_search_scope.setter
    def group_search_scope(self, group_search_scope):
        """Sets the group_search_scope of this ProvidersLdapIdParams.

        Specifies the depth from the base DN to perform LDAP searches.  # noqa: E501

        :param group_search_scope: The group_search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._group_search_scope = group_search_scope

    @property
    def home_directory_template(self):
        """Gets the home_directory_template of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the path to the home directory template.  # noqa: E501

        :return: The home_directory_template of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._home_directory_template

    @home_directory_template.setter
    def home_directory_template(self, home_directory_template):
        """Sets the home_directory_template of this ProvidersLdapIdParams.

        Specifies the path to the home directory template.  # noqa: E501

        :param home_directory_template: The home_directory_template of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if home_directory_template is not None and len(home_directory_template) > 4096:
            raise ValueError("Invalid value for `home_directory_template`, length must be less than or equal to `4096`")  # noqa: E501
        if home_directory_template is not None and len(home_directory_template) < 0:
            raise ValueError("Invalid value for `home_directory_template`, length must be greater than or equal to `0`")  # noqa: E501
        if home_directory_template is not None and not re.search('^((\/[^\/\\0]+)(\/?))*$', home_directory_template):  # noqa: E501
            raise ValueError("Invalid value for `home_directory_template`, must be a follow pattern or equal to `/^((\/[^\/\\0]+)(\/?))*$/`")  # noqa: E501

        self._home_directory_template = home_directory_template

    @property
    def homedir_attribute(self):
        """Gets the homedir_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Homedir attribute.  # noqa: E501

        :return: The homedir_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._homedir_attribute

    @homedir_attribute.setter
    def homedir_attribute(self, homedir_attribute):
        """Sets the homedir_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Homedir attribute.  # noqa: E501

        :param homedir_attribute: The homedir_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if homedir_attribute is not None and len(homedir_attribute) > 255:
            raise ValueError("Invalid value for `homedir_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if homedir_attribute is not None and len(homedir_attribute) < 0:
            raise ValueError("Invalid value for `homedir_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._homedir_attribute = homedir_attribute

    @property
    def ignore_tls_errors(self):
        """Gets the ignore_tls_errors of this ProvidersLdapIdParams.  # noqa: E501

        If true, continues over secure connections even if identity checks fail.  # noqa: E501

        :return: The ignore_tls_errors of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_tls_errors

    @ignore_tls_errors.setter
    def ignore_tls_errors(self, ignore_tls_errors):
        """Sets the ignore_tls_errors of this ProvidersLdapIdParams.

        If true, continues over secure connections even if identity checks fail.  # noqa: E501

        :param ignore_tls_errors: The ignore_tls_errors of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._ignore_tls_errors = ignore_tls_errors

    @property
    def listable_groups(self):
        """Gets the listable_groups of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the groups that can be viewed in the provider.  # noqa: E501

        :return: The listable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._listable_groups

    @listable_groups.setter
    def listable_groups(self, listable_groups):
        """Sets the listable_groups of this ProvidersLdapIdParams.

        Specifies the groups that can be viewed in the provider.  # noqa: E501

        :param listable_groups: The listable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._listable_groups = listable_groups

    @property
    def listable_users(self):
        """Gets the listable_users of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the users that can be viewed in the provider.  # noqa: E501

        :return: The listable_users of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._listable_users

    @listable_users.setter
    def listable_users(self, listable_users):
        """Sets the listable_users of this ProvidersLdapIdParams.

        Specifies the users that can be viewed in the provider.  # noqa: E501

        :param listable_users: The listable_users of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._listable_users = listable_users

    @property
    def login_shell(self):
        """Gets the login_shell of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the login shell path.  # noqa: E501

        :return: The login_shell of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._login_shell

    @login_shell.setter
    def login_shell(self, login_shell):
        """Sets the login_shell of this ProvidersLdapIdParams.

        Specifies the login shell path.  # noqa: E501

        :param login_shell: The login_shell of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if login_shell is not None and len(login_shell) > 4096:
            raise ValueError("Invalid value for `login_shell`, length must be less than or equal to `4096`")  # noqa: E501
        if login_shell is not None and len(login_shell) < 0:
            raise ValueError("Invalid value for `login_shell`, length must be greater than or equal to `0`")  # noqa: E501

        self._login_shell = login_shell

    @property
    def member_lookup_method(self):
        """Gets the member_lookup_method of this ProvidersLdapIdParams.  # noqa: E501

        Sets the method by which group member lookups are performed. Use caution when changing this option directly.  # noqa: E501

        :return: The member_lookup_method of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._member_lookup_method

    @member_lookup_method.setter
    def member_lookup_method(self, member_lookup_method):
        """Sets the member_lookup_method of this ProvidersLdapIdParams.

        Sets the method by which group member lookups are performed. Use caution when changing this option directly.  # noqa: E501

        :param member_lookup_method: The member_lookup_method of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._member_lookup_method = member_lookup_method

    @property
    def member_of_attribute(self):
        """Gets the member_of_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Query Member Of attribute, which performs reverse membership queries.  # noqa: E501

        :return: The member_of_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._member_of_attribute

    @member_of_attribute.setter
    def member_of_attribute(self, member_of_attribute):
        """Sets the member_of_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Query Member Of attribute, which performs reverse membership queries.  # noqa: E501

        :param member_of_attribute: The member_of_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if member_of_attribute is not None and len(member_of_attribute) > 255:
            raise ValueError("Invalid value for `member_of_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if member_of_attribute is not None and len(member_of_attribute) < 0:
            raise ValueError("Invalid value for `member_of_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._member_of_attribute = member_of_attribute

    @property
    def name(self):
        """Gets the name of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the name of the LDAP provider.  # noqa: E501

        :return: The name of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProvidersLdapIdParams.

        Specifies the name of the LDAP provider.  # noqa: E501

        :param name: The name of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 0:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `0`")  # noqa: E501

        self._name = name

    @property
    def name_attribute(self):
        """Gets the name_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP UID attribute, which is used as the login name.  # noqa: E501

        :return: The name_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._name_attribute

    @name_attribute.setter
    def name_attribute(self, name_attribute):
        """Sets the name_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP UID attribute, which is used as the login name.  # noqa: E501

        :param name_attribute: The name_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if name_attribute is not None and len(name_attribute) > 255:
            raise ValueError("Invalid value for `name_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if name_attribute is not None and len(name_attribute) < 0:
            raise ValueError("Invalid value for `name_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._name_attribute = name_attribute

    @property
    def netgroup_base_dn(self):
        """Gets the netgroup_base_dn of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the distinguished name of the entry where LDAP searches for netgroups are started.  # noqa: E501

        :return: The netgroup_base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._netgroup_base_dn

    @netgroup_base_dn.setter
    def netgroup_base_dn(self, netgroup_base_dn):
        """Sets the netgroup_base_dn of this ProvidersLdapIdParams.

        Specifies the distinguished name of the entry where LDAP searches for netgroups are started.  # noqa: E501

        :param netgroup_base_dn: The netgroup_base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if netgroup_base_dn is not None and len(netgroup_base_dn) > 255:
            raise ValueError("Invalid value for `netgroup_base_dn`, length must be less than or equal to `255`")  # noqa: E501
        if netgroup_base_dn is not None and len(netgroup_base_dn) < 0:
            raise ValueError("Invalid value for `netgroup_base_dn`, length must be greater than or equal to `0`")  # noqa: E501

        self._netgroup_base_dn = netgroup_base_dn

    @property
    def netgroup_filter(self):
        """Gets the netgroup_filter of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP filter for netgroup objects.  # noqa: E501

        :return: The netgroup_filter of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._netgroup_filter

    @netgroup_filter.setter
    def netgroup_filter(self, netgroup_filter):
        """Sets the netgroup_filter of this ProvidersLdapIdParams.

        Specifies the LDAP filter for netgroup objects.  # noqa: E501

        :param netgroup_filter: The netgroup_filter of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if netgroup_filter is not None and len(netgroup_filter) > 255:
            raise ValueError("Invalid value for `netgroup_filter`, length must be less than or equal to `255`")  # noqa: E501
        if netgroup_filter is not None and len(netgroup_filter) < 0:
            raise ValueError("Invalid value for `netgroup_filter`, length must be greater than or equal to `0`")  # noqa: E501

        self._netgroup_filter = netgroup_filter

    @property
    def netgroup_members_attribute(self):
        """Gets the netgroup_members_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Netgroup Members attribute.  # noqa: E501

        :return: The netgroup_members_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._netgroup_members_attribute

    @netgroup_members_attribute.setter
    def netgroup_members_attribute(self, netgroup_members_attribute):
        """Sets the netgroup_members_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Netgroup Members attribute.  # noqa: E501

        :param netgroup_members_attribute: The netgroup_members_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if netgroup_members_attribute is not None and len(netgroup_members_attribute) > 255:
            raise ValueError("Invalid value for `netgroup_members_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if netgroup_members_attribute is not None and len(netgroup_members_attribute) < 0:
            raise ValueError("Invalid value for `netgroup_members_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._netgroup_members_attribute = netgroup_members_attribute

    @property
    def netgroup_search_scope(self):
        """Gets the netgroup_search_scope of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the depth from the base DN to perform LDAP searches.  # noqa: E501

        :return: The netgroup_search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._netgroup_search_scope

    @netgroup_search_scope.setter
    def netgroup_search_scope(self, netgroup_search_scope):
        """Sets the netgroup_search_scope of this ProvidersLdapIdParams.

        Specifies the depth from the base DN to perform LDAP searches.  # noqa: E501

        :param netgroup_search_scope: The netgroup_search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._netgroup_search_scope = netgroup_search_scope

    @property
    def netgroup_triple_attribute(self):
        """Gets the netgroup_triple_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Netgroup Triple attribute.  # noqa: E501

        :return: The netgroup_triple_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._netgroup_triple_attribute

    @netgroup_triple_attribute.setter
    def netgroup_triple_attribute(self, netgroup_triple_attribute):
        """Sets the netgroup_triple_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Netgroup Triple attribute.  # noqa: E501

        :param netgroup_triple_attribute: The netgroup_triple_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if netgroup_triple_attribute is not None and len(netgroup_triple_attribute) > 255:
            raise ValueError("Invalid value for `netgroup_triple_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if netgroup_triple_attribute is not None and len(netgroup_triple_attribute) < 0:
            raise ValueError("Invalid value for `netgroup_triple_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._netgroup_triple_attribute = netgroup_triple_attribute

    @property
    def normalize_groups(self):
        """Gets the normalize_groups of this ProvidersLdapIdParams.  # noqa: E501

        Normalizes group names to lowercase before look up.  # noqa: E501

        :return: The normalize_groups of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._normalize_groups

    @normalize_groups.setter
    def normalize_groups(self, normalize_groups):
        """Sets the normalize_groups of this ProvidersLdapIdParams.

        Normalizes group names to lowercase before look up.  # noqa: E501

        :param normalize_groups: The normalize_groups of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._normalize_groups = normalize_groups

    @property
    def normalize_users(self):
        """Gets the normalize_users of this ProvidersLdapIdParams.  # noqa: E501

        Normalizes user names to lowercase before look up.  # noqa: E501

        :return: The normalize_users of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._normalize_users

    @normalize_users.setter
    def normalize_users(self, normalize_users):
        """Sets the normalize_users of this ProvidersLdapIdParams.

        Normalizes user names to lowercase before look up.  # noqa: E501

        :param normalize_users: The normalize_users of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._normalize_users = normalize_users

    @property
    def nt_password_attribute(self):
        """Gets the nt_password_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP NT Password attribute.  # noqa: E501

        :return: The nt_password_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._nt_password_attribute

    @nt_password_attribute.setter
    def nt_password_attribute(self, nt_password_attribute):
        """Sets the nt_password_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP NT Password attribute.  # noqa: E501

        :param nt_password_attribute: The nt_password_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if nt_password_attribute is not None and len(nt_password_attribute) > 255:
            raise ValueError("Invalid value for `nt_password_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if nt_password_attribute is not None and len(nt_password_attribute) < 0:
            raise ValueError("Invalid value for `nt_password_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._nt_password_attribute = nt_password_attribute

    @property
    def ntlm_support(self):
        """Gets the ntlm_support of this ProvidersLdapIdParams.  # noqa: E501

        Specifies which NTLM versions to support for users with NTLM-compatible credentials.  # noqa: E501

        :return: The ntlm_support of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._ntlm_support

    @ntlm_support.setter
    def ntlm_support(self, ntlm_support):
        """Sets the ntlm_support of this ProvidersLdapIdParams.

        Specifies which NTLM versions to support for users with NTLM-compatible credentials.  # noqa: E501

        :param ntlm_support: The ntlm_support of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._ntlm_support = ntlm_support

    @property
    def provider_domain(self):
        """Gets the provider_domain of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the provider domain.  # noqa: E501

        :return: The provider_domain of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._provider_domain

    @provider_domain.setter
    def provider_domain(self, provider_domain):
        """Sets the provider_domain of this ProvidersLdapIdParams.

        Specifies the provider domain.  # noqa: E501

        :param provider_domain: The provider_domain of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if provider_domain is not None and len(provider_domain) > 255:
            raise ValueError("Invalid value for `provider_domain`, length must be less than or equal to `255`")  # noqa: E501
        if provider_domain is not None and len(provider_domain) < 0:
            raise ValueError("Invalid value for `provider_domain`, length must be greater than or equal to `0`")  # noqa: E501

        self._provider_domain = provider_domain

    @property
    def require_secure_connection(self):
        """Gets the require_secure_connection of this ProvidersLdapIdParams.  # noqa: E501

        Determines whether to continue over a non-TLS connection.  # noqa: E501

        :return: The require_secure_connection of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._require_secure_connection

    @require_secure_connection.setter
    def require_secure_connection(self, require_secure_connection):
        """Sets the require_secure_connection of this ProvidersLdapIdParams.

        Determines whether to continue over a non-TLS connection.  # noqa: E501

        :param require_secure_connection: The require_secure_connection of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._require_secure_connection = require_secure_connection

    @property
    def restrict_findable(self):
        """Gets the restrict_findable of this ProvidersLdapIdParams.  # noqa: E501

        If true, checks the provider for filtered lists of findable and unfindable users and groups.  # noqa: E501

        :return: The restrict_findable of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_findable

    @restrict_findable.setter
    def restrict_findable(self, restrict_findable):
        """Sets the restrict_findable of this ProvidersLdapIdParams.

        If true, checks the provider for filtered lists of findable and unfindable users and groups.  # noqa: E501

        :param restrict_findable: The restrict_findable of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._restrict_findable = restrict_findable

    @property
    def restrict_listable(self):
        """Gets the restrict_listable of this ProvidersLdapIdParams.  # noqa: E501

        If true, checks the provider for filtered lists of listable and unlistable users and groups.  # noqa: E501

        :return: The restrict_listable of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_listable

    @restrict_listable.setter
    def restrict_listable(self, restrict_listable):
        """Sets the restrict_listable of this ProvidersLdapIdParams.

        If true, checks the provider for filtered lists of listable and unlistable users and groups.  # noqa: E501

        :param restrict_listable: The restrict_listable of this ProvidersLdapIdParams.  # noqa: E501
        :type: bool
        """

        self._restrict_listable = restrict_listable

    @property
    def search_scope(self):
        """Gets the search_scope of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the default depth from the base DN to perform LDAP searches.  # noqa: E501

        :return: The search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._search_scope

    @search_scope.setter
    def search_scope(self, search_scope):
        """Sets the search_scope of this ProvidersLdapIdParams.

        Specifies the default depth from the base DN to perform LDAP searches.  # noqa: E501

        :param search_scope: The search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._search_scope = search_scope

    @property
    def search_timeout(self):
        """Gets the search_timeout of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the search timeout period in seconds.  # noqa: E501

        :return: The search_timeout of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: int
        """
        return self._search_timeout

    @search_timeout.setter
    def search_timeout(self, search_timeout):
        """Sets the search_timeout of this ProvidersLdapIdParams.

        Specifies the search timeout period in seconds.  # noqa: E501

        :param search_timeout: The search_timeout of this ProvidersLdapIdParams.  # noqa: E501
        :type: int
        """
        if search_timeout is not None and search_timeout > 3600:  # noqa: E501
            raise ValueError("Invalid value for `search_timeout`, must be a value less than or equal to `3600`")  # noqa: E501
        if search_timeout is not None and search_timeout < 10:  # noqa: E501
            raise ValueError("Invalid value for `search_timeout`, must be a value greater than or equal to `10`")  # noqa: E501

        self._search_timeout = search_timeout

    @property
    def server_uris(self):
        """Gets the server_uris of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the server URIs.  # noqa: E501

        :return: The server_uris of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._server_uris

    @server_uris.setter
    def server_uris(self, server_uris):
        """Sets the server_uris of this ProvidersLdapIdParams.

        Specifies the server URIs.  # noqa: E501

        :param server_uris: The server_uris of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._server_uris = server_uris

    @property
    def shadow_expire_attribute(self):
        """Gets the shadow_expire_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the absolute date to expire the account.  # noqa: E501

        :return: The shadow_expire_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_expire_attribute

    @shadow_expire_attribute.setter
    def shadow_expire_attribute(self, shadow_expire_attribute):
        """Sets the shadow_expire_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the absolute date to expire the account.  # noqa: E501

        :param shadow_expire_attribute: The shadow_expire_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_expire_attribute is not None and len(shadow_expire_attribute) > 255:
            raise ValueError("Invalid value for `shadow_expire_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_expire_attribute is not None and len(shadow_expire_attribute) < 0:
            raise ValueError("Invalid value for `shadow_expire_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_expire_attribute = shadow_expire_attribute

    @property
    def shadow_flag_attribute(self):
        """Gets the shadow_flag_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the section of the shadow map that is used to store the flag value.  # noqa: E501

        :return: The shadow_flag_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_flag_attribute

    @shadow_flag_attribute.setter
    def shadow_flag_attribute(self, shadow_flag_attribute):
        """Sets the shadow_flag_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the section of the shadow map that is used to store the flag value.  # noqa: E501

        :param shadow_flag_attribute: The shadow_flag_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_flag_attribute is not None and len(shadow_flag_attribute) > 255:
            raise ValueError("Invalid value for `shadow_flag_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_flag_attribute is not None and len(shadow_flag_attribute) < 0:
            raise ValueError("Invalid value for `shadow_flag_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_flag_attribute = shadow_flag_attribute

    @property
    def shadow_inactive_attribute(self):
        """Gets the shadow_inactive_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the number of days of inactivity that is allowed for the user.  # noqa: E501

        :return: The shadow_inactive_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_inactive_attribute

    @shadow_inactive_attribute.setter
    def shadow_inactive_attribute(self, shadow_inactive_attribute):
        """Sets the shadow_inactive_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the number of days of inactivity that is allowed for the user.  # noqa: E501

        :param shadow_inactive_attribute: The shadow_inactive_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_inactive_attribute is not None and len(shadow_inactive_attribute) > 255:
            raise ValueError("Invalid value for `shadow_inactive_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_inactive_attribute is not None and len(shadow_inactive_attribute) < 0:
            raise ValueError("Invalid value for `shadow_inactive_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_inactive_attribute = shadow_inactive_attribute

    @property
    def shadow_last_change_attribute(self):
        """Gets the shadow_last_change_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the last change of the shadow information.  # noqa: E501

        :return: The shadow_last_change_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_last_change_attribute

    @shadow_last_change_attribute.setter
    def shadow_last_change_attribute(self, shadow_last_change_attribute):
        """Sets the shadow_last_change_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the last change of the shadow information.  # noqa: E501

        :param shadow_last_change_attribute: The shadow_last_change_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_last_change_attribute is not None and len(shadow_last_change_attribute) > 255:
            raise ValueError("Invalid value for `shadow_last_change_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_last_change_attribute is not None and len(shadow_last_change_attribute) < 0:
            raise ValueError("Invalid value for `shadow_last_change_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_last_change_attribute = shadow_last_change_attribute

    @property
    def shadow_max_attribute(self):
        """Gets the shadow_max_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the maximum number of days a password can be valid.  # noqa: E501

        :return: The shadow_max_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_max_attribute

    @shadow_max_attribute.setter
    def shadow_max_attribute(self, shadow_max_attribute):
        """Sets the shadow_max_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the maximum number of days a password can be valid.  # noqa: E501

        :param shadow_max_attribute: The shadow_max_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_max_attribute is not None and len(shadow_max_attribute) > 255:
            raise ValueError("Invalid value for `shadow_max_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_max_attribute is not None and len(shadow_max_attribute) < 0:
            raise ValueError("Invalid value for `shadow_max_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_max_attribute = shadow_max_attribute

    @property
    def shadow_min_attribute(self):
        """Gets the shadow_min_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the minimum number of days between shadow changes.  # noqa: E501

        :return: The shadow_min_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_min_attribute

    @shadow_min_attribute.setter
    def shadow_min_attribute(self, shadow_min_attribute):
        """Sets the shadow_min_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the minimum number of days between shadow changes.  # noqa: E501

        :param shadow_min_attribute: The shadow_min_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_min_attribute is not None and len(shadow_min_attribute) > 255:
            raise ValueError("Invalid value for `shadow_min_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_min_attribute is not None and len(shadow_min_attribute) < 0:
            raise ValueError("Invalid value for `shadow_min_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_min_attribute = shadow_min_attribute

    @property
    def shadow_user_filter(self):
        """Gets the shadow_user_filter of this ProvidersLdapIdParams.  # noqa: E501

        Sets LDAP filter for shadow user objects.  # noqa: E501

        :return: The shadow_user_filter of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_user_filter

    @shadow_user_filter.setter
    def shadow_user_filter(self, shadow_user_filter):
        """Sets the shadow_user_filter of this ProvidersLdapIdParams.

        Sets LDAP filter for shadow user objects.  # noqa: E501

        :param shadow_user_filter: The shadow_user_filter of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_user_filter is not None and len(shadow_user_filter) > 255:
            raise ValueError("Invalid value for `shadow_user_filter`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_user_filter is not None and len(shadow_user_filter) < 0:
            raise ValueError("Invalid value for `shadow_user_filter`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_user_filter = shadow_user_filter

    @property
    def shadow_warning_attribute(self):
        """Gets the shadow_warning_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the number of days before the password expires to warn the user.  # noqa: E501

        :return: The shadow_warning_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shadow_warning_attribute

    @shadow_warning_attribute.setter
    def shadow_warning_attribute(self, shadow_warning_attribute):
        """Sets the shadow_warning_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the number of days before the password expires to warn the user.  # noqa: E501

        :param shadow_warning_attribute: The shadow_warning_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shadow_warning_attribute is not None and len(shadow_warning_attribute) > 255:
            raise ValueError("Invalid value for `shadow_warning_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shadow_warning_attribute is not None and len(shadow_warning_attribute) < 0:
            raise ValueError("Invalid value for `shadow_warning_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shadow_warning_attribute = shadow_warning_attribute

    @property
    def shell_attribute(self):
        """Gets the shell_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP Shell attribute.  # noqa: E501

        :return: The shell_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._shell_attribute

    @shell_attribute.setter
    def shell_attribute(self, shell_attribute):
        """Sets the shell_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP Shell attribute.  # noqa: E501

        :param shell_attribute: The shell_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if shell_attribute is not None and len(shell_attribute) > 255:
            raise ValueError("Invalid value for `shell_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if shell_attribute is not None and len(shell_attribute) < 0:
            raise ValueError("Invalid value for `shell_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._shell_attribute = shell_attribute

    @property
    def ssh_public_key_attribute(self):
        """Gets the ssh_public_key_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the attribute name that indicates the SSH Public Key for the user.  # noqa: E501

        :return: The ssh_public_key_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._ssh_public_key_attribute

    @ssh_public_key_attribute.setter
    def ssh_public_key_attribute(self, ssh_public_key_attribute):
        """Sets the ssh_public_key_attribute of this ProvidersLdapIdParams.

        Sets the attribute name that indicates the SSH Public Key for the user.  # noqa: E501

        :param ssh_public_key_attribute: The ssh_public_key_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if ssh_public_key_attribute is not None and len(ssh_public_key_attribute) > 255:
            raise ValueError("Invalid value for `ssh_public_key_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if ssh_public_key_attribute is not None and len(ssh_public_key_attribute) < 0:
            raise ValueError("Invalid value for `ssh_public_key_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._ssh_public_key_attribute = ssh_public_key_attribute

    @property
    def template(self):
        """Gets the template of this ProvidersLdapIdParams.  # noqa: E501

        Specifies template to be used to create the LDAP provider. The list of templates can be found at /auth/ldap-templates.  Any fields directly defined in your request will override the template values.  # noqa: E501

        :return: The template of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._template

    @template.setter
    def template(self, template):
        """Sets the template of this ProvidersLdapIdParams.

        Specifies template to be used to create the LDAP provider. The list of templates can be found at /auth/ldap-templates.  Any fields directly defined in your request will override the template values.  # noqa: E501

        :param template: The template of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._template = template

    @property
    def tls_protocol_min(self):
        """Gets the tls_protocol_min of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the minimum TLS protocol version.  # noqa: E501

        :return: The tls_protocol_min of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._tls_protocol_min

    @tls_protocol_min.setter
    def tls_protocol_min(self, tls_protocol_min):
        """Sets the tls_protocol_min of this ProvidersLdapIdParams.

        Specifies the minimum TLS protocol version.  # noqa: E501

        :param tls_protocol_min: The tls_protocol_min of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if tls_protocol_min is not None and len(tls_protocol_min) > 255:
            raise ValueError("Invalid value for `tls_protocol_min`, length must be less than or equal to `255`")  # noqa: E501
        if tls_protocol_min is not None and len(tls_protocol_min) < 0:
            raise ValueError("Invalid value for `tls_protocol_min`, length must be greater than or equal to `0`")  # noqa: E501
        if tls_protocol_min is not None and not re.search('^[0-9]+\\.[0-9]+$', tls_protocol_min):  # noqa: E501
            raise ValueError("Invalid value for `tls_protocol_min`, must be a follow pattern or equal to `/^[0-9]+\\.[0-9]+$/`")  # noqa: E501

        self._tls_protocol_min = tls_protocol_min

    @property
    def uid_attribute(self):
        """Gets the uid_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP UID Number attribute.  # noqa: E501

        :return: The uid_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._uid_attribute

    @uid_attribute.setter
    def uid_attribute(self, uid_attribute):
        """Sets the uid_attribute of this ProvidersLdapIdParams.

        Specifies the LDAP UID Number attribute.  # noqa: E501

        :param uid_attribute: The uid_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if uid_attribute is not None and len(uid_attribute) > 255:
            raise ValueError("Invalid value for `uid_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if uid_attribute is not None and len(uid_attribute) < 0:
            raise ValueError("Invalid value for `uid_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._uid_attribute = uid_attribute

    @property
    def unfindable_groups(self):
        """Gets the unfindable_groups of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the groups that cannot be resolved by the provider.  # noqa: E501

        :return: The unfindable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._unfindable_groups

    @unfindable_groups.setter
    def unfindable_groups(self, unfindable_groups):
        """Sets the unfindable_groups of this ProvidersLdapIdParams.

        Specifies the groups that cannot be resolved by the provider.  # noqa: E501

        :param unfindable_groups: The unfindable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._unfindable_groups = unfindable_groups

    @property
    def unfindable_users(self):
        """Gets the unfindable_users of this ProvidersLdapIdParams.  # noqa: E501

        Specifies users that cannot be resolved by the provider.  # noqa: E501

        :return: The unfindable_users of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._unfindable_users

    @unfindable_users.setter
    def unfindable_users(self, unfindable_users):
        """Sets the unfindable_users of this ProvidersLdapIdParams.

        Specifies users that cannot be resolved by the provider.  # noqa: E501

        :param unfindable_users: The unfindable_users of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._unfindable_users = unfindable_users

    @property
    def unique_group_members_attribute(self):
        """Gets the unique_group_members_attribute of this ProvidersLdapIdParams.  # noqa: E501

        Sets the LDAP Unique Group Members attribute.  # noqa: E501

        :return: The unique_group_members_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._unique_group_members_attribute

    @unique_group_members_attribute.setter
    def unique_group_members_attribute(self, unique_group_members_attribute):
        """Sets the unique_group_members_attribute of this ProvidersLdapIdParams.

        Sets the LDAP Unique Group Members attribute.  # noqa: E501

        :param unique_group_members_attribute: The unique_group_members_attribute of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if unique_group_members_attribute is not None and len(unique_group_members_attribute) > 255:
            raise ValueError("Invalid value for `unique_group_members_attribute`, length must be less than or equal to `255`")  # noqa: E501
        if unique_group_members_attribute is not None and len(unique_group_members_attribute) < 0:
            raise ValueError("Invalid value for `unique_group_members_attribute`, length must be greater than or equal to `0`")  # noqa: E501

        self._unique_group_members_attribute = unique_group_members_attribute

    @property
    def unlistable_groups(self):
        """Gets the unlistable_groups of this ProvidersLdapIdParams.  # noqa: E501

        Specifies a group that cannot be listed by the provider.  # noqa: E501

        :return: The unlistable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._unlistable_groups

    @unlistable_groups.setter
    def unlistable_groups(self, unlistable_groups):
        """Sets the unlistable_groups of this ProvidersLdapIdParams.

        Specifies a group that cannot be listed by the provider.  # noqa: E501

        :param unlistable_groups: The unlistable_groups of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._unlistable_groups = unlistable_groups

    @property
    def unlistable_users(self):
        """Gets the unlistable_users of this ProvidersLdapIdParams.  # noqa: E501

        Specifies a user that cannot be listed by the provider.  # noqa: E501

        :return: The unlistable_users of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._unlistable_users

    @unlistable_users.setter
    def unlistable_users(self, unlistable_users):
        """Sets the unlistable_users of this ProvidersLdapIdParams.

        Specifies a user that cannot be listed by the provider.  # noqa: E501

        :param unlistable_users: The unlistable_users of this ProvidersLdapIdParams.  # noqa: E501
        :type: list[str]
        """

        self._unlistable_users = unlistable_users

    @property
    def user_base_dn(self):
        """Gets the user_base_dn of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the distinguished name of the entry at which to start LDAP searches for users.  # noqa: E501

        :return: The user_base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._user_base_dn

    @user_base_dn.setter
    def user_base_dn(self, user_base_dn):
        """Sets the user_base_dn of this ProvidersLdapIdParams.

        Specifies the distinguished name of the entry at which to start LDAP searches for users.  # noqa: E501

        :param user_base_dn: The user_base_dn of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if user_base_dn is not None and len(user_base_dn) > 255:
            raise ValueError("Invalid value for `user_base_dn`, length must be less than or equal to `255`")  # noqa: E501
        if user_base_dn is not None and len(user_base_dn) < 0:
            raise ValueError("Invalid value for `user_base_dn`, length must be greater than or equal to `0`")  # noqa: E501

        self._user_base_dn = user_base_dn

    @property
    def user_domain(self):
        """Gets the user_domain of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the domain for this provider through which users are qualified.  # noqa: E501

        :return: The user_domain of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._user_domain

    @user_domain.setter
    def user_domain(self, user_domain):
        """Sets the user_domain of this ProvidersLdapIdParams.

        Specifies the domain for this provider through which users are qualified.  # noqa: E501

        :param user_domain: The user_domain of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if user_domain is not None and len(user_domain) > 255:
            raise ValueError("Invalid value for `user_domain`, length must be less than or equal to `255`")  # noqa: E501
        if user_domain is not None and len(user_domain) < 0:
            raise ValueError("Invalid value for `user_domain`, length must be greater than or equal to `0`")  # noqa: E501

        self._user_domain = user_domain

    @property
    def user_filter(self):
        """Gets the user_filter of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the LDAP filter for user objects.  # noqa: E501

        :return: The user_filter of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._user_filter

    @user_filter.setter
    def user_filter(self, user_filter):
        """Sets the user_filter of this ProvidersLdapIdParams.

        Specifies the LDAP filter for user objects.  # noqa: E501

        :param user_filter: The user_filter of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """
        if user_filter is not None and len(user_filter) > 255:
            raise ValueError("Invalid value for `user_filter`, length must be less than or equal to `255`")  # noqa: E501
        if user_filter is not None and len(user_filter) < 0:
            raise ValueError("Invalid value for `user_filter`, length must be greater than or equal to `0`")  # noqa: E501

        self._user_filter = user_filter

    @property
    def user_search_scope(self):
        """Gets the user_search_scope of this ProvidersLdapIdParams.  # noqa: E501

        Specifies the depth from the base DN to perform LDAP searches.  # noqa: E501

        :return: The user_search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :rtype: str
        """
        return self._user_search_scope

    @user_search_scope.setter
    def user_search_scope(self, user_search_scope):
        """Sets the user_search_scope of this ProvidersLdapIdParams.

        Specifies the depth from the base DN to perform LDAP searches.  # noqa: E501

        :param user_search_scope: The user_search_scope of this ProvidersLdapIdParams.  # noqa: E501
        :type: str
        """

        self._user_search_scope = user_search_scope

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProvidersLdapIdParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
