# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ProvidersAdsAdsItemExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allocate_gids': 'bool',
        'allocate_uids': 'bool',
        'assume_default_domain': 'bool',
        'authentication': 'bool',
        'check_online_interval': 'int',
        'controller_time': 'int',
        'create_home_directory': 'bool',
        'domain_offline_alerts': 'bool',
        'extra_expected_spns': 'list[str]',
        'findable_groups': 'list[str]',
        'findable_users': 'list[str]',
        'forest': 'str',
        'groupnet': 'str',
        'home_directory_template': 'str',
        'hostname': 'str',
        'id': 'str',
        'ignore_all_trusts': 'bool',
        'ignored_trusted_domains': 'list[str]',
        'include_trusted_domains': 'list[str]',
        'instance': 'str',
        'ldap_sign_and_seal': 'bool',
        'login_shell': 'str',
        'lookup_domains': 'list[str]',
        'lookup_groups': 'bool',
        'lookup_normalize_groups': 'bool',
        'lookup_normalize_users': 'bool',
        'lookup_users': 'bool',
        'machine_account': 'str',
        'machine_password_changes': 'bool',
        'machine_password_lifespan': 'int',
        'name': 'str',
        'netbios_domain': 'str',
        'node_dc_affinity': 'str',
        'node_dc_affinity_timeout': 'int',
        'nss_enumeration': 'bool',
        'primary_domain': 'str',
        'restrict_findable': 'bool',
        'sfu_support': 'str',
        'site': 'str',
        'status': 'str',
        'store_sfu_mappings': 'bool',
        'system': 'bool',
        'unfindable_groups': 'list[str]',
        'unfindable_users': 'list[str]',
        'zone_name': 'str'
    }

    attribute_map = {
        'allocate_gids': 'allocate_gids',
        'allocate_uids': 'allocate_uids',
        'assume_default_domain': 'assume_default_domain',
        'authentication': 'authentication',
        'check_online_interval': 'check_online_interval',
        'controller_time': 'controller_time',
        'create_home_directory': 'create_home_directory',
        'domain_offline_alerts': 'domain_offline_alerts',
        'extra_expected_spns': 'extra_expected_spns',
        'findable_groups': 'findable_groups',
        'findable_users': 'findable_users',
        'forest': 'forest',
        'groupnet': 'groupnet',
        'home_directory_template': 'home_directory_template',
        'hostname': 'hostname',
        'id': 'id',
        'ignore_all_trusts': 'ignore_all_trusts',
        'ignored_trusted_domains': 'ignored_trusted_domains',
        'include_trusted_domains': 'include_trusted_domains',
        'instance': 'instance',
        'ldap_sign_and_seal': 'ldap_sign_and_seal',
        'login_shell': 'login_shell',
        'lookup_domains': 'lookup_domains',
        'lookup_groups': 'lookup_groups',
        'lookup_normalize_groups': 'lookup_normalize_groups',
        'lookup_normalize_users': 'lookup_normalize_users',
        'lookup_users': 'lookup_users',
        'machine_account': 'machine_account',
        'machine_password_changes': 'machine_password_changes',
        'machine_password_lifespan': 'machine_password_lifespan',
        'name': 'name',
        'netbios_domain': 'netbios_domain',
        'node_dc_affinity': 'node_dc_affinity',
        'node_dc_affinity_timeout': 'node_dc_affinity_timeout',
        'nss_enumeration': 'nss_enumeration',
        'primary_domain': 'primary_domain',
        'restrict_findable': 'restrict_findable',
        'sfu_support': 'sfu_support',
        'site': 'site',
        'status': 'status',
        'store_sfu_mappings': 'store_sfu_mappings',
        'system': 'system',
        'unfindable_groups': 'unfindable_groups',
        'unfindable_users': 'unfindable_users',
        'zone_name': 'zone_name'
    }

    def __init__(self, allocate_gids=None, allocate_uids=None, assume_default_domain=None, authentication=None, check_online_interval=None, controller_time=None, create_home_directory=None, domain_offline_alerts=None, extra_expected_spns=None, findable_groups=None, findable_users=None, forest=None, groupnet=None, home_directory_template=None, hostname=None, id=None, ignore_all_trusts=None, ignored_trusted_domains=None, include_trusted_domains=None, instance=None, ldap_sign_and_seal=None, login_shell=None, lookup_domains=None, lookup_groups=None, lookup_normalize_groups=None, lookup_normalize_users=None, lookup_users=None, machine_account=None, machine_password_changes=None, machine_password_lifespan=None, name=None, netbios_domain=None, node_dc_affinity=None, node_dc_affinity_timeout=None, nss_enumeration=None, primary_domain=None, restrict_findable=None, sfu_support=None, site=None, status=None, store_sfu_mappings=None, system=None, unfindable_groups=None, unfindable_users=None, zone_name=None):  # noqa: E501
        """ProvidersAdsAdsItemExtended - a model defined in Swagger"""  # noqa: E501

        self._allocate_gids = None
        self._allocate_uids = None
        self._assume_default_domain = None
        self._authentication = None
        self._check_online_interval = None
        self._controller_time = None
        self._create_home_directory = None
        self._domain_offline_alerts = None
        self._extra_expected_spns = None
        self._findable_groups = None
        self._findable_users = None
        self._forest = None
        self._groupnet = None
        self._home_directory_template = None
        self._hostname = None
        self._id = None
        self._ignore_all_trusts = None
        self._ignored_trusted_domains = None
        self._include_trusted_domains = None
        self._instance = None
        self._ldap_sign_and_seal = None
        self._login_shell = None
        self._lookup_domains = None
        self._lookup_groups = None
        self._lookup_normalize_groups = None
        self._lookup_normalize_users = None
        self._lookup_users = None
        self._machine_account = None
        self._machine_password_changes = None
        self._machine_password_lifespan = None
        self._name = None
        self._netbios_domain = None
        self._node_dc_affinity = None
        self._node_dc_affinity_timeout = None
        self._nss_enumeration = None
        self._primary_domain = None
        self._restrict_findable = None
        self._sfu_support = None
        self._site = None
        self._status = None
        self._store_sfu_mappings = None
        self._system = None
        self._unfindable_groups = None
        self._unfindable_users = None
        self._zone_name = None
        self.discriminator = None

        if allocate_gids is not None:
            self.allocate_gids = allocate_gids
        if allocate_uids is not None:
            self.allocate_uids = allocate_uids
        if assume_default_domain is not None:
            self.assume_default_domain = assume_default_domain
        if authentication is not None:
            self.authentication = authentication
        if check_online_interval is not None:
            self.check_online_interval = check_online_interval
        if controller_time is not None:
            self.controller_time = controller_time
        if create_home_directory is not None:
            self.create_home_directory = create_home_directory
        if domain_offline_alerts is not None:
            self.domain_offline_alerts = domain_offline_alerts
        if extra_expected_spns is not None:
            self.extra_expected_spns = extra_expected_spns
        if findable_groups is not None:
            self.findable_groups = findable_groups
        if findable_users is not None:
            self.findable_users = findable_users
        if forest is not None:
            self.forest = forest
        if groupnet is not None:
            self.groupnet = groupnet
        if home_directory_template is not None:
            self.home_directory_template = home_directory_template
        if hostname is not None:
            self.hostname = hostname
        if id is not None:
            self.id = id
        if ignore_all_trusts is not None:
            self.ignore_all_trusts = ignore_all_trusts
        if ignored_trusted_domains is not None:
            self.ignored_trusted_domains = ignored_trusted_domains
        if include_trusted_domains is not None:
            self.include_trusted_domains = include_trusted_domains
        if instance is not None:
            self.instance = instance
        if ldap_sign_and_seal is not None:
            self.ldap_sign_and_seal = ldap_sign_and_seal
        if login_shell is not None:
            self.login_shell = login_shell
        if lookup_domains is not None:
            self.lookup_domains = lookup_domains
        if lookup_groups is not None:
            self.lookup_groups = lookup_groups
        if lookup_normalize_groups is not None:
            self.lookup_normalize_groups = lookup_normalize_groups
        if lookup_normalize_users is not None:
            self.lookup_normalize_users = lookup_normalize_users
        if lookup_users is not None:
            self.lookup_users = lookup_users
        if machine_account is not None:
            self.machine_account = machine_account
        if machine_password_changes is not None:
            self.machine_password_changes = machine_password_changes
        if machine_password_lifespan is not None:
            self.machine_password_lifespan = machine_password_lifespan
        if name is not None:
            self.name = name
        if netbios_domain is not None:
            self.netbios_domain = netbios_domain
        if node_dc_affinity is not None:
            self.node_dc_affinity = node_dc_affinity
        if node_dc_affinity_timeout is not None:
            self.node_dc_affinity_timeout = node_dc_affinity_timeout
        if nss_enumeration is not None:
            self.nss_enumeration = nss_enumeration
        if primary_domain is not None:
            self.primary_domain = primary_domain
        if restrict_findable is not None:
            self.restrict_findable = restrict_findable
        if sfu_support is not None:
            self.sfu_support = sfu_support
        if site is not None:
            self.site = site
        if status is not None:
            self.status = status
        if store_sfu_mappings is not None:
            self.store_sfu_mappings = store_sfu_mappings
        if system is not None:
            self.system = system
        if unfindable_groups is not None:
            self.unfindable_groups = unfindable_groups
        if unfindable_users is not None:
            self.unfindable_users = unfindable_users
        if zone_name is not None:
            self.zone_name = zone_name

    @property
    def allocate_gids(self):
        """Gets the allocate_gids of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Allocates an ID for an unmapped Active Directory (ADS) group. ADS groups without GIDs can be proactively assigned a GID by the ID mapper. If the ID mapper option is disabled, GIDs are not proactively assigned, and when a primary group for a user does not include a GID, the system may allocate one.   # noqa: E501

        :return: The allocate_gids of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._allocate_gids

    @allocate_gids.setter
    def allocate_gids(self, allocate_gids):
        """Sets the allocate_gids of this ProvidersAdsAdsItemExtended.

        Allocates an ID for an unmapped Active Directory (ADS) group. ADS groups without GIDs can be proactively assigned a GID by the ID mapper. If the ID mapper option is disabled, GIDs are not proactively assigned, and when a primary group for a user does not include a GID, the system may allocate one.   # noqa: E501

        :param allocate_gids: The allocate_gids of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._allocate_gids = allocate_gids

    @property
    def allocate_uids(self):
        """Gets the allocate_uids of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Allocates a user ID for an unmapped Active Directory (ADS) user. ADS users without UIDs can be proactively assigned a UID by the ID mapper. IF the ID mapper option is disabled, UIDs are not proactively assigned, and when an identify for a user does not include a UID, the system may allocate one.  # noqa: E501

        :return: The allocate_uids of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._allocate_uids

    @allocate_uids.setter
    def allocate_uids(self, allocate_uids):
        """Sets the allocate_uids of this ProvidersAdsAdsItemExtended.

        Allocates a user ID for an unmapped Active Directory (ADS) user. ADS users without UIDs can be proactively assigned a UID by the ID mapper. IF the ID mapper option is disabled, UIDs are not proactively assigned, and when an identify for a user does not include a UID, the system may allocate one.  # noqa: E501

        :param allocate_uids: The allocate_uids of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._allocate_uids = allocate_uids

    @property
    def assume_default_domain(self):
        """Gets the assume_default_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Enables lookup of unqualified user names in the primary domain.  # noqa: E501

        :return: The assume_default_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._assume_default_domain

    @assume_default_domain.setter
    def assume_default_domain(self, assume_default_domain):
        """Sets the assume_default_domain of this ProvidersAdsAdsItemExtended.

        Enables lookup of unqualified user names in the primary domain.  # noqa: E501

        :param assume_default_domain: The assume_default_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._assume_default_domain = assume_default_domain

    @property
    def authentication(self):
        """Gets the authentication of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Enables authentication and identity management through the authentication provider.  # noqa: E501

        :return: The authentication of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._authentication

    @authentication.setter
    def authentication(self, authentication):
        """Sets the authentication of this ProvidersAdsAdsItemExtended.

        Enables authentication and identity management through the authentication provider.  # noqa: E501

        :param authentication: The authentication of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._authentication = authentication

    @property
    def check_online_interval(self):
        """Gets the check_online_interval of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the time in seconds between provider online checks.  # noqa: E501

        :return: The check_online_interval of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: int
        """
        return self._check_online_interval

    @check_online_interval.setter
    def check_online_interval(self, check_online_interval):
        """Sets the check_online_interval of this ProvidersAdsAdsItemExtended.

        Specifies the time in seconds between provider online checks.  # noqa: E501

        :param check_online_interval: The check_online_interval of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: int
        """
        if check_online_interval is not None and check_online_interval > 86400:  # noqa: E501
            raise ValueError("Invalid value for `check_online_interval`, must be a value less than or equal to `86400`")  # noqa: E501
        if check_online_interval is not None and check_online_interval < 60:  # noqa: E501
            raise ValueError("Invalid value for `check_online_interval`, must be a value greater than or equal to `60`")  # noqa: E501

        self._check_online_interval = check_online_interval

    @property
    def controller_time(self):
        """Gets the controller_time of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the current time for the domain controllers.  # noqa: E501

        :return: The controller_time of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: int
        """
        return self._controller_time

    @controller_time.setter
    def controller_time(self, controller_time):
        """Sets the controller_time of this ProvidersAdsAdsItemExtended.

        Specifies the current time for the domain controllers.  # noqa: E501

        :param controller_time: The controller_time of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: int
        """
        if controller_time is not None and controller_time > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `controller_time`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if controller_time is not None and controller_time < 0:  # noqa: E501
            raise ValueError("Invalid value for `controller_time`, must be a value greater than or equal to `0`")  # noqa: E501

        self._controller_time = controller_time

    @property
    def create_home_directory(self):
        """Gets the create_home_directory of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Automatically creates a home directory on the first login.  # noqa: E501

        :return: The create_home_directory of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._create_home_directory

    @create_home_directory.setter
    def create_home_directory(self, create_home_directory):
        """Sets the create_home_directory of this ProvidersAdsAdsItemExtended.

        Automatically creates a home directory on the first login.  # noqa: E501

        :param create_home_directory: The create_home_directory of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._create_home_directory = create_home_directory

    @property
    def domain_offline_alerts(self):
        """Gets the domain_offline_alerts of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Sends an alert if the domain goes offline.  # noqa: E501

        :return: The domain_offline_alerts of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._domain_offline_alerts

    @domain_offline_alerts.setter
    def domain_offline_alerts(self, domain_offline_alerts):
        """Sets the domain_offline_alerts of this ProvidersAdsAdsItemExtended.

        Sends an alert if the domain goes offline.  # noqa: E501

        :param domain_offline_alerts: The domain_offline_alerts of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._domain_offline_alerts = domain_offline_alerts

    @property
    def extra_expected_spns(self):
        """Gets the extra_expected_spns of this ProvidersAdsAdsItemExtended.  # noqa: E501

        List of additional SPNs to expect beyond what automatic checking routines might find  # noqa: E501

        :return: The extra_expected_spns of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._extra_expected_spns

    @extra_expected_spns.setter
    def extra_expected_spns(self, extra_expected_spns):
        """Sets the extra_expected_spns of this ProvidersAdsAdsItemExtended.

        List of additional SPNs to expect beyond what automatic checking routines might find  # noqa: E501

        :param extra_expected_spns: The extra_expected_spns of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._extra_expected_spns = extra_expected_spns

    @property
    def findable_groups(self):
        """Gets the findable_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Sets list of groups that can be resolved.  # noqa: E501

        :return: The findable_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._findable_groups

    @findable_groups.setter
    def findable_groups(self, findable_groups):
        """Sets the findable_groups of this ProvidersAdsAdsItemExtended.

        Sets list of groups that can be resolved.  # noqa: E501

        :param findable_groups: The findable_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._findable_groups = findable_groups

    @property
    def findable_users(self):
        """Gets the findable_users of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Sets list of users that can be resolved.  # noqa: E501

        :return: The findable_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._findable_users

    @findable_users.setter
    def findable_users(self, findable_users):
        """Sets the findable_users of this ProvidersAdsAdsItemExtended.

        Sets list of users that can be resolved.  # noqa: E501

        :param findable_users: The findable_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._findable_users = findable_users

    @property
    def forest(self):
        """Gets the forest of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the Active Directory forest.  # noqa: E501

        :return: The forest of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._forest

    @forest.setter
    def forest(self, forest):
        """Sets the forest of this ProvidersAdsAdsItemExtended.

        Specifies the Active Directory forest.  # noqa: E501

        :param forest: The forest of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if forest is not None and len(forest) > 255:
            raise ValueError("Invalid value for `forest`, length must be less than or equal to `255`")  # noqa: E501
        if forest is not None and len(forest) < 0:
            raise ValueError("Invalid value for `forest`, length must be greater than or equal to `0`")  # noqa: E501

        self._forest = forest

    @property
    def groupnet(self):
        """Gets the groupnet of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Groupnet identifier.  # noqa: E501

        :return: The groupnet of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._groupnet

    @groupnet.setter
    def groupnet(self, groupnet):
        """Sets the groupnet of this ProvidersAdsAdsItemExtended.

        Groupnet identifier.  # noqa: E501

        :param groupnet: The groupnet of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if groupnet is not None and len(groupnet) > 255:
            raise ValueError("Invalid value for `groupnet`, length must be less than or equal to `255`")  # noqa: E501
        if groupnet is not None and len(groupnet) < 0:
            raise ValueError("Invalid value for `groupnet`, length must be greater than or equal to `0`")  # noqa: E501

        self._groupnet = groupnet

    @property
    def home_directory_template(self):
        """Gets the home_directory_template of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the path to the home directory template.  # noqa: E501

        :return: The home_directory_template of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._home_directory_template

    @home_directory_template.setter
    def home_directory_template(self, home_directory_template):
        """Sets the home_directory_template of this ProvidersAdsAdsItemExtended.

        Specifies the path to the home directory template.  # noqa: E501

        :param home_directory_template: The home_directory_template of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if home_directory_template is not None and len(home_directory_template) > 4096:
            raise ValueError("Invalid value for `home_directory_template`, length must be less than or equal to `4096`")  # noqa: E501
        if home_directory_template is not None and len(home_directory_template) < 0:
            raise ValueError("Invalid value for `home_directory_template`, length must be greater than or equal to `0`")  # noqa: E501
        if home_directory_template is not None and not re.search('^((\/[^\/\\0]+)(\/?))*$', home_directory_template):  # noqa: E501
            raise ValueError("Invalid value for `home_directory_template`, must be a follow pattern or equal to `/^((\/[^\/\\0]+)(\/?))*$/`")  # noqa: E501

        self._home_directory_template = home_directory_template

    @property
    def hostname(self):
        """Gets the hostname of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the fully qualified hostname stored in the machine account.  # noqa: E501

        :return: The hostname of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this ProvidersAdsAdsItemExtended.

        Specifies the fully qualified hostname stored in the machine account.  # noqa: E501

        :param hostname: The hostname of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if hostname is not None and len(hostname) > 255:
            raise ValueError("Invalid value for `hostname`, length must be less than or equal to `255`")  # noqa: E501
        if hostname is not None and len(hostname) < 0:
            raise ValueError("Invalid value for `hostname`, length must be greater than or equal to `0`")  # noqa: E501

        self._hostname = hostname

    @property
    def id(self):
        """Gets the id of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the ID of the Active Directory provider instance.  # noqa: E501

        :return: The id of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProvidersAdsAdsItemExtended.

        Specifies the ID of the Active Directory provider instance.  # noqa: E501

        :param id: The id of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if id is not None and len(id) > 255:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `255`")  # noqa: E501
        if id is not None and len(id) < 0:
            raise ValueError("Invalid value for `id`, length must be greater than or equal to `0`")  # noqa: E501

        self._id = id

    @property
    def ignore_all_trusts(self):
        """Gets the ignore_all_trusts of this ProvidersAdsAdsItemExtended.  # noqa: E501

        If set to true, ignores all trusted domains.  # noqa: E501

        :return: The ignore_all_trusts of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_all_trusts

    @ignore_all_trusts.setter
    def ignore_all_trusts(self, ignore_all_trusts):
        """Sets the ignore_all_trusts of this ProvidersAdsAdsItemExtended.

        If set to true, ignores all trusted domains.  # noqa: E501

        :param ignore_all_trusts: The ignore_all_trusts of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._ignore_all_trusts = ignore_all_trusts

    @property
    def ignored_trusted_domains(self):
        """Gets the ignored_trusted_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Includes trusted domains when 'ignore_all_trusts' is set to false.  # noqa: E501

        :return: The ignored_trusted_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._ignored_trusted_domains

    @ignored_trusted_domains.setter
    def ignored_trusted_domains(self, ignored_trusted_domains):
        """Sets the ignored_trusted_domains of this ProvidersAdsAdsItemExtended.

        Includes trusted domains when 'ignore_all_trusts' is set to false.  # noqa: E501

        :param ignored_trusted_domains: The ignored_trusted_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._ignored_trusted_domains = ignored_trusted_domains

    @property
    def include_trusted_domains(self):
        """Gets the include_trusted_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Includes trusted domains when 'ignore_all_trusts' is set to true.  # noqa: E501

        :return: The include_trusted_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._include_trusted_domains

    @include_trusted_domains.setter
    def include_trusted_domains(self, include_trusted_domains):
        """Sets the include_trusted_domains of this ProvidersAdsAdsItemExtended.

        Includes trusted domains when 'ignore_all_trusts' is set to true.  # noqa: E501

        :param include_trusted_domains: The include_trusted_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._include_trusted_domains = include_trusted_domains

    @property
    def instance(self):
        """Gets the instance of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies Active Directory provider instance.  # noqa: E501

        :return: The instance of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._instance

    @instance.setter
    def instance(self, instance):
        """Sets the instance of this ProvidersAdsAdsItemExtended.

        Specifies Active Directory provider instance.  # noqa: E501

        :param instance: The instance of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if instance is not None and len(instance) > 255:
            raise ValueError("Invalid value for `instance`, length must be less than or equal to `255`")  # noqa: E501
        if instance is not None and len(instance) < 0:
            raise ValueError("Invalid value for `instance`, length must be greater than or equal to `0`")  # noqa: E501

        self._instance = instance

    @property
    def ldap_sign_and_seal(self):
        """Gets the ldap_sign_and_seal of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Enables encryption and signing on LDAP requests.  # noqa: E501

        :return: The ldap_sign_and_seal of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._ldap_sign_and_seal

    @ldap_sign_and_seal.setter
    def ldap_sign_and_seal(self, ldap_sign_and_seal):
        """Sets the ldap_sign_and_seal of this ProvidersAdsAdsItemExtended.

        Enables encryption and signing on LDAP requests.  # noqa: E501

        :param ldap_sign_and_seal: The ldap_sign_and_seal of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._ldap_sign_and_seal = ldap_sign_and_seal

    @property
    def login_shell(self):
        """Gets the login_shell of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the login shell path.  # noqa: E501

        :return: The login_shell of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._login_shell

    @login_shell.setter
    def login_shell(self, login_shell):
        """Sets the login_shell of this ProvidersAdsAdsItemExtended.

        Specifies the login shell path.  # noqa: E501

        :param login_shell: The login_shell of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if login_shell is not None and len(login_shell) > 4096:
            raise ValueError("Invalid value for `login_shell`, length must be less than or equal to `4096`")  # noqa: E501
        if login_shell is not None and len(login_shell) < 0:
            raise ValueError("Invalid value for `login_shell`, length must be greater than or equal to `0`")  # noqa: E501

        self._login_shell = login_shell

    @property
    def lookup_domains(self):
        """Gets the lookup_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Limits user and group lookups to the specified domains.  # noqa: E501

        :return: The lookup_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._lookup_domains

    @lookup_domains.setter
    def lookup_domains(self, lookup_domains):
        """Sets the lookup_domains of this ProvidersAdsAdsItemExtended.

        Limits user and group lookups to the specified domains.  # noqa: E501

        :param lookup_domains: The lookup_domains of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._lookup_domains = lookup_domains

    @property
    def lookup_groups(self):
        """Gets the lookup_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Looks up AD groups in other providers before allocating a group ID.  # noqa: E501

        :return: The lookup_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._lookup_groups

    @lookup_groups.setter
    def lookup_groups(self, lookup_groups):
        """Sets the lookup_groups of this ProvidersAdsAdsItemExtended.

        Looks up AD groups in other providers before allocating a group ID.  # noqa: E501

        :param lookup_groups: The lookup_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._lookup_groups = lookup_groups

    @property
    def lookup_normalize_groups(self):
        """Gets the lookup_normalize_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Normalizes AD group names to lowercase before look up.  # noqa: E501

        :return: The lookup_normalize_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._lookup_normalize_groups

    @lookup_normalize_groups.setter
    def lookup_normalize_groups(self, lookup_normalize_groups):
        """Sets the lookup_normalize_groups of this ProvidersAdsAdsItemExtended.

        Normalizes AD group names to lowercase before look up.  # noqa: E501

        :param lookup_normalize_groups: The lookup_normalize_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._lookup_normalize_groups = lookup_normalize_groups

    @property
    def lookup_normalize_users(self):
        """Gets the lookup_normalize_users of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Normalize AD user names to lowercase before look up.  # noqa: E501

        :return: The lookup_normalize_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._lookup_normalize_users

    @lookup_normalize_users.setter
    def lookup_normalize_users(self, lookup_normalize_users):
        """Sets the lookup_normalize_users of this ProvidersAdsAdsItemExtended.

        Normalize AD user names to lowercase before look up.  # noqa: E501

        :param lookup_normalize_users: The lookup_normalize_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._lookup_normalize_users = lookup_normalize_users

    @property
    def lookup_users(self):
        """Gets the lookup_users of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Looks up AD users in other providers before allocating a user ID.  # noqa: E501

        :return: The lookup_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._lookup_users

    @lookup_users.setter
    def lookup_users(self, lookup_users):
        """Sets the lookup_users of this ProvidersAdsAdsItemExtended.

        Looks up AD users in other providers before allocating a user ID.  # noqa: E501

        :param lookup_users: The lookup_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._lookup_users = lookup_users

    @property
    def machine_account(self):
        """Gets the machine_account of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the machine account name when creating a SAM account with Active Directory.  # noqa: E501

        :return: The machine_account of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._machine_account

    @machine_account.setter
    def machine_account(self, machine_account):
        """Sets the machine_account of this ProvidersAdsAdsItemExtended.

        Specifies the machine account name when creating a SAM account with Active Directory.  # noqa: E501

        :param machine_account: The machine_account of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if machine_account is not None and len(machine_account) > 255:
            raise ValueError("Invalid value for `machine_account`, length must be less than or equal to `255`")  # noqa: E501
        if machine_account is not None and len(machine_account) < 0:
            raise ValueError("Invalid value for `machine_account`, length must be greater than or equal to `0`")  # noqa: E501

        self._machine_account = machine_account

    @property
    def machine_password_changes(self):
        """Gets the machine_password_changes of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Enables periodic changes of the machine password for security.  # noqa: E501

        :return: The machine_password_changes of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._machine_password_changes

    @machine_password_changes.setter
    def machine_password_changes(self, machine_password_changes):
        """Sets the machine_password_changes of this ProvidersAdsAdsItemExtended.

        Enables periodic changes of the machine password for security.  # noqa: E501

        :param machine_password_changes: The machine_password_changes of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._machine_password_changes = machine_password_changes

    @property
    def machine_password_lifespan(self):
        """Gets the machine_password_lifespan of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Sets maximum age of a password in seconds.  # noqa: E501

        :return: The machine_password_lifespan of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: int
        """
        return self._machine_password_lifespan

    @machine_password_lifespan.setter
    def machine_password_lifespan(self, machine_password_lifespan):
        """Sets the machine_password_lifespan of this ProvidersAdsAdsItemExtended.

        Sets maximum age of a password in seconds.  # noqa: E501

        :param machine_password_lifespan: The machine_password_lifespan of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: int
        """
        if machine_password_lifespan is not None and machine_password_lifespan > 31536000:  # noqa: E501
            raise ValueError("Invalid value for `machine_password_lifespan`, must be a value less than or equal to `31536000`")  # noqa: E501
        if machine_password_lifespan is not None and machine_password_lifespan < 3600:  # noqa: E501
            raise ValueError("Invalid value for `machine_password_lifespan`, must be a value greater than or equal to `3600`")  # noqa: E501

        self._machine_password_lifespan = machine_password_lifespan

    @property
    def name(self):
        """Gets the name of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the Active Directory provider name.  # noqa: E501

        :return: The name of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProvidersAdsAdsItemExtended.

        Specifies the Active Directory provider name.  # noqa: E501

        :param name: The name of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 64:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def netbios_domain(self):
        """Gets the netbios_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the NetBIOS domain name associated with the machine account.  # noqa: E501

        :return: The netbios_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._netbios_domain

    @netbios_domain.setter
    def netbios_domain(self, netbios_domain):
        """Sets the netbios_domain of this ProvidersAdsAdsItemExtended.

        Specifies the NetBIOS domain name associated with the machine account.  # noqa: E501

        :param netbios_domain: The netbios_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if netbios_domain is not None and len(netbios_domain) > 15:
            raise ValueError("Invalid value for `netbios_domain`, length must be less than or equal to `15`")  # noqa: E501
        if netbios_domain is not None and len(netbios_domain) < 1:
            raise ValueError("Invalid value for `netbios_domain`, length must be greater than or equal to `1`")  # noqa: E501

        self._netbios_domain = netbios_domain

    @property
    def node_dc_affinity(self):
        """Gets the node_dc_affinity of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the domain controller for which the node has affinity.  # noqa: E501

        :return: The node_dc_affinity of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._node_dc_affinity

    @node_dc_affinity.setter
    def node_dc_affinity(self, node_dc_affinity):
        """Sets the node_dc_affinity of this ProvidersAdsAdsItemExtended.

        Specifies the domain controller for which the node has affinity.  # noqa: E501

        :param node_dc_affinity: The node_dc_affinity of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if node_dc_affinity is not None and len(node_dc_affinity) > 255:
            raise ValueError("Invalid value for `node_dc_affinity`, length must be less than or equal to `255`")  # noqa: E501
        if node_dc_affinity is not None and len(node_dc_affinity) < 0:
            raise ValueError("Invalid value for `node_dc_affinity`, length must be greater than or equal to `0`")  # noqa: E501

        self._node_dc_affinity = node_dc_affinity

    @property
    def node_dc_affinity_timeout(self):
        """Gets the node_dc_affinity_timeout of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the timeout for the domain controller for which the local node has affinity.  # noqa: E501

        :return: The node_dc_affinity_timeout of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: int
        """
        return self._node_dc_affinity_timeout

    @node_dc_affinity_timeout.setter
    def node_dc_affinity_timeout(self, node_dc_affinity_timeout):
        """Sets the node_dc_affinity_timeout of this ProvidersAdsAdsItemExtended.

        Specifies the timeout for the domain controller for which the local node has affinity.  # noqa: E501

        :param node_dc_affinity_timeout: The node_dc_affinity_timeout of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: int
        """
        if node_dc_affinity_timeout is not None and node_dc_affinity_timeout > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `node_dc_affinity_timeout`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if node_dc_affinity_timeout is not None and node_dc_affinity_timeout < 0:  # noqa: E501
            raise ValueError("Invalid value for `node_dc_affinity_timeout`, must be a value greater than or equal to `0`")  # noqa: E501

        self._node_dc_affinity_timeout = node_dc_affinity_timeout

    @property
    def nss_enumeration(self):
        """Gets the nss_enumeration of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Enables the Active Directory provider to respond to 'getpwent' and 'getgrent' requests.  # noqa: E501

        :return: The nss_enumeration of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._nss_enumeration

    @nss_enumeration.setter
    def nss_enumeration(self, nss_enumeration):
        """Sets the nss_enumeration of this ProvidersAdsAdsItemExtended.

        Enables the Active Directory provider to respond to 'getpwent' and 'getgrent' requests.  # noqa: E501

        :param nss_enumeration: The nss_enumeration of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._nss_enumeration = nss_enumeration

    @property
    def primary_domain(self):
        """Gets the primary_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the AD domain to which the provider is joined.  # noqa: E501

        :return: The primary_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._primary_domain

    @primary_domain.setter
    def primary_domain(self, primary_domain):
        """Sets the primary_domain of this ProvidersAdsAdsItemExtended.

        Specifies the AD domain to which the provider is joined.  # noqa: E501

        :param primary_domain: The primary_domain of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if primary_domain is not None and len(primary_domain) > 255:
            raise ValueError("Invalid value for `primary_domain`, length must be less than or equal to `255`")  # noqa: E501
        if primary_domain is not None and len(primary_domain) < 2:
            raise ValueError("Invalid value for `primary_domain`, length must be greater than or equal to `2`")  # noqa: E501

        self._primary_domain = primary_domain

    @property
    def restrict_findable(self):
        """Gets the restrict_findable of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Check the provider for filtered lists of findable and unfindable users and groups.  # noqa: E501

        :return: The restrict_findable of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_findable

    @restrict_findable.setter
    def restrict_findable(self, restrict_findable):
        """Sets the restrict_findable of this ProvidersAdsAdsItemExtended.

        Check the provider for filtered lists of findable and unfindable users and groups.  # noqa: E501

        :param restrict_findable: The restrict_findable of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._restrict_findable = restrict_findable

    @property
    def sfu_support(self):
        """Gets the sfu_support of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies whether to support RFC 2307 attributes on ADS domain controllers.  # noqa: E501

        :return: The sfu_support of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._sfu_support

    @sfu_support.setter
    def sfu_support(self, sfu_support):
        """Sets the sfu_support of this ProvidersAdsAdsItemExtended.

        Specifies whether to support RFC 2307 attributes on ADS domain controllers.  # noqa: E501

        :param sfu_support: The sfu_support of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        allowed_values = ["none", "rfc2307"]  # noqa: E501
        if sfu_support not in allowed_values:
            raise ValueError(
                "Invalid value for `sfu_support` ({0}), must be one of {1}"  # noqa: E501
                .format(sfu_support, allowed_values)
            )

        self._sfu_support = sfu_support

    @property
    def site(self):
        """Gets the site of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the site for the Active Directory.  # noqa: E501

        :return: The site of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._site

    @site.setter
    def site(self, site):
        """Sets the site of this ProvidersAdsAdsItemExtended.

        Specifies the site for the Active Directory.  # noqa: E501

        :param site: The site of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if site is not None and len(site) > 63:
            raise ValueError("Invalid value for `site`, length must be less than or equal to `63`")  # noqa: E501
        if site is not None and len(site) < 1:
            raise ValueError("Invalid value for `site`, length must be greater than or equal to `1`")  # noqa: E501

        self._site = site

    @property
    def status(self):
        """Gets the status of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the status of the provider.  # noqa: E501

        :return: The status of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ProvidersAdsAdsItemExtended.

        Specifies the status of the provider.  # noqa: E501

        :param status: The status of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if status is not None and len(status) > 255:
            raise ValueError("Invalid value for `status`, length must be less than or equal to `255`")  # noqa: E501
        if status is not None and len(status) < 0:
            raise ValueError("Invalid value for `status`, length must be greater than or equal to `0`")  # noqa: E501

        self._status = status

    @property
    def store_sfu_mappings(self):
        """Gets the store_sfu_mappings of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Stores SFU mappings permanently in the ID mapper.  # noqa: E501

        :return: The store_sfu_mappings of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._store_sfu_mappings

    @store_sfu_mappings.setter
    def store_sfu_mappings(self, store_sfu_mappings):
        """Sets the store_sfu_mappings of this ProvidersAdsAdsItemExtended.

        Stores SFU mappings permanently in the ID mapper.  # noqa: E501

        :param store_sfu_mappings: The store_sfu_mappings of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._store_sfu_mappings = store_sfu_mappings

    @property
    def system(self):
        """Gets the system of this ProvidersAdsAdsItemExtended.  # noqa: E501

        If set to true, indicates that this provider instance was created by OneFS and cannot be removed.  # noqa: E501

        :return: The system of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this ProvidersAdsAdsItemExtended.

        If set to true, indicates that this provider instance was created by OneFS and cannot be removed.  # noqa: E501

        :param system: The system of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def unfindable_groups(self):
        """Gets the unfindable_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies groups that cannot be resolved by the provider.  # noqa: E501

        :return: The unfindable_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._unfindable_groups

    @unfindable_groups.setter
    def unfindable_groups(self, unfindable_groups):
        """Sets the unfindable_groups of this ProvidersAdsAdsItemExtended.

        Specifies groups that cannot be resolved by the provider.  # noqa: E501

        :param unfindable_groups: The unfindable_groups of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._unfindable_groups = unfindable_groups

    @property
    def unfindable_users(self):
        """Gets the unfindable_users of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies users that cannot be resolved by the provider.  # noqa: E501

        :return: The unfindable_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: list[str]
        """
        return self._unfindable_users

    @unfindable_users.setter
    def unfindable_users(self, unfindable_users):
        """Sets the unfindable_users of this ProvidersAdsAdsItemExtended.

        Specifies users that cannot be resolved by the provider.  # noqa: E501

        :param unfindable_users: The unfindable_users of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: list[str]
        """

        self._unfindable_users = unfindable_users

    @property
    def zone_name(self):
        """Gets the zone_name of this ProvidersAdsAdsItemExtended.  # noqa: E501

        Specifies the name of the access zone in which this provider was created.  # noqa: E501

        :return: The zone_name of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :rtype: str
        """
        return self._zone_name

    @zone_name.setter
    def zone_name(self, zone_name):
        """Sets the zone_name of this ProvidersAdsAdsItemExtended.

        Specifies the name of the access zone in which this provider was created.  # noqa: E501

        :param zone_name: The zone_name of this ProvidersAdsAdsItemExtended.  # noqa: E501
        :type: str
        """
        if zone_name is not None and len(zone_name) > 255:
            raise ValueError("Invalid value for `zone_name`, length must be less than or equal to `255`")  # noqa: E501
        if zone_name is not None and len(zone_name) < 0:
            raise ValueError("Invalid value for `zone_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._zone_name = zone_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProvidersAdsAdsItemExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
