# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class JobJobSummarySummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_is_degraded': 'bool',
        'connected': 'bool',
        'coordinator': 'int',
        'coordinator_lnn': 'int',
        'disconnected_nodes': 'list[int]',
        'down_or_read_only_nodes': 'bool',
        'job_d_enabled': 'bool',
        'next_jid': 'int',
        'run_degraded': 'bool',
        'stats_ready': 'bool'
    }

    attribute_map = {
        'cluster_is_degraded': 'cluster_is_degraded',
        'connected': 'connected',
        'coordinator': 'coordinator',
        'coordinator_lnn': 'coordinator_lnn',
        'disconnected_nodes': 'disconnected_nodes',
        'down_or_read_only_nodes': 'down_or_read_only_nodes',
        'job_d_enabled': 'job_d_enabled',
        'next_jid': 'next_jid',
        'run_degraded': 'run_degraded',
        'stats_ready': 'stats_ready'
    }

    def __init__(self, cluster_is_degraded=None, connected=None, coordinator=None, coordinator_lnn=None, disconnected_nodes=None, down_or_read_only_nodes=None, job_d_enabled=None, next_jid=None, run_degraded=None, stats_ready=None):  # noqa: E501
        """JobJobSummarySummary - a model defined in Swagger"""  # noqa: E501

        self._cluster_is_degraded = None
        self._connected = None
        self._coordinator = None
        self._coordinator_lnn = None
        self._disconnected_nodes = None
        self._down_or_read_only_nodes = None
        self._job_d_enabled = None
        self._next_jid = None
        self._run_degraded = None
        self._stats_ready = None
        self.discriminator = None

        self.cluster_is_degraded = cluster_is_degraded
        self.connected = connected
        self.coordinator = coordinator
        if coordinator_lnn is not None:
            self.coordinator_lnn = coordinator_lnn
        if disconnected_nodes is not None:
            self.disconnected_nodes = disconnected_nodes
        self.down_or_read_only_nodes = down_or_read_only_nodes
        self.job_d_enabled = job_d_enabled
        self.next_jid = next_jid
        self.run_degraded = run_degraded
        self.stats_ready = stats_ready

    @property
    def cluster_is_degraded(self):
        """Gets the cluster_is_degraded of this JobJobSummarySummary.  # noqa: E501

        Whether the cluster is in a degraded state.  Note this is from the perspective of the node handling the query, which might be different from another node.  # noqa: E501

        :return: The cluster_is_degraded of this JobJobSummarySummary.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_is_degraded

    @cluster_is_degraded.setter
    def cluster_is_degraded(self, cluster_is_degraded):
        """Sets the cluster_is_degraded of this JobJobSummarySummary.

        Whether the cluster is in a degraded state.  Note this is from the perspective of the node handling the query, which might be different from another node.  # noqa: E501

        :param cluster_is_degraded: The cluster_is_degraded of this JobJobSummarySummary.  # noqa: E501
        :type: bool
        """
        if cluster_is_degraded is None:
            raise ValueError("Invalid value for `cluster_is_degraded`, must not be `None`")  # noqa: E501

        self._cluster_is_degraded = cluster_is_degraded

    @property
    def connected(self):
        """Gets the connected of this JobJobSummarySummary.  # noqa: E501

        Whether isi_job_d instances on all up nodes in the cluster are connected to the coordinator.  # noqa: E501

        :return: The connected of this JobJobSummarySummary.  # noqa: E501
        :rtype: bool
        """
        return self._connected

    @connected.setter
    def connected(self, connected):
        """Sets the connected of this JobJobSummarySummary.

        Whether isi_job_d instances on all up nodes in the cluster are connected to the coordinator.  # noqa: E501

        :param connected: The connected of this JobJobSummarySummary.  # noqa: E501
        :type: bool
        """
        if connected is None:
            raise ValueError("Invalid value for `connected`, must not be `None`")  # noqa: E501

        self._connected = connected

    @property
    def coordinator(self):
        """Gets the coordinator of this JobJobSummarySummary.  # noqa: E501

        The devid of the job engine coordinator.  # noqa: E501

        :return: The coordinator of this JobJobSummarySummary.  # noqa: E501
        :rtype: int
        """
        return self._coordinator

    @coordinator.setter
    def coordinator(self, coordinator):
        """Sets the coordinator of this JobJobSummarySummary.

        The devid of the job engine coordinator.  # noqa: E501

        :param coordinator: The coordinator of this JobJobSummarySummary.  # noqa: E501
        :type: int
        """
        if coordinator is None:
            raise ValueError("Invalid value for `coordinator`, must not be `None`")  # noqa: E501
        if coordinator is not None and coordinator > 65435:  # noqa: E501
            raise ValueError("Invalid value for `coordinator`, must be a value less than or equal to `65435`")  # noqa: E501
        if coordinator is not None and coordinator < 1:  # noqa: E501
            raise ValueError("Invalid value for `coordinator`, must be a value greater than or equal to `1`")  # noqa: E501

        self._coordinator = coordinator

    @property
    def coordinator_lnn(self):
        """Gets the coordinator_lnn of this JobJobSummarySummary.  # noqa: E501

        Logical Node Number (LNN) of a node.  # noqa: E501

        :return: The coordinator_lnn of this JobJobSummarySummary.  # noqa: E501
        :rtype: int
        """
        return self._coordinator_lnn

    @coordinator_lnn.setter
    def coordinator_lnn(self, coordinator_lnn):
        """Sets the coordinator_lnn of this JobJobSummarySummary.

        Logical Node Number (LNN) of a node.  # noqa: E501

        :param coordinator_lnn: The coordinator_lnn of this JobJobSummarySummary.  # noqa: E501
        :type: int
        """
        if coordinator_lnn is not None and coordinator_lnn > 65535:  # noqa: E501
            raise ValueError("Invalid value for `coordinator_lnn`, must be a value less than or equal to `65535`")  # noqa: E501
        if coordinator_lnn is not None and coordinator_lnn < 1:  # noqa: E501
            raise ValueError("Invalid value for `coordinator_lnn`, must be a value greater than or equal to `1`")  # noqa: E501

        self._coordinator_lnn = coordinator_lnn

    @property
    def disconnected_nodes(self):
        """Gets the disconnected_nodes of this JobJobSummarySummary.  # noqa: E501

        If connected=false, this is the set of devids that are not connected to the coordinator.  # noqa: E501

        :return: The disconnected_nodes of this JobJobSummarySummary.  # noqa: E501
        :rtype: list[int]
        """
        return self._disconnected_nodes

    @disconnected_nodes.setter
    def disconnected_nodes(self, disconnected_nodes):
        """Sets the disconnected_nodes of this JobJobSummarySummary.

        If connected=false, this is the set of devids that are not connected to the coordinator.  # noqa: E501

        :param disconnected_nodes: The disconnected_nodes of this JobJobSummarySummary.  # noqa: E501
        :type: list[int]
        """

        self._disconnected_nodes = disconnected_nodes

    @property
    def down_or_read_only_nodes(self):
        """Gets the down_or_read_only_nodes of this JobJobSummarySummary.  # noqa: E501

        Whether the cluster has any down or read-only nodes.  These nodes are not considered in the connected property.  # noqa: E501

        :return: The down_or_read_only_nodes of this JobJobSummarySummary.  # noqa: E501
        :rtype: bool
        """
        return self._down_or_read_only_nodes

    @down_or_read_only_nodes.setter
    def down_or_read_only_nodes(self, down_or_read_only_nodes):
        """Sets the down_or_read_only_nodes of this JobJobSummarySummary.

        Whether the cluster has any down or read-only nodes.  These nodes are not considered in the connected property.  # noqa: E501

        :param down_or_read_only_nodes: The down_or_read_only_nodes of this JobJobSummarySummary.  # noqa: E501
        :type: bool
        """
        if down_or_read_only_nodes is None:
            raise ValueError("Invalid value for `down_or_read_only_nodes`, must not be `None`")  # noqa: E501

        self._down_or_read_only_nodes = down_or_read_only_nodes

    @property
    def job_d_enabled(self):
        """Gets the job_d_enabled of this JobJobSummarySummary.  # noqa: E501

        Whether the isi_job_d is enabled.  # noqa: E501

        :return: The job_d_enabled of this JobJobSummarySummary.  # noqa: E501
        :rtype: bool
        """
        return self._job_d_enabled

    @job_d_enabled.setter
    def job_d_enabled(self, job_d_enabled):
        """Sets the job_d_enabled of this JobJobSummarySummary.

        Whether the isi_job_d is enabled.  # noqa: E501

        :param job_d_enabled: The job_d_enabled of this JobJobSummarySummary.  # noqa: E501
        :type: bool
        """
        if job_d_enabled is None:
            raise ValueError("Invalid value for `job_d_enabled`, must not be `None`")  # noqa: E501

        self._job_d_enabled = job_d_enabled

    @property
    def next_jid(self):
        """Gets the next_jid of this JobJobSummarySummary.  # noqa: E501

        The job ID to be assigned to the next job.  # noqa: E501

        :return: The next_jid of this JobJobSummarySummary.  # noqa: E501
        :rtype: int
        """
        return self._next_jid

    @next_jid.setter
    def next_jid(self, next_jid):
        """Sets the next_jid of this JobJobSummarySummary.

        The job ID to be assigned to the next job.  # noqa: E501

        :param next_jid: The next_jid of this JobJobSummarySummary.  # noqa: E501
        :type: int
        """
        if next_jid is None:
            raise ValueError("Invalid value for `next_jid`, must not be `None`")  # noqa: E501
        if next_jid is not None and next_jid > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `next_jid`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if next_jid is not None and next_jid < 1:  # noqa: E501
            raise ValueError("Invalid value for `next_jid`, must be a value greater than or equal to `1`")  # noqa: E501

        self._next_jid = next_jid

    @property
    def run_degraded(self):
        """Gets the run_degraded of this JobJobSummarySummary.  # noqa: E501

        Whether the job engine would allow most jobs to run even when the cluster is in a degraded state.  # noqa: E501

        :return: The run_degraded of this JobJobSummarySummary.  # noqa: E501
        :rtype: bool
        """
        return self._run_degraded

    @run_degraded.setter
    def run_degraded(self, run_degraded):
        """Sets the run_degraded of this JobJobSummarySummary.

        Whether the job engine would allow most jobs to run even when the cluster is in a degraded state.  # noqa: E501

        :param run_degraded: The run_degraded of this JobJobSummarySummary.  # noqa: E501
        :type: bool
        """
        if run_degraded is None:
            raise ValueError("Invalid value for `run_degraded`, must not be `None`")  # noqa: E501

        self._run_degraded = run_degraded

    @property
    def stats_ready(self):
        """Gets the stats_ready of this JobJobSummarySummary.  # noqa: E501

        Whether the coordinator has recently gathered statistics for all nodes in the cluster.  # noqa: E501

        :return: The stats_ready of this JobJobSummarySummary.  # noqa: E501
        :rtype: bool
        """
        return self._stats_ready

    @stats_ready.setter
    def stats_ready(self, stats_ready):
        """Sets the stats_ready of this JobJobSummarySummary.

        Whether the coordinator has recently gathered statistics for all nodes in the cluster.  # noqa: E501

        :param stats_ready: The stats_ready of this JobJobSummarySummary.  # noqa: E501
        :type: bool
        """
        if stats_ready is None:
            raise ValueError("Invalid value for `stats_ready`, must not be `None`")  # noqa: E501

        self._stats_ready = stats_ready

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobJobSummarySummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
