# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_9_1_0.api_client import ApiClient


class ProtocolsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_hdfs_crypto_encryption_zone(self, hdfs_crypto_encryption_zone, **kwargs):  # noqa: E501
        """create_hdfs_crypto_encryption_zone  # noqa: E501

        Turn an empty directory into an Encryption Zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hdfs_crypto_encryption_zone(hdfs_crypto_encryption_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsCryptoEncryptionZone hdfs_crypto_encryption_zone: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hdfs_crypto_encryption_zone_with_http_info(hdfs_crypto_encryption_zone, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hdfs_crypto_encryption_zone_with_http_info(hdfs_crypto_encryption_zone, **kwargs)  # noqa: E501
            return data

    def create_hdfs_crypto_encryption_zone_with_http_info(self, hdfs_crypto_encryption_zone, **kwargs):  # noqa: E501
        """create_hdfs_crypto_encryption_zone  # noqa: E501

        Turn an empty directory into an Encryption Zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hdfs_crypto_encryption_zone_with_http_info(hdfs_crypto_encryption_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsCryptoEncryptionZone hdfs_crypto_encryption_zone: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_crypto_encryption_zone', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hdfs_crypto_encryption_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_crypto_encryption_zone' is set
        if ('hdfs_crypto_encryption_zone' not in params or
                params['hdfs_crypto_encryption_zone'] is None):
            raise ValueError("Missing the required parameter `hdfs_crypto_encryption_zone` when calling `create_hdfs_crypto_encryption_zone`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `create_hdfs_crypto_encryption_zone`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `create_hdfs_crypto_encryption_zone`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_crypto_encryption_zone' in params:
            body_params = params['hdfs_crypto_encryption_zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/hdfs/crypto/encryption-zones', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hdfs_proxyuser(self, hdfs_proxyuser, **kwargs):  # noqa: E501
        """create_hdfs_proxyuser  # noqa: E501

        Create a new HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hdfs_proxyuser(hdfs_proxyuser, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsProxyuserCreateParams hdfs_proxyuser: (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hdfs_proxyuser_with_http_info(hdfs_proxyuser, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hdfs_proxyuser_with_http_info(hdfs_proxyuser, **kwargs)  # noqa: E501
            return data

    def create_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser, **kwargs):  # noqa: E501
        """create_hdfs_proxyuser  # noqa: E501

        Create a new HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hdfs_proxyuser_with_http_info(hdfs_proxyuser, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsProxyuserCreateParams hdfs_proxyuser: (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser' is set
        if ('hdfs_proxyuser' not in params or
                params['hdfs_proxyuser'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser` when calling `create_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_proxyuser' in params:
            body_params = params['hdfs_proxyuser']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hdfs_rack(self, hdfs_rack, **kwargs):  # noqa: E501
        """create_hdfs_rack  # noqa: E501

        Create a new HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hdfs_rack(hdfs_rack, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsRackCreateParams hdfs_rack: (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hdfs_rack_with_http_info(hdfs_rack, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hdfs_rack_with_http_info(hdfs_rack, **kwargs)  # noqa: E501
            return data

    def create_hdfs_rack_with_http_info(self, hdfs_rack, **kwargs):  # noqa: E501
        """create_hdfs_rack  # noqa: E501

        Create a new HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hdfs_rack_with_http_info(hdfs_rack, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsRackCreateParams hdfs_rack: (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack' is set
        if ('hdfs_rack' not in params or
                params['hdfs_rack'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack` when calling `create_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_rack' in params:
            body_params = params['hdfs_rack']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ndmp_settings_preferred_ip(self, ndmp_settings_preferred_ip, **kwargs):  # noqa: E501
        """create_ndmp_settings_preferred_ip  # noqa: E501

        Create a preferred ip preference.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ndmp_settings_preferred_ip(ndmp_settings_preferred_ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsPreferredIpCreateParams ndmp_settings_preferred_ip: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip, **kwargs)  # noqa: E501
            return data

    def create_ndmp_settings_preferred_ip_with_http_info(self, ndmp_settings_preferred_ip, **kwargs):  # noqa: E501
        """create_ndmp_settings_preferred_ip  # noqa: E501

        Create a preferred ip preference.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsPreferredIpCreateParams ndmp_settings_preferred_ip: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_preferred_ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ndmp_settings_preferred_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_preferred_ip' is set
        if ('ndmp_settings_preferred_ip' not in params or
                params['ndmp_settings_preferred_ip'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_preferred_ip` when calling `create_ndmp_settings_preferred_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_settings_preferred_ip' in params:
            body_params = params['ndmp_settings_preferred_ip']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/ndmp/settings/preferred-ips', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ndmp_settings_variable(self, ndmp_settings_variable, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """create_ndmp_settings_variable  # noqa: E501

        Create a preferred NDMP environment variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ndmp_settings_variable(ndmp_settings_variable, ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsVariableCreateParams ndmp_settings_variable: (required)
        :param str ndmp_settings_variable_id: Create a preferred NDMP environment variable. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ndmp_settings_variable_with_http_info(ndmp_settings_variable, ndmp_settings_variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ndmp_settings_variable_with_http_info(ndmp_settings_variable, ndmp_settings_variable_id, **kwargs)  # noqa: E501
            return data

    def create_ndmp_settings_variable_with_http_info(self, ndmp_settings_variable, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """create_ndmp_settings_variable  # noqa: E501

        Create a preferred NDMP environment variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ndmp_settings_variable_with_http_info(ndmp_settings_variable, ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsVariableCreateParams ndmp_settings_variable: (required)
        :param str ndmp_settings_variable_id: Create a preferred NDMP environment variable. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_variable', 'ndmp_settings_variable_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ndmp_settings_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_variable' is set
        if ('ndmp_settings_variable' not in params or
                params['ndmp_settings_variable'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_variable` when calling `create_ndmp_settings_variable`")  # noqa: E501
        # verify the required parameter 'ndmp_settings_variable_id' is set
        if ('ndmp_settings_variable_id' not in params or
                params['ndmp_settings_variable_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_variable_id` when calling `create_ndmp_settings_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_variable_id' in params:
            path_params['NdmpSettingsVariableId'] = params['ndmp_settings_variable_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_settings_variable' in params:
            body_params = params['ndmp_settings_variable']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ndmp_user(self, ndmp_user, **kwargs):  # noqa: E501
        """create_ndmp_user  # noqa: E501

        Created a new user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ndmp_user(ndmp_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpUserCreateParams ndmp_user: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ndmp_user_with_http_info(ndmp_user, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ndmp_user_with_http_info(ndmp_user, **kwargs)  # noqa: E501
            return data

    def create_ndmp_user_with_http_info(self, ndmp_user, **kwargs):  # noqa: E501
        """create_ndmp_user  # noqa: E501

        Created a new user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ndmp_user_with_http_info(ndmp_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpUserCreateParams ndmp_user: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ndmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_user' is set
        if ('ndmp_user' not in params or
                params['ndmp_user'] is None):
            raise ValueError("Missing the required parameter `ndmp_user` when calling `create_ndmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_user' in params:
            body_params = params['ndmp_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_alias(self, nfs_alias, **kwargs):  # noqa: E501
        """create_nfs_alias  # noqa: E501

        Create a new NFS alias.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_alias(nfs_alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsAliasCreateParams nfs_alias: (required)
        :param str zone: Access zone
        :return: CreateNfsAliasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nfs_alias_with_http_info(nfs_alias, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_alias_with_http_info(nfs_alias, **kwargs)  # noqa: E501
            return data

    def create_nfs_alias_with_http_info(self, nfs_alias, **kwargs):  # noqa: E501
        """create_nfs_alias  # noqa: E501

        Create a new NFS alias.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_alias_with_http_info(nfs_alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsAliasCreateParams nfs_alias: (required)
        :param str zone: Access zone
        :return: CreateNfsAliasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias' is set
        if ('nfs_alias' not in params or
                params['nfs_alias'] is None):
            raise ValueError("Missing the required parameter `nfs_alias` when calling `create_nfs_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_alias' in params:
            body_params = params['nfs_alias']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateNfsAliasResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_export(self, nfs_export, **kwargs):  # noqa: E501
        """create_nfs_export  # noqa: E501

        Create a new NFS export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_export(nfs_export, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsExportCreateParams nfs_export: (required)
        :param bool force: If true, the export will be created even if it conflicts with another export.
        :param bool ignore_unresolvable_hosts: Ignore unresolvable hosts.
        :param str zone: Access zone
        :param bool ignore_conflicts: Ignore conflicts with existing exports.
        :param bool ignore_bad_paths: Ignore nonexistent or otherwise bad paths.
        :param bool ignore_bad_auth: Ignore invalid users.
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nfs_export_with_http_info(nfs_export, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_export_with_http_info(nfs_export, **kwargs)  # noqa: E501
            return data

    def create_nfs_export_with_http_info(self, nfs_export, **kwargs):  # noqa: E501
        """create_nfs_export  # noqa: E501

        Create a new NFS export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_export_with_http_info(nfs_export, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsExportCreateParams nfs_export: (required)
        :param bool force: If true, the export will be created even if it conflicts with another export.
        :param bool ignore_unresolvable_hosts: Ignore unresolvable hosts.
        :param str zone: Access zone
        :param bool ignore_conflicts: Ignore conflicts with existing exports.
        :param bool ignore_bad_paths: Ignore nonexistent or otherwise bad paths.
        :param bool ignore_bad_auth: Ignore invalid users.
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export', 'force', 'ignore_unresolvable_hosts', 'zone', 'ignore_conflicts', 'ignore_bad_paths', 'ignore_bad_auth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export' is set
        if ('nfs_export' not in params or
                params['nfs_export'] is None):
            raise ValueError("Missing the required parameter `nfs_export` when calling `create_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'ignore_unresolvable_hosts' in params:
            query_params.append(('ignore_unresolvable_hosts', params['ignore_unresolvable_hosts']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'ignore_conflicts' in params:
            query_params.append(('ignore_conflicts', params['ignore_conflicts']))  # noqa: E501
        if 'ignore_bad_paths' in params:
            query_params.append(('ignore_bad_paths', params['ignore_bad_paths']))  # noqa: E501
        if 'ignore_bad_auth' in params:
            query_params.append(('ignore_bad_auth', params['ignore_bad_auth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_export' in params:
            body_params = params['nfs_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/nfs/exports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateQuotaReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_netgroup_check_item(self, nfs_netgroup_check_item, **kwargs):  # noqa: E501
        """create_nfs_netgroup_check_item  # noqa: E501

        Update the NFS netgroups in the cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_netgroup_check_item(nfs_netgroup_check_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_netgroup_check_item: (required)
        :param str host: IP address of node to update. If unspecified, the local nodes cache is updated.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nfs_netgroup_check_item_with_http_info(nfs_netgroup_check_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_netgroup_check_item_with_http_info(nfs_netgroup_check_item, **kwargs)  # noqa: E501
            return data

    def create_nfs_netgroup_check_item_with_http_info(self, nfs_netgroup_check_item, **kwargs):  # noqa: E501
        """create_nfs_netgroup_check_item  # noqa: E501

        Update the NFS netgroups in the cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_netgroup_check_item_with_http_info(nfs_netgroup_check_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_netgroup_check_item: (required)
        :param str host: IP address of node to update. If unspecified, the local nodes cache is updated.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_netgroup_check_item', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_netgroup_check_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_netgroup_check_item' is set
        if ('nfs_netgroup_check_item' not in params or
                params['nfs_netgroup_check_item'] is None):
            raise ValueError("Missing the required parameter `nfs_netgroup_check_item` when calling `create_nfs_netgroup_check_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'host' in params:
            query_params.append(('host', params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_netgroup_check_item' in params:
            body_params = params['nfs_netgroup_check_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/netgroup/check', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_netgroup_flush_item(self, nfs_netgroup_flush_item, **kwargs):  # noqa: E501
        """create_nfs_netgroup_flush_item  # noqa: E501

        Flush the NFS netgroups in the cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_netgroup_flush_item(nfs_netgroup_flush_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_netgroup_flush_item: (required)
        :param str host: IP address of node to flush. If unspecified, all nodes on the cluster are flushed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nfs_netgroup_flush_item_with_http_info(nfs_netgroup_flush_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_netgroup_flush_item_with_http_info(nfs_netgroup_flush_item, **kwargs)  # noqa: E501
            return data

    def create_nfs_netgroup_flush_item_with_http_info(self, nfs_netgroup_flush_item, **kwargs):  # noqa: E501
        """create_nfs_netgroup_flush_item  # noqa: E501

        Flush the NFS netgroups in the cache.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_netgroup_flush_item_with_http_info(nfs_netgroup_flush_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_netgroup_flush_item: (required)
        :param str host: IP address of node to flush. If unspecified, all nodes on the cluster are flushed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_netgroup_flush_item', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_netgroup_flush_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_netgroup_flush_item' is set
        if ('nfs_netgroup_flush_item' not in params or
                params['nfs_netgroup_flush_item'] is None):
            raise ValueError("Missing the required parameter `nfs_netgroup_flush_item` when calling `create_nfs_netgroup_flush_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'host' in params:
            query_params.append(('host', params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_netgroup_flush_item' in params:
            body_params = params['nfs_netgroup_flush_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/netgroup/flush', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_nlm_sessions_check_item(self, nfs_nlm_sessions_check_item, **kwargs):  # noqa: E501
        """create_nfs_nlm_sessions_check_item  # noqa: E501

        Perform an active scan for lost NFSv3 locks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_nlm_sessions_check_item(nfs_nlm_sessions_check_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_nlm_sessions_check_item: (required)
        :param str cluster_ip: An IP address for which NSM has client records
        :param str zone: Represents an extant auth zone
        :return: CreateNfsNlmSessionsCheckItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nfs_nlm_sessions_check_item_with_http_info(nfs_nlm_sessions_check_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_nlm_sessions_check_item_with_http_info(nfs_nlm_sessions_check_item, **kwargs)  # noqa: E501
            return data

    def create_nfs_nlm_sessions_check_item_with_http_info(self, nfs_nlm_sessions_check_item, **kwargs):  # noqa: E501
        """create_nfs_nlm_sessions_check_item  # noqa: E501

        Perform an active scan for lost NFSv3 locks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_nlm_sessions_check_item_with_http_info(nfs_nlm_sessions_check_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_nlm_sessions_check_item: (required)
        :param str cluster_ip: An IP address for which NSM has client records
        :param str zone: Represents an extant auth zone
        :return: CreateNfsNlmSessionsCheckItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_nlm_sessions_check_item', 'cluster_ip', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_nlm_sessions_check_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_nlm_sessions_check_item' is set
        if ('nfs_nlm_sessions_check_item' not in params or
                params['nfs_nlm_sessions_check_item'] is None):
            raise ValueError("Missing the required parameter `nfs_nlm_sessions_check_item` when calling `create_nfs_nlm_sessions_check_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cluster_ip' in params:
            query_params.append(('cluster_ip', params['cluster_ip']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_nlm_sessions_check_item' in params:
            body_params = params['nfs_nlm_sessions_check_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/nlm/sessions-check', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateNfsNlmSessionsCheckItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nfs_reload_item(self, nfs_reload_item, **kwargs):  # noqa: E501
        """create_nfs_reload_item  # noqa: E501

        Reload default NFS export configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_reload_item(nfs_reload_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_reload_item: (required)
        :param str zone: Access zone
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nfs_reload_item_with_http_info(nfs_reload_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nfs_reload_item_with_http_info(nfs_reload_item, **kwargs)  # noqa: E501
            return data

    def create_nfs_reload_item_with_http_info(self, nfs_reload_item, **kwargs):  # noqa: E501
        """create_nfs_reload_item  # noqa: E501

        Reload default NFS export configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_nfs_reload_item_with_http_info(nfs_reload_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty nfs_reload_item: (required)
        :param str zone: Access zone
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_reload_item', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nfs_reload_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_reload_item' is set
        if ('nfs_reload_item' not in params or
                params['nfs_reload_item'] is None):
            raise ValueError("Missing the required parameter `nfs_reload_item` when calling `create_nfs_reload_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_reload_item' in params:
            body_params = params['nfs_reload_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/reload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ntp_server(self, ntp_server, **kwargs):  # noqa: E501
        """create_ntp_server  # noqa: E501

        Create an NTP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ntp_server(ntp_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NtpServerCreateParams ntp_server: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ntp_server_with_http_info(ntp_server, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ntp_server_with_http_info(ntp_server, **kwargs)  # noqa: E501
            return data

    def create_ntp_server_with_http_info(self, ntp_server, **kwargs):  # noqa: E501
        """create_ntp_server  # noqa: E501

        Create an NTP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ntp_server_with_http_info(ntp_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NtpServerCreateParams ntp_server: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ntp_server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ntp_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ntp_server' is set
        if ('ntp_server' not in params or
                params['ntp_server'] is None):
            raise ValueError("Missing the required parameter `ntp_server` when calling `create_ntp_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ntp_server' in params:
            body_params = params['ntp_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/servers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_s3_bucket(self, s3_bucket, **kwargs):  # noqa: E501
        """create_s3_bucket  # noqa: E501

        Create a new bucket.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_bucket(s3_bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3BucketCreateParams s3_bucket: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_s3_bucket_with_http_info(s3_bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.create_s3_bucket_with_http_info(s3_bucket, **kwargs)  # noqa: E501
            return data

    def create_s3_bucket_with_http_info(self, s3_bucket, **kwargs):  # noqa: E501
        """create_s3_bucket  # noqa: E501

        Create a new bucket.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_bucket_with_http_info(s3_bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3BucketCreateParams s3_bucket: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_bucket', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_s3_bucket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_bucket' is set
        if ('s3_bucket' not in params or
                params['s3_bucket'] is None):
            raise ValueError("Missing the required parameter `s3_bucket` when calling `create_s3_bucket`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `create_s3_bucket`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `create_s3_bucket`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_bucket' in params:
            body_params = params['s3_bucket']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/buckets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_s3_key(self, s3_key, s3_key_id, **kwargs):  # noqa: E501
        """create_s3_key  # noqa: E501

        Generate a new secret key/access ID for given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_key(s3_key, s3_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Key s3_key: (required)
        :param str s3_key_id: Generate a new secret key/access ID for given user. (required)
        :param bool force: Forces to create new key.
        :param str zone: Specifies access zone containing user.
        :return: CreateS3KeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_s3_key_with_http_info(s3_key, s3_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_s3_key_with_http_info(s3_key, s3_key_id, **kwargs)  # noqa: E501
            return data

    def create_s3_key_with_http_info(self, s3_key, s3_key_id, **kwargs):  # noqa: E501
        """create_s3_key  # noqa: E501

        Generate a new secret key/access ID for given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_key_with_http_info(s3_key, s3_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Key s3_key: (required)
        :param str s3_key_id: Generate a new secret key/access ID for given user. (required)
        :param bool force: Forces to create new key.
        :param str zone: Specifies access zone containing user.
        :return: CreateS3KeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_key', 's3_key_id', 'force', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_s3_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_key' is set
        if ('s3_key' not in params or
                params['s3_key'] is None):
            raise ValueError("Missing the required parameter `s3_key` when calling `create_s3_key`")  # noqa: E501
        # verify the required parameter 's3_key_id' is set
        if ('s3_key_id' not in params or
                params['s3_key_id'] is None):
            raise ValueError("Missing the required parameter `s3_key_id` when calling `create_s3_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 's3_key_id' in params:
            path_params['S3KeyId'] = params['s3_key_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_key' in params:
            body_params = params['s3_key']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/keys/{S3KeyId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateS3KeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_s3_mykey(self, s3_mykey, **kwargs):  # noqa: E501
        """create_s3_mykey  # noqa: E501

        Generate a new secret key/access ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_mykey(s3_mykey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Key s3_mykey: (required)
        :param bool force: Forces to create new key.
        :return: CreateS3KeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_s3_mykey_with_http_info(s3_mykey, **kwargs)  # noqa: E501
        else:
            (data) = self.create_s3_mykey_with_http_info(s3_mykey, **kwargs)  # noqa: E501
            return data

    def create_s3_mykey_with_http_info(self, s3_mykey, **kwargs):  # noqa: E501
        """create_s3_mykey  # noqa: E501

        Generate a new secret key/access ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_mykey_with_http_info(s3_mykey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Key s3_mykey: (required)
        :param bool force: Forces to create new key.
        :return: CreateS3KeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_mykey', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_s3_mykey" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_mykey' is set
        if ('s3_mykey' not in params or
                params['s3_mykey'] is None):
            raise ValueError("Missing the required parameter `s3_mykey` when calling `create_s3_mykey`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_mykey' in params:
            body_params = params['s3_mykey']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/mykeys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateS3KeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_smb_log_level_filter(self, smb_log_level_filter, **kwargs):  # noqa: E501
        """create_smb_log_level_filter  # noqa: E501

        Add an SMB log filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_smb_log_level_filter(smb_log_level_filter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbLogLevelFilter smb_log_level_filter: (required)
        :return: CreateSmbLogLevelFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_smb_log_level_filter_with_http_info(smb_log_level_filter, **kwargs)  # noqa: E501
        else:
            (data) = self.create_smb_log_level_filter_with_http_info(smb_log_level_filter, **kwargs)  # noqa: E501
            return data

    def create_smb_log_level_filter_with_http_info(self, smb_log_level_filter, **kwargs):  # noqa: E501
        """create_smb_log_level_filter  # noqa: E501

        Add an SMB log filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_smb_log_level_filter_with_http_info(smb_log_level_filter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbLogLevelFilter smb_log_level_filter: (required)
        :return: CreateSmbLogLevelFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_log_level_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_smb_log_level_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_log_level_filter' is set
        if ('smb_log_level_filter' not in params or
                params['smb_log_level_filter'] is None):
            raise ValueError("Missing the required parameter `smb_log_level_filter` when calling `create_smb_log_level_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_log_level_filter' in params:
            body_params = params['smb_log_level_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level/filters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSmbLogLevelFilterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_smb_share(self, smb_share, **kwargs):  # noqa: E501
        """create_smb_share  # noqa: E501

        Create a new share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_smb_share(smb_share, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbShareCreateParams smb_share: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateSmbShareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_smb_share_with_http_info(smb_share, **kwargs)  # noqa: E501
        else:
            (data) = self.create_smb_share_with_http_info(smb_share, **kwargs)  # noqa: E501
            return data

    def create_smb_share_with_http_info(self, smb_share, **kwargs):  # noqa: E501
        """create_smb_share  # noqa: E501

        Create a new share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_smb_share_with_http_info(smb_share, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbShareCreateParams smb_share: (required)
        :param str zone: Specifies which access zone to use.
        :return: CreateSmbShareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share' is set
        if ('smb_share' not in params or
                params['smb_share'] is None):
            raise ValueError("Missing the required parameter `smb_share` when calling `create_smb_share`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `create_smb_share`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `create_smb_share`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_share' in params:
            body_params = params['smb_share']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/shares', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSmbShareResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_swift_account(self, swift_account, **kwargs):  # noqa: E501
        """create_swift_account  # noqa: E501

        Create a new Swift account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_swift_account(swift_account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SwiftAccount swift_account: (required)
        :param str zone: Access zone which contains Swift account.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_swift_account_with_http_info(swift_account, **kwargs)  # noqa: E501
        else:
            (data) = self.create_swift_account_with_http_info(swift_account, **kwargs)  # noqa: E501
            return data

    def create_swift_account_with_http_info(self, swift_account, **kwargs):  # noqa: E501
        """create_swift_account  # noqa: E501

        Create a new Swift account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_swift_account_with_http_info(swift_account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SwiftAccount swift_account: (required)
        :param str zone: Access zone which contains Swift account.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['swift_account', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_swift_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'swift_account' is set
        if ('swift_account' not in params or
                params['swift_account'] is None):
            raise ValueError("Missing the required parameter `swift_account` when calling `create_swift_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'swift_account' in params:
            body_params = params['swift_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/swift/accounts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hdfs_fsimage_latest(self, **kwargs):  # noqa: E501
        """delete_hdfs_fsimage_latest  # noqa: E501

        Delete the latest HDFS FSImage, if there is one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_fsimage_latest(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS FSImage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hdfs_fsimage_latest_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_hdfs_fsimage_latest_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_hdfs_fsimage_latest_with_http_info(self, **kwargs):  # noqa: E501
        """delete_hdfs_fsimage_latest  # noqa: E501

        Delete the latest HDFS FSImage, if there is one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_fsimage_latest_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS FSImage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hdfs_fsimage_latest" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/latest', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hdfs_inotify_stream(self, **kwargs):  # noqa: E501
        """delete_hdfs_inotify_stream  # noqa: E501

        Delete all collected events, this has the effect of resetting the stream. Note that this may cause clients reading INotify to fail. The clients that want to track metadata changes may resume reading from INotify stream after updating filesystem metadata from other sources, like HDFS FSImage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_inotify_stream(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which exposes HDFS INotify.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hdfs_inotify_stream_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_hdfs_inotify_stream_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_hdfs_inotify_stream_with_http_info(self, **kwargs):  # noqa: E501
        """delete_hdfs_inotify_stream  # noqa: E501

        Delete all collected events, this has the effect of resetting the stream. Note that this may cause clients reading INotify to fail. The clients that want to track metadata changes may resume reading from INotify stream after updating filesystem metadata from other sources, like HDFS FSImage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_inotify_stream_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which exposes HDFS INotify.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hdfs_inotify_stream" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/inotify/stream', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hdfs_proxyuser(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """delete_hdfs_proxyuser  # noqa: E501

        Delete an HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_proxyuser(hdfs_proxyuser_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_proxyuser_id: Delete an HDFS proxyuser. (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
            return data

    def delete_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """delete_hdfs_proxyuser  # noqa: E501

        Delete an HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_proxyuser_id: Delete an HDFS proxyuser. (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser_id' is set
        if ('hdfs_proxyuser_id' not in params or
                params['hdfs_proxyuser_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser_id` when calling `delete_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_proxyuser_id' in params:
            path_params['HdfsProxyuserId'] = params['hdfs_proxyuser_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hdfs_rack(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """delete_hdfs_rack  # noqa: E501

        Delete the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_rack(hdfs_rack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_rack_id: Delete the HDFS rack. (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
            return data

    def delete_hdfs_rack_with_http_info(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """delete_hdfs_rack  # noqa: E501

        Delete the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hdfs_rack_with_http_info(hdfs_rack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_rack_id: Delete the HDFS rack. (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack_id' is set
        if ('hdfs_rack_id' not in params or
                params['hdfs_rack_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack_id` when calling `delete_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_rack_id' in params:
            path_params['HdfsRackId'] = params['hdfs_rack_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks/{HdfsRackId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_contexts_backup_by_id(self, ndmp_contexts_backup_id, **kwargs):  # noqa: E501
        """delete_ndmp_contexts_backup_by_id  # noqa: E501

        Delete a backup context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_contexts_backup_by_id(ndmp_contexts_backup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_backup_id: Delete a backup context (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_contexts_backup_by_id_with_http_info(ndmp_contexts_backup_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_contexts_backup_by_id_with_http_info(ndmp_contexts_backup_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_contexts_backup_by_id_with_http_info(self, ndmp_contexts_backup_id, **kwargs):  # noqa: E501
        """delete_ndmp_contexts_backup_by_id  # noqa: E501

        Delete a backup context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_contexts_backup_by_id_with_http_info(ndmp_contexts_backup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_backup_id: Delete a backup context (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_contexts_backup_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_contexts_backup_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_contexts_backup_id' is set
        if ('ndmp_contexts_backup_id' not in params or
                params['ndmp_contexts_backup_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_contexts_backup_id` when calling `delete_ndmp_contexts_backup_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_contexts_backup_id' in params:
            path_params['NdmpContextsBackupId'] = params['ndmp_contexts_backup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/backup/{NdmpContextsBackupId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_contexts_bre_by_id(self, ndmp_contexts_bre_id, **kwargs):  # noqa: E501
        """delete_ndmp_contexts_bre_by_id  # noqa: E501

        Delete a NDMP BRE context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_contexts_bre_by_id(ndmp_contexts_bre_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_bre_id: Delete a NDMP BRE context (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_contexts_bre_by_id_with_http_info(ndmp_contexts_bre_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_contexts_bre_by_id_with_http_info(ndmp_contexts_bre_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_contexts_bre_by_id_with_http_info(self, ndmp_contexts_bre_id, **kwargs):  # noqa: E501
        """delete_ndmp_contexts_bre_by_id  # noqa: E501

        Delete a NDMP BRE context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_contexts_bre_by_id_with_http_info(ndmp_contexts_bre_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_bre_id: Delete a NDMP BRE context (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_contexts_bre_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_contexts_bre_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_contexts_bre_id' is set
        if ('ndmp_contexts_bre_id' not in params or
                params['ndmp_contexts_bre_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_contexts_bre_id` when calling `delete_ndmp_contexts_bre_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_contexts_bre_id' in params:
            path_params['NdmpContextsBreId'] = params['ndmp_contexts_bre_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/bre/{NdmpContextsBreId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_contexts_restore_by_id(self, ndmp_contexts_restore_id, **kwargs):  # noqa: E501
        """delete_ndmp_contexts_restore_by_id  # noqa: E501

        Delete a restore context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_contexts_restore_by_id(ndmp_contexts_restore_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_restore_id: Delete a restore context (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_contexts_restore_by_id_with_http_info(ndmp_contexts_restore_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_contexts_restore_by_id_with_http_info(ndmp_contexts_restore_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_contexts_restore_by_id_with_http_info(self, ndmp_contexts_restore_id, **kwargs):  # noqa: E501
        """delete_ndmp_contexts_restore_by_id  # noqa: E501

        Delete a restore context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_contexts_restore_by_id_with_http_info(ndmp_contexts_restore_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_restore_id: Delete a restore context (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_contexts_restore_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_contexts_restore_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_contexts_restore_id' is set
        if ('ndmp_contexts_restore_id' not in params or
                params['ndmp_contexts_restore_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_contexts_restore_id` when calling `delete_ndmp_contexts_restore_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_contexts_restore_id' in params:
            path_params['NdmpContextsRestoreId'] = params['ndmp_contexts_restore_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/restore/{NdmpContextsRestoreId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_dumpdate(self, ndmp_dumpdate_id, **kwargs):  # noqa: E501
        """delete_ndmp_dumpdate  # noqa: E501

        Delete dumpdates entries of a specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_dumpdate(ndmp_dumpdate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_dumpdate_id: Delete dumpdates entries of a specified path. (required)
        :param int level: Level is an input from 0 to 10.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_dumpdate_with_http_info(ndmp_dumpdate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_dumpdate_with_http_info(ndmp_dumpdate_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_dumpdate_with_http_info(self, ndmp_dumpdate_id, **kwargs):  # noqa: E501
        """delete_ndmp_dumpdate  # noqa: E501

        Delete dumpdates entries of a specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_dumpdate_with_http_info(ndmp_dumpdate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_dumpdate_id: Delete dumpdates entries of a specified path. (required)
        :param int level: Level is an input from 0 to 10.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_dumpdate_id', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_dumpdate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_dumpdate_id' is set
        if ('ndmp_dumpdate_id' not in params or
                params['ndmp_dumpdate_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_dumpdate_id` when calling `delete_ndmp_dumpdate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_dumpdate_id' in params:
            path_params['NdmpDumpdateId'] = params['ndmp_dumpdate_id']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/dumpdates/{NdmpDumpdateId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_session(self, ndmp_session_id, **kwargs):  # noqa: E501
        """delete_ndmp_session  # noqa: E501

        Delete the ndmp session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_session(ndmp_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_session_id: Delete the ndmp session. (required)
        :param str lnn: Logical node number.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_session_with_http_info(ndmp_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_session_with_http_info(ndmp_session_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_session_with_http_info(self, ndmp_session_id, **kwargs):  # noqa: E501
        """delete_ndmp_session  # noqa: E501

        Delete the ndmp session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_session_with_http_info(ndmp_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_session_id: Delete the ndmp session. (required)
        :param str lnn: Logical node number.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_session_id', 'lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_session_id' is set
        if ('ndmp_session_id' not in params or
                params['ndmp_session_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_session_id` when calling `delete_ndmp_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_session_id' in params:
            path_params['NdmpSessionId'] = params['ndmp_session_id']  # noqa: E501

        query_params = []
        if 'lnn' in params:
            query_params.append(('lnn', params['lnn']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/sessions/{NdmpSessionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_settings_preferred_ip(self, ndmp_settings_preferred_ip_id, **kwargs):  # noqa: E501
        """delete_ndmp_settings_preferred_ip  # noqa: E501

        Delete a preferred ip preference.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_settings_preferred_ip(ndmp_settings_preferred_ip_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_preferred_ip_id: Delete a preferred ip preference. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_settings_preferred_ip_with_http_info(self, ndmp_settings_preferred_ip_id, **kwargs):  # noqa: E501
        """delete_ndmp_settings_preferred_ip  # noqa: E501

        Delete a preferred ip preference.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_preferred_ip_id: Delete a preferred ip preference. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_preferred_ip_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_settings_preferred_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_preferred_ip_id' is set
        if ('ndmp_settings_preferred_ip_id' not in params or
                params['ndmp_settings_preferred_ip_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_preferred_ip_id` when calling `delete_ndmp_settings_preferred_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_preferred_ip_id' in params:
            path_params['NdmpSettingsPreferredIpId'] = params['ndmp_settings_preferred_ip_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/ndmp/settings/preferred-ips/{NdmpSettingsPreferredIpId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_settings_variable(self, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """delete_ndmp_settings_variable  # noqa: E501

        Delete preferred environment variable entries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_settings_variable(ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_variable_id: Delete preferred environment variable entries (required)
        :param str name: Name of the variable to delete.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_settings_variable_with_http_info(ndmp_settings_variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_settings_variable_with_http_info(ndmp_settings_variable_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_settings_variable_with_http_info(self, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """delete_ndmp_settings_variable  # noqa: E501

        Delete preferred environment variable entries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_settings_variable_with_http_info(ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_variable_id: Delete preferred environment variable entries (required)
        :param str name: Name of the variable to delete.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_variable_id', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_settings_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_variable_id' is set
        if ('ndmp_settings_variable_id' not in params or
                params['ndmp_settings_variable_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_variable_id` when calling `delete_ndmp_settings_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_variable_id' in params:
            path_params['NdmpSettingsVariableId'] = params['ndmp_settings_variable_id']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ndmp_user(self, ndmp_user_id, **kwargs):  # noqa: E501
        """delete_ndmp_user  # noqa: E501

        Delete the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_user(ndmp_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_user_id: Delete the user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ndmp_user_with_http_info(ndmp_user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ndmp_user_with_http_info(ndmp_user_id, **kwargs)  # noqa: E501
            return data

    def delete_ndmp_user_with_http_info(self, ndmp_user_id, **kwargs):  # noqa: E501
        """delete_ndmp_user  # noqa: E501

        Delete the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ndmp_user_with_http_info(ndmp_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_user_id: Delete the user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ndmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_user_id' is set
        if ('ndmp_user_id' not in params or
                params['ndmp_user_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_user_id` when calling `delete_ndmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_user_id' in params:
            path_params['NdmpUserId'] = params['ndmp_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/users/{NdmpUserId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nfs_alias(self, nfs_alias_id, **kwargs):  # noqa: E501
        """delete_nfs_alias  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_nfs_alias(nfs_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_alias_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
            return data

    def delete_nfs_alias_with_http_info(self, nfs_alias_id, **kwargs):  # noqa: E501
        """delete_nfs_alias  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_nfs_alias_with_http_info(nfs_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_alias_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias_id' is set
        if ('nfs_alias_id' not in params or
                params['nfs_alias_id'] is None):
            raise ValueError("Missing the required parameter `nfs_alias_id` when calling `delete_nfs_alias`")  # noqa: E501

        if 'nfs_alias_id' in params:
            # tag this parameter so that it can be url encoded with quote_plus
            # by the api_client code because it contains a '/' character that
            # needs to be url encoded.
            params['nfs_alias_id'] = "__x-isi-url-encode-path-param__{0}".format(params['nfs_alias_id'])
        collection_formats = {}

        path_params = {}
        if 'nfs_alias_id' in params:
            path_params['NfsAliasId'] = params['nfs_alias_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases/{NfsAliasId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nfs_export(self, nfs_export_id, **kwargs):  # noqa: E501
        """delete_nfs_export  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_nfs_export(nfs_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_export_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
            return data

    def delete_nfs_export_with_http_info(self, nfs_export_id, **kwargs):  # noqa: E501
        """delete_nfs_export  # noqa: E501

        Delete the export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_nfs_export_with_http_info(nfs_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_export_id: Delete the export. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export_id' is set
        if ('nfs_export_id' not in params or
                params['nfs_export_id'] is None):
            raise ValueError("Missing the required parameter `nfs_export_id` when calling `delete_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_export_id' in params:
            path_params['NfsExportId'] = params['nfs_export_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/nfs/exports/{NfsExportId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nfs_nlm_session(self, nfs_nlm_session_id, **kwargs):  # noqa: E501
        """delete_nfs_nlm_session  # noqa: E501

        Delete all lock state for this host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_nfs_nlm_session(nfs_nlm_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_nlm_session_id: Delete all lock state for this host. (required)
        :param str cluster_ip: An IP address for which NSM has client records
        :param str zone: Represents an extant auth zone
        :param bool refresh: if set to true, the client will be given a chance to reclaim its locks before they are destroyed
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_nfs_nlm_session_with_http_info(nfs_nlm_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nfs_nlm_session_with_http_info(nfs_nlm_session_id, **kwargs)  # noqa: E501
            return data

    def delete_nfs_nlm_session_with_http_info(self, nfs_nlm_session_id, **kwargs):  # noqa: E501
        """delete_nfs_nlm_session  # noqa: E501

        Delete all lock state for this host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_nfs_nlm_session_with_http_info(nfs_nlm_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_nlm_session_id: Delete all lock state for this host. (required)
        :param str cluster_ip: An IP address for which NSM has client records
        :param str zone: Represents an extant auth zone
        :param bool refresh: if set to true, the client will be given a chance to reclaim its locks before they are destroyed
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_nlm_session_id', 'cluster_ip', 'zone', 'refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nfs_nlm_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_nlm_session_id' is set
        if ('nfs_nlm_session_id' not in params or
                params['nfs_nlm_session_id'] is None):
            raise ValueError("Missing the required parameter `nfs_nlm_session_id` when calling `delete_nfs_nlm_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_nlm_session_id' in params:
            path_params['NfsNlmSessionId'] = params['nfs_nlm_session_id']  # noqa: E501

        query_params = []
        if 'cluster_ip' in params:
            query_params.append(('cluster_ip', params['cluster_ip']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/nlm/sessions/{NfsNlmSessionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ntp_server(self, ntp_server_id, **kwargs):  # noqa: E501
        """delete_ntp_server  # noqa: E501

        Delete an NTP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ntp_server(ntp_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ntp_server_id: Delete an NTP server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ntp_server_with_http_info(ntp_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ntp_server_with_http_info(ntp_server_id, **kwargs)  # noqa: E501
            return data

    def delete_ntp_server_with_http_info(self, ntp_server_id, **kwargs):  # noqa: E501
        """delete_ntp_server  # noqa: E501

        Delete an NTP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ntp_server_with_http_info(ntp_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ntp_server_id: Delete an NTP server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ntp_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ntp_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ntp_server_id' is set
        if ('ntp_server_id' not in params or
                params['ntp_server_id'] is None):
            raise ValueError("Missing the required parameter `ntp_server_id` when calling `delete_ntp_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ntp_server_id' in params:
            path_params['NtpServerId'] = params['ntp_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/servers/{NtpServerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ntp_servers(self, **kwargs):  # noqa: E501
        """delete_ntp_servers  # noqa: E501

        Delete all NTP server entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ntp_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ntp_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_ntp_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_ntp_servers_with_http_info(self, **kwargs):  # noqa: E501
        """delete_ntp_servers  # noqa: E501

        Delete all NTP server entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ntp_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ntp_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/servers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_s3_bucket(self, s3_bucket_id, **kwargs):  # noqa: E501
        """delete_s3_bucket  # noqa: E501

        Delete the bucket.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_bucket(s3_bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_bucket_id: Delete the bucket. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_s3_bucket_with_http_info(s3_bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_s3_bucket_with_http_info(s3_bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_s3_bucket_with_http_info(self, s3_bucket_id, **kwargs):  # noqa: E501
        """delete_s3_bucket  # noqa: E501

        Delete the bucket.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_bucket_with_http_info(s3_bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_bucket_id: Delete the bucket. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_bucket_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_s3_bucket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_bucket_id' is set
        if ('s3_bucket_id' not in params or
                params['s3_bucket_id'] is None):
            raise ValueError("Missing the required parameter `s3_bucket_id` when calling `delete_s3_bucket`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `delete_s3_bucket`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `delete_s3_bucket`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 's3_bucket_id' in params:
            path_params['S3BucketId'] = params['s3_bucket_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/buckets/{S3BucketId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_s3_key(self, s3_key_id, **kwargs):  # noqa: E501
        """delete_s3_key  # noqa: E501

        Delete secret key information for given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_key(s3_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_key_id: Delete secret key information for given user. (required)
        :param str zone: Specifies access zone containing user.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_s3_key_with_http_info(s3_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_s3_key_with_http_info(s3_key_id, **kwargs)  # noqa: E501
            return data

    def delete_s3_key_with_http_info(self, s3_key_id, **kwargs):  # noqa: E501
        """delete_s3_key  # noqa: E501

        Delete secret key information for given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_key_with_http_info(s3_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_key_id: Delete secret key information for given user. (required)
        :param str zone: Specifies access zone containing user.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_key_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_s3_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_key_id' is set
        if ('s3_key_id' not in params or
                params['s3_key_id'] is None):
            raise ValueError("Missing the required parameter `s3_key_id` when calling `delete_s3_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 's3_key_id' in params:
            path_params['S3KeyId'] = params['s3_key_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/keys/{S3KeyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_s3_mykeys(self, **kwargs):  # noqa: E501
        """delete_s3_mykeys  # noqa: E501

        Delete secret key information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_mykeys(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_s3_mykeys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_s3_mykeys_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_s3_mykeys_with_http_info(self, **kwargs):  # noqa: E501
        """delete_s3_mykeys  # noqa: E501

        Delete secret key information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_mykeys_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_s3_mykeys" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/mykeys', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_log_level_filter(self, smb_log_level_filter_id, **kwargs):  # noqa: E501
        """delete_smb_log_level_filter  # noqa: E501

        Delete log filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_log_level_filter(smb_log_level_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_log_level_filter_id: Delete log filter. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_log_level_filter_with_http_info(smb_log_level_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_log_level_filter_with_http_info(smb_log_level_filter_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_log_level_filter_with_http_info(self, smb_log_level_filter_id, **kwargs):  # noqa: E501
        """delete_smb_log_level_filter  # noqa: E501

        Delete log filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_log_level_filter_with_http_info(smb_log_level_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_log_level_filter_id: Delete log filter. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_log_level_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_log_level_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_log_level_filter_id' is set
        if ('smb_log_level_filter_id' not in params or
                params['smb_log_level_filter_id'] is None):
            raise ValueError("Missing the required parameter `smb_log_level_filter_id` when calling `delete_smb_log_level_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_log_level_filter_id' in params:
            path_params['SmbLogLevelFilterId'] = params['smb_log_level_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level/filters/{SmbLogLevelFilterId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_log_level_filters(self, **kwargs):  # noqa: E501
        """delete_smb_log_level_filters  # noqa: E501

        Delete existing SMB log filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_log_level_filters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str level: Valid SMB logging levels
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_log_level_filters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_log_level_filters_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_smb_log_level_filters_with_http_info(self, **kwargs):  # noqa: E501
        """delete_smb_log_level_filters  # noqa: E501

        Delete existing SMB log filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_log_level_filters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str level: Valid SMB logging levels
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_log_level_filters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level/filters', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_openfile(self, smb_openfile_id, **kwargs):  # noqa: E501
        """delete_smb_openfile  # noqa: E501

        Close the file in the SMB server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_openfile(smb_openfile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_openfile_id: Close the file in the SMB server. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_openfile_with_http_info(smb_openfile_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_openfile_with_http_info(smb_openfile_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_openfile_with_http_info(self, smb_openfile_id, **kwargs):  # noqa: E501
        """delete_smb_openfile  # noqa: E501

        Close the file in the SMB server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_openfile_with_http_info(smb_openfile_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_openfile_id: Close the file in the SMB server. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_openfile_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_openfile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_openfile_id' is set
        if ('smb_openfile_id' not in params or
                params['smb_openfile_id'] is None):
            raise ValueError("Missing the required parameter `smb_openfile_id` when calling `delete_smb_openfile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_openfile_id' in params:
            path_params['SmbOpenfileId'] = params['smb_openfile_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/openfiles/{SmbOpenfileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_session(self, smb_session_id, **kwargs):  # noqa: E501
        """delete_smb_session  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_session(smb_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_session_id: Close the SMB session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_session_with_http_info(smb_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_session_with_http_info(smb_session_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_session_with_http_info(self, smb_session_id, **kwargs):  # noqa: E501
        """delete_smb_session  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_session_with_http_info(smb_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_session_id: Close the SMB session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_session_id' is set
        if ('smb_session_id' not in params or
                params['smb_session_id'] is None):
            raise ValueError("Missing the required parameter `smb_session_id` when calling `delete_smb_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_session_id' in params:
            path_params['SmbSessionId'] = params['smb_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/sessions/{SmbSessionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_sessions_computer_user(self, smb_sessions_computer_user, computer, **kwargs):  # noqa: E501
        """delete_smb_sessions_computer_user  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_sessions_computer_user(smb_sessions_computer_user, computer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_sessions_computer_user: Close the SMB session. (required)
        :param str computer: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_sessions_computer_user_with_http_info(smb_sessions_computer_user, computer, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_sessions_computer_user_with_http_info(smb_sessions_computer_user, computer, **kwargs)  # noqa: E501
            return data

    def delete_smb_sessions_computer_user_with_http_info(self, smb_sessions_computer_user, computer, **kwargs):  # noqa: E501
        """delete_smb_sessions_computer_user  # noqa: E501

        Close the SMB session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_sessions_computer_user_with_http_info(smb_sessions_computer_user, computer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_sessions_computer_user: Close the SMB session. (required)
        :param str computer: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_sessions_computer_user', 'computer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_sessions_computer_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_sessions_computer_user' is set
        if ('smb_sessions_computer_user' not in params or
                params['smb_sessions_computer_user'] is None):
            raise ValueError("Missing the required parameter `smb_sessions_computer_user` when calling `delete_smb_sessions_computer_user`")  # noqa: E501
        # verify the required parameter 'computer' is set
        if ('computer' not in params or
                params['computer'] is None):
            raise ValueError("Missing the required parameter `computer` when calling `delete_smb_sessions_computer_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_sessions_computer_user' in params:
            path_params['SmbSessionsComputerUser'] = params['smb_sessions_computer_user']  # noqa: E501
        if 'computer' in params:
            path_params['Computer'] = params['computer']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/sessions/{Computer}/{SmbSessionsComputerUser}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_share(self, smb_share_id, **kwargs):  # noqa: E501
        """delete_smb_share  # noqa: E501

        Delete the share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_share(smb_share_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_share_id: Delete the share. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
            return data

    def delete_smb_share_with_http_info(self, smb_share_id, **kwargs):  # noqa: E501
        """delete_smb_share  # noqa: E501

        Delete the share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_share_with_http_info(smb_share_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_share_id: Delete the share. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share_id' is set
        if ('smb_share_id' not in params or
                params['smb_share_id'] is None):
            raise ValueError("Missing the required parameter `smb_share_id` when calling `delete_smb_share`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `delete_smb_share`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `delete_smb_share`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'smb_share_id' in params:
            path_params['SmbShareId'] = params['smb_share_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/shares/{SmbShareId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_smb_shares(self, **kwargs):  # noqa: E501
        """delete_smb_shares  # noqa: E501

        Delete multiple smb shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_shares(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_smb_shares_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_smb_shares_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_smb_shares_with_http_info(self, **kwargs):  # noqa: E501
        """delete_smb_shares  # noqa: E501

        Delete multiple smb shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_smb_shares_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_smb_shares" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/shares', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_swift_account(self, swift_account_id, **kwargs):  # noqa: E501
        """delete_swift_account  # noqa: E501

        Delete a Swift account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_swift_account(swift_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str swift_account_id: Delete a Swift account. (required)
        :param str zone: Access zone which contains Swift account.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_swift_account_with_http_info(swift_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_swift_account_with_http_info(swift_account_id, **kwargs)  # noqa: E501
            return data

    def delete_swift_account_with_http_info(self, swift_account_id, **kwargs):  # noqa: E501
        """delete_swift_account  # noqa: E501

        Delete a Swift account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_swift_account_with_http_info(swift_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str swift_account_id: Delete a Swift account. (required)
        :param str zone: Access zone which contains Swift account.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['swift_account_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_swift_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'swift_account_id' is set
        if ('swift_account_id' not in params or
                params['swift_account_id'] is None):
            raise ValueError("Missing the required parameter `swift_account_id` when calling `delete_swift_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'swift_account_id' in params:
            path_params['SwiftAccountId'] = params['swift_account_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/swift/accounts/{SwiftAccountId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ftp_settings(self, **kwargs):  # noqa: E501
        """get_ftp_settings  # noqa: E501

        Retrieve the FTP settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ftp_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FtpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ftp_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ftp_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ftp_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_ftp_settings  # noqa: E501

        Retrieve the FTP settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ftp_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FtpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ftp_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ftp/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FtpSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_crypto_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_crypto_settings  # noqa: E501

        Retrieve HDFS crypto settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_crypto_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Specifies which access zone to use.
        :return: HdfsCryptoSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_crypto_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_crypto_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_crypto_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_crypto_settings  # noqa: E501

        Retrieve HDFS crypto settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_crypto_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Specifies which access zone to use.
        :return: HdfsCryptoSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_crypto_settings" % key
                )
            params[key] = val
        del params['kwargs']

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_hdfs_crypto_settings`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_hdfs_crypto_settings`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/hdfs/crypto/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsCryptoSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_fsimage_job(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_job  # noqa: E501

        Retrieve current HDFS FSImage job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_job(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains job information.
        :return: HdfsFsimageJob
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_fsimage_job_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_fsimage_job_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_fsimage_job_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_job  # noqa: E501

        Retrieve current HDFS FSImage job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_job_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains job information.
        :return: HdfsFsimageJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_fsimage_job" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/job', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsFsimageJob',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_fsimage_job_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_job_settings  # noqa: E501

        Retrieve HDFS FSImage job properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_job_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains job settings.
        :return: HdfsFsimageJobSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_fsimage_job_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_fsimage_job_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_fsimage_job_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_job_settings  # noqa: E501

        Retrieve HDFS FSImage job properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_job_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains job settings.
        :return: HdfsFsimageJobSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_fsimage_job_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/job/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsFsimageJobSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_fsimage_latest(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_latest  # noqa: E501

        Retrieve the latest HDFS FSImage information, if there is one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_latest(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS FSImage.
        :return: HdfsFsimageLatest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_fsimage_latest_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_fsimage_latest_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_fsimage_latest_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_latest  # noqa: E501

        Retrieve the latest HDFS FSImage information, if there is one.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_latest_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS FSImage.
        :return: HdfsFsimageLatest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_fsimage_latest" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsFsimageLatest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_fsimage_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_settings  # noqa: E501

        Retrieve HDFS FSImage properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains FSImage settings.
        :return: HdfsFsimageSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_fsimage_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_fsimage_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_fsimage_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_fsimage_settings  # noqa: E501

        Retrieve HDFS FSImage properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_fsimage_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains FSImage settings.
        :return: HdfsFsimageSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_fsimage_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsFsimageSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_inotify_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_inotify_settings  # noqa: E501

        Retrieve HDFS INotify properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_inotify_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains INotify settings.
        :return: HdfsInotifySettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_inotify_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_inotify_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_inotify_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_inotify_settings  # noqa: E501

        Retrieve HDFS INotify properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_inotify_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains INotify settings.
        :return: HdfsInotifySettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_inotify_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/inotify/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsInotifySettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_inotify_stream(self, **kwargs):  # noqa: E501
        """get_hdfs_inotify_stream  # noqa: E501

        Retrieve information about the collection and availability of HDFS INotify edit events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_inotify_stream(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which exposes HDFS INotify.
        :return: HdfsInotifyStream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_inotify_stream_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_inotify_stream_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_inotify_stream_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_inotify_stream  # noqa: E501

        Retrieve information about the collection and availability of HDFS INotify edit events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_inotify_stream_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which exposes HDFS INotify.
        :return: HdfsInotifyStream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_inotify_stream" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/inotify/stream', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsInotifyStream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_log_level(self, **kwargs):  # noqa: E501
        """get_hdfs_log_level  # noqa: E501

        Retrieve the HDFS service log-level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_log_level(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HdfsLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_log_level_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_log_level_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_log_level_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_log_level  # noqa: E501

        Retrieve the HDFS service log-level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_log_level_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HdfsLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_log_level" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/hdfs/log-level', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsLogLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_proxyuser(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """get_hdfs_proxyuser  # noqa: E501

        View the proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_proxyuser(hdfs_proxyuser_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_proxyuser_id: View the proxyuser. (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, **kwargs)  # noqa: E501
            return data

    def get_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """get_hdfs_proxyuser  # noqa: E501

        View the proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_proxyuser_with_http_info(hdfs_proxyuser_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_proxyuser_id: View the proxyuser. (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser_id' is set
        if ('hdfs_proxyuser_id' not in params or
                params['hdfs_proxyuser_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser_id` when calling `get_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_proxyuser_id' in params:
            path_params['HdfsProxyuserId'] = params['hdfs_proxyuser_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsProxyusers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_rack(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """get_hdfs_rack  # noqa: E501

        Retrieve the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_rack(hdfs_rack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_rack_id: Retrieve the HDFS rack. (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: HdfsRacks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_rack_with_http_info(hdfs_rack_id, **kwargs)  # noqa: E501
            return data

    def get_hdfs_rack_with_http_info(self, hdfs_rack_id, **kwargs):  # noqa: E501
        """get_hdfs_rack  # noqa: E501

        Retrieve the HDFS rack.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_rack_with_http_info(hdfs_rack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str hdfs_rack_id: Retrieve the HDFS rack. (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: HdfsRacks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack_id' is set
        if ('hdfs_rack_id' not in params or
                params['hdfs_rack_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack_id` when calling `get_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_rack_id' in params:
            path_params['HdfsRackId'] = params['hdfs_rack_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks/{HdfsRackId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsRacks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_ranger_plugin_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_ranger_plugin_settings  # noqa: E501

        Retrieve HDFS ranger-plugin properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_ranger_plugin_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS ranger-plugin settings.
        :return: HdfsRangerPluginSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_ranger_plugin_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_ranger_plugin_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_ranger_plugin_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_ranger_plugin_settings  # noqa: E501

        Retrieve HDFS ranger-plugin properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_ranger_plugin_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS ranger-plugin settings.
        :return: HdfsRangerPluginSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_ranger_plugin_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/hdfs/ranger-plugin/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsRangerPluginSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_settings(self, **kwargs):  # noqa: E501
        """get_hdfs_settings  # noqa: E501

        Retrieve HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS settings.
        :return: HdfsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_settings  # noqa: E501

        Retrieve HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains HDFS settings.
        :return: HdfsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/protocols/hdfs/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hdfs_settings_global(self, **kwargs):  # noqa: E501
        """get_hdfs_settings_global  # noqa: E501

        Retrieve HDFS global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HdfsSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hdfs_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hdfs_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hdfs_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_hdfs_settings_global  # noqa: E501

        Retrieve HDFS global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hdfs_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HdfsSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/protocols/hdfs/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsSettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_http_settings(self, **kwargs):  # noqa: E501
        """get_http_settings  # noqa: E501

        Retrieve HTTP properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_http_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HttpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_http_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_http_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_http_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_http_settings  # noqa: E501

        Retrieve HTTP properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_http_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HttpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_http_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/http/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HttpSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_contexts_backup(self, **kwargs):  # noqa: E501
        """get_ndmp_contexts_backup  # noqa: E501

        Get List of NDMP Backup Contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_backup(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpContextsBackupExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_contexts_backup_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_contexts_backup_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_contexts_backup_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_contexts_backup  # noqa: E501

        Get List of NDMP Backup Contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_backup_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpContextsBackupExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_contexts_backup" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_contexts_backup`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_contexts_backup`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_contexts_backup`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_contexts_backup`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/backup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpContextsBackupExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_contexts_backup_by_id(self, ndmp_contexts_backup_id, **kwargs):  # noqa: E501
        """get_ndmp_contexts_backup_by_id  # noqa: E501

        View a NDMP backup context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_backup_by_id(ndmp_contexts_backup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_backup_id: View a NDMP backup context (required)
        :return: NdmpContextsBackup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_contexts_backup_by_id_with_http_info(ndmp_contexts_backup_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_contexts_backup_by_id_with_http_info(ndmp_contexts_backup_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_contexts_backup_by_id_with_http_info(self, ndmp_contexts_backup_id, **kwargs):  # noqa: E501
        """get_ndmp_contexts_backup_by_id  # noqa: E501

        View a NDMP backup context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_backup_by_id_with_http_info(ndmp_contexts_backup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_backup_id: View a NDMP backup context (required)
        :return: NdmpContextsBackup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_contexts_backup_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_contexts_backup_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_contexts_backup_id' is set
        if ('ndmp_contexts_backup_id' not in params or
                params['ndmp_contexts_backup_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_contexts_backup_id` when calling `get_ndmp_contexts_backup_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_contexts_backup_id' in params:
            path_params['NdmpContextsBackupId'] = params['ndmp_contexts_backup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/backup/{NdmpContextsBackupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpContextsBackup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_contexts_bre(self, **kwargs):  # noqa: E501
        """get_ndmp_contexts_bre  # noqa: E501

        Get list of NDMP BRE Contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_bre(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpContextsBreExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_contexts_bre_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_contexts_bre_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_contexts_bre_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_contexts_bre  # noqa: E501

        Get list of NDMP BRE Contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_bre_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpContextsBreExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_contexts_bre" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_contexts_bre`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_contexts_bre`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_contexts_bre`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_contexts_bre`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/bre', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpContextsBreExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_contexts_bre_by_id(self, ndmp_contexts_bre_id, **kwargs):  # noqa: E501
        """get_ndmp_contexts_bre_by_id  # noqa: E501

        View a NDMP BRE context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_bre_by_id(ndmp_contexts_bre_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_bre_id: View a NDMP BRE context (required)
        :return: NdmpContextsBre
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_contexts_bre_by_id_with_http_info(ndmp_contexts_bre_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_contexts_bre_by_id_with_http_info(ndmp_contexts_bre_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_contexts_bre_by_id_with_http_info(self, ndmp_contexts_bre_id, **kwargs):  # noqa: E501
        """get_ndmp_contexts_bre_by_id  # noqa: E501

        View a NDMP BRE context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_bre_by_id_with_http_info(ndmp_contexts_bre_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_bre_id: View a NDMP BRE context (required)
        :return: NdmpContextsBre
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_contexts_bre_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_contexts_bre_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_contexts_bre_id' is set
        if ('ndmp_contexts_bre_id' not in params or
                params['ndmp_contexts_bre_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_contexts_bre_id` when calling `get_ndmp_contexts_bre_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_contexts_bre_id' in params:
            path_params['NdmpContextsBreId'] = params['ndmp_contexts_bre_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/bre/{NdmpContextsBreId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpContextsBre',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_contexts_restore(self, **kwargs):  # noqa: E501
        """get_ndmp_contexts_restore  # noqa: E501

        Get List of NDMP Restore Contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_restore(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpContextsBackupExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_contexts_restore_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_contexts_restore_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_contexts_restore_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_contexts_restore  # noqa: E501

        Get List of NDMP Restore Contexts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_restore_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpContextsBackupExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_contexts_restore" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_contexts_restore`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_contexts_restore`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_contexts_restore`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_contexts_restore`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/restore', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpContextsBackupExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_contexts_restore_by_id(self, ndmp_contexts_restore_id, **kwargs):  # noqa: E501
        """get_ndmp_contexts_restore_by_id  # noqa: E501

        View a NDMP restore context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_restore_by_id(ndmp_contexts_restore_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_restore_id: View a NDMP restore context (required)
        :return: NdmpContextsBackup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_contexts_restore_by_id_with_http_info(ndmp_contexts_restore_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_contexts_restore_by_id_with_http_info(ndmp_contexts_restore_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_contexts_restore_by_id_with_http_info(self, ndmp_contexts_restore_id, **kwargs):  # noqa: E501
        """get_ndmp_contexts_restore_by_id  # noqa: E501

        View a NDMP restore context  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_contexts_restore_by_id_with_http_info(ndmp_contexts_restore_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_contexts_restore_id: View a NDMP restore context (required)
        :return: NdmpContextsBackup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_contexts_restore_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_contexts_restore_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_contexts_restore_id' is set
        if ('ndmp_contexts_restore_id' not in params or
                params['ndmp_contexts_restore_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_contexts_restore_id` when calling `get_ndmp_contexts_restore_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_contexts_restore_id' in params:
            path_params['NdmpContextsRestoreId'] = params['ndmp_contexts_restore_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/contexts/restore/{NdmpContextsRestoreId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpContextsBackup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_diagnostics(self, **kwargs):  # noqa: E501
        """get_ndmp_diagnostics  # noqa: E501

        List ndmp diagnostics settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_diagnostics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpDiagnostics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_diagnostics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_diagnostics_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_diagnostics_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_diagnostics  # noqa: E501

        List ndmp diagnostics settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_diagnostics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpDiagnostics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/diagnostics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpDiagnostics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_dumpdate(self, ndmp_dumpdate_id, **kwargs):  # noqa: E501
        """get_ndmp_dumpdate  # noqa: E501

        List of dumpdates entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_dumpdate(ndmp_dumpdate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_dumpdate_id: List of dumpdates entries. (required)
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int level: Filter by dumpdate level.
        :param int limit: Return no more than this many results at once (see resume).
        :param str path: Filter by file path.
        :param str dir: The direction of the sort.
        :return: NdmpDumpdates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_dumpdate_with_http_info(ndmp_dumpdate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_dumpdate_with_http_info(ndmp_dumpdate_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_dumpdate_with_http_info(self, ndmp_dumpdate_id, **kwargs):  # noqa: E501
        """get_ndmp_dumpdate  # noqa: E501

        List of dumpdates entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_dumpdate_with_http_info(ndmp_dumpdate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_dumpdate_id: List of dumpdates entries. (required)
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int level: Filter by dumpdate level.
        :param int limit: Return no more than this many results at once (see resume).
        :param str path: Filter by file path.
        :param str dir: The direction of the sort.
        :return: NdmpDumpdates
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_dumpdate_id', 'sort', 'resume', 'level', 'limit', 'path', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_dumpdate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_dumpdate_id' is set
        if ('ndmp_dumpdate_id' not in params or
                params['ndmp_dumpdate_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_dumpdate_id` when calling `get_ndmp_dumpdate`")  # noqa: E501

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_ndmp_dumpdate`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_ndmp_dumpdate`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_dumpdate`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_dumpdate`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_dumpdate`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_dumpdate`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_ndmp_dumpdate`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ndmp_dumpdate_id' in params:
            path_params['NdmpDumpdateId'] = params['ndmp_dumpdate_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/dumpdates/{NdmpDumpdateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpDumpdates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_logs(self, **kwargs):  # noqa: E501
        """get_ndmp_logs  # noqa: E501

        Get NDMP logs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lnn: Logical node number.
        :param int page: The page number of the NDMP logs file.
        :param int pagesize: The page size of each page of the NDMP log file.
        :return: NdmpLogs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_logs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_logs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_logs_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_logs  # noqa: E501

        Get NDMP logs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str lnn: Logical node number.
        :param int page: The page number of the NDMP logs file.
        :param int pagesize: The page size of each page of the NDMP log file.
        :return: NdmpLogs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'page', 'pagesize']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_logs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lnn' in params:
            query_params.append(('lnn', params['lnn']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'pagesize' in params:
            query_params.append(('pagesize', params['pagesize']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpLogs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_session(self, ndmp_session_id, **kwargs):  # noqa: E501
        """get_ndmp_session  # noqa: E501

        Retrieve the ndmp session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_session(ndmp_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_session_id: Retrieve the ndmp session. (required)
        :param str lnn: Logical node number.
        :return: NdmpSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_session_with_http_info(ndmp_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_session_with_http_info(ndmp_session_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_session_with_http_info(self, ndmp_session_id, **kwargs):  # noqa: E501
        """get_ndmp_session  # noqa: E501

        Retrieve the ndmp session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_session_with_http_info(ndmp_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_session_id: Retrieve the ndmp session. (required)
        :param str lnn: Logical node number.
        :return: NdmpSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_session_id', 'lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_session_id' is set
        if ('ndmp_session_id' not in params or
                params['ndmp_session_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_session_id` when calling `get_ndmp_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_session_id' in params:
            path_params['NdmpSessionId'] = params['ndmp_session_id']  # noqa: E501

        query_params = []
        if 'lnn' in params:
            query_params.append(('lnn', params['lnn']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/sessions/{NdmpSessionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSessions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_sessions(self, **kwargs):  # noqa: E501
        """get_ndmp_sessions  # noqa: E501

        List all ndmp sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_sessions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool consolidate: Combine sessions in the same context.
        :param str node: Only return sessions of the node.
        :param str session: Only return the specified session.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpSessionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_sessions  # noqa: E501

        List all ndmp sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_sessions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool consolidate: Combine sessions in the same context.
        :param str node: Only return sessions of the node.
        :param str session: Only return the specified session.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpSessionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consolidate', 'node', 'session', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_sessions`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_sessions`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_sessions`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_sessions`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'consolidate' in params:
            query_params.append(('consolidate', params['consolidate']))  # noqa: E501
        if 'node' in params:
            query_params.append(('node', params['node']))  # noqa: E501
        if 'session' in params:
            query_params.append(('session', params['session']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSessionsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_settings_dmas(self, **kwargs):  # noqa: E501
        """get_ndmp_settings_dmas  # noqa: E501

        List of supported dma vendors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_dmas(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpSettingsDmas
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_settings_dmas_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_settings_dmas_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_settings_dmas_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_settings_dmas  # noqa: E501

        List of supported dma vendors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_dmas_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpSettingsDmas
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_settings_dmas" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/dmas', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSettingsDmas',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_settings_global(self, **kwargs):  # noqa: E501
        """get_ndmp_settings_global  # noqa: E501

        List global ndmp settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ndmp_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_ndmp_settings_global  # noqa: E501

        List global ndmp settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_settings_preferred_ip(self, ndmp_settings_preferred_ip_id, **kwargs):  # noqa: E501
        """get_ndmp_settings_preferred_ip  # noqa: E501

        Get one preference by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_preferred_ip(ndmp_settings_preferred_ip_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_preferred_ip_id: Get one preference by id. (required)
        :return: NdmpSettingsPreferredIps
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_settings_preferred_ip_with_http_info(self, ndmp_settings_preferred_ip_id, **kwargs):  # noqa: E501
        """get_ndmp_settings_preferred_ip  # noqa: E501

        Get one preference by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_preferred_ip_id: Get one preference by id. (required)
        :return: NdmpSettingsPreferredIps
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_preferred_ip_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_settings_preferred_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_preferred_ip_id' is set
        if ('ndmp_settings_preferred_ip_id' not in params or
                params['ndmp_settings_preferred_ip_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_preferred_ip_id` when calling `get_ndmp_settings_preferred_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_preferred_ip_id' in params:
            path_params['NdmpSettingsPreferredIpId'] = params['ndmp_settings_preferred_ip_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/ndmp/settings/preferred-ips/{NdmpSettingsPreferredIpId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSettingsPreferredIps',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_settings_variable(self, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """get_ndmp_settings_variable  # noqa: E501

        List of preferred environment variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_variable(ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_variable_id: List of preferred environment variables. (required)
        :param str path: Return variables of the path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpSettingsVariables
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_settings_variable_with_http_info(ndmp_settings_variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_settings_variable_with_http_info(ndmp_settings_variable_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_settings_variable_with_http_info(self, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """get_ndmp_settings_variable  # noqa: E501

        List of preferred environment variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_settings_variable_with_http_info(ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_settings_variable_id: List of preferred environment variables. (required)
        :param str path: Return variables of the path.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpSettingsVariables
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_variable_id', 'path', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_settings_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_variable_id' is set
        if ('ndmp_settings_variable_id' not in params or
                params['ndmp_settings_variable_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_variable_id` when calling `get_ndmp_settings_variable`")  # noqa: E501

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_settings_variable`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_ndmp_settings_variable`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_settings_variable`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_ndmp_settings_variable`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_variable_id' in params:
            path_params['NdmpSettingsVariableId'] = params['ndmp_settings_variable_id']  # noqa: E501

        query_params = []
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSettingsVariables',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ndmp_user(self, ndmp_user_id, **kwargs):  # noqa: E501
        """get_ndmp_user  # noqa: E501

        Retrieve the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_user(ndmp_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_user_id: Retrieve the user. (required)
        :return: NdmpUsers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ndmp_user_with_http_info(ndmp_user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ndmp_user_with_http_info(ndmp_user_id, **kwargs)  # noqa: E501
            return data

    def get_ndmp_user_with_http_info(self, ndmp_user_id, **kwargs):  # noqa: E501
        """get_ndmp_user  # noqa: E501

        Retrieve the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ndmp_user_with_http_info(ndmp_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ndmp_user_id: Retrieve the user. (required)
        :return: NdmpUsers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ndmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_user_id' is set
        if ('ndmp_user_id' not in params or
                params['ndmp_user_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_user_id` when calling `get_ndmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_user_id' in params:
            path_params['NdmpUserId'] = params['ndmp_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/users/{NdmpUserId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpUsers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_alias(self, nfs_alias_id, **kwargs):  # noqa: E501
        """get_nfs_alias  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_alias(nfs_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_alias_id: Retrieve export information. (required)
        :param str scope: When specified as 'effective', or not specified, all fields are returned. When specified as 'user', only fields with non-default values are shown. When specified as 'default', the original values are returned.
        :param bool check: Check for conflicts when viewing alias.
        :param str zone: Access zone
        :return: NfsAliases
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_alias_with_http_info(nfs_alias_id, **kwargs)  # noqa: E501
            return data

    def get_nfs_alias_with_http_info(self, nfs_alias_id, **kwargs):  # noqa: E501
        """get_nfs_alias  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_alias_with_http_info(nfs_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_alias_id: Retrieve export information. (required)
        :param str scope: When specified as 'effective', or not specified, all fields are returned. When specified as 'user', only fields with non-default values are shown. When specified as 'default', the original values are returned.
        :param bool check: Check for conflicts when viewing alias.
        :param str zone: Access zone
        :return: NfsAliases
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias_id', 'scope', 'check', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias_id' is set
        if ('nfs_alias_id' not in params or
                params['nfs_alias_id'] is None):
            raise ValueError("Missing the required parameter `nfs_alias_id` when calling `get_nfs_alias`")  # noqa: E501

        if 'nfs_alias_id' in params:
            # tag this parameter so that it can be url encoded with quote_plus
            # by the api_client code because it contains a '/' character that
            # needs to be url encoded.
            params['nfs_alias_id'] = "__x-isi-url-encode-path-param__{0}".format(params['nfs_alias_id'])
        collection_formats = {}

        path_params = {}
        if 'nfs_alias_id' in params:
            path_params['NfsAliasId'] = params['nfs_alias_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'check' in params:
            query_params.append(('check', params['check']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases/{NfsAliasId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsAliases',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_check(self, **kwargs):  # noqa: E501
        """get_nfs_check  # noqa: E501

        Retrieve NFS export validation information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_check(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ignore_bad_paths: Ignore nonexistent or otherwise bad paths.
        :param bool ignore_bad_auth: Ignore invalid users.
        :param str zone: Access zone
        :param bool ignore_unresolvable_hosts: Ignore unresolvable hosts.
        :return: NfsCheckExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_check_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_check_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_check_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_check  # noqa: E501

        Retrieve NFS export validation information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_check_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ignore_bad_paths: Ignore nonexistent or otherwise bad paths.
        :param bool ignore_bad_auth: Ignore invalid users.
        :param str zone: Access zone
        :param bool ignore_unresolvable_hosts: Ignore unresolvable hosts.
        :return: NfsCheckExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ignore_bad_paths', 'ignore_bad_auth', 'zone', 'ignore_unresolvable_hosts']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_check" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ignore_bad_paths' in params:
            query_params.append(('ignore_bad_paths', params['ignore_bad_paths']))  # noqa: E501
        if 'ignore_bad_auth' in params:
            query_params.append(('ignore_bad_auth', params['ignore_bad_auth']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'ignore_unresolvable_hosts' in params:
            query_params.append(('ignore_unresolvable_hosts', params['ignore_unresolvable_hosts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/check', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsCheckExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_export(self, nfs_export_id, **kwargs):  # noqa: E501
        """get_nfs_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_export(nfs_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_export_id: Retrieve export information. (required)
        :param str scope: When specified as 'effective', or not specified, all fields are returned. When specified as 'user', only fields with non-default values are shown. When specified as 'default', the original values are returned.
        :param str zone: Access zone
        :return: NfsExports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_export_with_http_info(nfs_export_id, **kwargs)  # noqa: E501
            return data

    def get_nfs_export_with_http_info(self, nfs_export_id, **kwargs):  # noqa: E501
        """get_nfs_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_export_with_http_info(nfs_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_export_id: Retrieve export information. (required)
        :param str scope: When specified as 'effective', or not specified, all fields are returned. When specified as 'user', only fields with non-default values are shown. When specified as 'default', the original values are returned.
        :param str zone: Access zone
        :return: NfsExports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export_id', 'scope', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export_id' is set
        if ('nfs_export_id' not in params or
                params['nfs_export_id'] is None):
            raise ValueError("Missing the required parameter `nfs_export_id` when calling `get_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_export_id' in params:
            path_params['NfsExportId'] = params['nfs_export_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/nfs/exports/{NfsExportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsExports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_exports_summary(self, **kwargs):  # noqa: E501
        """get_nfs_exports_summary  # noqa: E501

        Retrieve NFS export summary information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_exports_summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone
        :return: NfsExportsSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_exports_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_exports_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_exports_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_exports_summary  # noqa: E501

        Retrieve NFS export summary information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_exports_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone
        :return: NfsExportsSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_exports_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/exports-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsExportsSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_log_level(self, **kwargs):  # noqa: E501
        """get_nfs_log_level  # noqa: E501

        Get the current NFS service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_log_level(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NfsLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_log_level_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_log_level_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_log_level_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_log_level  # noqa: E501

        Get the current NFS service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_log_level_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NfsLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_log_level" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/log-level', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsLogLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_netgroup(self, **kwargs):  # noqa: E501
        """get_nfs_netgroup  # noqa: E501

        Get the current NFS netgroup cache settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_netgroup(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str host: Host to retrieve netgroup cache settings from.
        :return: NfsNetgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_netgroup_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_netgroup_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_netgroup_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_netgroup  # noqa: E501

        Get the current NFS netgroup cache settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_netgroup_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str host: Host to retrieve netgroup cache settings from.
        :return: NfsNetgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_netgroup" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'host' in params:
            query_params.append(('host', params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/netgroup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNetgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_locks(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_locks  # noqa: E501

        List all NLM locks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_locks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str created: Return locks created after the specified unix epoch time.
        :param str lin: Filter locks by the specified LIN in /ifs that is locked.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str client: Filter locks by the specified client host name and IP address.
        :param int limit: Return no more than this many results at once (see resume).
        :param str client_id: Filter locks by the specified client ID.
        :param str path: Filter locks by the specified path under /ifs.
        :param str dir: The direction of the sort.
        :return: NfsNlmLocks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_nlm_locks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_locks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_locks_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_locks  # noqa: E501

        List all NLM locks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_locks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str created: Return locks created after the specified unix epoch time.
        :param str lin: Filter locks by the specified LIN in /ifs that is locked.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str client: Filter locks by the specified client host name and IP address.
        :param int limit: Return no more than this many results at once (see resume).
        :param str client_id: Filter locks by the specified client ID.
        :param str path: Filter locks by the specified path under /ifs.
        :param str dir: The direction of the sort.
        :return: NfsNlmLocks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'created', 'lin', 'resume', 'client', 'limit', 'client_id', 'path', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_locks" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_nfs_nlm_locks`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_nfs_nlm_locks`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_nfs_nlm_locks`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_nfs_nlm_locks`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_locks`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_locks`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_nfs_nlm_locks`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'created' in params:
            query_params.append(('created', params['created']))  # noqa: E501
        if 'lin' in params:
            query_params.append(('lin', params['lin']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'client' in params:
            query_params.append(('client', params['client']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'client_id' in params:
            query_params.append(('client_id', params['client_id']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/nlm/locks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmLocks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_session(self, nfs_nlm_session_id, **kwargs):  # noqa: E501
        """get_nfs_nlm_session  # noqa: E501

        Retrieve all lock state for a single client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_session(nfs_nlm_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_nlm_session_id: Retrieve all lock state for a single client. (required)
        :param str cluster_ip: An IP address for which NSM has client records
        :param str zone: Represents an extant auth zone
        :return: NfsNlmSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_nlm_session_with_http_info(nfs_nlm_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_session_with_http_info(nfs_nlm_session_id, **kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_session_with_http_info(self, nfs_nlm_session_id, **kwargs):  # noqa: E501
        """get_nfs_nlm_session  # noqa: E501

        Retrieve all lock state for a single client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_session_with_http_info(nfs_nlm_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nfs_nlm_session_id: Retrieve all lock state for a single client. (required)
        :param str cluster_ip: An IP address for which NSM has client records
        :param str zone: Represents an extant auth zone
        :return: NfsNlmSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_nlm_session_id', 'cluster_ip', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_nlm_session_id' is set
        if ('nfs_nlm_session_id' not in params or
                params['nfs_nlm_session_id'] is None):
            raise ValueError("Missing the required parameter `nfs_nlm_session_id` when calling `get_nfs_nlm_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_nlm_session_id' in params:
            path_params['NfsNlmSessionId'] = params['nfs_nlm_session_id']  # noqa: E501

        query_params = []
        if 'cluster_ip' in params:
            query_params.append(('cluster_ip', params['cluster_ip']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/nlm/sessions/{NfsNlmSessionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmSessions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_sessions(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_sessions  # noqa: E501

        List all NSM clients (optionally filtered by either zone or IP)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_sessions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str ip: An IP address for which NSM has client records
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Represents an extant auth zone
        :param str dir: The direction of the sort.
        :return: NfsNlmSessionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_nlm_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_sessions  # noqa: E501

        List all NSM clients (optionally filtered by either zone or IP)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_sessions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str ip: An IP address for which NSM has client records
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Represents an extant auth zone
        :param str dir: The direction of the sort.
        :return: NfsNlmSessionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'ip', 'limit', 'zone', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_nfs_nlm_sessions`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_nfs_nlm_sessions`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_sessions`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_sessions`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_nfs_nlm_sessions`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'ip' in params:
            query_params.append(('ip', params['ip']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/nlm/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmSessionsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_nlm_waiters(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_waiters  # noqa: E501

        List all NLM lock waiters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_waiters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmWaiters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_nlm_waiters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_nlm_waiters_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_nlm_waiters_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_nlm_waiters  # noqa: E501

        List all NLM lock waiters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_nlm_waiters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NfsNlmWaiters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_nlm_waiters" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_nfs_nlm_waiters`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_nfs_nlm_waiters`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_waiters`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_nfs_nlm_waiters`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_nfs_nlm_waiters`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_nfs_nlm_waiters`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_nfs_nlm_waiters`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/nlm/waiters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsNlmWaiters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_settings_export(self, **kwargs):  # noqa: E501
        """get_nfs_settings_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_settings_export(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Access zone
        :return: NfsSettingsExport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_settings_export_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_settings_export_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_settings_export_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_settings_export  # noqa: E501

        Retrieve export information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_settings_export_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Access zone
        :return: NfsSettingsExport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_settings_export" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_nfs_settings_export`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_nfs_settings_export`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsSettingsExport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_settings_global(self, **kwargs):  # noqa: E501
        """get_nfs_settings_global  # noqa: E501

        Retrieve the NFS configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NfsSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_settings_global  # noqa: E501

        Retrieve the NFS configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NfsSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/nfs/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsSettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nfs_settings_zone(self, **kwargs):  # noqa: E501
        """get_nfs_settings_zone  # noqa: E501

        Retrieve the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_settings_zone(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone
        :return: NfsSettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nfs_settings_zone_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_nfs_settings_zone_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_nfs_settings_zone_with_http_info(self, **kwargs):  # noqa: E501
        """get_nfs_settings_zone  # noqa: E501

        Retrieve the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_nfs_settings_zone_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone
        :return: NfsSettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nfs_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/zone', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsSettingsZone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ntp_server(self, ntp_server_id, **kwargs):  # noqa: E501
        """get_ntp_server  # noqa: E501

        Retrieve one NTP server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ntp_server(ntp_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ntp_server_id: Retrieve one NTP server. (required)
        :return: NtpServers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ntp_server_with_http_info(ntp_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ntp_server_with_http_info(ntp_server_id, **kwargs)  # noqa: E501
            return data

    def get_ntp_server_with_http_info(self, ntp_server_id, **kwargs):  # noqa: E501
        """get_ntp_server  # noqa: E501

        Retrieve one NTP server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ntp_server_with_http_info(ntp_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ntp_server_id: Retrieve one NTP server. (required)
        :return: NtpServers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ntp_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ntp_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ntp_server_id' is set
        if ('ntp_server_id' not in params or
                params['ntp_server_id'] is None):
            raise ValueError("Missing the required parameter `ntp_server_id` when calling `get_ntp_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ntp_server_id' in params:
            path_params['NtpServerId'] = params['ntp_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/servers/{NtpServerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NtpServers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ntp_settings(self, **kwargs):  # noqa: E501
        """get_ntp_settings  # noqa: E501

        Retrieve the NTP settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ntp_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NtpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ntp_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ntp_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ntp_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_ntp_settings  # noqa: E501

        Retrieve the NTP settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ntp_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NtpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ntp_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NtpSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_bucket(self, s3_bucket_id, **kwargs):  # noqa: E501
        """get_s3_bucket  # noqa: E501

        Retrieve bucket.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket(s3_bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_bucket_id: Retrieve bucket. (required)
        :param str zone: Specifies which access zone to use.
        :return: S3Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_bucket_with_http_info(s3_bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_bucket_with_http_info(s3_bucket_id, **kwargs)  # noqa: E501
            return data

    def get_s3_bucket_with_http_info(self, s3_bucket_id, **kwargs):  # noqa: E501
        """get_s3_bucket  # noqa: E501

        Retrieve bucket.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_with_http_info(s3_bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_bucket_id: Retrieve bucket. (required)
        :param str zone: Specifies which access zone to use.
        :return: S3Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_bucket_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_bucket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_bucket_id' is set
        if ('s3_bucket_id' not in params or
                params['s3_bucket_id'] is None):
            raise ValueError("Missing the required parameter `s3_bucket_id` when calling `get_s3_bucket`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_s3_bucket`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_s3_bucket`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 's3_bucket_id' in params:
            path_params['S3BucketId'] = params['s3_bucket_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/buckets/{S3BucketId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='S3Buckets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_key(self, s3_key_id, **kwargs):  # noqa: E501
        """get_s3_key  # noqa: E501

        Get access ID information for given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_key(s3_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_key_id: Get access ID information for given user. (required)
        :param str zone: Specifies access zone containing user.
        :return: S3Keys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_key_with_http_info(s3_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_key_with_http_info(s3_key_id, **kwargs)  # noqa: E501
            return data

    def get_s3_key_with_http_info(self, s3_key_id, **kwargs):  # noqa: E501
        """get_s3_key  # noqa: E501

        Get access ID information for given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_key_with_http_info(s3_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str s3_key_id: Get access ID information for given user. (required)
        :param str zone: Specifies access zone containing user.
        :return: S3Keys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_key_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_key_id' is set
        if ('s3_key_id' not in params or
                params['s3_key_id'] is None):
            raise ValueError("Missing the required parameter `s3_key_id` when calling `get_s3_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 's3_key_id' in params:
            path_params['S3KeyId'] = params['s3_key_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/keys/{S3KeyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='S3Keys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_log_level(self, **kwargs):  # noqa: E501
        """get_s3_log_level  # noqa: E501

        Get the current S3 service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_log_level(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: S3LogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_log_level_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_log_level_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_s3_log_level_with_http_info(self, **kwargs):  # noqa: E501
        """get_s3_log_level  # noqa: E501

        Get the current S3 service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_log_level_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: S3LogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_log_level" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/log-level', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='S3LogLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_settings_global(self, **kwargs):  # noqa: E501
        """get_s3_settings_global  # noqa: E501

        Retrieve global S3 bucket settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: S3SettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_s3_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_s3_settings_global  # noqa: E501

        Retrieve global S3 bucket settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: S3SettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='S3SettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_settings_zone(self, **kwargs):  # noqa: E501
        """get_s3_settings_zone  # noqa: E501

        Retrieve the S3 bucket settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_settings_zone(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone
        :return: S3SettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_settings_zone_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_settings_zone_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_s3_settings_zone_with_http_info(self, **kwargs):  # noqa: E501
        """get_s3_settings_zone  # noqa: E501

        Retrieve the S3 bucket settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_settings_zone_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone
        :return: S3SettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/settings/zone', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='S3SettingsZone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_log_level(self, **kwargs):  # noqa: E501
        """get_smb_log_level  # noqa: E501

        Get the current SMB logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_log_level(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SmbLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_log_level_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_log_level_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_log_level_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_log_level  # noqa: E501

        Get the current SMB logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_log_level_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SmbLogLevel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_log_level" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbLogLevel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_log_level_filter(self, smb_log_level_filter_id, **kwargs):  # noqa: E501
        """get_smb_log_level_filter  # noqa: E501

        View log filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_log_level_filter(smb_log_level_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_log_level_filter_id: View log filter. (required)
        :return: SmbLogLevelFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_log_level_filter_with_http_info(smb_log_level_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_log_level_filter_with_http_info(smb_log_level_filter_id, **kwargs)  # noqa: E501
            return data

    def get_smb_log_level_filter_with_http_info(self, smb_log_level_filter_id, **kwargs):  # noqa: E501
        """get_smb_log_level_filter  # noqa: E501

        View log filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_log_level_filter_with_http_info(smb_log_level_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_log_level_filter_id: View log filter. (required)
        :return: SmbLogLevelFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_log_level_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_log_level_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_log_level_filter_id' is set
        if ('smb_log_level_filter_id' not in params or
                params['smb_log_level_filter_id'] is None):
            raise ValueError("Missing the required parameter `smb_log_level_filter_id` when calling `get_smb_log_level_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'smb_log_level_filter_id' in params:
            path_params['SmbLogLevelFilterId'] = params['smb_log_level_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level/filters/{SmbLogLevelFilterId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbLogLevelFilters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_openfiles(self, **kwargs):  # noqa: E501
        """get_smb_openfiles  # noqa: E501

        List open files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_openfiles(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: Order results by this field. Default is id.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbOpenfiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_openfiles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_openfiles_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_openfiles_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_openfiles  # noqa: E501

        List open files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_openfiles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: Order results by this field. Default is id.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbOpenfiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_openfiles" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smb_openfiles`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smb_openfiles`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_smb_openfiles`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_smb_openfiles`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_smb_openfiles`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/openfiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbOpenfiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_sessions(self, **kwargs):  # noqa: E501
        """get_smb_sessions  # noqa: E501

        List open sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_sessions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: Order results by this field.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_sessions  # noqa: E501

        List open sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_sessions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: Order results by this field.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SmbSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smb_sessions`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_smb_sessions`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_smb_sessions`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_smb_sessions`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_smb_sessions`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSessions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_settings_global(self, **kwargs):  # noqa: E501
        """get_smb_settings_global  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: SmbSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_settings_global  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: SmbSettingsGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSettingsGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_settings_share(self, **kwargs):  # noqa: E501
        """get_smb_settings_share  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_settings_share(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Specifies which access zone to use.
        :return: SmbSettingsShare
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_settings_share_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_settings_share_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_settings_share_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_settings_share  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_settings_share_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Specifies which access zone to use.
        :return: SmbSettingsShare
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_settings_share" % key
                )
            params[key] = val
        del params['kwargs']

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_settings_share`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_settings_share`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/settings/share', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSettingsShare',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_settings_zone(self, **kwargs):  # noqa: E501
        """get_smb_settings_zone  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_settings_zone(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Name of the access zone
        :return: SmbSettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_settings_zone_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_settings_zone_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_settings_zone_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_settings_zone  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_settings_zone_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str zone: Name of the access zone
        :return: SmbSettingsZone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']

        if ('zone' in params and
                len(params['zone']) > 511):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_settings_zone`, length must be less than or equal to `511`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 1):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_settings_zone`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/6/protocols/smb/settings/zone', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSettingsZone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_share(self, smb_share_id, **kwargs):  # noqa: E501
        """get_smb_share  # noqa: E501

        Retrieve share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_share(smb_share_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_share_id: Retrieve share. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param str zone: Specifies which access zone to use.
        :return: SmbShares
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_share_with_http_info(smb_share_id, **kwargs)  # noqa: E501
            return data

    def get_smb_share_with_http_info(self, smb_share_id, **kwargs):  # noqa: E501
        """get_smb_share  # noqa: E501

        Retrieve share.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_share_with_http_info(smb_share_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str smb_share_id: Retrieve share. (required)
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param str zone: Specifies which access zone to use.
        :return: SmbShares
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share_id', 'scope', 'resolve_names', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share_id' is set
        if ('smb_share_id' not in params or
                params['smb_share_id'] is None):
            raise ValueError("Missing the required parameter `smb_share_id` when calling `get_smb_share`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_share`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_share`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'smb_share_id' in params:
            path_params['SmbShareId'] = params['smb_share_id']  # noqa: E501

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/shares/{SmbShareId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbShares',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_smb_shares_summary(self, **kwargs):  # noqa: E501
        """get_smb_shares_summary  # noqa: E501

        Return summary information about shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_shares_summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Specifies which access zone to use.
        :return: SmbSharesSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_smb_shares_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_smb_shares_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_smb_shares_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_smb_shares_summary  # noqa: E501

        Return summary information about shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_smb_shares_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Specifies which access zone to use.
        :return: SmbSharesSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_smb_shares_summary" % key
                )
            params[key] = val
        del params['kwargs']

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_shares_summary`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_smb_shares_summary`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/smb/shares-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSharesSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snmp_settings(self, **kwargs):  # noqa: E501
        """get_snmp_settings  # noqa: E501

        Retrieve the SNMP settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snmp_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnmpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snmp_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snmp_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snmp_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_snmp_settings  # noqa: E501

        Retrieve the SNMP settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snmp_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnmpSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snmp_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/snmp/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnmpSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ssh_settings(self, **kwargs):  # noqa: E501
        """get_ssh_settings  # noqa: E501

        ssh settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SshSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ssh_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ssh_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ssh_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_ssh_settings  # noqa: E501

        ssh settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SshSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ssh_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/8/protocols/ssh/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SshSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_swift_account(self, swift_account_id, **kwargs):  # noqa: E501
        """get_swift_account  # noqa: E501

        List a swift account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_swift_account(swift_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str swift_account_id: List a swift account. (required)
        :param str zone: Access zone which contains Swift account.
        :return: SwiftAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_swift_account_with_http_info(swift_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_swift_account_with_http_info(swift_account_id, **kwargs)  # noqa: E501
            return data

    def get_swift_account_with_http_info(self, swift_account_id, **kwargs):  # noqa: E501
        """get_swift_account  # noqa: E501

        List a swift account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_swift_account_with_http_info(swift_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str swift_account_id: List a swift account. (required)
        :param str zone: Access zone which contains Swift account.
        :return: SwiftAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['swift_account_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_swift_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'swift_account_id' is set
        if ('swift_account_id' not in params or
                params['swift_account_id'] is None):
            raise ValueError("Missing the required parameter `swift_account_id` when calling `get_swift_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'swift_account_id' in params:
            path_params['SwiftAccountId'] = params['swift_account_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/swift/accounts/{SwiftAccountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SwiftAccounts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hdfs_crypto_encryption_zones(self, **kwargs):  # noqa: E501
        """list_hdfs_crypto_encryption_zones  # noqa: E501

        Retrieve a list of Encryption Zones.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hdfs_crypto_encryption_zones(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Specifies which access zone to use.
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HdfsCryptoEncryptionZones
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_hdfs_crypto_encryption_zones_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_hdfs_crypto_encryption_zones_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_hdfs_crypto_encryption_zones_with_http_info(self, **kwargs):  # noqa: E501
        """list_hdfs_crypto_encryption_zones  # noqa: E501

        Retrieve a list of Encryption Zones.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hdfs_crypto_encryption_zones_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Specifies which access zone to use.
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HdfsCryptoEncryptionZones
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'zone', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hdfs_crypto_encryption_zones" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_hdfs_crypto_encryption_zones`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_hdfs_crypto_encryption_zones`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_hdfs_crypto_encryption_zones`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_hdfs_crypto_encryption_zones`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `list_hdfs_crypto_encryption_zones`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `list_hdfs_crypto_encryption_zones`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_hdfs_crypto_encryption_zones`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_hdfs_crypto_encryption_zones`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_hdfs_crypto_encryption_zones`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/hdfs/crypto/encryption-zones', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsCryptoEncryptionZones',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hdfs_proxyusers(self, **kwargs):  # noqa: E501
        """list_hdfs_proxyusers  # noqa: E501

        List all proxyusers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hdfs_proxyusers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Access zone which contains HDFS proxyusers.
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_hdfs_proxyusers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_hdfs_proxyusers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_hdfs_proxyusers_with_http_info(self, **kwargs):  # noqa: E501
        """list_hdfs_proxyusers  # noqa: E501

        List all proxyusers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hdfs_proxyusers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Access zone which contains HDFS proxyusers.
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HdfsProxyusers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'zone', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hdfs_proxyusers" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_hdfs_proxyusers`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_hdfs_proxyusers`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_hdfs_proxyusers`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_hdfs_proxyusers`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_hdfs_proxyusers`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsProxyusers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hdfs_racks(self, **kwargs):  # noqa: E501
        """list_hdfs_racks  # noqa: E501

        List all racks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hdfs_racks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Access zone which contains HDFS racks.
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HdfsRacksExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_hdfs_racks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_hdfs_racks_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_hdfs_racks_with_http_info(self, **kwargs):  # noqa: E501
        """list_hdfs_racks  # noqa: E501

        List all racks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hdfs_racks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str zone: Access zone which contains HDFS racks.
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HdfsRacksExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'zone', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hdfs_racks" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_hdfs_racks`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_hdfs_racks`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_hdfs_racks`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_hdfs_racks`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_hdfs_racks`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HdfsRacksExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ndmp_settings_preferred_ips(self, **kwargs):  # noqa: E501
        """list_ndmp_settings_preferred_ips  # noqa: E501

        Get list of preferences.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ndmp_settings_preferred_ips(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: Either cluster or a network subnet defined in OneFS.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpSettingsPreferredIpsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_ndmp_settings_preferred_ips_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_ndmp_settings_preferred_ips_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_ndmp_settings_preferred_ips_with_http_info(self, **kwargs):  # noqa: E501
        """list_ndmp_settings_preferred_ips  # noqa: E501

        Get list of preferences.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ndmp_settings_preferred_ips_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: Either cluster or a network subnet defined in OneFS.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NdmpSettingsPreferredIpsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ndmp_settings_preferred_ips" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_ndmp_settings_preferred_ips`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_ndmp_settings_preferred_ips`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_ndmp_settings_preferred_ips`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_ndmp_settings_preferred_ips`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/ndmp/settings/preferred-ips', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpSettingsPreferredIpsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ndmp_users(self, **kwargs):  # noqa: E501
        """list_ndmp_users  # noqa: E501

        List all ndmp administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ndmp_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpUsersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_ndmp_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_ndmp_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_ndmp_users_with_http_info(self, **kwargs):  # noqa: E501
        """list_ndmp_users  # noqa: E501

        List all ndmp administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ndmp_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NdmpUsersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ndmp_users" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NdmpUsersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_nfs_aliases(self, **kwargs):  # noqa: E501
        """list_nfs_aliases  # noqa: E501

        List all NFS aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_nfs_aliases(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param bool check: Check for conflicts when listing aliases.
        :param str dir: The direction of the sort.
        :return: NfsAliasesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_nfs_aliases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_nfs_aliases_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_nfs_aliases_with_http_info(self, **kwargs):  # noqa: E501
        """list_nfs_aliases  # noqa: E501

        List all NFS aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_nfs_aliases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param bool check: Check for conflicts when listing aliases.
        :param str dir: The direction of the sort.
        :return: NfsAliasesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'limit', 'check', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_nfs_aliases" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_nfs_aliases`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_nfs_aliases`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_nfs_aliases`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_nfs_aliases`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_nfs_aliases`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_nfs_aliases`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_nfs_aliases`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'check' in params:
            query_params.append(('check', params['check']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsAliasesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_nfs_exports(self, **kwargs):  # noqa: E501
        """list_nfs_exports  # noqa: E501

        List all NFS exports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_nfs_exports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting. Default is id.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str scope: When specified as 'effective', or not specified, all fields are returned. When specified as 'user', only fields with non-default values are shown. When specified as 'default', the original values are returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param int offset: The position of the first item returned for a paginated query within the full result set.
        :param str path: If specified, only exports that explicitly reference at least one of the given paths will be returned.
        :param bool check: Check for conflicts when listing exports.
        :param str dir: The direction of the sort.
        :return: NfsExportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_nfs_exports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_nfs_exports_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_nfs_exports_with_http_info(self, **kwargs):  # noqa: E501
        """list_nfs_exports  # noqa: E501

        List all NFS exports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_nfs_exports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting. Default is id.
        :param str zone: Access zone
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str scope: When specified as 'effective', or not specified, all fields are returned. When specified as 'user', only fields with non-default values are shown. When specified as 'default', the original values are returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param int offset: The position of the first item returned for a paginated query within the full result set.
        :param str path: If specified, only exports that explicitly reference at least one of the given paths will be returned.
        :param bool check: Check for conflicts when listing exports.
        :param str dir: The direction of the sort.
        :return: NfsExportsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'scope', 'limit', 'offset', 'path', 'check', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_nfs_exports" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_nfs_exports`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_nfs_exports`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_nfs_exports`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_nfs_exports`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 5000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_nfs_exports`, must be a value less than or equal to `5000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_nfs_exports`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `list_nfs_exports`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `list_nfs_exports`, must be a value greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_nfs_exports`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'check' in params:
            query_params.append(('check', params['check']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/nfs/exports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NfsExportsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ntp_servers(self, **kwargs):  # noqa: E501
        """list_ntp_servers  # noqa: E501

        List all NTP servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ntp_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NtpServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_ntp_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_ntp_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_ntp_servers_with_http_info(self, **kwargs):  # noqa: E501
        """list_ntp_servers  # noqa: E501

        List all NTP servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ntp_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: NtpServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ntp_servers" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_ntp_servers`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_ntp_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_ntp_servers`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_ntp_servers`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_ntp_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_ntp_servers`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_ntp_servers`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NtpServersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_s3_buckets(self, **kwargs):  # noqa: E501
        """list_s3_buckets  # noqa: E501

        List all buckets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_s3_buckets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Specifies which access zone to use.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str owner: Specifies the name of the owner.
        :param str dir: The direction of the sort.
        :return: S3BucketsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_s3_buckets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_s3_buckets_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_s3_buckets_with_http_info(self, **kwargs):  # noqa: E501
        """list_s3_buckets  # noqa: E501

        List all buckets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_s3_buckets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Specifies which access zone to use.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param int limit: Return no more than this many results at once (see resume).
        :param str owner: Specifies the name of the owner.
        :param str dir: The direction of the sort.
        :return: S3BucketsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'limit', 'owner', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_s3_buckets" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_s3_buckets`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_s3_buckets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `list_s3_buckets`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `list_s3_buckets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_s3_buckets`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_s3_buckets`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_s3_buckets`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_s3_buckets`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('owner' in params and
                len(params['owner']) > 255):
            raise ValueError("Invalid value for parameter `owner` when calling `list_s3_buckets`, length must be less than or equal to `255`")  # noqa: E501
        if ('owner' in params and
                len(params['owner']) < 0):
            raise ValueError("Invalid value for parameter `owner` when calling `list_s3_buckets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_s3_buckets`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'owner' in params:
            query_params.append(('owner', params['owner']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='S3BucketsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_s3_mykeys(self, **kwargs):  # noqa: E501
        """list_s3_mykeys  # noqa: E501

        Get user secret key information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_s3_mykeys(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CreateS3KeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_s3_mykeys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_s3_mykeys_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_s3_mykeys_with_http_info(self, **kwargs):  # noqa: E501
        """list_s3_mykeys  # noqa: E501

        Get user secret key information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_s3_mykeys_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CreateS3KeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_s3_mykeys" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/mykeys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateS3KeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_smb_log_level_filters(self, **kwargs):  # noqa: E501
        """list_smb_log_level_filters  # noqa: E501

        Get the current SMB log filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_smb_log_level_filters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str dir: The direction of the sort.
        :param str level: Valid SMB logging levels
        :return: SmbLogLevelFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_smb_log_level_filters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_smb_log_level_filters_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_smb_log_level_filters_with_http_info(self, **kwargs):  # noqa: E501
        """list_smb_log_level_filters  # noqa: E501

        Get the current SMB log filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_smb_log_level_filters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str dir: The direction of the sort.
        :param str level: Valid SMB logging levels
        :return: SmbLogLevelFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'dir', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_smb_log_level_filters" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_smb_log_level_filters`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_smb_log_level_filters`, length must be greater than or equal to `0`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_smb_log_level_filters`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level/filters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbLogLevelFilters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_smb_shares(self, **kwargs):  # noqa: E501
        """list_smb_shares  # noqa: E501

        List all shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_smb_shares(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Specifies which access zone to use.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SmbSharesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_smb_shares_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_smb_shares_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_smb_shares_with_http_info(self, **kwargs):  # noqa: E501
        """list_smb_shares  # noqa: E501

        List all shares.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_smb_shares_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The field that will be used for sorting.
        :param str zone: Specifies which access zone to use.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param int limit: Return no more than this many results at once (see resume).
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :param str dir: The direction of the sort.
        :return: SmbSharesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'zone', 'resume', 'resolve_names', 'limit', 'scope', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_smb_shares" % key
                )
            params[key] = val
        del params['kwargs']

        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_smb_shares`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_smb_shares`, length must be greater than or equal to `0`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `list_smb_shares`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `list_smb_shares`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_smb_shares`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_smb_shares`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 5000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_smb_shares`, must be a value less than or equal to `5000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_smb_shares`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_smb_shares`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/shares', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmbSharesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_swift_accounts(self, **kwargs):  # noqa: E501
        """list_swift_accounts  # noqa: E501

        List all swift accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_swift_accounts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains Swift accounts.
        :return: SwiftAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_swift_accounts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_swift_accounts_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_swift_accounts_with_http_info(self, **kwargs):  # noqa: E501
        """list_swift_accounts  # noqa: E501

        List all swift accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_swift_accounts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains Swift accounts.
        :return: SwiftAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_swift_accounts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/swift/accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SwiftAccountsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ftp_settings(self, ftp_settings, **kwargs):  # noqa: E501
        """update_ftp_settings  # noqa: E501

        Modify the FTP settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ftp_settings(ftp_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FtpSettingsExtended ftp_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ftp_settings_with_http_info(ftp_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ftp_settings_with_http_info(ftp_settings, **kwargs)  # noqa: E501
            return data

    def update_ftp_settings_with_http_info(self, ftp_settings, **kwargs):  # noqa: E501
        """update_ftp_settings  # noqa: E501

        Modify the FTP settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ftp_settings_with_http_info(ftp_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FtpSettingsExtended ftp_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ftp_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ftp_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ftp_settings' is set
        if ('ftp_settings' not in params or
                params['ftp_settings'] is None):
            raise ValueError("Missing the required parameter `ftp_settings` when calling `update_ftp_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ftp_settings' in params:
            body_params = params['ftp_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ftp/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_crypto_settings(self, hdfs_crypto_settings, **kwargs):  # noqa: E501
        """update_hdfs_crypto_settings  # noqa: E501

        Modify HDFS crypto settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_crypto_settings(hdfs_crypto_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsCryptoSettingsSettings hdfs_crypto_settings: (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_crypto_settings_with_http_info(hdfs_crypto_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_crypto_settings_with_http_info(hdfs_crypto_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_crypto_settings_with_http_info(self, hdfs_crypto_settings, **kwargs):  # noqa: E501
        """update_hdfs_crypto_settings  # noqa: E501

        Modify HDFS crypto settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_crypto_settings_with_http_info(hdfs_crypto_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsCryptoSettingsSettings hdfs_crypto_settings: (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_crypto_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_crypto_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_crypto_settings' is set
        if ('hdfs_crypto_settings' not in params or
                params['hdfs_crypto_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_crypto_settings` when calling `update_hdfs_crypto_settings`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `update_hdfs_crypto_settings`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `update_hdfs_crypto_settings`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_crypto_settings' in params:
            body_params = params['hdfs_crypto_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/hdfs/crypto/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_fsimage_job_settings(self, hdfs_fsimage_job_settings, **kwargs):  # noqa: E501
        """update_hdfs_fsimage_job_settings  # noqa: E501

        Modify HDFS FSImage job properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_fsimage_job_settings(hdfs_fsimage_job_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsFsimageJobSettingsSettings hdfs_fsimage_job_settings: (required)
        :param str zone: Access zone which contains job settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_fsimage_job_settings_with_http_info(hdfs_fsimage_job_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_fsimage_job_settings_with_http_info(hdfs_fsimage_job_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_fsimage_job_settings_with_http_info(self, hdfs_fsimage_job_settings, **kwargs):  # noqa: E501
        """update_hdfs_fsimage_job_settings  # noqa: E501

        Modify HDFS FSImage job properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_fsimage_job_settings_with_http_info(hdfs_fsimage_job_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsFsimageJobSettingsSettings hdfs_fsimage_job_settings: (required)
        :param str zone: Access zone which contains job settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_fsimage_job_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_fsimage_job_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_fsimage_job_settings' is set
        if ('hdfs_fsimage_job_settings' not in params or
                params['hdfs_fsimage_job_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_fsimage_job_settings` when calling `update_hdfs_fsimage_job_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_fsimage_job_settings' in params:
            body_params = params['hdfs_fsimage_job_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/job/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_fsimage_settings(self, hdfs_fsimage_settings, **kwargs):  # noqa: E501
        """update_hdfs_fsimage_settings  # noqa: E501

        Modify HDFS FSImage properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_fsimage_settings(hdfs_fsimage_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsFsimageSettingsSettings hdfs_fsimage_settings: (required)
        :param str zone: Access zone which contains FSImage settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_fsimage_settings_with_http_info(hdfs_fsimage_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_fsimage_settings_with_http_info(hdfs_fsimage_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_fsimage_settings_with_http_info(self, hdfs_fsimage_settings, **kwargs):  # noqa: E501
        """update_hdfs_fsimage_settings  # noqa: E501

        Modify HDFS FSImage properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_fsimage_settings_with_http_info(hdfs_fsimage_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsFsimageSettingsSettings hdfs_fsimage_settings: (required)
        :param str zone: Access zone which contains FSImage settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_fsimage_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_fsimage_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_fsimage_settings' is set
        if ('hdfs_fsimage_settings' not in params or
                params['hdfs_fsimage_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_fsimage_settings` when calling `update_hdfs_fsimage_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_fsimage_settings' in params:
            body_params = params['hdfs_fsimage_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/fsimage/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_inotify_settings(self, hdfs_inotify_settings, **kwargs):  # noqa: E501
        """update_hdfs_inotify_settings  # noqa: E501

        Modify HDFS INotify properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_inotify_settings(hdfs_inotify_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsInotifySettingsSettings hdfs_inotify_settings: (required)
        :param str zone: Access zone which contains INotify settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_inotify_settings_with_http_info(hdfs_inotify_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_inotify_settings_with_http_info(hdfs_inotify_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_inotify_settings_with_http_info(self, hdfs_inotify_settings, **kwargs):  # noqa: E501
        """update_hdfs_inotify_settings  # noqa: E501

        Modify HDFS INotify properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_inotify_settings_with_http_info(hdfs_inotify_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsInotifySettingsSettings hdfs_inotify_settings: (required)
        :param str zone: Access zone which contains INotify settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_inotify_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_inotify_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_inotify_settings' is set
        if ('hdfs_inotify_settings' not in params or
                params['hdfs_inotify_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_inotify_settings` when calling `update_hdfs_inotify_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_inotify_settings' in params:
            body_params = params['hdfs_inotify_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/hdfs/inotify/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_log_level(self, hdfs_log_level, **kwargs):  # noqa: E501
        """update_hdfs_log_level  # noqa: E501

        Modify the HDFS service log-level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_log_level(hdfs_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsLogLevel hdfs_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_log_level_with_http_info(hdfs_log_level, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_log_level_with_http_info(hdfs_log_level, **kwargs)  # noqa: E501
            return data

    def update_hdfs_log_level_with_http_info(self, hdfs_log_level, **kwargs):  # noqa: E501
        """update_hdfs_log_level  # noqa: E501

        Modify the HDFS service log-level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_log_level_with_http_info(hdfs_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsLogLevel hdfs_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_log_level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_log_level" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_log_level' is set
        if ('hdfs_log_level' not in params or
                params['hdfs_log_level'] is None):
            raise ValueError("Missing the required parameter `hdfs_log_level` when calling `update_hdfs_log_level`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_log_level' in params:
            body_params = params['hdfs_log_level']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/hdfs/log-level', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_proxyuser(self, hdfs_proxyuser, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """update_hdfs_proxyuser  # noqa: E501

        Modify an HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_proxyuser(hdfs_proxyuser, hdfs_proxyuser_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty hdfs_proxyuser: (required)
        :param str hdfs_proxyuser_id: Modify an HDFS proxyuser. (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_proxyuser_with_http_info(hdfs_proxyuser, hdfs_proxyuser_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_proxyuser_with_http_info(hdfs_proxyuser, hdfs_proxyuser_id, **kwargs)  # noqa: E501
            return data

    def update_hdfs_proxyuser_with_http_info(self, hdfs_proxyuser, hdfs_proxyuser_id, **kwargs):  # noqa: E501
        """update_hdfs_proxyuser  # noqa: E501

        Modify an HDFS proxyuser.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_proxyuser_with_http_info(hdfs_proxyuser, hdfs_proxyuser_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty hdfs_proxyuser: (required)
        :param str hdfs_proxyuser_id: Modify an HDFS proxyuser. (required)
        :param str zone: Access zone which contains HDFS proxyuser.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_proxyuser', 'hdfs_proxyuser_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_proxyuser" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_proxyuser' is set
        if ('hdfs_proxyuser' not in params or
                params['hdfs_proxyuser'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser` when calling `update_hdfs_proxyuser`")  # noqa: E501
        # verify the required parameter 'hdfs_proxyuser_id' is set
        if ('hdfs_proxyuser_id' not in params or
                params['hdfs_proxyuser_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_proxyuser_id` when calling `update_hdfs_proxyuser`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_proxyuser_id' in params:
            path_params['HdfsProxyuserId'] = params['hdfs_proxyuser_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_proxyuser' in params:
            body_params = params['hdfs_proxyuser']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/proxyusers/{HdfsProxyuserId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_rack(self, hdfs_rack, hdfs_rack_id, **kwargs):  # noqa: E501
        """update_hdfs_rack  # noqa: E501

        Modify the HDFS rack  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_rack(hdfs_rack, hdfs_rack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsRack hdfs_rack: (required)
        :param str hdfs_rack_id: Modify the HDFS rack (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_rack_with_http_info(hdfs_rack, hdfs_rack_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_rack_with_http_info(hdfs_rack, hdfs_rack_id, **kwargs)  # noqa: E501
            return data

    def update_hdfs_rack_with_http_info(self, hdfs_rack, hdfs_rack_id, **kwargs):  # noqa: E501
        """update_hdfs_rack  # noqa: E501

        Modify the HDFS rack  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_rack_with_http_info(hdfs_rack, hdfs_rack_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsRack hdfs_rack: (required)
        :param str hdfs_rack_id: Modify the HDFS rack (required)
        :param str zone: Access zone which contains HDFS rack.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_rack', 'hdfs_rack_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_rack" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_rack' is set
        if ('hdfs_rack' not in params or
                params['hdfs_rack'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack` when calling `update_hdfs_rack`")  # noqa: E501
        # verify the required parameter 'hdfs_rack_id' is set
        if ('hdfs_rack_id' not in params or
                params['hdfs_rack_id'] is None):
            raise ValueError("Missing the required parameter `hdfs_rack_id` when calling `update_hdfs_rack`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hdfs_rack_id' in params:
            path_params['HdfsRackId'] = params['hdfs_rack_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_rack' in params:
            body_params = params['hdfs_rack']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/protocols/hdfs/racks/{HdfsRackId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_ranger_plugin_settings(self, hdfs_ranger_plugin_settings, **kwargs):  # noqa: E501
        """update_hdfs_ranger_plugin_settings  # noqa: E501

        Modify HDFS ranger-plugin properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_ranger_plugin_settings(hdfs_ranger_plugin_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsRangerPluginSettingsSettings hdfs_ranger_plugin_settings: (required)
        :param str zone: Access zone which contains HDFS ranger-plugin settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_ranger_plugin_settings_with_http_info(hdfs_ranger_plugin_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_ranger_plugin_settings_with_http_info(hdfs_ranger_plugin_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_ranger_plugin_settings_with_http_info(self, hdfs_ranger_plugin_settings, **kwargs):  # noqa: E501
        """update_hdfs_ranger_plugin_settings  # noqa: E501

        Modify HDFS ranger-plugin properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_ranger_plugin_settings_with_http_info(hdfs_ranger_plugin_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsRangerPluginSettingsSettings hdfs_ranger_plugin_settings: (required)
        :param str zone: Access zone which contains HDFS ranger-plugin settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_ranger_plugin_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_ranger_plugin_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_ranger_plugin_settings' is set
        if ('hdfs_ranger_plugin_settings' not in params or
                params['hdfs_ranger_plugin_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_ranger_plugin_settings` when calling `update_hdfs_ranger_plugin_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_ranger_plugin_settings' in params:
            body_params = params['hdfs_ranger_plugin_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/hdfs/ranger-plugin/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_settings(self, hdfs_settings, **kwargs):  # noqa: E501
        """update_hdfs_settings  # noqa: E501

        Modify HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_settings(hdfs_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsSettingsSettings hdfs_settings: (required)
        :param str zone: Access zone which contains HDFS settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_settings_with_http_info(hdfs_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_settings_with_http_info(hdfs_settings, **kwargs)  # noqa: E501
            return data

    def update_hdfs_settings_with_http_info(self, hdfs_settings, **kwargs):  # noqa: E501
        """update_hdfs_settings  # noqa: E501

        Modify HDFS properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_settings_with_http_info(hdfs_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsSettingsSettings hdfs_settings: (required)
        :param str zone: Access zone which contains HDFS settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_settings' is set
        if ('hdfs_settings' not in params or
                params['hdfs_settings'] is None):
            raise ValueError("Missing the required parameter `hdfs_settings` when calling `update_hdfs_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_settings' in params:
            body_params = params['hdfs_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/protocols/hdfs/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hdfs_settings_global(self, hdfs_settings_global, **kwargs):  # noqa: E501
        """update_hdfs_settings_global  # noqa: E501

        Modify HDFS global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_settings_global(hdfs_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsSettingsGlobalGlobalSettings hdfs_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hdfs_settings_global_with_http_info(hdfs_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hdfs_settings_global_with_http_info(hdfs_settings_global, **kwargs)  # noqa: E501
            return data

    def update_hdfs_settings_global_with_http_info(self, hdfs_settings_global, **kwargs):  # noqa: E501
        """update_hdfs_settings_global  # noqa: E501

        Modify HDFS global settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hdfs_settings_global_with_http_info(hdfs_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HdfsSettingsGlobalGlobalSettings hdfs_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hdfs_settings_global']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hdfs_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hdfs_settings_global' is set
        if ('hdfs_settings_global' not in params or
                params['hdfs_settings_global'] is None):
            raise ValueError("Missing the required parameter `hdfs_settings_global` when calling `update_hdfs_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hdfs_settings_global' in params:
            body_params = params['hdfs_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/protocols/hdfs/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_http_settings(self, http_settings, **kwargs):  # noqa: E501
        """update_http_settings  # noqa: E501

        Modify HTTP properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_http_settings(http_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HttpSettingsSettings http_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_http_settings_with_http_info(http_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_http_settings_with_http_info(http_settings, **kwargs)  # noqa: E501
            return data

    def update_http_settings_with_http_info(self, http_settings, **kwargs):  # noqa: E501
        """update_http_settings  # noqa: E501

        Modify HTTP properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_http_settings_with_http_info(http_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HttpSettingsSettings http_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['http_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_http_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'http_settings' is set
        if ('http_settings' not in params or
                params['http_settings'] is None):
            raise ValueError("Missing the required parameter `http_settings` when calling `update_http_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'http_settings' in params:
            body_params = params['http_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/http/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ndmp_diagnostics(self, ndmp_diagnostics, **kwargs):  # noqa: E501
        """update_ndmp_diagnostics  # noqa: E501

        Modify ndmp diagnostics settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_diagnostics(ndmp_diagnostics, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpDiagnosticsDiagnostics ndmp_diagnostics: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ndmp_diagnostics_with_http_info(ndmp_diagnostics, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ndmp_diagnostics_with_http_info(ndmp_diagnostics, **kwargs)  # noqa: E501
            return data

    def update_ndmp_diagnostics_with_http_info(self, ndmp_diagnostics, **kwargs):  # noqa: E501
        """update_ndmp_diagnostics  # noqa: E501

        Modify ndmp diagnostics settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_diagnostics_with_http_info(ndmp_diagnostics, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpDiagnosticsDiagnostics ndmp_diagnostics: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_diagnostics']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ndmp_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_diagnostics' is set
        if ('ndmp_diagnostics' not in params or
                params['ndmp_diagnostics'] is None):
            raise ValueError("Missing the required parameter `ndmp_diagnostics` when calling `update_ndmp_diagnostics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_diagnostics' in params:
            body_params = params['ndmp_diagnostics']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/diagnostics', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ndmp_settings_global(self, ndmp_settings_global, **kwargs):  # noqa: E501
        """update_ndmp_settings_global  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_settings_global(ndmp_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsGlobalGlobal ndmp_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ndmp_settings_global_with_http_info(ndmp_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ndmp_settings_global_with_http_info(ndmp_settings_global, **kwargs)  # noqa: E501
            return data

    def update_ndmp_settings_global_with_http_info(self, ndmp_settings_global, **kwargs):  # noqa: E501
        """update_ndmp_settings_global  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_settings_global_with_http_info(ndmp_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsGlobalGlobal ndmp_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_global']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ndmp_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_global' is set
        if ('ndmp_settings_global' not in params or
                params['ndmp_settings_global'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_global` when calling `update_ndmp_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_settings_global' in params:
            body_params = params['ndmp_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ndmp_settings_preferred_ip(self, ndmp_settings_preferred_ip, ndmp_settings_preferred_ip_id, **kwargs):  # noqa: E501
        """update_ndmp_settings_preferred_ip  # noqa: E501

        Modify a preferred ip preference.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_settings_preferred_ip(ndmp_settings_preferred_ip, ndmp_settings_preferred_ip_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsPreferredIp ndmp_settings_preferred_ip: (required)
        :param str ndmp_settings_preferred_ip_id: Modify a preferred ip preference. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip, ndmp_settings_preferred_ip_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip, ndmp_settings_preferred_ip_id, **kwargs)  # noqa: E501
            return data

    def update_ndmp_settings_preferred_ip_with_http_info(self, ndmp_settings_preferred_ip, ndmp_settings_preferred_ip_id, **kwargs):  # noqa: E501
        """update_ndmp_settings_preferred_ip  # noqa: E501

        Modify a preferred ip preference.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_settings_preferred_ip_with_http_info(ndmp_settings_preferred_ip, ndmp_settings_preferred_ip_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsPreferredIp ndmp_settings_preferred_ip: (required)
        :param str ndmp_settings_preferred_ip_id: Modify a preferred ip preference. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_preferred_ip', 'ndmp_settings_preferred_ip_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ndmp_settings_preferred_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_preferred_ip' is set
        if ('ndmp_settings_preferred_ip' not in params or
                params['ndmp_settings_preferred_ip'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_preferred_ip` when calling `update_ndmp_settings_preferred_ip`")  # noqa: E501
        # verify the required parameter 'ndmp_settings_preferred_ip_id' is set
        if ('ndmp_settings_preferred_ip_id' not in params or
                params['ndmp_settings_preferred_ip_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_preferred_ip_id` when calling `update_ndmp_settings_preferred_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_preferred_ip_id' in params:
            path_params['NdmpSettingsPreferredIpId'] = params['ndmp_settings_preferred_ip_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_settings_preferred_ip' in params:
            body_params = params['ndmp_settings_preferred_ip']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/ndmp/settings/preferred-ips/{NdmpSettingsPreferredIpId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ndmp_settings_variable(self, ndmp_settings_variable, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """update_ndmp_settings_variable  # noqa: E501

        Modify or create a NDMP preferred environment variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_settings_variable(ndmp_settings_variable, ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsVariable ndmp_settings_variable: (required)
        :param str ndmp_settings_variable_id: Modify or create a NDMP preferred environment variable. (required)
        :param str name: Name of the variable to modify.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ndmp_settings_variable_with_http_info(ndmp_settings_variable, ndmp_settings_variable_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ndmp_settings_variable_with_http_info(ndmp_settings_variable, ndmp_settings_variable_id, **kwargs)  # noqa: E501
            return data

    def update_ndmp_settings_variable_with_http_info(self, ndmp_settings_variable, ndmp_settings_variable_id, **kwargs):  # noqa: E501
        """update_ndmp_settings_variable  # noqa: E501

        Modify or create a NDMP preferred environment variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_settings_variable_with_http_info(ndmp_settings_variable, ndmp_settings_variable_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpSettingsVariable ndmp_settings_variable: (required)
        :param str ndmp_settings_variable_id: Modify or create a NDMP preferred environment variable. (required)
        :param str name: Name of the variable to modify.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_settings_variable', 'ndmp_settings_variable_id', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ndmp_settings_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_settings_variable' is set
        if ('ndmp_settings_variable' not in params or
                params['ndmp_settings_variable'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_variable` when calling `update_ndmp_settings_variable`")  # noqa: E501
        # verify the required parameter 'ndmp_settings_variable_id' is set
        if ('ndmp_settings_variable_id' not in params or
                params['ndmp_settings_variable_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_settings_variable_id` when calling `update_ndmp_settings_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_settings_variable_id' in params:
            path_params['NdmpSettingsVariableId'] = params['ndmp_settings_variable_id']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_settings_variable' in params:
            body_params = params['ndmp_settings_variable']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/settings/variables/{NdmpSettingsVariableId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ndmp_user(self, ndmp_user, ndmp_user_id, **kwargs):  # noqa: E501
        """update_ndmp_user  # noqa: E501

        Modify the user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_user(ndmp_user, ndmp_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpUser ndmp_user: (required)
        :param str ndmp_user_id: Modify the user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ndmp_user_with_http_info(ndmp_user, ndmp_user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ndmp_user_with_http_info(ndmp_user, ndmp_user_id, **kwargs)  # noqa: E501
            return data

    def update_ndmp_user_with_http_info(self, ndmp_user, ndmp_user_id, **kwargs):  # noqa: E501
        """update_ndmp_user  # noqa: E501

        Modify the user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ndmp_user_with_http_info(ndmp_user, ndmp_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NdmpUser ndmp_user: (required)
        :param str ndmp_user_id: Modify the user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ndmp_user', 'ndmp_user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ndmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ndmp_user' is set
        if ('ndmp_user' not in params or
                params['ndmp_user'] is None):
            raise ValueError("Missing the required parameter `ndmp_user` when calling `update_ndmp_user`")  # noqa: E501
        # verify the required parameter 'ndmp_user_id' is set
        if ('ndmp_user_id' not in params or
                params['ndmp_user_id'] is None):
            raise ValueError("Missing the required parameter `ndmp_user_id` when calling `update_ndmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ndmp_user_id' in params:
            path_params['NdmpUserId'] = params['ndmp_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ndmp_user' in params:
            body_params = params['ndmp_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ndmp/users/{NdmpUserId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_alias(self, nfs_alias, nfs_alias_id, **kwargs):  # noqa: E501
        """update_nfs_alias  # noqa: E501

        Modify the alias. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_alias(nfs_alias, nfs_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsAlias nfs_alias: (required)
        :param str nfs_alias_id: Modify the alias. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_alias_with_http_info(nfs_alias, nfs_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_alias_with_http_info(nfs_alias, nfs_alias_id, **kwargs)  # noqa: E501
            return data

    def update_nfs_alias_with_http_info(self, nfs_alias, nfs_alias_id, **kwargs):  # noqa: E501
        """update_nfs_alias  # noqa: E501

        Modify the alias. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_alias_with_http_info(nfs_alias, nfs_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsAlias nfs_alias: (required)
        :param str nfs_alias_id: Modify the alias. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_alias', 'nfs_alias_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_alias' is set
        if ('nfs_alias' not in params or
                params['nfs_alias'] is None):
            raise ValueError("Missing the required parameter `nfs_alias` when calling `update_nfs_alias`")  # noqa: E501
        # verify the required parameter 'nfs_alias_id' is set
        if ('nfs_alias_id' not in params or
                params['nfs_alias_id'] is None):
            raise ValueError("Missing the required parameter `nfs_alias_id` when calling `update_nfs_alias`")  # noqa: E501

        if 'nfs_alias_id' in params:
            # tag this parameter so that it can be url encoded with quote_plus
            # by the api_client code because it contains a '/' character that
            # needs to be url encoded.
            params['nfs_alias_id'] = "__x-isi-url-encode-path-param__{0}".format(params['nfs_alias_id'])
        collection_formats = {}

        path_params = {}
        if 'nfs_alias_id' in params:
            path_params['NfsAliasId'] = params['nfs_alias_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_alias' in params:
            body_params = params['nfs_alias']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/aliases/{NfsAliasId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_export(self, nfs_export, nfs_export_id, **kwargs):  # noqa: E501
        """update_nfs_export  # noqa: E501

        Modify the export. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_export(nfs_export, nfs_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsExport nfs_export: (required)
        :param str nfs_export_id: Modify the export. All input fields are optional, but one or more must be supplied. (required)
        :param bool force: If true, the export will be updated even if that change conflicts with another export.
        :param bool ignore_unresolvable_hosts: Ignore unresolvable hosts.
        :param str zone: Access zone
        :param bool ignore_conflicts: Ignore conflicts with existing exports.
        :param bool ignore_bad_paths: Ignore nonexistent or otherwise bad paths.
        :param bool ignore_bad_auth: Ignore invalid users.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_export_with_http_info(nfs_export, nfs_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_export_with_http_info(nfs_export, nfs_export_id, **kwargs)  # noqa: E501
            return data

    def update_nfs_export_with_http_info(self, nfs_export, nfs_export_id, **kwargs):  # noqa: E501
        """update_nfs_export  # noqa: E501

        Modify the export. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_export_with_http_info(nfs_export, nfs_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsExport nfs_export: (required)
        :param str nfs_export_id: Modify the export. All input fields are optional, but one or more must be supplied. (required)
        :param bool force: If true, the export will be updated even if that change conflicts with another export.
        :param bool ignore_unresolvable_hosts: Ignore unresolvable hosts.
        :param str zone: Access zone
        :param bool ignore_conflicts: Ignore conflicts with existing exports.
        :param bool ignore_bad_paths: Ignore nonexistent or otherwise bad paths.
        :param bool ignore_bad_auth: Ignore invalid users.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_export', 'nfs_export_id', 'force', 'ignore_unresolvable_hosts', 'zone', 'ignore_conflicts', 'ignore_bad_paths', 'ignore_bad_auth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_export' is set
        if ('nfs_export' not in params or
                params['nfs_export'] is None):
            raise ValueError("Missing the required parameter `nfs_export` when calling `update_nfs_export`")  # noqa: E501
        # verify the required parameter 'nfs_export_id' is set
        if ('nfs_export_id' not in params or
                params['nfs_export_id'] is None):
            raise ValueError("Missing the required parameter `nfs_export_id` when calling `update_nfs_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nfs_export_id' in params:
            path_params['NfsExportId'] = params['nfs_export_id']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501
        if 'ignore_unresolvable_hosts' in params:
            query_params.append(('ignore_unresolvable_hosts', params['ignore_unresolvable_hosts']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'ignore_conflicts' in params:
            query_params.append(('ignore_conflicts', params['ignore_conflicts']))  # noqa: E501
        if 'ignore_bad_paths' in params:
            query_params.append(('ignore_bad_paths', params['ignore_bad_paths']))  # noqa: E501
        if 'ignore_bad_auth' in params:
            query_params.append(('ignore_bad_auth', params['ignore_bad_auth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_export' in params:
            body_params = params['nfs_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/protocols/nfs/exports/{NfsExportId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_log_level(self, nfs_log_level, **kwargs):  # noqa: E501
        """update_nfs_log_level  # noqa: E501

        Set the current NFS service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_log_level(nfs_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsLogLevel nfs_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_log_level_with_http_info(nfs_log_level, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_log_level_with_http_info(nfs_log_level, **kwargs)  # noqa: E501
            return data

    def update_nfs_log_level_with_http_info(self, nfs_log_level, **kwargs):  # noqa: E501
        """update_nfs_log_level  # noqa: E501

        Set the current NFS service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_log_level_with_http_info(nfs_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsLogLevel nfs_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_log_level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_log_level" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_log_level' is set
        if ('nfs_log_level' not in params or
                params['nfs_log_level'] is None):
            raise ValueError("Missing the required parameter `nfs_log_level` when calling `update_nfs_log_level`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_log_level' in params:
            body_params = params['nfs_log_level']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/log-level', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_netgroup(self, nfs_netgroup, **kwargs):  # noqa: E501
        """update_nfs_netgroup  # noqa: E501

        Modify the current NFS netgroup settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_netgroup(nfs_netgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsNetgroup nfs_netgroup: (required)
        :param str host: Host to retrieve netgroup cache settings for.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_netgroup_with_http_info(nfs_netgroup, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_netgroup_with_http_info(nfs_netgroup, **kwargs)  # noqa: E501
            return data

    def update_nfs_netgroup_with_http_info(self, nfs_netgroup, **kwargs):  # noqa: E501
        """update_nfs_netgroup  # noqa: E501

        Modify the current NFS netgroup settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_netgroup_with_http_info(nfs_netgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsNetgroup nfs_netgroup: (required)
        :param str host: Host to retrieve netgroup cache settings for.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_netgroup', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_netgroup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_netgroup' is set
        if ('nfs_netgroup' not in params or
                params['nfs_netgroup'] is None):
            raise ValueError("Missing the required parameter `nfs_netgroup` when calling `update_nfs_netgroup`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'host' in params:
            query_params.append(('host', params['host']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_netgroup' in params:
            body_params = params['nfs_netgroup']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/nfs/netgroup', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_settings_export(self, nfs_settings_export, **kwargs):  # noqa: E501
        """update_nfs_settings_export  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_settings_export(nfs_settings_export, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsSettingsExportSettings nfs_settings_export: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_settings_export_with_http_info(nfs_settings_export, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_settings_export_with_http_info(nfs_settings_export, **kwargs)  # noqa: E501
            return data

    def update_nfs_settings_export_with_http_info(self, nfs_settings_export, **kwargs):  # noqa: E501
        """update_nfs_settings_export  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_settings_export_with_http_info(nfs_settings_export, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsSettingsExportSettings nfs_settings_export: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_settings_export', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_settings_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_settings_export' is set
        if ('nfs_settings_export' not in params or
                params['nfs_settings_export'] is None):
            raise ValueError("Missing the required parameter `nfs_settings_export` when calling `update_nfs_settings_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_settings_export' in params:
            body_params = params['nfs_settings_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/export', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_settings_global(self, nfs_settings_global, **kwargs):  # noqa: E501
        """update_nfs_settings_global  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_settings_global(nfs_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsSettingsGlobalSettings nfs_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_settings_global_with_http_info(nfs_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_settings_global_with_http_info(nfs_settings_global, **kwargs)  # noqa: E501
            return data

    def update_nfs_settings_global_with_http_info(self, nfs_settings_global, **kwargs):  # noqa: E501
        """update_nfs_settings_global  # noqa: E501

        Modify the default values for NFS exports. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_settings_global_with_http_info(nfs_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsSettingsGlobalSettings nfs_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_settings_global']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_settings_global' is set
        if ('nfs_settings_global' not in params or
                params['nfs_settings_global'] is None):
            raise ValueError("Missing the required parameter `nfs_settings_global` when calling `update_nfs_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_settings_global' in params:
            body_params = params['nfs_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/nfs/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nfs_settings_zone(self, nfs_settings_zone, **kwargs):  # noqa: E501
        """update_nfs_settings_zone  # noqa: E501

        Modify the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_settings_zone(nfs_settings_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsSettingsZoneSettings nfs_settings_zone: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nfs_settings_zone_with_http_info(nfs_settings_zone, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nfs_settings_zone_with_http_info(nfs_settings_zone, **kwargs)  # noqa: E501
            return data

    def update_nfs_settings_zone_with_http_info(self, nfs_settings_zone, **kwargs):  # noqa: E501
        """update_nfs_settings_zone  # noqa: E501

        Modify the NFS server settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_nfs_settings_zone_with_http_info(nfs_settings_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NfsSettingsZoneSettings nfs_settings_zone: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nfs_settings_zone', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nfs_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nfs_settings_zone' is set
        if ('nfs_settings_zone' not in params or
                params['nfs_settings_zone'] is None):
            raise ValueError("Missing the required parameter `nfs_settings_zone` when calling `update_nfs_settings_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'nfs_settings_zone' in params:
            body_params = params['nfs_settings_zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/2/protocols/nfs/settings/zone', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ntp_server(self, ntp_server, ntp_server_id, **kwargs):  # noqa: E501
        """update_ntp_server  # noqa: E501

        Modify the key value for an NTP server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ntp_server(ntp_server, ntp_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NtpServer ntp_server: (required)
        :param str ntp_server_id: Modify the key value for an NTP server. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ntp_server_with_http_info(ntp_server, ntp_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ntp_server_with_http_info(ntp_server, ntp_server_id, **kwargs)  # noqa: E501
            return data

    def update_ntp_server_with_http_info(self, ntp_server, ntp_server_id, **kwargs):  # noqa: E501
        """update_ntp_server  # noqa: E501

        Modify the key value for an NTP server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ntp_server_with_http_info(ntp_server, ntp_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NtpServer ntp_server: (required)
        :param str ntp_server_id: Modify the key value for an NTP server. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ntp_server', 'ntp_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ntp_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ntp_server' is set
        if ('ntp_server' not in params or
                params['ntp_server'] is None):
            raise ValueError("Missing the required parameter `ntp_server` when calling `update_ntp_server`")  # noqa: E501
        # verify the required parameter 'ntp_server_id' is set
        if ('ntp_server_id' not in params or
                params['ntp_server_id'] is None):
            raise ValueError("Missing the required parameter `ntp_server_id` when calling `update_ntp_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ntp_server_id' in params:
            path_params['NtpServerId'] = params['ntp_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ntp_server' in params:
            body_params = params['ntp_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/servers/{NtpServerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ntp_settings(self, ntp_settings, **kwargs):  # noqa: E501
        """update_ntp_settings  # noqa: E501

        Modify the NTP settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ntp_settings(ntp_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NtpSettingsSettings ntp_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ntp_settings_with_http_info(ntp_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ntp_settings_with_http_info(ntp_settings, **kwargs)  # noqa: E501
            return data

    def update_ntp_settings_with_http_info(self, ntp_settings, **kwargs):  # noqa: E501
        """update_ntp_settings  # noqa: E501

        Modify the NTP settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ntp_settings_with_http_info(ntp_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NtpSettingsSettings ntp_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ntp_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ntp_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ntp_settings' is set
        if ('ntp_settings' not in params or
                params['ntp_settings'] is None):
            raise ValueError("Missing the required parameter `ntp_settings` when calling `update_ntp_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ntp_settings' in params:
            body_params = params['ntp_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/ntp/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_s3_bucket(self, s3_bucket, s3_bucket_id, **kwargs):  # noqa: E501
        """update_s3_bucket  # noqa: E501

        Modify bucket. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_bucket(s3_bucket, s3_bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Bucket s3_bucket: (required)
        :param str s3_bucket_id: Modify bucket. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_s3_bucket_with_http_info(s3_bucket, s3_bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_s3_bucket_with_http_info(s3_bucket, s3_bucket_id, **kwargs)  # noqa: E501
            return data

    def update_s3_bucket_with_http_info(self, s3_bucket, s3_bucket_id, **kwargs):  # noqa: E501
        """update_s3_bucket  # noqa: E501

        Modify bucket. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_bucket_with_http_info(s3_bucket, s3_bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Bucket s3_bucket: (required)
        :param str s3_bucket_id: Modify bucket. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_bucket', 's3_bucket_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_s3_bucket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_bucket' is set
        if ('s3_bucket' not in params or
                params['s3_bucket'] is None):
            raise ValueError("Missing the required parameter `s3_bucket` when calling `update_s3_bucket`")  # noqa: E501
        # verify the required parameter 's3_bucket_id' is set
        if ('s3_bucket_id' not in params or
                params['s3_bucket_id'] is None):
            raise ValueError("Missing the required parameter `s3_bucket_id` when calling `update_s3_bucket`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `update_s3_bucket`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `update_s3_bucket`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 's3_bucket_id' in params:
            path_params['S3BucketId'] = params['s3_bucket_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_bucket' in params:
            body_params = params['s3_bucket']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/buckets/{S3BucketId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_s3_log_level(self, s3_log_level, **kwargs):  # noqa: E501
        """update_s3_log_level  # noqa: E501

        Set the current S3 service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_log_level(s3_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3LogLevel s3_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_s3_log_level_with_http_info(s3_log_level, **kwargs)  # noqa: E501
        else:
            (data) = self.update_s3_log_level_with_http_info(s3_log_level, **kwargs)  # noqa: E501
            return data

    def update_s3_log_level_with_http_info(self, s3_log_level, **kwargs):  # noqa: E501
        """update_s3_log_level  # noqa: E501

        Set the current S3 service logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_log_level_with_http_info(s3_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3LogLevel s3_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_log_level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_s3_log_level" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_log_level' is set
        if ('s3_log_level' not in params or
                params['s3_log_level'] is None):
            raise ValueError("Missing the required parameter `s3_log_level` when calling `update_s3_log_level`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_log_level' in params:
            body_params = params['s3_log_level']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/log-level', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_s3_settings_global(self, s3_settings_global, **kwargs):  # noqa: E501
        """update_s3_settings_global  # noqa: E501

        Modify global S3 bucket settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_settings_global(s3_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3SettingsGlobalSettings s3_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_s3_settings_global_with_http_info(s3_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_s3_settings_global_with_http_info(s3_settings_global, **kwargs)  # noqa: E501
            return data

    def update_s3_settings_global_with_http_info(self, s3_settings_global, **kwargs):  # noqa: E501
        """update_s3_settings_global  # noqa: E501

        Modify global S3 bucket settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_settings_global_with_http_info(s3_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3SettingsGlobalSettings s3_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_settings_global']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_s3_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_settings_global' is set
        if ('s3_settings_global' not in params or
                params['s3_settings_global'] is None):
            raise ValueError("Missing the required parameter `s3_settings_global` when calling `update_s3_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_settings_global' in params:
            body_params = params['s3_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_s3_settings_zone(self, s3_settings_zone, **kwargs):  # noqa: E501
        """update_s3_settings_zone  # noqa: E501

        Modify the S3 bucket settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_settings_zone(s3_settings_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3SettingsZoneSettings s3_settings_zone: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_s3_settings_zone_with_http_info(s3_settings_zone, **kwargs)  # noqa: E501
        else:
            (data) = self.update_s3_settings_zone_with_http_info(s3_settings_zone, **kwargs)  # noqa: E501
            return data

    def update_s3_settings_zone_with_http_info(self, s3_settings_zone, **kwargs):  # noqa: E501
        """update_s3_settings_zone  # noqa: E501

        Modify the S3 bucket settings for this zone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_settings_zone_with_http_info(s3_settings_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3SettingsZoneSettings s3_settings_zone: (required)
        :param str zone: Access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['s3_settings_zone', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_s3_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 's3_settings_zone' is set
        if ('s3_settings_zone' not in params or
                params['s3_settings_zone'] is None):
            raise ValueError("Missing the required parameter `s3_settings_zone` when calling `update_s3_settings_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 's3_settings_zone' in params:
            body_params = params['s3_settings_zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/protocols/s3/settings/zone', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_log_level(self, smb_log_level, **kwargs):  # noqa: E501
        """update_smb_log_level  # noqa: E501

        Set the current SMB logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_log_level(smb_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbLogLevel smb_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_smb_log_level_with_http_info(smb_log_level, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_log_level_with_http_info(smb_log_level, **kwargs)  # noqa: E501
            return data

    def update_smb_log_level_with_http_info(self, smb_log_level, **kwargs):  # noqa: E501
        """update_smb_log_level  # noqa: E501

        Set the current SMB logging level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_log_level_with_http_info(smb_log_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbLogLevel smb_log_level: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_log_level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_log_level" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_log_level' is set
        if ('smb_log_level' not in params or
                params['smb_log_level'] is None):
            raise ValueError("Missing the required parameter `smb_log_level` when calling `update_smb_log_level`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_log_level' in params:
            body_params = params['smb_log_level']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/smb/log-level', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_settings_global(self, smb_settings_global, **kwargs):  # noqa: E501
        """update_smb_settings_global  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_settings_global(smb_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbSettingsGlobalExtended smb_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_smb_settings_global_with_http_info(smb_settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_settings_global_with_http_info(smb_settings_global, **kwargs)  # noqa: E501
            return data

    def update_smb_settings_global_with_http_info(self, smb_settings_global, **kwargs):  # noqa: E501
        """update_smb_settings_global  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_settings_global_with_http_info(smb_settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbSettingsGlobalExtended smb_settings_global: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_settings_global']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_settings_global' is set
        if ('smb_settings_global' not in params or
                params['smb_settings_global'] is None):
            raise ValueError("Missing the required parameter `smb_settings_global` when calling `update_smb_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_settings_global' in params:
            body_params = params['smb_settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_settings_share(self, smb_settings_share, **kwargs):  # noqa: E501
        """update_smb_settings_share  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_settings_share(smb_settings_share, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbSettingsShareExtended smb_settings_share: (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_smb_settings_share_with_http_info(smb_settings_share, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_settings_share_with_http_info(smb_settings_share, **kwargs)  # noqa: E501
            return data

    def update_smb_settings_share_with_http_info(self, smb_settings_share, **kwargs):  # noqa: E501
        """update_smb_settings_share  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_settings_share_with_http_info(smb_settings_share, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbSettingsShareExtended smb_settings_share: (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_settings_share', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_settings_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_settings_share' is set
        if ('smb_settings_share' not in params or
                params['smb_settings_share'] is None):
            raise ValueError("Missing the required parameter `smb_settings_share` when calling `update_smb_settings_share`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `update_smb_settings_share`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `update_smb_settings_share`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_settings_share' in params:
            body_params = params['smb_settings_share']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/settings/share', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_settings_zone(self, smb_settings_zone, **kwargs):  # noqa: E501
        """update_smb_settings_zone  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_settings_zone(smb_settings_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbSettingsZoneSettings smb_settings_zone: (required)
        :param str zone: Name of the access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_smb_settings_zone_with_http_info(smb_settings_zone, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_settings_zone_with_http_info(smb_settings_zone, **kwargs)  # noqa: E501
            return data

    def update_smb_settings_zone_with_http_info(self, smb_settings_zone, **kwargs):  # noqa: E501
        """update_smb_settings_zone  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_settings_zone_with_http_info(smb_settings_zone, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbSettingsZoneSettings smb_settings_zone: (required)
        :param str zone: Name of the access zone
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_settings_zone', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_settings_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_settings_zone' is set
        if ('smb_settings_zone' not in params or
                params['smb_settings_zone'] is None):
            raise ValueError("Missing the required parameter `smb_settings_zone` when calling `update_smb_settings_zone`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 511):
            raise ValueError("Invalid value for parameter `zone` when calling `update_smb_settings_zone`, length must be less than or equal to `511`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 1):
            raise ValueError("Invalid value for parameter `zone` when calling `update_smb_settings_zone`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_settings_zone' in params:
            body_params = params['smb_settings_zone']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/6/protocols/smb/settings/zone', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_smb_share(self, smb_share, smb_share_id, **kwargs):  # noqa: E501
        """update_smb_share  # noqa: E501

        Modify share. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_share(smb_share, smb_share_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbShare smb_share: (required)
        :param str smb_share_id: Modify share. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_smb_share_with_http_info(smb_share, smb_share_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_smb_share_with_http_info(smb_share, smb_share_id, **kwargs)  # noqa: E501
            return data

    def update_smb_share_with_http_info(self, smb_share, smb_share_id, **kwargs):  # noqa: E501
        """update_smb_share  # noqa: E501

        Modify share. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_smb_share_with_http_info(smb_share, smb_share_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SmbShare smb_share: (required)
        :param str smb_share_id: Modify share. All input fields are optional, but one or more must be supplied. (required)
        :param str zone: Specifies which access zone to use.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['smb_share', 'smb_share_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_smb_share" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'smb_share' is set
        if ('smb_share' not in params or
                params['smb_share'] is None):
            raise ValueError("Missing the required parameter `smb_share` when calling `update_smb_share`")  # noqa: E501
        # verify the required parameter 'smb_share_id' is set
        if ('smb_share_id' not in params or
                params['smb_share_id'] is None):
            raise ValueError("Missing the required parameter `smb_share_id` when calling `update_smb_share`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `update_smb_share`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `update_smb_share`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'smb_share_id' in params:
            path_params['SmbShareId'] = params['smb_share_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smb_share' in params:
            body_params = params['smb_share']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/protocols/smb/shares/{SmbShareId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snmp_settings(self, snmp_settings, **kwargs):  # noqa: E501
        """update_snmp_settings  # noqa: E501

        Modify the SNMP settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snmp_settings(snmp_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnmpSettingsExtended snmp_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snmp_settings_with_http_info(snmp_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snmp_settings_with_http_info(snmp_settings, **kwargs)  # noqa: E501
            return data

    def update_snmp_settings_with_http_info(self, snmp_settings, **kwargs):  # noqa: E501
        """update_snmp_settings  # noqa: E501

        Modify the SNMP settings. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snmp_settings_with_http_info(snmp_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnmpSettingsExtended snmp_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snmp_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snmp_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snmp_settings' is set
        if ('snmp_settings' not in params or
                params['snmp_settings'] is None):
            raise ValueError("Missing the required parameter `snmp_settings` when calling `update_snmp_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snmp_settings' in params:
            body_params = params['snmp_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/protocols/snmp/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ssh_settings(self, ssh_settings, **kwargs):  # noqa: E501
        """update_ssh_settings  # noqa: E501

        ssh settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ssh_settings(ssh_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SshSettingsSettings ssh_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ssh_settings_with_http_info(ssh_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ssh_settings_with_http_info(ssh_settings, **kwargs)  # noqa: E501
            return data

    def update_ssh_settings_with_http_info(self, ssh_settings, **kwargs):  # noqa: E501
        """update_ssh_settings  # noqa: E501

        ssh settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ssh_settings_with_http_info(ssh_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SshSettingsSettings ssh_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ssh_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ssh_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ssh_settings' is set
        if ('ssh_settings' not in params or
                params['ssh_settings'] is None):
            raise ValueError("Missing the required parameter `ssh_settings` when calling `update_ssh_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ssh_settings' in params:
            body_params = params['ssh_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/8/protocols/ssh/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_swift_account(self, swift_account, swift_account_id, **kwargs):  # noqa: E501
        """update_swift_account  # noqa: E501

        Modify a Swift account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_swift_account(swift_account, swift_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SwiftAccount swift_account: (required)
        :param str swift_account_id: Modify a Swift account (required)
        :param str zone: Access zone which contains Swift account.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_swift_account_with_http_info(swift_account, swift_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_swift_account_with_http_info(swift_account, swift_account_id, **kwargs)  # noqa: E501
            return data

    def update_swift_account_with_http_info(self, swift_account, swift_account_id, **kwargs):  # noqa: E501
        """update_swift_account  # noqa: E501

        Modify a Swift account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_swift_account_with_http_info(swift_account, swift_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SwiftAccount swift_account: (required)
        :param str swift_account_id: Modify a Swift account (required)
        :param str zone: Access zone which contains Swift account.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['swift_account', 'swift_account_id', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_swift_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'swift_account' is set
        if ('swift_account' not in params or
                params['swift_account'] is None):
            raise ValueError("Missing the required parameter `swift_account` when calling `update_swift_account`")  # noqa: E501
        # verify the required parameter 'swift_account_id' is set
        if ('swift_account_id' not in params or
                params['swift_account_id'] is None):
            raise ValueError("Missing the required parameter `swift_account_id` when calling `update_swift_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'swift_account_id' in params:
            path_params['SwiftAccountId'] = params['swift_account_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'swift_account' in params:
            body_params = params['swift_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/protocols/swift/accounts/{SwiftAccountId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
