# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Tell mypy (a type checker) to ignore all errors from this file.
# See https://mypy.readthedocs.io/en/stable/config_file.html?highlight=ignore-errors#confval-ignore_errors
# mypy: ignore-errors

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime

# Used for default argument values
DEFAULT = object()


class RustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return rust_call(_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return rust_call(_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return rust_call(_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_free, self)

    def __str__(self):
        return "RustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def allocWithBuilder():
        """Context-manger to allocate a buffer using a RustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = RustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consumeWithStream(self):
        """Context-manager to consume a buffer using a RustBufferStream.

        The RustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = RustBufferStream(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer after consuming")
        finally:
            self.free()


class ForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "ForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class RustBufferStream(object):
    """
    Helper for structured reading of bytes from a RustBuffer
    """

    def __init__(self, rbuf):
        self.rbuf = rbuf
        self.offset = 0

    def remaining(self):
        return self.rbuf.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.rbuf.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.rbuf.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.rbuf.len:
            raise InternalError("read past end of rust buffer")
        data = self.rbuf.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def readI8(self):
        return self._unpack_from(1, ">b")

    def readU8(self):
        return self._unpack_from(1, ">B")

    def readI16(self):
        return self._unpack_from(2, ">h")

    def readU16(self):
        return self._unpack_from(2, ">H")

    def readI32(self):
        return self._unpack_from(4, ">i")

    def readU32(self):
        return self._unpack_from(4, ">I")

    def readI64(self):
        return self._unpack_from(8, ">q")

    def readU64(self):
        return self._unpack_from(8, ">Q")

    def readFloat(self):
        v = self._unpack_from(4, ">f")
        return v

    def readDouble(self):
        return self._unpack_from(8, ">d")


class RustBufferBuilder(object):
    """
    Helper for structured writing of bytes into a RustBuffer.
    """

    def __init__(self):
        self.rbuf = RustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, numBytes):
        if self.rbuf.len + numBytes > self.rbuf.capacity:
            self.rbuf = RustBuffer.reserve(self.rbuf, numBytes)
        yield None
        self.rbuf.len += numBytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def writeI8(self, v):
        self._pack_into(1, ">b", v)

    def writeU8(self, v):
        self._pack_into(1, ">B", v)

    def writeI16(self, v):
        self._pack_into(2, ">h", v)

    def writeU16(self, v):
        self._pack_into(2, ">H", v)

    def writeI32(self, v):
        self._pack_into(4, ">i", v)

    def writeU32(self, v):
        self._pack_into(4, ">I", v)

    def writeI64(self, v):
        self._pack_into(8, ">q", v)

    def writeU64(self, v):
        self._pack_into(8, ">Q", v)

    def writeFloat(self, v):
        self._pack_into(4, ">f", v)

    def writeDouble(self, v):
        self._pack_into(8, ">d", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class RustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", RustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == RustCallStatus.CALL_SUCCESS:
            return "RustCallStatus(CALL_SUCCESS)"
        elif self.code == RustCallStatus.CALL_ERROR:
            return "RustCallStatus(CALL_ERROR)"
        elif self.code == RustCallStatus.CALL_PANIC:
            return "RustCallStatus(CALL_PANIC)"
        else:
            return "RustCallStatus(<invalid code>)"

def rust_call(fn, *args):
    # Call a rust function
    return rust_call_with_error(None, fn, *args)

def rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the FFIConverter for the error class that corresponds to the result.
    call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    if call_status.code == RustCallStatus.CALL_SUCCESS:
        return result
    elif call_status.code == RustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.err_buf.contents.free()
            raise InternalError("rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == RustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a RustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = FfiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid RustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: RustBuffer, buf_ptr: *mut RustBuffer) -> int`
FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, RustBuffer, ctypes.POINTER(RustBuffer))
# Types conforming to `FfiConverterPrimitive` pass themselves directly over the FFI.
class FfiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

# Helper class for wrapper types that will always go through a RustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class FfiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consumeWithStream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with RustBuffer.allocWithBuilder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code,
# and the FFI Function declarations in a com.sun.jna.Library.
# This is how we find and load the dynamic library provided by the component.
# For now we just look it up by name.
#
# XXX TODO: This will probably grow some magic for resolving megazording in future.
# E.g. we might start by looking for the named component in `libuniffi.so` and if
# that fails, fall back to loading it separately from `lib${componentName}.so`.

from pathlib import Path

def loadIndirect():
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    lib = libname.format("rgblibffi")
    path = str(Path(__file__).parent / lib)
    return ctypes.cdll.LoadLibrary(path)

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniFFILib = loadIndirect()
_UniFFILib.ffi_rgb_lib_e83b_Wallet_object_free.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_rgb_lib_e83b_Wallet_object_free.restype = None
_UniFFILib.rgb_lib_e83b_Wallet_new.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_new.restype = ctypes.c_void_p
_UniFFILib.rgb_lib_e83b_Wallet_blind.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_blind.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_create_utxos.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_create_utxos.restype = ctypes.c_uint64
_UniFFILib.rgb_lib_e83b_Wallet_create_utxos_begin.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_create_utxos_begin.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_create_utxos_end.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_create_utxos_end.restype = ctypes.c_uint64
_UniFFILib.rgb_lib_e83b_Wallet_delete_transfers.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_delete_transfers.restype = None
_UniFFILib.rgb_lib_e83b_Wallet_drain_to.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_drain_to.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_drain_to_begin.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_drain_to_begin.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_drain_to_end.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_drain_to_end.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_fail_transfers.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_fail_transfers.restype = None
_UniFFILib.rgb_lib_e83b_Wallet_get_address.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_get_address.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_get_asset_balance.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_get_asset_balance.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_go_online.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_go_online.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_issue_asset.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.c_uint8,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_issue_asset.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_list_assets.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_list_assets.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_list_transfers.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_list_transfers.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_list_unspents.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int8,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_list_unspents.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_refresh.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_refresh.restype = None
_UniFFILib.rgb_lib_e83b_Wallet_send.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_send.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_send_begin.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_send_begin.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_Wallet_send_end.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_Wallet_send_end.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_generate_keys.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_generate_keys.restype = RustBuffer
_UniFFILib.rgb_lib_e83b_restore_keys.argtypes = (
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.rgb_lib_e83b_restore_keys.restype = RustBuffer
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_alloc.restype = RustBuffer
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_from_bytes.argtypes = (
    ForeignBytes,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_from_bytes.restype = RustBuffer
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_free.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_free.restype = None
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_reserve.argtypes = (
    RustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_rgb_lib_e83b_rustbuffer_reserve.restype = RustBuffer

# Public interface members begin here.


class FfiConverterUInt8(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU8()

    @staticmethod
    def write(value, buf):
        buf.writeU8(value)

class FfiConverterUInt32(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU32()

    @staticmethod
    def write(value, buf):
        buf.writeU32(value)

class FfiConverterUInt64(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readU64()

    @staticmethod
    def write(value, buf):
        buf.writeU64(value)

class FfiConverterInt64(FfiConverterPrimitive):
    @staticmethod
    def read(buf):
        return buf.readI64()

    @staticmethod
    def write(value, buf):
        buf.writeI64(value)

class FfiConverterBool:
    @classmethod
    def read(cls, buf):
        return cls.lift(buf.readU8())

    @classmethod
    def write(cls, value, buf):
        buf.writeU8(cls.lower(value))

    @staticmethod
    def lift(value):
        return int(value) != 0

    @staticmethod
    def lower(value):
        return 1 if value else 0

class FfiConverterString:
    @staticmethod
    def read(buf):
        size = buf.readI32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8Bytes = buf.read(size)
        return utf8Bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8Bytes = value.encode("utf-8")
        buf.writeI32(len(utf8Bytes))
        buf.write(utf8Bytes)

    @staticmethod
    def lift(buf):
        with buf.consumeWithStream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with RustBuffer.allocWithBuilder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class Wallet(object):
    def __init__(self, wallet_data):
        wallet_data = wallet_data
        
        self._pointer = rust_call_with_error(FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_new,
        FfiConverterTypeWalletData.lower(wallet_data))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.ffi_rgb_lib_e83b_Wallet_object_free, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    

    def blind(self, asset_id,duration_seconds):
        asset_id = (None if asset_id is None else asset_id)
        
        duration_seconds = (None if duration_seconds is None else int(duration_seconds))
        
        return FfiConverterTypeBlindData.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_blind,self._pointer,
        FfiConverterOptionalString.lower(asset_id),
        FfiConverterOptionalUInt32.lower(duration_seconds))
        )
    def create_utxos(self, online):
        online = online
        
        return FfiConverterUInt64.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_create_utxos,self._pointer,
        FfiConverterTypeOnline.lower(online))
        )
    def create_utxos_begin(self, online):
        online = online
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_create_utxos_begin,self._pointer,
        FfiConverterTypeOnline.lower(online))
        )
    def create_utxos_end(self, online,signed_psbt):
        online = online
        
        signed_psbt = signed_psbt
        
        return FfiConverterUInt64.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_create_utxos_end,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(signed_psbt))
        )
    def delete_transfers(self, blinded_utxo):
        blinded_utxo = (None if blinded_utxo is None else blinded_utxo)
        
        rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_delete_transfers,self._pointer,
        FfiConverterOptionalString.lower(blinded_utxo))
    
    def drain_to(self, online,address,destroy_assets):
        online = online
        
        address = address
        
        destroy_assets = bool(destroy_assets)
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_drain_to,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(address),
        FfiConverterBool.lower(destroy_assets))
        )
    def drain_to_begin(self, online,address,destroy_assets):
        online = online
        
        address = address
        
        destroy_assets = bool(destroy_assets)
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_drain_to_begin,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(address),
        FfiConverterBool.lower(destroy_assets))
        )
    def drain_to_end(self, online,signed_psbt):
        online = online
        
        signed_psbt = signed_psbt
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_drain_to_end,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(signed_psbt))
        )
    def fail_transfers(self, online,blinded_utxo):
        online = online
        
        blinded_utxo = (None if blinded_utxo is None else blinded_utxo)
        
        rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_fail_transfers,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterOptionalString.lower(blinded_utxo))
    
    def get_address(self, ):
        return FfiConverterString.lift(
            rust_call(_UniFFILib.rgb_lib_e83b_Wallet_get_address,self._pointer,)
        )
    def get_asset_balance(self, asset_id):
        asset_id = asset_id
        
        return FfiConverterTypeBalance.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_get_asset_balance,self._pointer,
        FfiConverterString.lower(asset_id))
        )
    def go_online(self, electrum_url,skip_consistency_check):
        electrum_url = electrum_url
        
        skip_consistency_check = bool(skip_consistency_check)
        
        return FfiConverterTypeOnline.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_go_online,self._pointer,
        FfiConverterString.lower(electrum_url),
        FfiConverterBool.lower(skip_consistency_check))
        )
    def issue_asset(self, online,ticker,name,precision,amount):
        online = online
        
        ticker = ticker
        
        name = name
        
        precision = int(precision)
        
        amount = int(amount)
        
        return FfiConverterTypeAsset.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_issue_asset,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(ticker),
        FfiConverterString.lower(name),
        FfiConverterUInt8.lower(precision),
        FfiConverterUInt64.lower(amount))
        )
    def list_assets(self, ):
        return FfiConverterSequenceTypeAsset.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_list_assets,self._pointer,)
        )
    def list_transfers(self, asset_id):
        asset_id = asset_id
        
        return FfiConverterSequenceTypeTransfer.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_list_transfers,self._pointer,
        FfiConverterString.lower(asset_id))
        )
    def list_unspents(self, settled_only):
        settled_only = bool(settled_only)
        
        return FfiConverterSequenceTypeUnspent.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_list_unspents,self._pointer,
        FfiConverterBool.lower(settled_only))
        )
    def refresh(self, online,asset_id):
        online = online
        
        asset_id = (None if asset_id is None else asset_id)
        
        rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_refresh,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterOptionalString.lower(asset_id))
    
    def send(self, online,asset_id,blinded_utxo,amount):
        online = online
        
        asset_id = asset_id
        
        blinded_utxo = blinded_utxo
        
        amount = int(amount)
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_send,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(asset_id),
        FfiConverterString.lower(blinded_utxo),
        FfiConverterUInt64.lower(amount))
        )
    def send_begin(self, online,asset_id,blinded_utxo,amount):
        online = online
        
        asset_id = asset_id
        
        blinded_utxo = blinded_utxo
        
        amount = int(amount)
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_send_begin,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(asset_id),
        FfiConverterString.lower(blinded_utxo),
        FfiConverterUInt64.lower(amount))
        )
    def send_end(self, online,signed_psbt):
        online = online
        
        signed_psbt = signed_psbt
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_Wallet_send_end,self._pointer,
        FfiConverterTypeOnline.lower(online),
        FfiConverterString.lower(signed_psbt))
        )
    


class FfiConverterTypeWallet:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Wallet):
            raise TypeError("Expected Wallet instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Wallet._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer


class Asset:

    def __init__(self, asset_id, ticker, name, precision, balance):
        self.asset_id = asset_id
        self.ticker = ticker
        self.name = name
        self.precision = precision
        self.balance = balance

    def __str__(self):
        return "Asset(asset_id={}, ticker={}, name={}, precision={}, balance={})".format(self.asset_id, self.ticker, self.name, self.precision, self.balance)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.ticker != other.ticker:
            return False
        if self.name != other.name:
            return False
        if self.precision != other.precision:
            return False
        if self.balance != other.balance:
            return False
        return True

class FfiConverterTypeAsset(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Asset(
            asset_id=FfiConverterString.read(buf),
            ticker=FfiConverterString.read(buf),
            name=FfiConverterString.read(buf),
            precision=FfiConverterUInt8.read(buf),
            balance=FfiConverterTypeBalance.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.asset_id, buf)
        FfiConverterString.write(value.ticker, buf)
        FfiConverterString.write(value.name, buf)
        FfiConverterUInt8.write(value.precision, buf)
        FfiConverterTypeBalance.write(value.balance, buf)


class Balance:

    def __init__(self, settled, future):
        self.settled = settled
        self.future = future

    def __str__(self):
        return "Balance(settled={}, future={})".format(self.settled, self.future)

    def __eq__(self, other):
        if self.settled != other.settled:
            return False
        if self.future != other.future:
            return False
        return True

class FfiConverterTypeBalance(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Balance(
            settled=FfiConverterUInt64.read(buf),
            future=FfiConverterUInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.settled, buf)
        FfiConverterUInt64.write(value.future, buf)


class BlindData:

    def __init__(self, blinded_utxo, blinding_secret, expiration_timestamp):
        self.blinded_utxo = blinded_utxo
        self.blinding_secret = blinding_secret
        self.expiration_timestamp = expiration_timestamp

    def __str__(self):
        return "BlindData(blinded_utxo={}, blinding_secret={}, expiration_timestamp={})".format(self.blinded_utxo, self.blinding_secret, self.expiration_timestamp)

    def __eq__(self, other):
        if self.blinded_utxo != other.blinded_utxo:
            return False
        if self.blinding_secret != other.blinding_secret:
            return False
        if self.expiration_timestamp != other.expiration_timestamp:
            return False
        return True

class FfiConverterTypeBlindData(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BlindData(
            blinded_utxo=FfiConverterString.read(buf),
            blinding_secret=FfiConverterUInt64.read(buf),
            expiration_timestamp=FfiConverterOptionalInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.blinded_utxo, buf)
        FfiConverterUInt64.write(value.blinding_secret, buf)
        FfiConverterOptionalInt64.write(value.expiration_timestamp, buf)


class Keys:

    def __init__(self, mnemonic, xpub, xpub_fingerprint):
        self.mnemonic = mnemonic
        self.xpub = xpub
        self.xpub_fingerprint = xpub_fingerprint

    def __str__(self):
        return "Keys(mnemonic={}, xpub={}, xpub_fingerprint={})".format(self.mnemonic, self.xpub, self.xpub_fingerprint)

    def __eq__(self, other):
        if self.mnemonic != other.mnemonic:
            return False
        if self.xpub != other.xpub:
            return False
        if self.xpub_fingerprint != other.xpub_fingerprint:
            return False
        return True

class FfiConverterTypeKeys(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Keys(
            mnemonic=FfiConverterString.read(buf),
            xpub=FfiConverterString.read(buf),
            xpub_fingerprint=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.mnemonic, buf)
        FfiConverterString.write(value.xpub, buf)
        FfiConverterString.write(value.xpub_fingerprint, buf)


class Online:

    def __init__(self, id, electrum_url):
        self.id = id
        self.electrum_url = electrum_url

    def __str__(self):
        return "Online(id={}, electrum_url={})".format(self.id, self.electrum_url)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.electrum_url != other.electrum_url:
            return False
        return True

class FfiConverterTypeOnline(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Online(
            id=FfiConverterUInt64.read(buf),
            electrum_url=FfiConverterString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterUInt64.write(value.id, buf)
        FfiConverterString.write(value.electrum_url, buf)


class Outpoint:

    def __init__(self, txid, vout):
        self.txid = txid
        self.vout = vout

    def __str__(self):
        return "Outpoint(txid={}, vout={})".format(self.txid, self.vout)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        return True

class FfiConverterTypeOutpoint(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Outpoint(
            txid=FfiConverterString.read(buf),
            vout=FfiConverterUInt32.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.txid, buf)
        FfiConverterUInt32.write(value.vout, buf)


class RgbAllocation:

    def __init__(self, asset_id, amount, settled):
        self.asset_id = asset_id
        self.amount = amount
        self.settled = settled

    def __str__(self):
        return "RgbAllocation(asset_id={}, amount={}, settled={})".format(self.asset_id, self.amount, self.settled)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.amount != other.amount:
            return False
        if self.settled != other.settled:
            return False
        return True

class FfiConverterTypeRgbAllocation(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RgbAllocation(
            asset_id=FfiConverterOptionalString.read(buf),
            amount=FfiConverterUInt64.read(buf),
            settled=FfiConverterBool.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterOptionalString.write(value.asset_id, buf)
        FfiConverterUInt64.write(value.amount, buf)
        FfiConverterBool.write(value.settled, buf)


class Transfer:

    def __init__(self, idx, created_at, updated_at, status, received, sent, txid, blinded_utxo, unblinded_utxo, change_utxo, blinding_secret, expiration):
        self.idx = idx
        self.created_at = created_at
        self.updated_at = updated_at
        self.status = status
        self.received = received
        self.sent = sent
        self.txid = txid
        self.blinded_utxo = blinded_utxo
        self.unblinded_utxo = unblinded_utxo
        self.change_utxo = change_utxo
        self.blinding_secret = blinding_secret
        self.expiration = expiration

    def __str__(self):
        return "Transfer(idx={}, created_at={}, updated_at={}, status={}, received={}, sent={}, txid={}, blinded_utxo={}, unblinded_utxo={}, change_utxo={}, blinding_secret={}, expiration={})".format(self.idx, self.created_at, self.updated_at, self.status, self.received, self.sent, self.txid, self.blinded_utxo, self.unblinded_utxo, self.change_utxo, self.blinding_secret, self.expiration)

    def __eq__(self, other):
        if self.idx != other.idx:
            return False
        if self.created_at != other.created_at:
            return False
        if self.updated_at != other.updated_at:
            return False
        if self.status != other.status:
            return False
        if self.received != other.received:
            return False
        if self.sent != other.sent:
            return False
        if self.txid != other.txid:
            return False
        if self.blinded_utxo != other.blinded_utxo:
            return False
        if self.unblinded_utxo != other.unblinded_utxo:
            return False
        if self.change_utxo != other.change_utxo:
            return False
        if self.blinding_secret != other.blinding_secret:
            return False
        if self.expiration != other.expiration:
            return False
        return True

class FfiConverterTypeTransfer(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Transfer(
            idx=FfiConverterInt64.read(buf),
            created_at=FfiConverterInt64.read(buf),
            updated_at=FfiConverterInt64.read(buf),
            status=FfiConverterTypeTransferStatus.read(buf),
            received=FfiConverterUInt64.read(buf),
            sent=FfiConverterUInt64.read(buf),
            txid=FfiConverterOptionalString.read(buf),
            blinded_utxo=FfiConverterOptionalString.read(buf),
            unblinded_utxo=FfiConverterOptionalTypeOutpoint.read(buf),
            change_utxo=FfiConverterOptionalTypeOutpoint.read(buf),
            blinding_secret=FfiConverterOptionalUInt64.read(buf),
            expiration=FfiConverterOptionalInt64.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterInt64.write(value.idx, buf)
        FfiConverterInt64.write(value.created_at, buf)
        FfiConverterInt64.write(value.updated_at, buf)
        FfiConverterTypeTransferStatus.write(value.status, buf)
        FfiConverterUInt64.write(value.received, buf)
        FfiConverterUInt64.write(value.sent, buf)
        FfiConverterOptionalString.write(value.txid, buf)
        FfiConverterOptionalString.write(value.blinded_utxo, buf)
        FfiConverterOptionalTypeOutpoint.write(value.unblinded_utxo, buf)
        FfiConverterOptionalTypeOutpoint.write(value.change_utxo, buf)
        FfiConverterOptionalUInt64.write(value.blinding_secret, buf)
        FfiConverterOptionalInt64.write(value.expiration, buf)


class Unspent:

    def __init__(self, utxo, rgb_allocations):
        self.utxo = utxo
        self.rgb_allocations = rgb_allocations

    def __str__(self):
        return "Unspent(utxo={}, rgb_allocations={})".format(self.utxo, self.rgb_allocations)

    def __eq__(self, other):
        if self.utxo != other.utxo:
            return False
        if self.rgb_allocations != other.rgb_allocations:
            return False
        return True

class FfiConverterTypeUnspent(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Unspent(
            utxo=FfiConverterTypeUtxo.read(buf),
            rgb_allocations=FfiConverterSequenceTypeRgbAllocation.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypeUtxo.write(value.utxo, buf)
        FfiConverterSequenceTypeRgbAllocation.write(value.rgb_allocations, buf)


class Utxo:

    def __init__(self, outpoint, btc_amount, colorable):
        self.outpoint = outpoint
        self.btc_amount = btc_amount
        self.colorable = colorable

    def __str__(self):
        return "Utxo(outpoint={}, btc_amount={}, colorable={})".format(self.outpoint, self.btc_amount, self.colorable)

    def __eq__(self, other):
        if self.outpoint != other.outpoint:
            return False
        if self.btc_amount != other.btc_amount:
            return False
        if self.colorable != other.colorable:
            return False
        return True

class FfiConverterTypeUtxo(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Utxo(
            outpoint=FfiConverterTypeOutpoint.read(buf),
            btc_amount=FfiConverterUInt64.read(buf),
            colorable=FfiConverterBool.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterTypeOutpoint.write(value.outpoint, buf)
        FfiConverterUInt64.write(value.btc_amount, buf)
        FfiConverterBool.write(value.colorable, buf)


class WalletData:

    def __init__(self, data_dir, bitcoin_network, database_type, pubkey, mnemonic):
        self.data_dir = data_dir
        self.bitcoin_network = bitcoin_network
        self.database_type = database_type
        self.pubkey = pubkey
        self.mnemonic = mnemonic

    def __str__(self):
        return "WalletData(data_dir={}, bitcoin_network={}, database_type={}, pubkey={}, mnemonic={})".format(self.data_dir, self.bitcoin_network, self.database_type, self.pubkey, self.mnemonic)

    def __eq__(self, other):
        if self.data_dir != other.data_dir:
            return False
        if self.bitcoin_network != other.bitcoin_network:
            return False
        if self.database_type != other.database_type:
            return False
        if self.pubkey != other.pubkey:
            return False
        if self.mnemonic != other.mnemonic:
            return False
        return True

class FfiConverterTypeWalletData(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return WalletData(
            data_dir=FfiConverterString.read(buf),
            bitcoin_network=FfiConverterTypeBitcoinNetwork.read(buf),
            database_type=FfiConverterTypeDatabaseType.read(buf),
            pubkey=FfiConverterString.read(buf),
            mnemonic=FfiConverterOptionalString.read(buf),
        )

    @staticmethod
    def write(value, buf):
        FfiConverterString.write(value.data_dir, buf)
        FfiConverterTypeBitcoinNetwork.write(value.bitcoin_network, buf)
        FfiConverterTypeDatabaseType.write(value.database_type, buf)
        FfiConverterString.write(value.pubkey, buf)
        FfiConverterOptionalString.write(value.mnemonic, buf)




class BitcoinNetwork(enum.Enum):
    MAINNET = 1
    TESTNET = 2
    SIGNET = 3
    REGTEST = 4
    


class FfiConverterTypeBitcoinNetwork(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return BitcoinNetwork.MAINNET
        if variant == 2:
            return BitcoinNetwork.TESTNET
        if variant == 3:
            return BitcoinNetwork.SIGNET
        if variant == 4:
            return BitcoinNetwork.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == BitcoinNetwork.MAINNET:
            buf.writeI32(1)
        if value == BitcoinNetwork.TESTNET:
            buf.writeI32(2)
        if value == BitcoinNetwork.SIGNET:
            buf.writeI32(3)
        if value == BitcoinNetwork.REGTEST:
            buf.writeI32(4)




class DatabaseType(enum.Enum):
    SQLITE = 1
    


class FfiConverterTypeDatabaseType(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return DatabaseType.SQLITE
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == DatabaseType.SQLITE:
            buf.writeI32(1)




class TransferStatus(enum.Enum):
    WAITING_COUNTERPARTY = 1
    WAITING_CONFIRMATIONS = 2
    SETTLED = 3
    FAILED = 4
    


class FfiConverterTypeTransferStatus(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return TransferStatus.WAITING_COUNTERPARTY
        if variant == 2:
            return TransferStatus.WAITING_CONFIRMATIONS
        if variant == 3:
            return TransferStatus.SETTLED
        if variant == 4:
            return TransferStatus.FAILED
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == TransferStatus.WAITING_COUNTERPARTY:
            buf.writeI32(1)
        if value == TransferStatus.WAITING_CONFIRMATIONS:
            buf.writeI32(2)
        if value == TransferStatus.SETTLED:
            buf.writeI32(3)
        if value == TransferStatus.FAILED:
            buf.writeI32(4)


class RgbLibError(Exception):

    # Each variant is a nested class of the error itself.
    # It just carries a string error message, so no special implementation is necessary.
    class AllocationsAlreadyAvailable(Exception):
        pass
    class AssetNotFound(Exception):
        pass
    class BlindedUtxoAlreadyUsed(Exception):
        pass
    class CannotChangeOnline(Exception):
        pass
    class CannotDeleteTransfer(Exception):
        pass
    class CannotFailTransfer(Exception):
        pass
    class ConsignmentProxy(Exception):
        pass
    class Electrum(Exception):
        pass
    class FailedBdkSync(Exception):
        pass
    class FailedBroadcast(Exception):
        pass
    class FailedIssuance(Exception):
        pass
    class Io(Exception):
        pass
    class Inconsistency(Exception):
        pass
    class InexistentDataDir(Exception):
        pass
    class InsufficientAllocationSlots(Exception):
        pass
    class InsufficientAssets(Exception):
        pass
    class InsufficientFunds(Exception):
        pass
    class Internal(Exception):
        pass
    class InvalidAddress(Exception):
        pass
    class InvalidBitcoinKeys(Exception):
        pass
    class InvalidBlindedUtxo(Exception):
        pass
    class InvalidElectrum(Exception):
        pass
    class InvalidMnemonic(Exception):
        pass
    class InvalidName(Exception):
        pass
    class InvalidOnline(Exception):
        pass
    class InvalidPsbt(Exception):
        pass
    class InvalidPubkey(Exception):
        pass
    class InvalidTicker(Exception):
        pass
    class TransferNotFound(Exception):
        pass
    class WatchOnly(Exception):
        pass

class FfiConverterTypeRgbLibError(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return RgbLibError.AllocationsAlreadyAvailable(
                FfiConverterString.read(buf),
            )
        if variant == 2:
            return RgbLibError.AssetNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 3:
            return RgbLibError.BlindedUtxoAlreadyUsed(
                FfiConverterString.read(buf),
            )
        if variant == 4:
            return RgbLibError.CannotChangeOnline(
                FfiConverterString.read(buf),
            )
        if variant == 5:
            return RgbLibError.CannotDeleteTransfer(
                FfiConverterString.read(buf),
            )
        if variant == 6:
            return RgbLibError.CannotFailTransfer(
                FfiConverterString.read(buf),
            )
        if variant == 7:
            return RgbLibError.ConsignmentProxy(
                FfiConverterString.read(buf),
            )
        if variant == 8:
            return RgbLibError.Electrum(
                FfiConverterString.read(buf),
            )
        if variant == 9:
            return RgbLibError.FailedBdkSync(
                FfiConverterString.read(buf),
            )
        if variant == 10:
            return RgbLibError.FailedBroadcast(
                FfiConverterString.read(buf),
            )
        if variant == 11:
            return RgbLibError.FailedIssuance(
                FfiConverterString.read(buf),
            )
        if variant == 12:
            return RgbLibError.Io(
                FfiConverterString.read(buf),
            )
        if variant == 13:
            return RgbLibError.Inconsistency(
                FfiConverterString.read(buf),
            )
        if variant == 14:
            return RgbLibError.InexistentDataDir(
                FfiConverterString.read(buf),
            )
        if variant == 15:
            return RgbLibError.InsufficientAllocationSlots(
                FfiConverterString.read(buf),
            )
        if variant == 16:
            return RgbLibError.InsufficientAssets(
                FfiConverterString.read(buf),
            )
        if variant == 17:
            return RgbLibError.InsufficientFunds(
                FfiConverterString.read(buf),
            )
        if variant == 18:
            return RgbLibError.Internal(
                FfiConverterString.read(buf),
            )
        if variant == 19:
            return RgbLibError.InvalidAddress(
                FfiConverterString.read(buf),
            )
        if variant == 20:
            return RgbLibError.InvalidBitcoinKeys(
                FfiConverterString.read(buf),
            )
        if variant == 21:
            return RgbLibError.InvalidBlindedUtxo(
                FfiConverterString.read(buf),
            )
        if variant == 22:
            return RgbLibError.InvalidElectrum(
                FfiConverterString.read(buf),
            )
        if variant == 23:
            return RgbLibError.InvalidMnemonic(
                FfiConverterString.read(buf),
            )
        if variant == 24:
            return RgbLibError.InvalidName(
                FfiConverterString.read(buf),
            )
        if variant == 25:
            return RgbLibError.InvalidOnline(
                FfiConverterString.read(buf),
            )
        if variant == 26:
            return RgbLibError.InvalidPsbt(
                FfiConverterString.read(buf),
            )
        if variant == 27:
            return RgbLibError.InvalidPubkey(
                FfiConverterString.read(buf),
            )
        if variant == 28:
            return RgbLibError.InvalidTicker(
                FfiConverterString.read(buf),
            )
        if variant == 29:
            return RgbLibError.TransferNotFound(
                FfiConverterString.read(buf),
            )
        if variant == 30:
            return RgbLibError.WatchOnly(
                FfiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def write(value, buf):
        if isinstance(value, RgbLibError.AllocationsAlreadyAvailable):
            buf.writeI32(1)
        if isinstance(value, RgbLibError.AssetNotFound):
            buf.writeI32(2)
        if isinstance(value, RgbLibError.BlindedUtxoAlreadyUsed):
            buf.writeI32(3)
        if isinstance(value, RgbLibError.CannotChangeOnline):
            buf.writeI32(4)
        if isinstance(value, RgbLibError.CannotDeleteTransfer):
            buf.writeI32(5)
        if isinstance(value, RgbLibError.CannotFailTransfer):
            buf.writeI32(6)
        if isinstance(value, RgbLibError.ConsignmentProxy):
            buf.writeI32(7)
        if isinstance(value, RgbLibError.Electrum):
            buf.writeI32(8)
        if isinstance(value, RgbLibError.FailedBdkSync):
            buf.writeI32(9)
        if isinstance(value, RgbLibError.FailedBroadcast):
            buf.writeI32(10)
        if isinstance(value, RgbLibError.FailedIssuance):
            buf.writeI32(11)
        if isinstance(value, RgbLibError.Io):
            buf.writeI32(12)
        if isinstance(value, RgbLibError.Inconsistency):
            buf.writeI32(13)
        if isinstance(value, RgbLibError.InexistentDataDir):
            buf.writeI32(14)
        if isinstance(value, RgbLibError.InsufficientAllocationSlots):
            buf.writeI32(15)
        if isinstance(value, RgbLibError.InsufficientAssets):
            buf.writeI32(16)
        if isinstance(value, RgbLibError.InsufficientFunds):
            buf.writeI32(17)
        if isinstance(value, RgbLibError.Internal):
            buf.writeI32(18)
        if isinstance(value, RgbLibError.InvalidAddress):
            buf.writeI32(19)
        if isinstance(value, RgbLibError.InvalidBitcoinKeys):
            buf.writeI32(20)
        if isinstance(value, RgbLibError.InvalidBlindedUtxo):
            buf.writeI32(21)
        if isinstance(value, RgbLibError.InvalidElectrum):
            buf.writeI32(22)
        if isinstance(value, RgbLibError.InvalidMnemonic):
            buf.writeI32(23)
        if isinstance(value, RgbLibError.InvalidName):
            buf.writeI32(24)
        if isinstance(value, RgbLibError.InvalidOnline):
            buf.writeI32(25)
        if isinstance(value, RgbLibError.InvalidPsbt):
            buf.writeI32(26)
        if isinstance(value, RgbLibError.InvalidPubkey):
            buf.writeI32(27)
        if isinstance(value, RgbLibError.InvalidTicker):
            buf.writeI32(28)
        if isinstance(value, RgbLibError.TransferNotFound):
            buf.writeI32(29)
        if isinstance(value, RgbLibError.WatchOnly):
            buf.writeI32(30)



class FfiConverterOptionalUInt32(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalUInt64(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalInt64(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalString(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterOptionalTypeOutpoint(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterTypeOutpoint.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterTypeOutpoint.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class FfiConverterSequenceTypeAsset(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeAsset.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeAsset.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeRgbAllocation(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeRgbAllocation.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeRgbAllocation.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeTransfer(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeTransfer.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeTransfer.read(buf) for i in range(count)
        ]



class FfiConverterSequenceTypeUnspent(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.writeI32(items)
        for item in value:
            FfiConverterTypeUnspent.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.readI32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            FfiConverterTypeUnspent.read(buf) for i in range(count)
        ]

def generate_keys(bitcoin_network):
    bitcoin_network = bitcoin_network
    
    return FfiConverterTypeKeys.lift(rust_call(_UniFFILib.rgb_lib_e83b_generate_keys,
        FfiConverterTypeBitcoinNetwork.lower(bitcoin_network)))



def restore_keys(bitcoin_network,mnemonic):
    bitcoin_network = bitcoin_network
    
    mnemonic = mnemonic
    
    return FfiConverterTypeKeys.lift(rust_call_with_error(FfiConverterTypeRgbLibError,_UniFFILib.rgb_lib_e83b_restore_keys,
        FfiConverterTypeBitcoinNetwork.lower(bitcoin_network),
        FfiConverterString.lower(mnemonic)))



__all__ = [
    "InternalError",
    "BitcoinNetwork",
    "DatabaseType",
    "TransferStatus",
    "Asset",
    "Balance",
    "BlindData",
    "Keys",
    "Online",
    "Outpoint",
    "RgbAllocation",
    "Transfer",
    "Unspent",
    "Utxo",
    "WalletData",
    "generate_keys",
    "restore_keys",
    "Wallet",
    "RgbLibError",
]

