# SlurmGen - Simple Slurm Manager

> * **Repository: [github.com/otvam/slurmgen](https://github.com/otvam/slurmgen)**
> * **PyPi: [pypi.org/project/slurmgen](https://pypi.org/project/slurmgen)**
> * **Conda: [anaconda.org/conda-forge/slurmgen](https://anaconda.org/conda-forge/slurmgen)**

## Summary

**SlurmGen** is a very **simple** **Slurm** manager:
* The job description is stored in JSON files.
* The JSON files are transformed into Slurm scripts.
* The Slurm script can be run locally or on a Slurm Cluster.

**SlurmGen** is only supporting a small **subset** of **Slurm**:
* Create and delete folders.
* Set environment variables.
* Set the job name and log.
* Set the ressources (memory, time, CPU, etc.).
* Define the set of commands to be executed.

SlurmGen is not a binding and/or a wrapper for Slurm.
SlurmGen is only generating Slurm scripts from JSON files.
SlurmGen is written in Python without any external dependencies.

## Example

An example is located in the `example` folder of the repository:
* `job_def.json` contains the job definition
* `job_tmpl.json` contains the template data
* `run_slurm.py` contains is dummy script executed by the Slurm job
* `slurm_output` contains the generated Slurm script and log file
* `data_output` contains data generated by the Slurm job

```bash
# Create a Slurm script with a command line template.
sgen job_def.json --tmpl_str "title" "test" --tmpl_str "var" "Welcome to everyone"

# Create a Slurm script with a JSON file template.
sgen job_def.json --tmpl_file job_tmpl.json

# Create a Slurm script and run the job locally.
sgen job_def.json --local --tmpl_file job_tmpl.json

# Create a Slurm script and run the job on the cluster.
sgen job_def.json --cluster --tmpl_file job_tmpl.json
```

## Project Links

* Repository: https://github.com/otvam/slurmgen
* Releases: https://github.com/otvam/slurmgen/releases
* Tags: https://github.com/otvam/slurmgen/tags
* Issues: https://github.com/otvam/slurmgen/issues
* PyPi: https://pypi.org/project/slurmgen
* Conda: https://anaconda.org/conda-forge/slurmgen

## Author

* **Thomas Guillod**
* Email: guillod@otvam.ch
* Website: https://otvam.ch

## Copyright

> (c) 2023 - Thomas Guillod
> 
>  BSD 2-Clause "Simplified" License
