# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetLbFrontendsResult',
    'AwaitableGetLbFrontendsResult',
    'get_lb_frontends',
    'get_lb_frontends_output',
]

@pulumi.output_type
class GetLbFrontendsResult:
    """
    A collection of values returned by getLbFrontends.
    """
    def __init__(__self__, frontends=None, id=None, lb_id=None, name=None, organization_id=None, project_id=None, zone=None):
        if frontends and not isinstance(frontends, list):
            raise TypeError("Expected argument 'frontends' to be a list")
        pulumi.set(__self__, "frontends", frontends)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lb_id and not isinstance(lb_id, str):
            raise TypeError("Expected argument 'lb_id' to be a str")
        pulumi.set(__self__, "lb_id", lb_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def frontends(self) -> Sequence['outputs.GetLbFrontendsFrontendResult']:
        """
        List of found frontends
        """
        return pulumi.get(self, "frontends")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> str:
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetLbFrontendsResult(GetLbFrontendsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbFrontendsResult(
            frontends=self.frontends,
            id=self.id,
            lb_id=self.lb_id,
            name=self.name,
            organization_id=self.organization_id,
            project_id=self.project_id,
            zone=self.zone)


def get_lb_frontends(lb_id: Optional[str] = None,
                     name: Optional[str] = None,
                     project_id: Optional[str] = None,
                     zone: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbFrontendsResult:
    """
    Gets information about multiple Load Balancer Frontends.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_lbid = scaleway.get_lb_frontends(lb_id=scaleway_lb["lb01"]["id"])
    by_lbid_and_name = scaleway.get_lb_frontends(lb_id=scaleway_lb["lb01"]["id"],
        name="tf-frontend-datasource")
    ```


    :param str lb_id: The load-balancer ID this frontend is attached to. frontends with a LB ID like it are listed.
    :param str name: The frontend name used as filter. Frontends with a name like it are listed.
    :param str zone: `zone`) The zone in which frontends exist.
    """
    __args__ = dict()
    __args__['lbId'] = lb_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getLbFrontends:getLbFrontends', __args__, opts=opts, typ=GetLbFrontendsResult).value

    return AwaitableGetLbFrontendsResult(
        frontends=pulumi.get(__ret__, 'frontends'),
        id=pulumi.get(__ret__, 'id'),
        lb_id=pulumi.get(__ret__, 'lb_id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        zone=pulumi.get(__ret__, 'zone'))


@_utilities.lift_output_func(get_lb_frontends)
def get_lb_frontends_output(lb_id: Optional[pulumi.Input[str]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            project_id: Optional[pulumi.Input[Optional[str]]] = None,
                            zone: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLbFrontendsResult]:
    """
    Gets information about multiple Load Balancer Frontends.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_lbid = scaleway.get_lb_frontends(lb_id=scaleway_lb["lb01"]["id"])
    by_lbid_and_name = scaleway.get_lb_frontends(lb_id=scaleway_lb["lb01"]["id"],
        name="tf-frontend-datasource")
    ```


    :param str lb_id: The load-balancer ID this frontend is attached to. frontends with a LB ID like it are listed.
    :param str name: The frontend name used as filter. Frontends with a name like it are listed.
    :param str zone: `zone`) The zone in which frontends exist.
    """
    ...
