# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetIamGroupResult',
    'AwaitableGetIamGroupResult',
    'get_iam_group',
    'get_iam_group_output',
]

@pulumi.output_type
class GetIamGroupResult:
    """
    A collection of values returned by getIamGroup.
    """
    def __init__(__self__, application_ids=None, created_at=None, description=None, external_membership=None, group_id=None, id=None, name=None, organization_id=None, tags=None, updated_at=None, user_ids=None):
        if application_ids and not isinstance(application_ids, list):
            raise TypeError("Expected argument 'application_ids' to be a list")
        pulumi.set(__self__, "application_ids", application_ids)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if external_membership and not isinstance(external_membership, bool):
            raise TypeError("Expected argument 'external_membership' to be a bool")
        pulumi.set(__self__, "external_membership", external_membership)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_ids and not isinstance(user_ids, list):
            raise TypeError("Expected argument 'user_ids' to be a list")
        pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="applicationIds")
    def application_ids(self) -> Sequence[str]:
        return pulumi.get(self, "application_ids")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalMembership")
    def external_membership(self) -> bool:
        return pulumi.get(self, "external_membership")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[str]:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Sequence[str]:
        return pulumi.get(self, "user_ids")


class AwaitableGetIamGroupResult(GetIamGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamGroupResult(
            application_ids=self.application_ids,
            created_at=self.created_at,
            description=self.description,
            external_membership=self.external_membership,
            group_id=self.group_id,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            tags=self.tags,
            updated_at=self.updated_at,
            user_ids=self.user_ids)


def get_iam_group(group_id: Optional[str] = None,
                  name: Optional[str] = None,
                  organization_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamGroupResult:
    """
    Gets information about an existing IAM group. For more information, please
    check [the documentation](https://developers.scaleway.com/en/products/iam/api/v1alpha1/#applications-83ce5e)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.get_iam_group(name="foobar")
    find_by_id = scaleway.get_iam_group(group_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str group_id: The ID of the IAM group.
           Only one of the `name` and `group_id` should be specified.
    :param str name: The name of the IAM group.
           Only one of the `name` and `group_id` should be specified.
    :param str organization_id: `organization_id`) The ID of the
           organization the group is associated with.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getIamGroup:getIamGroup', __args__, opts=opts, typ=GetIamGroupResult).value

    return AwaitableGetIamGroupResult(
        application_ids=pulumi.get(__ret__, 'application_ids'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        external_membership=pulumi.get(__ret__, 'external_membership'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_ids=pulumi.get(__ret__, 'user_ids'))


@_utilities.lift_output_func(get_iam_group)
def get_iam_group_output(group_id: Optional[pulumi.Input[Optional[str]]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         organization_id: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIamGroupResult]:
    """
    Gets information about an existing IAM group. For more information, please
    check [the documentation](https://developers.scaleway.com/en/products/iam/api/v1alpha1/#applications-83ce5e)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    find_by_name = scaleway.get_iam_group(name="foobar")
    find_by_id = scaleway.get_iam_group(group_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str group_id: The ID of the IAM group.
           Only one of the `name` and `group_id` should be specified.
    :param str name: The name of the IAM group.
           Only one of the `name` and `group_id` should be specified.
    :param str organization_id: `organization_id`) The ID of the
           organization the group is associated with.
    """
    ...
