# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDocumentdbLoadBalancerEndpointResult',
    'AwaitableGetDocumentdbLoadBalancerEndpointResult',
    'get_documentdb_load_balancer_endpoint',
    'get_documentdb_load_balancer_endpoint_output',
]

@pulumi.output_type
class GetDocumentdbLoadBalancerEndpointResult:
    """
    A collection of values returned by getDocumentdbLoadBalancerEndpoint.
    """
    def __init__(__self__, hostname=None, id=None, instance_id=None, instance_name=None, ip=None, name=None, port=None, project_id=None, region=None):
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname of your endpoint.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The IP of your load balancer service.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of your load balancer service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port of your load balancer service.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetDocumentdbLoadBalancerEndpointResult(GetDocumentdbLoadBalancerEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDocumentdbLoadBalancerEndpointResult(
            hostname=self.hostname,
            id=self.id,
            instance_id=self.instance_id,
            instance_name=self.instance_name,
            ip=self.ip,
            name=self.name,
            port=self.port,
            project_id=self.project_id,
            region=self.region)


def get_documentdb_load_balancer_endpoint(instance_id: Optional[str] = None,
                                          instance_name: Optional[str] = None,
                                          project_id: Optional[str] = None,
                                          region: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDocumentdbLoadBalancerEndpointResult:
    """
    Gets information about an DocumentDB load balancer endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_endpoint = scaleway.get_documentdb_load_balancer_endpoint(instance_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str instance_id: The DocumentDB Instance on which the endpoint is attached. Only one of `instance_name` and `instance_id` should be specified.
    :param str instance_name: The DocumentDB Instance Name on which the endpoint is attached. Only one of `instance_name` and `instance_id` should be specified.
    :param str project_id: The ID of the project the DocumentDB endpoint is associated with.
    :param str region: `region`) The region in which the DocumentDB endpoint exists.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['instanceName'] = instance_name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getDocumentdbLoadBalancerEndpoint:getDocumentdbLoadBalancerEndpoint', __args__, opts=opts, typ=GetDocumentdbLoadBalancerEndpointResult).value

    return AwaitableGetDocumentdbLoadBalancerEndpointResult(
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        ip=pulumi.get(__ret__, 'ip'),
        name=pulumi.get(__ret__, 'name'),
        port=pulumi.get(__ret__, 'port'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'))


@_utilities.lift_output_func(get_documentdb_load_balancer_endpoint)
def get_documentdb_load_balancer_endpoint_output(instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                 instance_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                 project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                 region: Optional[pulumi.Input[Optional[str]]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDocumentdbLoadBalancerEndpointResult]:
    """
    Gets information about an DocumentDB load balancer endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_endpoint = scaleway.get_documentdb_load_balancer_endpoint(instance_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str instance_id: The DocumentDB Instance on which the endpoint is attached. Only one of `instance_name` and `instance_id` should be specified.
    :param str instance_name: The DocumentDB Instance Name on which the endpoint is attached. Only one of `instance_name` and `instance_id` should be specified.
    :param str project_id: The ID of the project the DocumentDB endpoint is associated with.
    :param str region: `region`) The region in which the DocumentDB endpoint exists.
    """
    ...
