# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCockpitResult',
    'AwaitableGetCockpitResult',
    'get_cockpit',
    'get_cockpit_output',
]

@pulumi.output_type
class GetCockpitResult:
    """
    A collection of values returned by getCockpit.
    """
    def __init__(__self__, endpoints=None, id=None, plan_id=None, project_id=None, push_urls=None):
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if push_urls and not isinstance(push_urls, list):
            raise TypeError("Expected argument 'push_urls' to be a list")
        pulumi.set(__self__, "push_urls", push_urls)

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetCockpitEndpointResult']:
        """
        Endpoints
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The ID of the current plan
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pushUrls")
    def push_urls(self) -> Sequence['outputs.GetCockpitPushUrlResult']:
        return pulumi.get(self, "push_urls")


class AwaitableGetCockpitResult(GetCockpitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCockpitResult(
            endpoints=self.endpoints,
            id=self.id,
            plan_id=self.plan_id,
            project_id=self.project_id,
            push_urls=self.push_urls)


def get_cockpit(project_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCockpitResult:
    """
    > **Note:**
    As of April 2024, Cockpit has introduced regionalization to offer more flexibility and resilience.
    If you have customized dashboards in Grafana for monitoring Scaleway resources, please update your queries to accommodate the new regionalized data sources.

    Gets information about the Scaleway Cockpit.

    For more information consult the [documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    main = scaleway.get_cockpit()
    ```

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    main = scaleway.get_cockpit(project_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str project_id: `project_id`) The ID of the project the cockpit is associated with.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getCockpit:getCockpit', __args__, opts=opts, typ=GetCockpitResult).value

    return AwaitableGetCockpitResult(
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        push_urls=pulumi.get(__ret__, 'push_urls'))


@_utilities.lift_output_func(get_cockpit)
def get_cockpit_output(project_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCockpitResult]:
    """
    > **Note:**
    As of April 2024, Cockpit has introduced regionalization to offer more flexibility and resilience.
    If you have customized dashboards in Grafana for monitoring Scaleway resources, please update your queries to accommodate the new regionalized data sources.

    Gets information about the Scaleway Cockpit.

    For more information consult the [documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    main = scaleway.get_cockpit()
    ```

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    main = scaleway.get_cockpit(project_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str project_id: `project_id`) The ID of the project the cockpit is associated with.
    """
    ...
