# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CockpitSourceArgs', 'CockpitSource']

@pulumi.input_type
class CockpitSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CockpitSource resource.
        :param pulumi.Input[str] name: The name of the cockpit data source.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cockpit data source is associated with.
        :param pulumi.Input[str] region: `region`) The region of the cockpit datasource.
        :param pulumi.Input[str] type: The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cockpit data source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the cockpit data source is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region of the cockpit datasource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _CockpitSourceState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 synchronized_with_grafana: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CockpitSource resources.
        :param pulumi.Input[str] created_at: Date and time of the cockpit data source's creation (RFC 3339 format).
        :param pulumi.Input[str] name: The name of the cockpit data source.
        :param pulumi.Input[str] origin: The origin of the cockpit data source.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cockpit data source is associated with.
        :param pulumi.Input[str] region: `region`) The region of the cockpit datasource.
        :param pulumi.Input[bool] synchronized_with_grafana: Indicates whether the data source is synchronized with Grafana.
        :param pulumi.Input[str] type: The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        :param pulumi.Input[str] updated_at: Date and time of the cockpit datas ource's last update (RFC 3339 format).
        :param pulumi.Input[str] url: The URL of the cockpit data source.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if synchronized_with_grafana is not None:
            pulumi.set(__self__, "synchronized_with_grafana", synchronized_with_grafana)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time of the cockpit data source's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cockpit data source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[str]]:
        """
        The origin of the cockpit data source.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the cockpit data source is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region of the cockpit datasource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="synchronizedWithGrafana")
    def synchronized_with_grafana(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the data source is synchronized with Grafana.
        """
        return pulumi.get(self, "synchronized_with_grafana")

    @synchronized_with_grafana.setter
    def synchronized_with_grafana(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "synchronized_with_grafana", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time of the cockpit datas ource's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the cockpit data source.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class CockpitSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Cockpit Data Sources.

        For more information consult the [documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#data-sources).

        ## Example Usage

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        project = scaleway.AccountProject("project")
        main = scaleway.CockpitSource("main",
            project_id=project.id,
            type="metrics")
        ```

        ## Import

        Cockpits Data Sources can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/cockpitSource:CockpitSource main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the cockpit data source.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cockpit data source is associated with.
        :param pulumi.Input[str] region: `region`) The region of the cockpit datasource.
        :param pulumi.Input[str] type: The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CockpitSourceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Cockpit Data Sources.

        For more information consult the [documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#data-sources).

        ## Example Usage

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        project = scaleway.AccountProject("project")
        main = scaleway.CockpitSource("main",
            project_id=project.id,
            type="metrics")
        ```

        ## Import

        Cockpits Data Sources can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/cockpitSource:CockpitSource main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param CockpitSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CockpitSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CockpitSourceArgs.__new__(CockpitSourceArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["origin"] = None
            __props__.__dict__["synchronized_with_grafana"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["url"] = None
        super(CockpitSource, __self__).__init__(
            'scaleway:index/cockpitSource:CockpitSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            origin: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            synchronized_with_grafana: Optional[pulumi.Input[bool]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'CockpitSource':
        """
        Get an existing CockpitSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Date and time of the cockpit data source's creation (RFC 3339 format).
        :param pulumi.Input[str] name: The name of the cockpit data source.
        :param pulumi.Input[str] origin: The origin of the cockpit data source.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the cockpit data source is associated with.
        :param pulumi.Input[str] region: `region`) The region of the cockpit datasource.
        :param pulumi.Input[bool] synchronized_with_grafana: Indicates whether the data source is synchronized with Grafana.
        :param pulumi.Input[str] type: The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        :param pulumi.Input[str] updated_at: Date and time of the cockpit datas ource's last update (RFC 3339 format).
        :param pulumi.Input[str] url: The URL of the cockpit data source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CockpitSourceState.__new__(_CockpitSourceState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["origin"] = origin
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["synchronized_with_grafana"] = synchronized_with_grafana
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["url"] = url
        return CockpitSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Date and time of the cockpit data source's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cockpit data source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output[str]:
        """
        The origin of the cockpit data source.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the cockpit data source is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        `region`) The region of the cockpit datasource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="synchronizedWithGrafana")
    def synchronized_with_grafana(self) -> pulumi.Output[bool]:
        """
        Indicates whether the data source is synchronized with Grafana.
        """
        return pulumi.get(self, "synchronized_with_grafana")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the cockpit data source. Possible values are: `metrics`, `logs` or `traces`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Date and time of the cockpit datas ource's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL of the cockpit data source.
        """
        return pulumi.get(self, "url")

